// services/network/public/mojom/key_pinning.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/key_pinning.mojom-shared-internal.h"
#include "services/network/public/mojom/hash_value.mojom-shared.h"


namespace network::mojom {
class PinSetDataView;

class PinSetInfoDataView;

class PinListDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::PinSetDataView> {
  using Data = ::network::mojom::internal::PinSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::PinSetInfoDataView> {
  using Data = ::network::mojom::internal::PinSetInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::PinListDataView> {
  using Data = ::network::mojom::internal::PinList_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class PinSetDataView {
 public:
  PinSetDataView() = default;

  PinSetDataView(
      internal::PinSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStaticSpkiHashesDataView(
      mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStaticSpkiHashes(UserType* output) {
    
    auto* pointer = data_->static_spki_hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>>(
        pointer, output, message_);
  }
  inline void GetBadStaticSpkiHashesDataView(
      mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBadStaticSpkiHashes(UserType* output) {
    
    auto* pointer = data_->bad_static_spki_hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PinSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PinSetInfoDataView {
 public:
  PinSetInfoDataView() = default;

  PinSetInfoDataView(
      internal::PinSetInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostnameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostname(UserType* output) {
    
    auto* pointer = data_->hostname.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPinsetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinsetName(UserType* output) {
    
    auto* pointer = data_->pinset_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool include_subdomains() const {
    return data_->include_subdomains;
  }
 private:
  internal::PinSetInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PinListDataView {
 public:
  PinListDataView() = default;

  PinListDataView(
      internal::PinList_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPinsetsDataView(
      mojo::ArrayDataView<PinSetDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinsets(UserType* output) {
    
    auto* pointer = data_->pinsets.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PinSetDataView>>(
        pointer, output, message_);
  }
  inline void GetHostPinsDataView(
      mojo::ArrayDataView<PinSetInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostPins(UserType* output) {
    
    auto* pointer = data_->host_pins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PinSetInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PinList_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_DATA_VIEW_H_