// services/network/public/mojom/isolation_info.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  NetworkIsolationPartition as network_mojom_NetworkIsolationPartition,
  NetworkIsolationPartitionSpec as network_mojom_NetworkIsolationPartitionSpec
} from './network_isolation_partition.mojom.m.js';

import {
  SiteForCookies as network_mojom_SiteForCookies,
  SiteForCookiesSpec as network_mojom_SiteForCookiesSpec
} from './site_for_cookies.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IsolationInfoRequestTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IsolationInfoRequestType = {
  
  kMainFrame: 0,
  kSubFrame: 1,
  kOther: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IsolationInfoFrameAncestorRelationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IsolationInfoFrameAncestorRelation = {
  
  kSameOrigin: 0,
  kSameSite: 1,
  kCrossSite: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IsolationInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    IsolationInfoSpec.$,
    'IsolationInfo',
    [
      mojo.internal.StructField(
        'requestType', 0,
        0,
        IsolationInfoRequestTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameOrigin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nonce', 24,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'siteForCookies', 32,
        0,
        network_mojom_SiteForCookiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkIsolationPartition', 4,
        0,
        network_mojom_NetworkIsolationPartitionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frame_ancestor_relation_$flag', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "frame_ancestor_relation_$value",
          originalFieldName: "frameAncestorRelation",
        }
      ),
      mojo.internal.StructField(
        'frame_ancestor_relation_$value', 44,
        0,
        IsolationInfoFrameAncestorRelationSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "frameAncestorRelation",
        }
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class IsolationInfo {
  constructor() {
    /** @type { !IsolationInfoRequestType } */
    this.requestType;
    /** @type { (url_mojom_Origin|undefined) } */
    this.topFrameOrigin;
    /** @type { (url_mojom_Origin|undefined) } */
    this.frameOrigin;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.nonce;
    /** @type { !network_mojom_SiteForCookies } */
    this.siteForCookies;
    /** @type { !network_mojom_NetworkIsolationPartition } */
    this.networkIsolationPartition;
    /** @type { (IsolationInfoFrameAncestorRelation|undefined) } */
    this.frameAncestorRelation;
  }
}

