// services/network/public/mojom/isolation_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/isolation_info.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/isolation_info.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/isolation_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/network_isolation_partition.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/isolation_info_mojom_traits.h"




namespace network::mojom {








class  IsolationInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IsolationInfo, T>::value>;
  using DataView = IsolationInfoDataView;
  using Data_ = internal::IsolationInfo_Data;

  template <typename... Args>
  static IsolationInfoPtr New(Args&&... args) {
    return IsolationInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IsolationInfoPtr From(const U& u) {
    return mojo::TypeConverter<IsolationInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IsolationInfo>::Convert(*this);
  }


  IsolationInfo();

  IsolationInfo(
      IsolationInfoRequestType request_type,
      const std::optional<::url::Origin>& top_frame_origin,
      const std::optional<::url::Origin>& frame_origin,
      const std::optional<::base::UnguessableToken>& nonce,
      const ::net::SiteForCookies& site_for_cookies,
      ::net::NetworkIsolationPartition network_isolation_partition,
      std::optional<IsolationInfoFrameAncestorRelation> frame_ancestor_relation);


  ~IsolationInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IsolationInfoPtr>
  IsolationInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IsolationInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IsolationInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IsolationInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IsolationInfo_UnserializedMessageContext<
            UserType, IsolationInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IsolationInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IsolationInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IsolationInfo_UnserializedMessageContext<
            UserType, IsolationInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IsolationInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IsolationInfoRequestType request_type;
  
  std::optional<::url::Origin> top_frame_origin;
  
  std::optional<::url::Origin> frame_origin;
  
  std::optional<::base::UnguessableToken> nonce;
  
  ::net::SiteForCookies site_for_cookies;
  
  ::net::NetworkIsolationPartition network_isolation_partition;
  
  std::optional<IsolationInfoFrameAncestorRelation> frame_ancestor_relation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IsolationInfoPtr IsolationInfo::Clone() const {
  return New(
      mojo::Clone(request_type),
      mojo::Clone(top_frame_origin),
      mojo::Clone(frame_origin),
      mojo::Clone(nonce),
      mojo::Clone(site_for_cookies),
      mojo::Clone(network_isolation_partition),
      mojo::Clone(frame_ancestor_relation)
  );
}

template <typename T, IsolationInfo::EnableIfSame<T>*>
bool IsolationInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_type, other_struct.request_type))
    return false;
  if (!mojo::Equals(this->top_frame_origin, other_struct.top_frame_origin))
    return false;
  if (!mojo::Equals(this->frame_origin, other_struct.frame_origin))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->network_isolation_partition, other_struct.network_isolation_partition))
    return false;
  if (!mojo::Equals(this->frame_ancestor_relation, other_struct.frame_ancestor_relation))
    return false;
  return true;
}

template <typename T, IsolationInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_type < rhs.request_type)
    return true;
  if (rhs.request_type < lhs.request_type)
    return false;
  if (lhs.top_frame_origin < rhs.top_frame_origin)
    return true;
  if (rhs.top_frame_origin < lhs.top_frame_origin)
    return false;
  if (lhs.frame_origin < rhs.frame_origin)
    return true;
  if (rhs.frame_origin < lhs.frame_origin)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  if (lhs.site_for_cookies < rhs.site_for_cookies)
    return true;
  if (rhs.site_for_cookies < lhs.site_for_cookies)
    return false;
  if (lhs.network_isolation_partition < rhs.network_isolation_partition)
    return true;
  if (rhs.network_isolation_partition < lhs.network_isolation_partition)
    return false;
  if (lhs.frame_ancestor_relation < rhs.frame_ancestor_relation)
    return true;
  if (rhs.frame_ancestor_relation < lhs.frame_ancestor_relation)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::IsolationInfo::DataView,
                                         ::network::mojom::IsolationInfoPtr> {
  static bool IsNull(const ::network::mojom::IsolationInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::IsolationInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::IsolationInfo::request_type) request_type(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->request_type;
  }

  static const decltype(::network::mojom::IsolationInfo::top_frame_origin)& top_frame_origin(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->top_frame_origin;
  }

  static const decltype(::network::mojom::IsolationInfo::frame_origin)& frame_origin(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->frame_origin;
  }

  static const decltype(::network::mojom::IsolationInfo::nonce)& nonce(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->nonce;
  }

  static const decltype(::network::mojom::IsolationInfo::site_for_cookies)& site_for_cookies(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->site_for_cookies;
  }

  static decltype(::network::mojom::IsolationInfo::network_isolation_partition) network_isolation_partition(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->network_isolation_partition;
  }

  static decltype(::network::mojom::IsolationInfo::frame_ancestor_relation) frame_ancestor_relation(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->frame_ancestor_relation;
  }

  static bool Read(::network::mojom::IsolationInfo::DataView input, ::network::mojom::IsolationInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_H_