// services/network/public/mojom/isolation_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/isolation_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"




#include "services/network/public/mojom/isolation_info.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::IsolationInfoRequestType>
    : public mojo::internal::EnumHashImpl<::network::mojom::IsolationInfoRequestType> {};

template <>
struct hash<::network::mojom::IsolationInfoFrameAncestorRelation>
    : public mojo::internal::EnumHashImpl<::network::mojom::IsolationInfoFrameAncestorRelation> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IsolationInfoRequestType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::IsolationInfoRequestType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::IsolationInfoRequestType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IsolationInfoFrameAncestorRelation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::IsolationInfoFrameAncestorRelation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::IsolationInfoFrameAncestorRelation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IsolationInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::IsolationInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::IsolationInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::IsolationInfoRequestType>(
      Traits::request_type(input),
      &fragment->request_type);

    decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_origin)::BaseType> top_frame_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin,
      top_frame_origin_fragment);

    fragment->top_frame_origin.Set(
        top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

    decltype(Traits::frame_origin(input)) in_frame_origin = Traits::frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_origin)::BaseType> frame_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_frame_origin,
      frame_origin_fragment);

    fragment->frame_origin.Set(
        frame_origin_fragment.is_null() ? nullptr : frame_origin_fragment.data());

    decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonce)::BaseType> nonce_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_nonce,
      nonce_fragment);

    fragment->nonce.Set(
        nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies,
      site_for_cookies_fragment);

    fragment->site_for_cookies.Set(
        site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->site_for_cookies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in IsolationInfo struct");

    
    mojo::internal::Serialize<::network::mojom::NetworkIsolationPartition>(
      Traits::network_isolation_partition(input),
      &fragment->network_isolation_partition);
    fragment->frame_ancestor_relation_$flag = Traits::frame_ancestor_relation(input).has_value();
    if (Traits::frame_ancestor_relation(input).has_value()) {
      
      mojo::internal::Serialize<::network::mojom::IsolationInfoFrameAncestorRelation>(
        Traits::frame_ancestor_relation(input).value(),
        &fragment->frame_ancestor_relation_$value);
    } else {
      fragment->frame_ancestor_relation_$value =
          static_cast<int32_t>(::network::mojom::IsolationInfoFrameAncestorRelation::kMinValue);
    }
  }

  static bool Deserialize(::network::mojom::internal::IsolationInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::IsolationInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void IsolationInfoDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void IsolationInfoDataView::GetFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void IsolationInfoDataView::GetNonceDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->nonce.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void IsolationInfoDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::IsolationInfoRequestType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::IsolationInfoRequestType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::IsolationInfoFrameAncestorRelation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::IsolationInfoFrameAncestorRelation value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SHARED_H_