// services/network/public/mojom/isolation_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/isolation_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace network::mojom {
class IsolationInfoDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::IsolationInfoDataView> {
  using Data = ::network::mojom::internal::IsolationInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class IsolationInfoRequestType : int32_t {
  
  kMainFrame = 0,
  
  kSubFrame = 1,
  
  kOther = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, IsolationInfoRequestType value);
inline bool IsKnownEnumValue(IsolationInfoRequestType value) {
  return internal::IsolationInfoRequestType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IsolationInfoFrameAncestorRelation : int32_t {
  
  kSameOrigin = 0,
  
  kSameSite = 1,
  
  kCrossSite = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, IsolationInfoFrameAncestorRelation value);
inline bool IsKnownEnumValue(IsolationInfoFrameAncestorRelation value) {
  return internal::IsolationInfoFrameAncestorRelation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class IsolationInfoDataView {
 public:
  IsolationInfoDataView() = default;

  IsolationInfoDataView(
      internal::IsolationInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestType(UserType* output) const {
    auto data_value = data_->request_type;
    return mojo::internal::Deserialize<::network::mojom::IsolationInfoRequestType>(
        data_value, output);
  }
  IsolationInfoRequestType request_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IsolationInfoRequestType>(data_->request_type));
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `top_frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopFrameOrigin` instead "
    "of `ReadTopFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameOrigin` instead "
    "of `ReadFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkIsolationPartition(UserType* output) const {
    auto data_value = data_->network_isolation_partition;
    return mojo::internal::Deserialize<::network::mojom::NetworkIsolationPartition>(
        data_value, output);
  }
  ::network::mojom::NetworkIsolationPartition network_isolation_partition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NetworkIsolationPartition>(data_->network_isolation_partition));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFrameAncestorRelation(UserType* output) const {
    if (!data_->frame_ancestor_relation_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::IsolationInfoFrameAncestorRelation>(
        data_->frame_ancestor_relation_$value, &output->emplace());
  }
  std::optional<IsolationInfoFrameAncestorRelation> frame_ancestor_relation() const {
    if (!data_->frame_ancestor_relation_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IsolationInfoFrameAncestorRelation>(data_->frame_ancestor_relation_$value));
  }
 private:
  internal::IsolationInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_DATA_VIEW_H_