// services/network/public/mojom/ip_address.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_IP_ADDRESS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_IP_ADDRESS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ip_address.mojom-shared-internal.h"




#include "services/network/public/mojom/ip_address.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IPAddressDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::IPAddressDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::IPAddress_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::address_bytes(input)) in_address_bytes = Traits::address_bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address_bytes)::BaseType>
        address_bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& address_bytes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_address_bytes,
      address_bytes_fragment,
      &address_bytes_validate_params);

    fragment->address_bytes.Set(
        address_bytes_fragment.is_null() ? nullptr : address_bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->address_bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null address_bytes in IPAddress struct");
  }

  static bool Deserialize(::network::mojom::internal::IPAddress_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::IPAddressDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void IPAddressDataView::GetAddressBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->address_bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_IP_ADDRESS_MOJOM_SHARED_H_