// services/network/public/mojom/ip_address.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_IP_ADDRESS_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_IP_ADDRESS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ip_address.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/network/public/cpp/ip_address_mojom_traits.h"
#include "third_party/blink/renderer/platform/network/ip_address.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class  IPAddress {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IPAddress, T>::value>;
  using DataView = IPAddressDataView;
  using Data_ = internal::IPAddress_Data;

  template <typename... Args>
  static IPAddressPtr New(Args&&... args) {
    return IPAddressPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IPAddressPtr From(const U& u) {
    return mojo::TypeConverter<IPAddressPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IPAddress>::Convert(*this);
  }


  IPAddress();

  explicit IPAddress(
      ::blink::Vector<uint8_t> address_bytes);


  ~IPAddress();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IPAddressPtr>
  IPAddressPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IPAddress::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IPAddress::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IPAddress::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IPAddress::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IPAddress::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IPAddress::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IPAddress_UnserializedMessageContext<
            UserType, IPAddress::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IPAddress::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IPAddress::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IPAddress_UnserializedMessageContext<
            UserType, IPAddress::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IPAddress::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<uint8_t> address_bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IPAddress::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IPAddress::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IPAddress::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IPAddress::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IPAddressPtr IPAddress::Clone() const {
  return New(
      mojo::Clone(address_bytes)
  );
}

template <typename T, IPAddress::EnableIfSame<T>*>
bool IPAddress::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->address_bytes, other_struct.address_bytes))
    return false;
  return true;
}

template <typename T, IPAddress::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.address_bytes < rhs.address_bytes)
    return true;
  if (rhs.address_bytes < lhs.address_bytes)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::network::mojom::blink::IPAddress::DataView,
                                         ::network::mojom::blink::IPAddressPtr> {
  static bool IsNull(const ::network::mojom::blink::IPAddressPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::IPAddressPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::IPAddress::address_bytes)& address_bytes(
      const ::network::mojom::blink::IPAddressPtr& input) {
    return input->address_bytes;
  }

  static bool Read(::network::mojom::blink::IPAddress::DataView input, ::network::mojom::blink::IPAddressPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_IP_ADDRESS_MOJOM_BLINK_H_