// services/network/public/mojom/integrity_metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/integrity_metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var integrity_algorithm$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/integrity_algorithm.mojom', 'integrity_algorithm.mojom.js');
  }



  function IntegrityMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IntegrityMetadata.prototype.initDefaults_ = function() {
    this.algorithm = 0;
    this.value = null;
  };
  IntegrityMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IntegrityMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IntegrityMetadata.algorithm
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, integrity_algorithm$.IntegrityAlgorithm);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IntegrityMetadata.value
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IntegrityMetadata.encodedSize = codec.kStructHeaderSize + 16;

  IntegrityMetadata.decode = function(decoder) {
    var packed;
    var val = new IntegrityMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.algorithm =
        decoder.decodeStruct(new codec.Enum(integrity_algorithm$.IntegrityAlgorithm));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.value =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  IntegrityMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IntegrityMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.algorithm);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.value);
  };
  exports.IntegrityMetadata = IntegrityMetadata;
})();