// services/network/public/mojom/http_cache_backend_file_operations.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_error.mojom.h"
#include "mojo/public/mojom/base/file_info.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/file_enumeration_entry_mojom_traits.h"




namespace network::mojom {

class FileEnumeratorProxy;

template <typename ImplRefTraits>
class FileEnumeratorStub;

class FileEnumeratorRequestValidator;
class FileEnumeratorResponseValidator;


class FileEnumerator
    : public FileEnumeratorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.FileEnumerator";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileEnumeratorInterfaceBase;
  using Proxy_ = FileEnumeratorProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileEnumeratorStub<ImplRefTraits>;

  using RequestValidator_ = FileEnumeratorRequestValidator;
  using ResponseValidator_ = FileEnumeratorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetNextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetNext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileEnumerator() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetNext(uint32_t num_entries, std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>* out_entries, bool* out_end, bool* out_error);
  using GetNextCallback = base::OnceCallback<void(const std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>&, bool, bool)>;
  using GetNextMojoCallback = base::OnceCallback<void(const std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>&, bool, bool)>;

  virtual void GetNext(uint32_t num_entries, GetNextCallback callback) = 0;
};

class HttpCacheBackendFileOperationsProxy;

template <typename ImplRefTraits>
class HttpCacheBackendFileOperationsStub;

class HttpCacheBackendFileOperationsRequestValidator;
class HttpCacheBackendFileOperationsResponseValidator;


class HttpCacheBackendFileOperations
    : public HttpCacheBackendFileOperationsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.HttpCacheBackendFileOperations";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1, 
    2, 
    3, 
    4, 
    5, 
    6
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HttpCacheBackendFileOperationsInterfaceBase;
  using Proxy_ = HttpCacheBackendFileOperationsProxy;

  template <typename ImplRefTraits>
  using Stub_ = HttpCacheBackendFileOperationsStub<ImplRefTraits>;

  using RequestValidator_ = HttpCacheBackendFileOperationsRequestValidator;
  using ResponseValidator_ = HttpCacheBackendFileOperationsResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateDirectoryMinVersion = 0,
    kPathExistsMinVersion = 0,
    kDirectoryExistsMinVersion = 0,
    kOpenFileMinVersion = 0,
    kDeleteFileMinVersion = 0,
    kRenameFileMinVersion = 0,
    kGetFileInfoMinVersion = 0,
    kEnumerateFilesMinVersion = 0,
    kCleanupDirectoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PathExists_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DirectoryExists_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenameFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFileInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnumerateFiles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CleanupDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HttpCacheBackendFileOperations() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateDirectory(const ::base::FilePath& path, bool* out_result);
  using CreateDirectoryCallback = base::OnceCallback<void(bool)>;
  using CreateDirectoryMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool PathExists(const ::base::FilePath& path, bool* out_result);
  using PathExistsCallback = base::OnceCallback<void(bool)>;
  using PathExistsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void PathExists(const ::base::FilePath& path, PathExistsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DirectoryExists(const ::base::FilePath& path, bool* out_result);
  using DirectoryExistsCallback = base::OnceCallback<void(bool)>;
  using DirectoryExistsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DirectoryExists(const ::base::FilePath& path, DirectoryExistsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenFile(const ::base::FilePath& path, HttpCacheBackendOpenFileFlags flags, ::base::File* out_file, ::base::File::Error* out_error);
  using OpenFileCallback = base::OnceCallback<void(::base::File, ::base::File::Error)>;
  using OpenFileMojoCallback = base::OnceCallback<void(::base::File, ::base::File::Error)>;

  virtual void OpenFile(const ::base::FilePath& path, HttpCacheBackendOpenFileFlags flags, OpenFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DeleteFile(const ::base::FilePath& path, HttpCacheBackendDeleteFileMode mode, bool* out_result);
  using DeleteFileCallback = base::OnceCallback<void(bool)>;
  using DeleteFileMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteFile(const ::base::FilePath& path, HttpCacheBackendDeleteFileMode mode, DeleteFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RenameFile(const ::base::FilePath& from_path, const ::base::FilePath& to_path, ::base::File::Error* out_error);
  using RenameFileCallback = base::OnceCallback<void(::base::File::Error)>;
  using RenameFileMojoCallback = base::OnceCallback<void(::base::File::Error)>;

  virtual void RenameFile(const ::base::FilePath& from_path, const ::base::FilePath& to_path, RenameFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_info);
  using GetFileInfoCallback = base::OnceCallback<void(const std::optional<::base::File::Info>&)>;
  using GetFileInfoMojoCallback = base::OnceCallback<void(const std::optional<::base::File::Info>&)>;

  virtual void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) = 0;

  virtual void EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingReceiver<FileEnumerator> receiver) = 0;

  using CleanupDirectoryCallback = base::OnceCallback<void(bool)>;
  using CleanupDirectoryMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CleanupDirectory(const ::base::FilePath& path, CleanupDirectoryCallback callback) = 0;
};

class HttpCacheBackendFileOperationsFactoryProxy;

template <typename ImplRefTraits>
class HttpCacheBackendFileOperationsFactoryStub;

class HttpCacheBackendFileOperationsFactoryRequestValidator;


class HttpCacheBackendFileOperationsFactory
    : public HttpCacheBackendFileOperationsFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.HttpCacheBackendFileOperationsFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HttpCacheBackendFileOperationsFactoryInterfaceBase;
  using Proxy_ = HttpCacheBackendFileOperationsFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = HttpCacheBackendFileOperationsFactoryStub<ImplRefTraits>;

  using RequestValidator_ = HttpCacheBackendFileOperationsFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Create_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HttpCacheBackendFileOperationsFactory() = default;

  virtual void Create(::mojo::PendingReceiver<HttpCacheBackendFileOperations> receiver) = 0;
};



class  FileEnumeratorProxy
    : public FileEnumerator {
 public:
  using InterfaceType = FileEnumerator;

  explicit FileEnumeratorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetNext(uint32_t num_entries, std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>* out_entries, bool* out_end, bool* out_error) final;
  
  void GetNext(uint32_t num_entries, GetNextCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HttpCacheBackendFileOperationsProxy
    : public HttpCacheBackendFileOperations {
 public:
  using InterfaceType = HttpCacheBackendFileOperations;

  explicit HttpCacheBackendFileOperationsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool CreateDirectory(const ::base::FilePath& path, bool* out_result) final;
  
  void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) final;
  
  bool PathExists(const ::base::FilePath& path, bool* out_result) final;
  
  void PathExists(const ::base::FilePath& path, PathExistsCallback callback) final;
  
  bool DirectoryExists(const ::base::FilePath& path, bool* out_result) final;
  
  void DirectoryExists(const ::base::FilePath& path, DirectoryExistsCallback callback) final;
  
  bool OpenFile(const ::base::FilePath& path, HttpCacheBackendOpenFileFlags flags, ::base::File* out_file, ::base::File::Error* out_error) final;
  
  void OpenFile(const ::base::FilePath& path, HttpCacheBackendOpenFileFlags flags, OpenFileCallback callback) final;
  
  bool DeleteFile(const ::base::FilePath& path, HttpCacheBackendDeleteFileMode mode, bool* out_result) final;
  
  void DeleteFile(const ::base::FilePath& path, HttpCacheBackendDeleteFileMode mode, DeleteFileCallback callback) final;
  
  bool RenameFile(const ::base::FilePath& from_path, const ::base::FilePath& to_path, ::base::File::Error* out_error) final;
  
  void RenameFile(const ::base::FilePath& from_path, const ::base::FilePath& to_path, RenameFileCallback callback) final;
  
  bool GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_info) final;
  
  void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) final;
  
  void EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingReceiver<FileEnumerator> receiver) final;
  
  void CleanupDirectory(const ::base::FilePath& path, CleanupDirectoryCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HttpCacheBackendFileOperationsFactoryProxy
    : public HttpCacheBackendFileOperationsFactory {
 public:
  using InterfaceType = HttpCacheBackendFileOperationsFactory;

  explicit HttpCacheBackendFileOperationsFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Create(::mojo::PendingReceiver<HttpCacheBackendFileOperations> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FileEnumeratorStubDispatch {
 public:
  static bool Accept(FileEnumerator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileEnumerator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileEnumerator>>
class FileEnumeratorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileEnumeratorStub() = default;
  ~FileEnumeratorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileEnumeratorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileEnumeratorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HttpCacheBackendFileOperationsStubDispatch {
 public:
  static bool Accept(HttpCacheBackendFileOperations* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HttpCacheBackendFileOperations* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HttpCacheBackendFileOperations>>
class HttpCacheBackendFileOperationsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HttpCacheBackendFileOperationsStub() = default;
  ~HttpCacheBackendFileOperationsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HttpCacheBackendFileOperationsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HttpCacheBackendFileOperationsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HttpCacheBackendFileOperationsFactoryStubDispatch {
 public:
  static bool Accept(HttpCacheBackendFileOperationsFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HttpCacheBackendFileOperationsFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HttpCacheBackendFileOperationsFactory>>
class HttpCacheBackendFileOperationsFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HttpCacheBackendFileOperationsFactoryStub() = default;
  ~HttpCacheBackendFileOperationsFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HttpCacheBackendFileOperationsFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HttpCacheBackendFileOperationsFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FileEnumeratorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HttpCacheBackendFileOperationsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HttpCacheBackendFileOperationsFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FileEnumeratorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HttpCacheBackendFileOperationsResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  FileEnumerationEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileEnumerationEntry, T>::value>;
  using DataView = FileEnumerationEntryDataView;
  using Data_ = internal::FileEnumerationEntry_Data;

  template <typename... Args>
  static FileEnumerationEntryPtr New(Args&&... args) {
    return FileEnumerationEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileEnumerationEntryPtr From(const U& u) {
    return mojo::TypeConverter<FileEnumerationEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileEnumerationEntry>::Convert(*this);
  }


  FileEnumerationEntry();

  FileEnumerationEntry(
      const ::base::FilePath& path,
      int64_t size,
      ::base::Time last_accessed,
      ::base::Time last_modified);


  ~FileEnumerationEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileEnumerationEntryPtr>
  FileEnumerationEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileEnumerationEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileEnumerationEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileEnumerationEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileEnumerationEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileEnumerationEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileEnumerationEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileEnumerationEntry_UnserializedMessageContext<
            UserType, FileEnumerationEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileEnumerationEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileEnumerationEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileEnumerationEntry_UnserializedMessageContext<
            UserType, FileEnumerationEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileEnumerationEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath path;
  
  int64_t size;
  
  ::base::Time last_accessed;
  
  ::base::Time last_modified;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileEnumerationEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileEnumerationEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileEnumerationEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileEnumerationEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FileEnumerationEntryPtr FileEnumerationEntry::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(size),
      mojo::Clone(last_accessed),
      mojo::Clone(last_modified)
  );
}

template <typename T, FileEnumerationEntry::EnableIfSame<T>*>
bool FileEnumerationEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->last_accessed, other_struct.last_accessed))
    return false;
  if (!mojo::Equals(this->last_modified, other_struct.last_modified))
    return false;
  return true;
}

template <typename T, FileEnumerationEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.last_accessed < rhs.last_accessed)
    return true;
  if (rhs.last_accessed < lhs.last_accessed)
    return false;
  if (lhs.last_modified < rhs.last_modified)
    return true;
  if (rhs.last_modified < lhs.last_modified)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::FileEnumerationEntry::DataView,
                                         ::network::mojom::FileEnumerationEntryPtr> {
  static bool IsNull(const ::network::mojom::FileEnumerationEntryPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FileEnumerationEntryPtr* output) { output->reset(); }

  static const decltype(::network::mojom::FileEnumerationEntry::path)& path(
      const ::network::mojom::FileEnumerationEntryPtr& input) {
    return input->path;
  }

  static decltype(::network::mojom::FileEnumerationEntry::size) size(
      const ::network::mojom::FileEnumerationEntryPtr& input) {
    return input->size;
  }

  static const decltype(::network::mojom::FileEnumerationEntry::last_accessed)& last_accessed(
      const ::network::mojom::FileEnumerationEntryPtr& input) {
    return input->last_accessed;
  }

  static const decltype(::network::mojom::FileEnumerationEntry::last_modified)& last_modified(
      const ::network::mojom::FileEnumerationEntryPtr& input) {
    return input->last_modified;
  }

  static bool Read(::network::mojom::FileEnumerationEntry::DataView input, ::network::mojom::FileEnumerationEntryPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_H_