// services/network/public/mojom/http_cache_backend_file_operations.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::HttpCacheBackendOpenFileFlags, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::HttpCacheBackendDeleteFileMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FileEnumerationEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FileEnumerationEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FileEnumerationEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in FileEnumerationEntry struct");

      fragment->size = Traits::size(input);

      decltype(Traits::last_accessed(input)) in_last_accessed = Traits::last_accessed(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_accessed)::BaseType> last_accessed_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_accessed,
        last_accessed_fragment);

      fragment->last_accessed.Set(
          last_accessed_fragment.is_null() ? nullptr : last_accessed_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_accessed.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_accessed in FileEnumerationEntry struct");

      decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_modified,
        last_modified_fragment);

      fragment->last_modified.Set(
          last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_modified.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified in FileEnumerationEntry struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_SEND_VALIDATION_H_