// services/network/public/mojom/host_resolver.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/host_resolver.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/host_resolver.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/host_resolver.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/address_list.mojom.h"
#include "services/network/public/mojom/host_resolver_endpoint_result.mojom.h"
#include "services/network/public/mojom/ip_address.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/network_anonymization_key.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/request_priority.mojom.h"
#include "url/mojom/scheme_host_port.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/host_resolver_mojom_traits.h"




namespace network::mojom {

class ResolveHostHandleProxy;

template <typename ImplRefTraits>
class ResolveHostHandleStub;

class ResolveHostHandleRequestValidator;


class ResolveHostHandle
    : public ResolveHostHandleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.ResolveHostHandle";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ResolveHostHandleInterfaceBase;
  using Proxy_ = ResolveHostHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResolveHostHandleStub<ImplRefTraits>;

  using RequestValidator_ = ResolveHostHandleRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ResolveHostHandle() = default;

  virtual void Cancel(int32_t result) = 0;
};

class ResolveHostClientProxy;

template <typename ImplRefTraits>
class ResolveHostClientStub;

class ResolveHostClientRequestValidator;


class ResolveHostClient
    : public ResolveHostClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.ResolveHostClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ResolveHostClientInterfaceBase;
  using Proxy_ = ResolveHostClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResolveHostClientStub<ImplRefTraits>;

  using RequestValidator_ = ResolveHostClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCompleteMinVersion = 0,
    kOnTextResultsMinVersion = 0,
    kOnHostnameResultsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTextResults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHostnameResults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ResolveHostClient() = default;

  virtual void OnComplete(int32_t result, const ::net::ResolveErrorInfo& resolve_error_info, const ::net::AddressList& resolved_addresses, const std::vector<::net::HostResolverEndpointResult>& alternative_endpoints) = 0;

  virtual void OnTextResults(const std::vector<std::string>& text_results) = 0;

  virtual void OnHostnameResults(const std::vector<::net::HostPortPair>& hosts) = 0;
};

class MdnsListenClientProxy;

template <typename ImplRefTraits>
class MdnsListenClientStub;

class MdnsListenClientRequestValidator;


class MdnsListenClient
    : public MdnsListenClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.MdnsListenClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MdnsListenClientInterfaceBase;
  using Proxy_ = MdnsListenClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = MdnsListenClientStub<ImplRefTraits>;

  using RequestValidator_ = MdnsListenClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnAddressResultMinVersion = 0,
    kOnTextResultMinVersion = 0,
    kOnHostnameResultMinVersion = 0,
    kOnUnhandledResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAddressResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTextResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHostnameResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnUnhandledResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using UpdateType = MdnsListenClient_UpdateType;
  virtual ~MdnsListenClient() = default;

  virtual void OnAddressResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type, const ::net::IPEndPoint& endpoint) = 0;

  virtual void OnTextResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type, const std::vector<std::string>& text_records) = 0;

  virtual void OnHostnameResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type, const ::net::HostPortPair& host) = 0;

  virtual void OnUnhandledResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type) = 0;
};

class HostResolverProxy;

template <typename ImplRefTraits>
class HostResolverStub;

class HostResolverRequestValidator;
class HostResolverResponseValidator;


class HostResolver
    : public HostResolverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.HostResolver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HostResolverInterfaceBase;
  using Proxy_ = HostResolverProxy;

  template <typename ImplRefTraits>
  using Stub_ = HostResolverStub<ImplRefTraits>;

  using RequestValidator_ = HostResolverRequestValidator;
  using ResponseValidator_ = HostResolverResponseValidator;
  enum MethodMinVersions : uint32_t {
    kResolveHostMinVersion = 0,
    kMdnsListenMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ResolveHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MdnsListen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HostResolver() = default;

  virtual void ResolveHost(HostResolverHostPtr host, const ::net::NetworkAnonymizationKey& network_anonymization_key, ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<ResolveHostClient> response_client) = 0;

  using MdnsListenCallback = base::OnceCallback<void(int32_t)>;
  using MdnsListenMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void MdnsListen(const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, MdnsListenCallback callback) = 0;
};

class DnsConfigChangeManagerClientProxy;

template <typename ImplRefTraits>
class DnsConfigChangeManagerClientStub;

class DnsConfigChangeManagerClientRequestValidator;


class DnsConfigChangeManagerClient
    : public DnsConfigChangeManagerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.DnsConfigChangeManagerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DnsConfigChangeManagerClientInterfaceBase;
  using Proxy_ = DnsConfigChangeManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DnsConfigChangeManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = DnsConfigChangeManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDnsConfigChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDnsConfigChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DnsConfigChangeManagerClient() = default;

  virtual void OnDnsConfigChanged() = 0;
};

class DnsConfigChangeManagerProxy;

template <typename ImplRefTraits>
class DnsConfigChangeManagerStub;

class DnsConfigChangeManagerRequestValidator;


class DnsConfigChangeManager
    : public DnsConfigChangeManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.DnsConfigChangeManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DnsConfigChangeManagerInterfaceBase;
  using Proxy_ = DnsConfigChangeManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DnsConfigChangeManagerStub<ImplRefTraits>;

  using RequestValidator_ = DnsConfigChangeManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestNotificationsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DnsConfigChangeManager() = default;

  virtual void RequestNotifications(::mojo::PendingRemote<DnsConfigChangeManagerClient> client) = 0;
};



class  ResolveHostHandleProxy
    : public ResolveHostHandle {
 public:
  using InterfaceType = ResolveHostHandle;

  explicit ResolveHostHandleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Cancel(int32_t result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ResolveHostClientProxy
    : public ResolveHostClient {
 public:
  using InterfaceType = ResolveHostClient;

  explicit ResolveHostClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnComplete(int32_t result, const ::net::ResolveErrorInfo& resolve_error_info, const ::net::AddressList& resolved_addresses, const std::vector<::net::HostResolverEndpointResult>& alternative_endpoints) final;
  
  void OnTextResults(const std::vector<std::string>& text_results) final;
  
  void OnHostnameResults(const std::vector<::net::HostPortPair>& hosts) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MdnsListenClientProxy
    : public MdnsListenClient {
 public:
  using InterfaceType = MdnsListenClient;

  explicit MdnsListenClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAddressResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type, const ::net::IPEndPoint& endpoint) final;
  
  void OnTextResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type, const std::vector<std::string>& text_records) final;
  
  void OnHostnameResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type, const ::net::HostPortPair& host) final;
  
  void OnUnhandledResult(::net::MdnsListenerUpdateType update_type, ::net::DnsQueryType query_type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HostResolverProxy
    : public HostResolver {
 public:
  using InterfaceType = HostResolver;

  explicit HostResolverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResolveHost(HostResolverHostPtr host, const ::net::NetworkAnonymizationKey& network_anonymization_key, ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<ResolveHostClient> response_client) final;
  
  void MdnsListen(const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, MdnsListenCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DnsConfigChangeManagerClientProxy
    : public DnsConfigChangeManagerClient {
 public:
  using InterfaceType = DnsConfigChangeManagerClient;

  explicit DnsConfigChangeManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDnsConfigChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DnsConfigChangeManagerProxy
    : public DnsConfigChangeManager {
 public:
  using InterfaceType = DnsConfigChangeManager;

  explicit DnsConfigChangeManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestNotifications(::mojo::PendingRemote<DnsConfigChangeManagerClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ResolveHostHandleStubDispatch {
 public:
  static bool Accept(ResolveHostHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResolveHostHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResolveHostHandle>>
class ResolveHostHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResolveHostHandleStub() = default;
  ~ResolveHostHandleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ResolveHostClientStubDispatch {
 public:
  static bool Accept(ResolveHostClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResolveHostClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResolveHostClient>>
class ResolveHostClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResolveHostClientStub() = default;
  ~ResolveHostClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MdnsListenClientStubDispatch {
 public:
  static bool Accept(MdnsListenClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MdnsListenClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MdnsListenClient>>
class MdnsListenClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MdnsListenClientStub() = default;
  ~MdnsListenClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MdnsListenClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MdnsListenClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HostResolverStubDispatch {
 public:
  static bool Accept(HostResolver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HostResolver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HostResolver>>
class HostResolverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HostResolverStub() = default;
  ~HostResolverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HostResolverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HostResolverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DnsConfigChangeManagerClientStubDispatch {
 public:
  static bool Accept(DnsConfigChangeManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DnsConfigChangeManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DnsConfigChangeManagerClient>>
class DnsConfigChangeManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DnsConfigChangeManagerClientStub() = default;
  ~DnsConfigChangeManagerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DnsConfigChangeManagerStubDispatch {
 public:
  static bool Accept(DnsConfigChangeManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DnsConfigChangeManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DnsConfigChangeManager>>
class DnsConfigChangeManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DnsConfigChangeManagerStub() = default;
  ~DnsConfigChangeManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ResolveHostHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ResolveHostClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MdnsListenClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HostResolverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DnsConfigChangeManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DnsConfigChangeManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HostResolverResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  HostResolverHost {
 public:
  using DataView = HostResolverHostDataView;
  using Data_ = internal::HostResolverHost_Data;
  using Tag = Data_::HostResolverHost_Tag;

  template <typename... Args>
  static HostResolverHostPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |scheme_host_port|.
  static HostResolverHostPtr NewSchemeHostPort(
      const ::url::SchemeHostPort& value);
  // Construct an instance holding |host_port_pair|.
  static HostResolverHostPtr NewHostPortPair(
      const ::net::HostPortPair& value);

  template <typename U>
  static HostResolverHostPtr From(const U& u) {
    return mojo::TypeConverter<HostResolverHostPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HostResolverHost>::Convert(*this);
  }
  ~HostResolverHost();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  HostResolverHost(const HostResolverHost& other) = delete;
  HostResolverHost& operator=(const HostResolverHost& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = HostResolverHostPtr>
  HostResolverHostPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, HostResolverHost>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, HostResolverHost>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_scheme_host_port() const { return tag_ == Tag::kSchemeHostPort; }
  const ::url::SchemeHostPort& get_scheme_host_port() const {
    CHECK(tag_ == Tag::kSchemeHostPort);
    return data_.scheme_host_port;
  }
  ::url::SchemeHostPort& get_scheme_host_port() {
    CHECK(tag_ == Tag::kSchemeHostPort);
    return data_.scheme_host_port;
  }
  void set_scheme_host_port(const ::url::SchemeHostPort& scheme_host_port);

  bool is_host_port_pair() const { return tag_ == Tag::kHostPortPair; }
  const ::net::HostPortPair& get_host_port_pair() const {
    CHECK(tag_ == Tag::kHostPortPair);
    return data_.host_port_pair;
  }
  ::net::HostPortPair& get_host_port_pair() {
    CHECK(tag_ == Tag::kHostPortPair);
    return data_.host_port_pair;
  }
  void set_host_port_pair(const ::net::HostPortPair& host_port_pair);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HostResolverHost::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<HostResolverHost::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSchemeHostPort)>,
        const ::url::SchemeHostPort& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHostPortPair)>,
        const ::net::HostPortPair& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::url::SchemeHostPort scheme_host_port;
    ::net::HostPortPair host_port_pair;
  };

  HostResolverHost(
      std::in_place_index_t<static_cast<size_t>(Tag::kSchemeHostPort)>,
      const ::url::SchemeHostPort& value);
  HostResolverHost(
      std::in_place_index_t<static_cast<size_t>(Tag::kHostPortPair)>,
      const ::net::HostPortPair& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  DnsOverHttpsServerConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DnsOverHttpsServerConfig, T>::value>;
  using DataView = DnsOverHttpsServerConfigDataView;
  using Data_ = internal::DnsOverHttpsServerConfig_Data;

  template <typename... Args>
  static DnsOverHttpsServerConfigPtr New(Args&&... args) {
    return DnsOverHttpsServerConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DnsOverHttpsServerConfigPtr From(const U& u) {
    return mojo::TypeConverter<DnsOverHttpsServerConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DnsOverHttpsServerConfig>::Convert(*this);
  }


  DnsOverHttpsServerConfig();

  DnsOverHttpsServerConfig(
      const std::string& server_template,
      std::vector<std::vector<::net::IPAddress>> endpoints);


  ~DnsOverHttpsServerConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DnsOverHttpsServerConfigPtr>
  DnsOverHttpsServerConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsOverHttpsServerConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsOverHttpsServerConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DnsOverHttpsServerConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DnsOverHttpsServerConfig_UnserializedMessageContext<
            UserType, DnsOverHttpsServerConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DnsOverHttpsServerConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DnsOverHttpsServerConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DnsOverHttpsServerConfig_UnserializedMessageContext<
            UserType, DnsOverHttpsServerConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DnsOverHttpsServerConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string server_template;
  
  std::vector<std::vector<::net::IPAddress>> endpoints;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DnsOverHttpsConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DnsOverHttpsConfig, T>::value>;
  using DataView = DnsOverHttpsConfigDataView;
  using Data_ = internal::DnsOverHttpsConfig_Data;

  template <typename... Args>
  static DnsOverHttpsConfigPtr New(Args&&... args) {
    return DnsOverHttpsConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DnsOverHttpsConfigPtr From(const U& u) {
    return mojo::TypeConverter<DnsOverHttpsConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DnsOverHttpsConfig>::Convert(*this);
  }


  DnsOverHttpsConfig();

  explicit DnsOverHttpsConfig(
      std::vector<::net::DnsOverHttpsServerConfig> servers);


  ~DnsOverHttpsConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DnsOverHttpsConfigPtr>
  DnsOverHttpsConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DnsOverHttpsConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DnsOverHttpsConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DnsOverHttpsConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsOverHttpsConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsOverHttpsConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DnsOverHttpsConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DnsOverHttpsConfig_UnserializedMessageContext<
            UserType, DnsOverHttpsConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DnsOverHttpsConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DnsOverHttpsConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DnsOverHttpsConfig_UnserializedMessageContext<
            UserType, DnsOverHttpsConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DnsOverHttpsConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::net::DnsOverHttpsServerConfig> servers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DnsOverHttpsConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DnsOverHttpsConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DnsOverHttpsConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DnsOverHttpsConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DnsConfigOverrides {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DnsConfigOverrides, T>::value>;
  using DataView = DnsConfigOverridesDataView;
  using Data_ = internal::DnsConfigOverrides_Data;
  using Tristate = DnsConfigOverrides_Tristate;

  template <typename... Args>
  static DnsConfigOverridesPtr New(Args&&... args) {
    return DnsConfigOverridesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DnsConfigOverridesPtr From(const U& u) {
    return mojo::TypeConverter<DnsConfigOverridesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DnsConfigOverrides>::Convert(*this);
  }


  DnsConfigOverrides();

  DnsConfigOverrides(
      std::optional<std::vector<::net::IPEndPoint>> nameservers,
      std::optional<std::vector<std::string>> search,
      DnsConfigOverrides::Tristate append_to_multi_label_name,
      int8_t ndots,
      std::optional<::base::TimeDelta> fallback_period,
      int32_t attempts,
      DnsConfigOverrides::Tristate rotate,
      DnsConfigOverrides::Tristate use_local_ipv6,
      const std::optional<::net::DnsOverHttpsConfig>& dns_over_https_config,
      OptionalSecureDnsMode secure_dns_mode,
      DnsConfigOverrides::Tristate allow_dns_over_https_upgrade,
      std::optional<std::vector<::net::IPEndPoint>> fallback_doh_nameservers,
      bool clear_hosts);


  ~DnsConfigOverrides();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DnsConfigOverridesPtr>
  DnsConfigOverridesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsConfigOverrides::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsConfigOverrides::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DnsConfigOverrides::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DnsConfigOverrides_UnserializedMessageContext<
            UserType, DnsConfigOverrides::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DnsConfigOverrides::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DnsConfigOverrides::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DnsConfigOverrides_UnserializedMessageContext<
            UserType, DnsConfigOverrides::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DnsConfigOverrides::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<::net::IPEndPoint>> nameservers;
  
  std::optional<std::vector<std::string>> search;
  
  DnsConfigOverrides::Tristate append_to_multi_label_name;
  
  int8_t ndots;
  
  std::optional<::base::TimeDelta> fallback_period;
  
  int32_t attempts;
  
  DnsConfigOverrides::Tristate rotate;
  
  DnsConfigOverrides::Tristate use_local_ipv6;
  
  std::optional<::net::DnsOverHttpsConfig> dns_over_https_config;
  
  OptionalSecureDnsMode secure_dns_mode;
  
  DnsConfigOverrides::Tristate allow_dns_over_https_upgrade;
  
  std::optional<std::vector<::net::IPEndPoint>> fallback_doh_nameservers;
  
  bool clear_hosts;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ResolveHostParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResolveHostParameters, T>::value>;
  using DataView = ResolveHostParametersDataView;
  using Data_ = internal::ResolveHostParameters_Data;
  using Source = ResolveHostParameters_Source;
  using CacheUsage = ResolveHostParameters_CacheUsage;
  using Purpose = ResolveHostParameters_Purpose;

  template <typename... Args>
  static ResolveHostParametersPtr New(Args&&... args) {
    return ResolveHostParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResolveHostParametersPtr From(const U& u) {
    return mojo::TypeConverter<ResolveHostParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResolveHostParameters>::Convert(*this);
  }


  ResolveHostParameters();

  ResolveHostParameters(
      ::net::DnsQueryType dns_query_type,
      ::net::RequestPriority initial_priority,
      ::net::HostResolverSource source,
      ResolveHostParameters::CacheUsage cache_usage,
      ::mojo::PendingReceiver<ResolveHostHandle> control_handle,
      bool include_canonical_name,
      bool loopback_only,
      bool is_speculative,
      SecureDnsPolicy secure_dns_policy,
      ResolveHostParameters::Purpose purpose);

ResolveHostParameters(const ResolveHostParameters&) = delete;
ResolveHostParameters& operator=(const ResolveHostParameters&) = delete;

  ~ResolveHostParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResolveHostParametersPtr>
  ResolveHostParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResolveHostParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResolveHostParameters_UnserializedMessageContext<
            UserType, ResolveHostParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResolveHostParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResolveHostParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResolveHostParameters_UnserializedMessageContext<
            UserType, ResolveHostParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResolveHostParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::DnsQueryType dns_query_type;
  
  ::net::RequestPriority initial_priority;
  
  ::net::HostResolverSource source;
  
  ResolveHostParameters::CacheUsage cache_usage;
  
  ::mojo::PendingReceiver<ResolveHostHandle> control_handle;
  
  bool include_canonical_name;
  
  bool loopback_only;
  
  bool is_speculative;
  
  SecureDnsPolicy secure_dns_policy;
  
  ResolveHostParameters::Purpose purpose;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
HostResolverHostPtr HostResolverHost::Clone() const {
  switch (tag_) {
    case Tag::kSchemeHostPort:
      return NewSchemeHostPort(
          mojo::Clone(data_.scheme_host_port));
    case Tag::kHostPortPair:
      return NewHostPortPair(
          mojo::Clone(data_.host_port_pair));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, HostResolverHost>::value>::type*>
bool HostResolverHost::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSchemeHostPort:
      return mojo::Equals(data_.scheme_host_port, other.data_.scheme_host_port);
    case Tag::kHostPortPair:
      return mojo::Equals(data_.host_port_pair, other.data_.host_port_pair);
  }

  return false;
}
template <typename StructPtrType>
DnsOverHttpsServerConfigPtr DnsOverHttpsServerConfig::Clone() const {
  return New(
      mojo::Clone(server_template),
      mojo::Clone(endpoints)
  );
}

template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>*>
bool DnsOverHttpsServerConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->server_template, other_struct.server_template))
    return false;
  if (!mojo::Equals(this->endpoints, other_struct.endpoints))
    return false;
  return true;
}

template <typename T, DnsOverHttpsServerConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.server_template < rhs.server_template)
    return true;
  if (rhs.server_template < lhs.server_template)
    return false;
  if (lhs.endpoints < rhs.endpoints)
    return true;
  if (rhs.endpoints < lhs.endpoints)
    return false;
  return false;
}
template <typename StructPtrType>
DnsOverHttpsConfigPtr DnsOverHttpsConfig::Clone() const {
  return New(
      mojo::Clone(servers)
  );
}

template <typename T, DnsOverHttpsConfig::EnableIfSame<T>*>
bool DnsOverHttpsConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->servers, other_struct.servers))
    return false;
  return true;
}

template <typename T, DnsOverHttpsConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.servers < rhs.servers)
    return true;
  if (rhs.servers < lhs.servers)
    return false;
  return false;
}
template <typename StructPtrType>
DnsConfigOverridesPtr DnsConfigOverrides::Clone() const {
  return New(
      mojo::Clone(nameservers),
      mojo::Clone(search),
      mojo::Clone(append_to_multi_label_name),
      mojo::Clone(ndots),
      mojo::Clone(fallback_period),
      mojo::Clone(attempts),
      mojo::Clone(rotate),
      mojo::Clone(use_local_ipv6),
      mojo::Clone(dns_over_https_config),
      mojo::Clone(secure_dns_mode),
      mojo::Clone(allow_dns_over_https_upgrade),
      mojo::Clone(fallback_doh_nameservers),
      mojo::Clone(clear_hosts)
  );
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>*>
bool DnsConfigOverrides::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->nameservers, other_struct.nameservers))
    return false;
  if (!mojo::Equals(this->search, other_struct.search))
    return false;
  if (!mojo::Equals(this->append_to_multi_label_name, other_struct.append_to_multi_label_name))
    return false;
  if (!mojo::Equals(this->ndots, other_struct.ndots))
    return false;
  if (!mojo::Equals(this->fallback_period, other_struct.fallback_period))
    return false;
  if (!mojo::Equals(this->attempts, other_struct.attempts))
    return false;
  if (!mojo::Equals(this->rotate, other_struct.rotate))
    return false;
  if (!mojo::Equals(this->use_local_ipv6, other_struct.use_local_ipv6))
    return false;
  if (!mojo::Equals(this->dns_over_https_config, other_struct.dns_over_https_config))
    return false;
  if (!mojo::Equals(this->secure_dns_mode, other_struct.secure_dns_mode))
    return false;
  if (!mojo::Equals(this->allow_dns_over_https_upgrade, other_struct.allow_dns_over_https_upgrade))
    return false;
  if (!mojo::Equals(this->fallback_doh_nameservers, other_struct.fallback_doh_nameservers))
    return false;
  if (!mojo::Equals(this->clear_hosts, other_struct.clear_hosts))
    return false;
  return true;
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.nameservers < rhs.nameservers)
    return true;
  if (rhs.nameservers < lhs.nameservers)
    return false;
  if (lhs.search < rhs.search)
    return true;
  if (rhs.search < lhs.search)
    return false;
  if (lhs.append_to_multi_label_name < rhs.append_to_multi_label_name)
    return true;
  if (rhs.append_to_multi_label_name < lhs.append_to_multi_label_name)
    return false;
  if (lhs.ndots < rhs.ndots)
    return true;
  if (rhs.ndots < lhs.ndots)
    return false;
  if (lhs.fallback_period < rhs.fallback_period)
    return true;
  if (rhs.fallback_period < lhs.fallback_period)
    return false;
  if (lhs.attempts < rhs.attempts)
    return true;
  if (rhs.attempts < lhs.attempts)
    return false;
  if (lhs.rotate < rhs.rotate)
    return true;
  if (rhs.rotate < lhs.rotate)
    return false;
  if (lhs.use_local_ipv6 < rhs.use_local_ipv6)
    return true;
  if (rhs.use_local_ipv6 < lhs.use_local_ipv6)
    return false;
  if (lhs.dns_over_https_config < rhs.dns_over_https_config)
    return true;
  if (rhs.dns_over_https_config < lhs.dns_over_https_config)
    return false;
  if (lhs.secure_dns_mode < rhs.secure_dns_mode)
    return true;
  if (rhs.secure_dns_mode < lhs.secure_dns_mode)
    return false;
  if (lhs.allow_dns_over_https_upgrade < rhs.allow_dns_over_https_upgrade)
    return true;
  if (rhs.allow_dns_over_https_upgrade < lhs.allow_dns_over_https_upgrade)
    return false;
  if (lhs.fallback_doh_nameservers < rhs.fallback_doh_nameservers)
    return true;
  if (rhs.fallback_doh_nameservers < lhs.fallback_doh_nameservers)
    return false;
  if (lhs.clear_hosts < rhs.clear_hosts)
    return true;
  if (rhs.clear_hosts < lhs.clear_hosts)
    return false;
  return false;
}
template <typename StructPtrType>
ResolveHostParametersPtr ResolveHostParameters::Clone() const {
  return New(
      mojo::Clone(dns_query_type),
      mojo::Clone(initial_priority),
      mojo::Clone(source),
      mojo::Clone(cache_usage),
      mojo::Clone(control_handle),
      mojo::Clone(include_canonical_name),
      mojo::Clone(loopback_only),
      mojo::Clone(is_speculative),
      mojo::Clone(secure_dns_policy),
      mojo::Clone(purpose)
  );
}

template <typename T, ResolveHostParameters::EnableIfSame<T>*>
bool ResolveHostParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dns_query_type, other_struct.dns_query_type))
    return false;
  if (!mojo::Equals(this->initial_priority, other_struct.initial_priority))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->cache_usage, other_struct.cache_usage))
    return false;
  if (!mojo::Equals(this->control_handle, other_struct.control_handle))
    return false;
  if (!mojo::Equals(this->include_canonical_name, other_struct.include_canonical_name))
    return false;
  if (!mojo::Equals(this->loopback_only, other_struct.loopback_only))
    return false;
  if (!mojo::Equals(this->is_speculative, other_struct.is_speculative))
    return false;
  if (!mojo::Equals(this->secure_dns_policy, other_struct.secure_dns_policy))
    return false;
  if (!mojo::Equals(this->purpose, other_struct.purpose))
    return false;
  return true;
}

template <typename T, ResolveHostParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dns_query_type < rhs.dns_query_type)
    return true;
  if (rhs.dns_query_type < lhs.dns_query_type)
    return false;
  if (lhs.initial_priority < rhs.initial_priority)
    return true;
  if (rhs.initial_priority < lhs.initial_priority)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.cache_usage < rhs.cache_usage)
    return true;
  if (rhs.cache_usage < lhs.cache_usage)
    return false;
  if (lhs.control_handle < rhs.control_handle)
    return true;
  if (rhs.control_handle < lhs.control_handle)
    return false;
  if (lhs.include_canonical_name < rhs.include_canonical_name)
    return true;
  if (rhs.include_canonical_name < lhs.include_canonical_name)
    return false;
  if (lhs.loopback_only < rhs.loopback_only)
    return true;
  if (rhs.loopback_only < lhs.loopback_only)
    return false;
  if (lhs.is_speculative < rhs.is_speculative)
    return true;
  if (rhs.is_speculative < lhs.is_speculative)
    return false;
  if (lhs.secure_dns_policy < rhs.secure_dns_policy)
    return true;
  if (rhs.secure_dns_policy < lhs.secure_dns_policy)
    return false;
  if (lhs.purpose < rhs.purpose)
    return true;
  if (rhs.purpose < lhs.purpose)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::DnsOverHttpsServerConfig::DataView,
                                         ::network::mojom::DnsOverHttpsServerConfigPtr> {
  static bool IsNull(const ::network::mojom::DnsOverHttpsServerConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DnsOverHttpsServerConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DnsOverHttpsServerConfig::server_template)& server_template(
      const ::network::mojom::DnsOverHttpsServerConfigPtr& input) {
    return input->server_template;
  }

  static const decltype(::network::mojom::DnsOverHttpsServerConfig::endpoints)& endpoints(
      const ::network::mojom::DnsOverHttpsServerConfigPtr& input) {
    return input->endpoints;
  }

  static bool Read(::network::mojom::DnsOverHttpsServerConfig::DataView input, ::network::mojom::DnsOverHttpsServerConfigPtr* output);
};


template <>
struct  StructTraits<::network::mojom::DnsOverHttpsConfig::DataView,
                                         ::network::mojom::DnsOverHttpsConfigPtr> {
  static bool IsNull(const ::network::mojom::DnsOverHttpsConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DnsOverHttpsConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DnsOverHttpsConfig::servers)& servers(
      const ::network::mojom::DnsOverHttpsConfigPtr& input) {
    return input->servers;
  }

  static bool Read(::network::mojom::DnsOverHttpsConfig::DataView input, ::network::mojom::DnsOverHttpsConfigPtr* output);
};


template <>
struct  StructTraits<::network::mojom::DnsConfigOverrides::DataView,
                                         ::network::mojom::DnsConfigOverridesPtr> {
  static bool IsNull(const ::network::mojom::DnsConfigOverridesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DnsConfigOverridesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DnsConfigOverrides::nameservers)& nameservers(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->nameservers;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::search)& search(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->search;
  }

  static decltype(::network::mojom::DnsConfigOverrides::append_to_multi_label_name) append_to_multi_label_name(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->append_to_multi_label_name;
  }

  static decltype(::network::mojom::DnsConfigOverrides::ndots) ndots(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->ndots;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::fallback_period)& fallback_period(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->fallback_period;
  }

  static decltype(::network::mojom::DnsConfigOverrides::attempts) attempts(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->attempts;
  }

  static decltype(::network::mojom::DnsConfigOverrides::rotate) rotate(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->rotate;
  }

  static decltype(::network::mojom::DnsConfigOverrides::use_local_ipv6) use_local_ipv6(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->use_local_ipv6;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::dns_over_https_config)& dns_over_https_config(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->dns_over_https_config;
  }

  static decltype(::network::mojom::DnsConfigOverrides::secure_dns_mode) secure_dns_mode(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->secure_dns_mode;
  }

  static decltype(::network::mojom::DnsConfigOverrides::allow_dns_over_https_upgrade) allow_dns_over_https_upgrade(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->allow_dns_over_https_upgrade;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::fallback_doh_nameservers)& fallback_doh_nameservers(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->fallback_doh_nameservers;
  }

  static decltype(::network::mojom::DnsConfigOverrides::clear_hosts) clear_hosts(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->clear_hosts;
  }

  static bool Read(::network::mojom::DnsConfigOverrides::DataView input, ::network::mojom::DnsConfigOverridesPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ResolveHostParameters::DataView,
                                         ::network::mojom::ResolveHostParametersPtr> {
  static bool IsNull(const ::network::mojom::ResolveHostParametersPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ResolveHostParametersPtr* output) { output->reset(); }

  static decltype(::network::mojom::ResolveHostParameters::dns_query_type) dns_query_type(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->dns_query_type;
  }

  static decltype(::network::mojom::ResolveHostParameters::initial_priority) initial_priority(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->initial_priority;
  }

  static decltype(::network::mojom::ResolveHostParameters::source) source(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->source;
  }

  static decltype(::network::mojom::ResolveHostParameters::cache_usage) cache_usage(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->cache_usage;
  }

  static  decltype(::network::mojom::ResolveHostParameters::control_handle)& control_handle(
       ::network::mojom::ResolveHostParametersPtr& input) {
    return input->control_handle;
  }

  static decltype(::network::mojom::ResolveHostParameters::include_canonical_name) include_canonical_name(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->include_canonical_name;
  }

  static decltype(::network::mojom::ResolveHostParameters::loopback_only) loopback_only(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->loopback_only;
  }

  static decltype(::network::mojom::ResolveHostParameters::is_speculative) is_speculative(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->is_speculative;
  }

  static decltype(::network::mojom::ResolveHostParameters::secure_dns_policy) secure_dns_policy(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->secure_dns_policy;
  }

  static decltype(::network::mojom::ResolveHostParameters::purpose) purpose(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->purpose;
  }

  static bool Read(::network::mojom::ResolveHostParameters::DataView input, ::network::mojom::ResolveHostParametersPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::HostResolverHost::DataView,
                                        ::network::mojom::HostResolverHostPtr> {
  static bool IsNull(const ::network::mojom::HostResolverHostPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HostResolverHostPtr* output) { output->reset(); }

  static ::network::mojom::HostResolverHost::Tag GetTag(const ::network::mojom::HostResolverHostPtr& input) {
    return input->which();
  }

  static const ::url::SchemeHostPort& scheme_host_port(const ::network::mojom::HostResolverHostPtr& input) {
    return input->get_scheme_host_port();
  }

  static const ::net::HostPortPair& host_port_pair(const ::network::mojom::HostResolverHostPtr& input) {
    return input->get_host_port_pair();
  }

  static bool Read(::network::mojom::HostResolverHost::DataView input, ::network::mojom::HostResolverHostPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_H_