// services/network/public/mojom/host_resolver.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/host_resolver.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/host_resolver.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::OptionalSecureDnsMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::OptionalSecureDnsMode> {};

template <>
struct hash<::network::mojom::SecureDnsMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::SecureDnsMode> {};

template <>
struct hash<::network::mojom::SecureDnsPolicy>
    : public mojo::internal::EnumHashImpl<::network::mojom::SecureDnsPolicy> {};

template <>
struct hash<::network::mojom::DnsQueryType>
    : public mojo::internal::EnumHashImpl<::network::mojom::DnsQueryType> {};

template <>
struct hash<::network::mojom::DnsConfigOverrides_Tristate>
    : public mojo::internal::EnumHashImpl<::network::mojom::DnsConfigOverrides_Tristate> {};

template <>
struct hash<::network::mojom::ResolveHostParameters_Source>
    : public mojo::internal::EnumHashImpl<::network::mojom::ResolveHostParameters_Source> {};

template <>
struct hash<::network::mojom::ResolveHostParameters_CacheUsage>
    : public mojo::internal::EnumHashImpl<::network::mojom::ResolveHostParameters_CacheUsage> {};

template <>
struct hash<::network::mojom::ResolveHostParameters_Purpose>
    : public mojo::internal::EnumHashImpl<::network::mojom::ResolveHostParameters_Purpose> {};

template <>
struct hash<::network::mojom::MdnsListenClient_UpdateType>
    : public mojo::internal::EnumHashImpl<::network::mojom::MdnsListenClient_UpdateType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::OptionalSecureDnsMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::OptionalSecureDnsMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::OptionalSecureDnsMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SecureDnsMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SecureDnsMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SecureDnsMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SecureDnsPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SecureDnsPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SecureDnsPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsQueryType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DnsQueryType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DnsQueryType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsConfigOverrides_Tristate, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DnsConfigOverrides_Tristate, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DnsConfigOverrides_Tristate>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParameters_Source, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ResolveHostParameters_Source, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ResolveHostParameters_Source>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParameters_CacheUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ResolveHostParameters_CacheUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ResolveHostParameters_CacheUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParameters_Purpose, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ResolveHostParameters_Purpose, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ResolveHostParameters_Purpose>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::MdnsListenClient_UpdateType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::MdnsListenClient_UpdateType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::MdnsListenClient_UpdateType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsOverHttpsServerConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsOverHttpsServerConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsOverHttpsServerConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::server_template(input)) in_server_template = Traits::server_template(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_template)::BaseType> server_template_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_server_template,
      server_template_fragment);

    fragment->server_template.Set(
        server_template_fragment.is_null() ? nullptr : server_template_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->server_template.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null server_template in DnsOverHttpsServerConfig struct");

    decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->endpoints)::BaseType>
        endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>>(
      in_endpoints,
      endpoints_fragment,
      &endpoints_validate_params);

    fragment->endpoints.Set(
        endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->endpoints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoints in DnsOverHttpsServerConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::DnsOverHttpsServerConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DnsOverHttpsServerConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsOverHttpsConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsOverHttpsConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsOverHttpsConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::servers(input)) in_servers = Traits::servers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->servers)::BaseType>
        servers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& servers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DnsOverHttpsServerConfigDataView>>(
      in_servers,
      servers_fragment,
      &servers_validate_params);

    fragment->servers.Set(
        servers_fragment.is_null() ? nullptr : servers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->servers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null servers in DnsOverHttpsConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::DnsOverHttpsConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DnsOverHttpsConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsConfigOverridesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsConfigOverridesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsConfigOverrides_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::nameservers(input)) in_nameservers = Traits::nameservers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nameservers)::BaseType>
        nameservers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& nameservers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
      in_nameservers,
      nameservers_fragment,
      &nameservers_validate_params);

    fragment->nameservers.Set(
        nameservers_fragment.is_null() ? nullptr : nameservers_fragment.data());

    decltype(Traits::search(input)) in_search = Traits::search(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->search)::BaseType>
        search_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& search_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_search,
      search_fragment,
      &search_validate_params);

    fragment->search.Set(
        search_fragment.is_null() ? nullptr : search_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
      Traits::append_to_multi_label_name(input),
      &fragment->append_to_multi_label_name);

    fragment->ndots = Traits::ndots(input);

    decltype(Traits::fallback_period(input)) in_fallback_period = Traits::fallback_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fallback_period)::BaseType> fallback_period_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_fallback_period,
      fallback_period_fragment);

    fragment->fallback_period.Set(
        fallback_period_fragment.is_null() ? nullptr : fallback_period_fragment.data());

    fragment->attempts = Traits::attempts(input);

    
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
      Traits::rotate(input),
      &fragment->rotate);

    
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
      Traits::use_local_ipv6(input),
      &fragment->use_local_ipv6);

    decltype(Traits::dns_over_https_config(input)) in_dns_over_https_config = Traits::dns_over_https_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dns_over_https_config)::BaseType> dns_over_https_config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::DnsOverHttpsConfigDataView>(
      in_dns_over_https_config,
      dns_over_https_config_fragment);

    fragment->dns_over_https_config.Set(
        dns_over_https_config_fragment.is_null() ? nullptr : dns_over_https_config_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::OptionalSecureDnsMode>(
      Traits::secure_dns_mode(input),
      &fragment->secure_dns_mode);

    
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
      Traits::allow_dns_over_https_upgrade(input),
      &fragment->allow_dns_over_https_upgrade);

    decltype(Traits::fallback_doh_nameservers(input)) in_fallback_doh_nameservers = Traits::fallback_doh_nameservers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fallback_doh_nameservers)::BaseType>
        fallback_doh_nameservers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fallback_doh_nameservers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
      in_fallback_doh_nameservers,
      fallback_doh_nameservers_fragment,
      &fallback_doh_nameservers_validate_params);

    fragment->fallback_doh_nameservers.Set(
        fallback_doh_nameservers_fragment.is_null() ? nullptr : fallback_doh_nameservers_fragment.data());

    fragment->clear_hosts = Traits::clear_hosts(input);
  }

  static bool Deserialize(::network::mojom::internal::DnsConfigOverrides_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DnsConfigOverridesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ResolveHostParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ResolveHostParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      Traits::dns_query_type(input),
      &fragment->dns_query_type);

    
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
      Traits::initial_priority(input),
      &fragment->initial_priority);

    
    mojo::internal::Serialize<::network::mojom::ResolveHostParameters_Source>(
      Traits::source(input),
      &fragment->source);

    
    mojo::internal::Serialize<::network::mojom::ResolveHostParameters_CacheUsage>(
      Traits::cache_usage(input),
      &fragment->cache_usage);

    decltype(Traits::control_handle(input)) in_control_handle = Traits::control_handle(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ResolveHostHandleInterfaceBase>>(
      in_control_handle,
      &fragment->control_handle,
      &fragment.message());

    fragment->include_canonical_name = Traits::include_canonical_name(input);

    fragment->loopback_only = Traits::loopback_only(input);

    fragment->is_speculative = Traits::is_speculative(input);

    
    mojo::internal::Serialize<::network::mojom::SecureDnsPolicy>(
      Traits::secure_dns_policy(input),
      &fragment->secure_dns_policy);

    
    mojo::internal::Serialize<::network::mojom::ResolveHostParameters_Purpose>(
      Traits::purpose(input),
      &fragment->purpose);
  }

  static bool Deserialize(::network::mojom::internal::ResolveHostParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ResolveHostParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HostResolverHostDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::HostResolverHostDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::HostResolverHost_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::HostResolverHostDataView::Tag::kSchemeHostPort: {
    decltype(Traits::scheme_host_port(input))
    in_scheme_host_port = Traits::scheme_host_port(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scheme_host_port)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView>(
  in_scheme_host_port,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scheme_host_port in HostResolverHost union");
    fragment->data.f_scheme_host_port.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::HostResolverHostDataView::Tag::kHostPortPair: {
    decltype(Traits::host_port_pair(input))
    in_host_port_pair = Traits::host_port_pair(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_host_port_pair)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
  in_host_port_pair,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null host_port_pair in HostResolverHost union");
    fragment->data.f_host_port_pair.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::HostResolverHost_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HostResolverHostDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void DnsOverHttpsServerConfigDataView::GetServerTemplateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->server_template.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DnsOverHttpsServerConfigDataView::GetEndpointsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>* output) {
  auto pointer = data_->endpoints.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(pointer, message_);
}


inline void DnsOverHttpsConfigDataView::GetServersDataView(
    mojo::ArrayDataView<DnsOverHttpsServerConfigDataView>* output) {
  auto pointer = data_->servers.Get();
  *output = mojo::ArrayDataView<DnsOverHttpsServerConfigDataView>(pointer, message_);
}


inline void DnsConfigOverridesDataView::GetNameserversDataView(
    mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output) {
  auto pointer = data_->nameservers.Get();
  *output = mojo::ArrayDataView<::network::mojom::IPEndPointDataView>(pointer, message_);
}
inline void DnsConfigOverridesDataView::GetSearchDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->search.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void DnsConfigOverridesDataView::GetFallbackPeriodDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->fallback_period.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DnsConfigOverridesDataView::GetDnsOverHttpsConfigDataView(
    DnsOverHttpsConfigDataView* output) {
  auto pointer = data_->dns_over_https_config.Get();
  *output = DnsOverHttpsConfigDataView(pointer, message_);
}
inline void DnsConfigOverridesDataView::GetFallbackDohNameserversDataView(
    mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output) {
  auto pointer = data_->fallback_doh_nameservers.Get();
  *output = mojo::ArrayDataView<::network::mojom::IPEndPointDataView>(pointer, message_);
}




inline void HostResolverHostDataView::GetSchemeHostPortDataView(
    ::url::mojom::SchemeHostPortDataView* output) const {
  CHECK(is_scheme_host_port());
  *output = ::url::mojom::SchemeHostPortDataView(data_->data.f_scheme_host_port.Get(), message_);
}
inline void HostResolverHostDataView::GetHostPortPairDataView(
    ::network::mojom::HostPortPairDataView* output) const {
  CHECK(is_host_port_pair());
  *output = ::network::mojom::HostPortPairDataView(data_->data.f_host_port_pair.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::OptionalSecureDnsMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::OptionalSecureDnsMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SecureDnsMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SecureDnsMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SecureDnsPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SecureDnsPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DnsQueryType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DnsQueryType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DnsConfigOverrides_Tristate> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DnsConfigOverrides_Tristate value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ResolveHostParameters_Source> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_Source value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ResolveHostParameters_CacheUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_CacheUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ResolveHostParameters_Purpose> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_Purpose value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::MdnsListenClient_UpdateType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::MdnsListenClient_UpdateType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SHARED_H_