// services/network/public/mojom/host_resolver.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/host_resolver.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"

#include "services/network/public/mojom/host_resolver.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::OptionalSecureDnsMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SecureDnsMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SecureDnsPolicy, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::DnsQueryType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DnsOverHttpsServerConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsOverHttpsServerConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsOverHttpsServerConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::server_template(input)) in_server_template = Traits::server_template(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->server_template)::BaseType> server_template_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_server_template,
        server_template_fragment);

      fragment->server_template.Set(
          server_template_fragment.is_null() ? nullptr : server_template_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->server_template.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_template in DnsOverHttpsServerConfig struct");

      decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->endpoints)::BaseType>
          endpoints_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>, send_validation>(
        in_endpoints,
        endpoints_fragment,
        &endpoints_validate_params);

      fragment->endpoints.Set(
          endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->endpoints.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null endpoints in DnsOverHttpsServerConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DnsOverHttpsConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsOverHttpsConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsOverHttpsConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::servers(input)) in_servers = Traits::servers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->servers)::BaseType>
          servers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& servers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DnsOverHttpsServerConfigDataView>, send_validation>(
        in_servers,
        servers_fragment,
        &servers_validate_params);

      fragment->servers.Set(
          servers_fragment.is_null() ? nullptr : servers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->servers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null servers in DnsOverHttpsConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DnsConfigOverridesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsConfigOverridesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsConfigOverrides_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::nameservers(input)) in_nameservers = Traits::nameservers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nameservers)::BaseType>
          nameservers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& nameservers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>, send_validation>(
        in_nameservers,
        nameservers_fragment,
        &nameservers_validate_params);

      fragment->nameservers.Set(
          nameservers_fragment.is_null() ? nullptr : nameservers_fragment.data());

      decltype(Traits::search(input)) in_search = Traits::search(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->search)::BaseType>
          search_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& search_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_search,
        search_fragment,
        &search_validate_params);

      fragment->search.Set(
          search_fragment.is_null() ? nullptr : search_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::append_to_multi_label_name(input),
        &fragment->append_to_multi_label_name);

      fragment->ndots = Traits::ndots(input);

      decltype(Traits::fallback_period(input)) in_fallback_period = Traits::fallback_period(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fallback_period)::BaseType> fallback_period_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_fallback_period,
        fallback_period_fragment);

      fragment->fallback_period.Set(
          fallback_period_fragment.is_null() ? nullptr : fallback_period_fragment.data());

      fragment->attempts = Traits::attempts(input);

      
      mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::rotate(input),
        &fragment->rotate);

      
      mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::use_local_ipv6(input),
        &fragment->use_local_ipv6);

      decltype(Traits::dns_over_https_config(input)) in_dns_over_https_config = Traits::dns_over_https_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dns_over_https_config)::BaseType> dns_over_https_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::DnsOverHttpsConfigDataView, send_validation>(
        in_dns_over_https_config,
        dns_over_https_config_fragment);

      fragment->dns_over_https_config.Set(
          dns_over_https_config_fragment.is_null() ? nullptr : dns_over_https_config_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::OptionalSecureDnsMode>(
        Traits::secure_dns_mode(input),
        &fragment->secure_dns_mode);

      
      mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::allow_dns_over_https_upgrade(input),
        &fragment->allow_dns_over_https_upgrade);

      decltype(Traits::fallback_doh_nameservers(input)) in_fallback_doh_nameservers = Traits::fallback_doh_nameservers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fallback_doh_nameservers)::BaseType>
          fallback_doh_nameservers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fallback_doh_nameservers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>, send_validation>(
        in_fallback_doh_nameservers,
        fallback_doh_nameservers_fragment,
        &fallback_doh_nameservers_validate_params);

      fragment->fallback_doh_nameservers.Set(
          fallback_doh_nameservers_fragment.is_null() ? nullptr : fallback_doh_nameservers_fragment.data());

      fragment->clear_hosts = Traits::clear_hosts(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ResolveHostParametersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ResolveHostParametersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ResolveHostParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::DnsQueryType>(
        Traits::dns_query_type(input),
        &fragment->dns_query_type);

      
      mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::initial_priority(input),
        &fragment->initial_priority);

      
      mojo::internal::Serialize<::network::mojom::ResolveHostParameters_Source>(
        Traits::source(input),
        &fragment->source);

      
      mojo::internal::Serialize<::network::mojom::ResolveHostParameters_CacheUsage>(
        Traits::cache_usage(input),
        &fragment->cache_usage);

      decltype(Traits::control_handle(input)) in_control_handle = Traits::control_handle(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ResolveHostHandleInterfaceBase>>(
        in_control_handle,
        &fragment->control_handle,
        &fragment.message());

      fragment->include_canonical_name = Traits::include_canonical_name(input);

      fragment->loopback_only = Traits::loopback_only(input);

      fragment->is_speculative = Traits::is_speculative(input);

      
      mojo::internal::Serialize<::network::mojom::SecureDnsPolicy>(
        Traits::secure_dns_policy(input),
        &fragment->secure_dns_policy);

      
      mojo::internal::Serialize<::network::mojom::ResolveHostParameters_Purpose>(
        Traits::purpose(input),
        &fragment->purpose);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::HostResolverHostDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::HostResolverHostDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::HostResolverHost_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::HostResolverHostDataView::Tag::kSchemeHostPort: {
    decltype(Traits::scheme_host_port(input))
    in_scheme_host_port = Traits::scheme_host_port(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scheme_host_port)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView, send_validation>(
  in_scheme_host_port,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scheme_host_port in HostResolverHost union");
    fragment->data.f_scheme_host_port.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::HostResolverHostDataView::Tag::kHostPortPair: {
    decltype(Traits::host_port_pair(input))
    in_host_port_pair = Traits::host_port_pair(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_host_port_pair)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::HostPortPairDataView, send_validation>(
  in_host_port_pair,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null host_port_pair in HostResolverHost union");
    fragment->data.f_host_port_pair.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SEND_VALIDATION_H_