// services/network/public/mojom/host_resolver.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/host_resolver.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT ResolveHostHandleInterceptorForTesting : public ResolveHostHandle {
  virtual ResolveHostHandle* GetForwardingInterface() = 0;
  void Cancel(int32_t result) override;
};
class BLINK_PLATFORM_EXPORT ResolveHostHandleAsyncWaiter {
 public:
  explicit ResolveHostHandleAsyncWaiter(ResolveHostHandle* proxy);

  ResolveHostHandleAsyncWaiter(const ResolveHostHandleAsyncWaiter&) = delete;
  ResolveHostHandleAsyncWaiter& operator=(const ResolveHostHandleAsyncWaiter&) = delete;

  ~ResolveHostHandleAsyncWaiter();

 private:
  ResolveHostHandle* const proxy_;
};


class BLINK_PLATFORM_EXPORT ResolveHostClientInterceptorForTesting : public ResolveHostClient {
  virtual ResolveHostClient* GetForwardingInterface() = 0;
  void OnComplete(int32_t result, ::network::mojom::blink::ResolveErrorInfoPtr resolve_error_info, ::network::mojom::blink::AddressListPtr resolved_addresses, ::blink::Vector<::network::mojom::blink::HostResolverEndpointResultPtr> alternative_endpoints) override;
  void OnTextResults(const ::blink::Vector<::blink::String>& text_results) override;
  void OnHostnameResults(const ::blink::Vector<::net::HostPortPair>& hosts) override;
};
class BLINK_PLATFORM_EXPORT ResolveHostClientAsyncWaiter {
 public:
  explicit ResolveHostClientAsyncWaiter(ResolveHostClient* proxy);

  ResolveHostClientAsyncWaiter(const ResolveHostClientAsyncWaiter&) = delete;
  ResolveHostClientAsyncWaiter& operator=(const ResolveHostClientAsyncWaiter&) = delete;

  ~ResolveHostClientAsyncWaiter();

 private:
  ResolveHostClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT MdnsListenClientInterceptorForTesting : public MdnsListenClient {
  virtual MdnsListenClient* GetForwardingInterface() = 0;
  void OnAddressResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::IPEndPoint& endpoint) override;
  void OnTextResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type, const ::blink::Vector<::blink::String>& text_records) override;
  void OnHostnameResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::HostPortPair& host) override;
  void OnUnhandledResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type) override;
};
class BLINK_PLATFORM_EXPORT MdnsListenClientAsyncWaiter {
 public:
  explicit MdnsListenClientAsyncWaiter(MdnsListenClient* proxy);

  MdnsListenClientAsyncWaiter(const MdnsListenClientAsyncWaiter&) = delete;
  MdnsListenClientAsyncWaiter& operator=(const MdnsListenClientAsyncWaiter&) = delete;

  ~MdnsListenClientAsyncWaiter();

 private:
  MdnsListenClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT HostResolverInterceptorForTesting : public HostResolver {
  virtual HostResolver* GetForwardingInterface() = 0;
  void ResolveHost(HostResolverHostPtr host, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<ResolveHostClient> response_client) override;
  void MdnsListen(const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, MdnsListenCallback callback) override;
};
class BLINK_PLATFORM_EXPORT HostResolverAsyncWaiter {
 public:
  explicit HostResolverAsyncWaiter(HostResolver* proxy);

  HostResolverAsyncWaiter(const HostResolverAsyncWaiter&) = delete;
  HostResolverAsyncWaiter& operator=(const HostResolverAsyncWaiter&) = delete;

  ~HostResolverAsyncWaiter();
  void MdnsListen(
      const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, int32_t* out_result);
  int32_t MdnsListen(const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client);

 private:
  HostResolver* const proxy_;
};


class BLINK_PLATFORM_EXPORT DnsConfigChangeManagerClientInterceptorForTesting : public DnsConfigChangeManagerClient {
  virtual DnsConfigChangeManagerClient* GetForwardingInterface() = 0;
  void OnDnsConfigChanged() override;
};
class BLINK_PLATFORM_EXPORT DnsConfigChangeManagerClientAsyncWaiter {
 public:
  explicit DnsConfigChangeManagerClientAsyncWaiter(DnsConfigChangeManagerClient* proxy);

  DnsConfigChangeManagerClientAsyncWaiter(const DnsConfigChangeManagerClientAsyncWaiter&) = delete;
  DnsConfigChangeManagerClientAsyncWaiter& operator=(const DnsConfigChangeManagerClientAsyncWaiter&) = delete;

  ~DnsConfigChangeManagerClientAsyncWaiter();

 private:
  DnsConfigChangeManagerClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT DnsConfigChangeManagerInterceptorForTesting : public DnsConfigChangeManager {
  virtual DnsConfigChangeManager* GetForwardingInterface() = 0;
  void RequestNotifications(::mojo::PendingRemote<DnsConfigChangeManagerClient> client) override;
};
class BLINK_PLATFORM_EXPORT DnsConfigChangeManagerAsyncWaiter {
 public:
  explicit DnsConfigChangeManagerAsyncWaiter(DnsConfigChangeManager* proxy);

  DnsConfigChangeManagerAsyncWaiter(const DnsConfigChangeManagerAsyncWaiter&) = delete;
  DnsConfigChangeManagerAsyncWaiter& operator=(const DnsConfigChangeManagerAsyncWaiter&) = delete;

  ~DnsConfigChangeManagerAsyncWaiter();

 private:
  DnsConfigChangeManager* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_BLINK_TEST_UTILS_H_