// services/network/public/mojom/hash_value.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HASH_VALUE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HASH_VALUE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/hash_value.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/hash_value.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/hash_value.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/network/public/cpp/hash_value_mojom_traits.h"




namespace network::mojom {








class  SHA256HashValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SHA256HashValue, T>::value>;
  using DataView = SHA256HashValueDataView;
  using Data_ = internal::SHA256HashValue_Data;

  template <typename... Args>
  static SHA256HashValuePtr New(Args&&... args) {
    return SHA256HashValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SHA256HashValuePtr From(const U& u) {
    return mojo::TypeConverter<SHA256HashValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SHA256HashValue>::Convert(*this);
  }


  SHA256HashValue();

  explicit SHA256HashValue(
      std::vector<uint8_t> data);


  ~SHA256HashValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SHA256HashValuePtr>
  SHA256HashValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SHA256HashValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SHA256HashValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SHA256HashValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SHA256HashValue_UnserializedMessageContext<
            UserType, SHA256HashValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SHA256HashValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SHA256HashValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SHA256HashValue_UnserializedMessageContext<
            UserType, SHA256HashValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SHA256HashValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SHA256HashValuePtr SHA256HashValue::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, SHA256HashValue::EnableIfSame<T>*>
bool SHA256HashValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, SHA256HashValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SHA256HashValue::DataView,
                                         ::network::mojom::SHA256HashValuePtr> {
  static bool IsNull(const ::network::mojom::SHA256HashValuePtr& input) { return !input; }
  static void SetToNull(::network::mojom::SHA256HashValuePtr* output) { output->reset(); }

  static const decltype(::network::mojom::SHA256HashValue::data)& data(
      const ::network::mojom::SHA256HashValuePtr& input) {
    return input->data;
  }

  static bool Read(::network::mojom::SHA256HashValue::DataView input, ::network::mojom::SHA256HashValuePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HASH_VALUE_MOJOM_H_