// services/network/public/mojom/first_party_sets_access_delegate.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_ACCESS_DELEGATE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_ACCESS_DELEGATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/first_party_sets.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class FirstPartySetsAccessDelegateProxy;

template <typename ImplRefTraits>
class FirstPartySetsAccessDelegateStub;

class FirstPartySetsAccessDelegateRequestValidator;


class FirstPartySetsAccessDelegate
    : public FirstPartySetsAccessDelegateInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.FirstPartySetsAccessDelegate";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FirstPartySetsAccessDelegateInterfaceBase;
  using Proxy_ = FirstPartySetsAccessDelegateProxy;

  template <typename ImplRefTraits>
  using Stub_ = FirstPartySetsAccessDelegateStub<ImplRefTraits>;

  using RequestValidator_ = FirstPartySetsAccessDelegateRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyReadyMinVersion = 0,
    kSetEnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FirstPartySetsAccessDelegate() = default;

  virtual void NotifyReady(FirstPartySetsReadyEventPtr ready_event) = 0;

  virtual void SetEnabled(bool enabled) = 0;
};



class  FirstPartySetsAccessDelegateProxy
    : public FirstPartySetsAccessDelegate {
 public:
  using InterfaceType = FirstPartySetsAccessDelegate;

  explicit FirstPartySetsAccessDelegateProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyReady(FirstPartySetsReadyEventPtr ready_event) final;
  
  void SetEnabled(bool enabled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FirstPartySetsAccessDelegateStubDispatch {
 public:
  static bool Accept(FirstPartySetsAccessDelegate* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FirstPartySetsAccessDelegate* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FirstPartySetsAccessDelegate>>
class FirstPartySetsAccessDelegateStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FirstPartySetsAccessDelegateStub() = default;
  ~FirstPartySetsAccessDelegateStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FirstPartySetsAccessDelegateStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FirstPartySetsAccessDelegateStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FirstPartySetsAccessDelegateRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  FirstPartySetsAccessDelegateParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetsAccessDelegateParams, T>::value>;
  using DataView = FirstPartySetsAccessDelegateParamsDataView;
  using Data_ = internal::FirstPartySetsAccessDelegateParams_Data;

  template <typename... Args>
  static FirstPartySetsAccessDelegateParamsPtr New(Args&&... args) {
    return FirstPartySetsAccessDelegateParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetsAccessDelegateParamsPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetsAccessDelegateParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetsAccessDelegateParams>::Convert(*this);
  }


  FirstPartySetsAccessDelegateParams();

  explicit FirstPartySetsAccessDelegateParams(
      bool enabled);


  ~FirstPartySetsAccessDelegateParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetsAccessDelegateParamsPtr>
  FirstPartySetsAccessDelegateParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsAccessDelegateParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsAccessDelegateParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetsAccessDelegateParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetsAccessDelegateParams_UnserializedMessageContext<
            UserType, FirstPartySetsAccessDelegateParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetsAccessDelegateParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetsAccessDelegateParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetsAccessDelegateParams_UnserializedMessageContext<
            UserType, FirstPartySetsAccessDelegateParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetsAccessDelegateParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  FirstPartySetsReadyEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetsReadyEvent, T>::value>;
  using DataView = FirstPartySetsReadyEventDataView;
  using Data_ = internal::FirstPartySetsReadyEvent_Data;

  template <typename... Args>
  static FirstPartySetsReadyEventPtr New(Args&&... args) {
    return FirstPartySetsReadyEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetsReadyEventPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetsReadyEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetsReadyEvent>::Convert(*this);
  }


  FirstPartySetsReadyEvent();

  FirstPartySetsReadyEvent(
      ::net::FirstPartySetsContextConfig config,
      ::net::FirstPartySetsCacheFilter cache_filter);

FirstPartySetsReadyEvent(const FirstPartySetsReadyEvent&) = delete;
FirstPartySetsReadyEvent& operator=(const FirstPartySetsReadyEvent&) = delete;

  ~FirstPartySetsReadyEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetsReadyEventPtr>
  FirstPartySetsReadyEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsReadyEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsReadyEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetsReadyEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetsReadyEvent_UnserializedMessageContext<
            UserType, FirstPartySetsReadyEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetsReadyEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetsReadyEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetsReadyEvent_UnserializedMessageContext<
            UserType, FirstPartySetsReadyEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetsReadyEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::FirstPartySetsContextConfig config;
  
  ::net::FirstPartySetsCacheFilter cache_filter;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FirstPartySetsAccessDelegateParamsPtr FirstPartySetsAccessDelegateParams::Clone() const {
  return New(
      mojo::Clone(enabled)
  );
}

template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>*>
bool FirstPartySetsAccessDelegateParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enabled, other_struct.enabled))
    return false;
  return true;
}

template <typename T, FirstPartySetsAccessDelegateParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.enabled < rhs.enabled)
    return true;
  if (rhs.enabled < lhs.enabled)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetsReadyEventPtr FirstPartySetsReadyEvent::Clone() const {
  return New(
      mojo::Clone(config),
      mojo::Clone(cache_filter)
  );
}

template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>*>
bool FirstPartySetsReadyEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->config, other_struct.config))
    return false;
  if (!mojo::Equals(this->cache_filter, other_struct.cache_filter))
    return false;
  return true;
}

template <typename T, FirstPartySetsReadyEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.config < rhs.config)
    return true;
  if (rhs.config < lhs.config)
    return false;
  if (lhs.cache_filter < rhs.cache_filter)
    return true;
  if (rhs.cache_filter < lhs.cache_filter)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::FirstPartySetsAccessDelegateParams::DataView,
                                         ::network::mojom::FirstPartySetsAccessDelegateParamsPtr> {
  static bool IsNull(const ::network::mojom::FirstPartySetsAccessDelegateParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FirstPartySetsAccessDelegateParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::FirstPartySetsAccessDelegateParams::enabled) enabled(
      const ::network::mojom::FirstPartySetsAccessDelegateParamsPtr& input) {
    return input->enabled;
  }

  static bool Read(::network::mojom::FirstPartySetsAccessDelegateParams::DataView input, ::network::mojom::FirstPartySetsAccessDelegateParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::FirstPartySetsReadyEvent::DataView,
                                         ::network::mojom::FirstPartySetsReadyEventPtr> {
  static bool IsNull(const ::network::mojom::FirstPartySetsReadyEventPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FirstPartySetsReadyEventPtr* output) { output->reset(); }

  static const decltype(::network::mojom::FirstPartySetsReadyEvent::config)& config(
      const ::network::mojom::FirstPartySetsReadyEventPtr& input) {
    return input->config;
  }

  static const decltype(::network::mojom::FirstPartySetsReadyEvent::cache_filter)& cache_filter(
      const ::network::mojom::FirstPartySetsReadyEventPtr& input) {
    return input->cache_filter;
  }

  static bool Read(::network::mojom::FirstPartySetsReadyEvent::DataView input, ::network::mojom::FirstPartySetsReadyEventPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_ACCESS_DELEGATE_MOJOM_H_