// services/network/public/mojom/first_party_sets_access_delegate.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/first_party_sets_access_delegate.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-params-data.h"
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-shared-message-ids.h"

#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-import-headers.h"
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-test-utils.h"


namespace network::mojom {
FirstPartySetsAccessDelegateParams::FirstPartySetsAccessDelegateParams()
    : enabled() {}

FirstPartySetsAccessDelegateParams::FirstPartySetsAccessDelegateParams(
    bool enabled_in)
    : enabled(std::move(enabled_in)) {}

FirstPartySetsAccessDelegateParams::~FirstPartySetsAccessDelegateParams() = default;
size_t FirstPartySetsAccessDelegateParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->enabled);
  return seed;
}

void FirstPartySetsAccessDelegateParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled"), this->enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FirstPartySetsAccessDelegateParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FirstPartySetsReadyEvent::FirstPartySetsReadyEvent()
    : config(),
      cache_filter() {}

FirstPartySetsReadyEvent::FirstPartySetsReadyEvent(
    ::net::FirstPartySetsContextConfig config_in,
    ::net::FirstPartySetsCacheFilter cache_filter_in)
    : config(std::move(config_in)),
      cache_filter(std::move(cache_filter_in)) {}

FirstPartySetsReadyEvent::~FirstPartySetsReadyEvent() = default;

void FirstPartySetsReadyEvent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config"), this->config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::FirstPartySetsContextConfig>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_filter"), this->cache_filter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::FirstPartySetsCacheFilter>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FirstPartySetsReadyEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FirstPartySetsAccessDelegate::IPCStableHashFunction FirstPartySetsAccessDelegate::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FirstPartySetsAccessDelegate>(message.name())) {
    case messages::FirstPartySetsAccessDelegate::kNotifyReady: {
      return &FirstPartySetsAccessDelegate::NotifyReady_Sym::IPCStableHash;
    }
    case messages::FirstPartySetsAccessDelegate::kSetEnabled: {
      return &FirstPartySetsAccessDelegate::SetEnabled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FirstPartySetsAccessDelegate::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FirstPartySetsAccessDelegate>(message.name())) {
      case messages::FirstPartySetsAccessDelegate::kNotifyReady:
            return "Receive network::mojom::FirstPartySetsAccessDelegate::NotifyReady";
      case messages::FirstPartySetsAccessDelegate::kSetEnabled:
            return "Receive network::mojom::FirstPartySetsAccessDelegate::SetEnabled";
    }
  } else {
    switch (static_cast<messages::FirstPartySetsAccessDelegate>(message.name())) {
      case messages::FirstPartySetsAccessDelegate::kNotifyReady:
            return "Receive reply network::mojom::FirstPartySetsAccessDelegate::NotifyReady";
      case messages::FirstPartySetsAccessDelegate::kSetEnabled:
            return "Receive reply network::mojom::FirstPartySetsAccessDelegate::SetEnabled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FirstPartySetsAccessDelegate::NotifyReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac455a65;  // IPCStableHash for network::mojom::FirstPartySetsAccessDelegate::NotifyReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FirstPartySetsAccessDelegate::SetEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55be9d94;  // IPCStableHash for network::mojom::FirstPartySetsAccessDelegate::SetEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FirstPartySetsAccessDelegateProxy::FirstPartySetsAccessDelegateProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FirstPartySetsAccessDelegateProxy::NotifyReady(
    FirstPartySetsReadyEventPtr in_ready_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::FirstPartySetsAccessDelegate::NotifyReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ready_event"), in_ready_event,
                        "<value of type FirstPartySetsReadyEventPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FirstPartySetsAccessDelegate::kNotifyReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::FirstPartySetsAccessDelegate_NotifyReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ready_event)::BaseType> ready_event_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::FirstPartySetsReadyEventDataView>(
    in_ready_event,
    ready_event_fragment);

  params->ready_event.Set(
      ready_event_fragment.is_null() ? nullptr : ready_event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ready_event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ready_event in FirstPartySetsAccessDelegate.NotifyReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FirstPartySetsAccessDelegate::Name_);
  message.set_method_name("NotifyReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FirstPartySetsAccessDelegateProxy::SetEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::FirstPartySetsAccessDelegate::SetEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FirstPartySetsAccessDelegate::kSetEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::FirstPartySetsAccessDelegate_SetEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FirstPartySetsAccessDelegate::Name_);
  message.set_method_name("SetEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FirstPartySetsAccessDelegateStubDispatch::Accept(
    FirstPartySetsAccessDelegate* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FirstPartySetsAccessDelegate>(message->header()->name)) {
    case messages::FirstPartySetsAccessDelegate::kNotifyReady: {
      DCHECK(message->is_serialized());
      internal::FirstPartySetsAccessDelegate_NotifyReady_Params_Data* params =
          reinterpret_cast<internal::FirstPartySetsAccessDelegate_NotifyReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FirstPartySetsAccessDelegate.0
      bool success = true;
      FirstPartySetsReadyEventPtr p_ready_event{};
      FirstPartySetsAccessDelegate_NotifyReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReadyEvent(&p_ready_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FirstPartySetsAccessDelegate::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyReady(        
        std::move(p_ready_event));
      return true;
    }
    case messages::FirstPartySetsAccessDelegate::kSetEnabled: {
      DCHECK(message->is_serialized());
      internal::FirstPartySetsAccessDelegate_SetEnabled_Params_Data* params =
          reinterpret_cast<internal::FirstPartySetsAccessDelegate_SetEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FirstPartySetsAccessDelegate.1
      bool success = true;
      bool p_enabled{};
      FirstPartySetsAccessDelegate_SetEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FirstPartySetsAccessDelegate::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnabled(        
        std::move(p_enabled));
      return true;
    }
  }
  return false;
}

// static
bool FirstPartySetsAccessDelegateStubDispatch::AcceptWithResponder(
    FirstPartySetsAccessDelegate* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FirstPartySetsAccessDelegate>(message->header()->name)) {
    case messages::FirstPartySetsAccessDelegate::kNotifyReady: {
      break;
    }
    case messages::FirstPartySetsAccessDelegate::kSetEnabled: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFirstPartySetsAccessDelegateValidationInfo[] = {
    { &internal::FirstPartySetsAccessDelegate_NotifyReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FirstPartySetsAccessDelegate_SetEnabled_Params_Data::Validate,
     nullptr /* no response */},
};

bool FirstPartySetsAccessDelegateRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::FirstPartySetsAccessDelegate::Name_,
    kFirstPartySetsAccessDelegateValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::FirstPartySetsAccessDelegateParams::DataView, ::network::mojom::FirstPartySetsAccessDelegateParamsPtr>::Read(
    ::network::mojom::FirstPartySetsAccessDelegateParams::DataView input,
    ::network::mojom::FirstPartySetsAccessDelegateParamsPtr* output) {
  bool success = true;
  ::network::mojom::FirstPartySetsAccessDelegateParamsPtr result(::network::mojom::FirstPartySetsAccessDelegateParams::New());
  
      if (success)
        result->enabled = input.enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FirstPartySetsReadyEvent::DataView, ::network::mojom::FirstPartySetsReadyEventPtr>::Read(
    ::network::mojom::FirstPartySetsReadyEvent::DataView input,
    ::network::mojom::FirstPartySetsReadyEventPtr* output) {
  bool success = true;
  ::network::mojom::FirstPartySetsReadyEventPtr result(::network::mojom::FirstPartySetsReadyEvent::New());
  
      if (success && !input.ReadConfig(&result->config))
        success = false;
      if (success && !input.ReadCacheFilter(&result->cache_filter))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void FirstPartySetsAccessDelegateInterceptorForTesting::NotifyReady(FirstPartySetsReadyEventPtr ready_event) {
  GetForwardingInterface()->NotifyReady(
    std::move(ready_event)
    );
}
void FirstPartySetsAccessDelegateInterceptorForTesting::SetEnabled(bool enabled) {
  GetForwardingInterface()->SetEnabled(
    std::move(enabled)
    );
}
FirstPartySetsAccessDelegateAsyncWaiter::FirstPartySetsAccessDelegateAsyncWaiter(
    FirstPartySetsAccessDelegate* proxy) : proxy_(proxy) {}

FirstPartySetsAccessDelegateAsyncWaiter::~FirstPartySetsAccessDelegateAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif