// services/network/public/mojom/first_party_sets.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/first_party_sets.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/first_party_sets.mojom-params-data.h"
#include "services/network/public/mojom/first_party_sets.mojom-shared-message-ids.h"

#include "services/network/public/mojom/first_party_sets.mojom-import-headers.h"
#include "services/network/public/mojom/first_party_sets.mojom-test-utils.h"


namespace network::mojom {
FirstPartySetEntry::FirstPartySetEntry()
    : primary(),
      site_type() {}

FirstPartySetEntry::FirstPartySetEntry(
    const ::net::SchemefulSite& primary_in,
    ::net::SiteType site_type_in)
    : primary(std::move(primary_in)),
      site_type(std::move(site_type_in)) {}

FirstPartySetEntry::~FirstPartySetEntry() = default;

void FirstPartySetEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary"), this->primary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SchemefulSite&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_type"), this->site_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::SiteType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FirstPartySetEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FirstPartySetMetadata::FirstPartySetMetadata()
    : frame_entry(),
      top_frame_entry() {}

FirstPartySetMetadata::FirstPartySetMetadata(
    const std::optional<::net::FirstPartySetEntry>& frame_entry_in,
    const std::optional<::net::FirstPartySetEntry>& top_frame_entry_in)
    : frame_entry(std::move(frame_entry_in)),
      top_frame_entry(std::move(top_frame_entry_in)) {}

FirstPartySetMetadata::~FirstPartySetMetadata() = default;

void FirstPartySetMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_entry"), this->frame_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::FirstPartySetEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_frame_entry"), this->top_frame_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::FirstPartySetEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FirstPartySetMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FirstPartySetEntryOverride::FirstPartySetEntryOverride()
    : entry() {}

FirstPartySetEntryOverride::FirstPartySetEntryOverride(
    const std::optional<::net::FirstPartySetEntry>& entry_in)
    : entry(std::move(entry_in)) {}

FirstPartySetEntryOverride::~FirstPartySetEntryOverride() = default;

void FirstPartySetEntryOverride::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entry"), this->entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::FirstPartySetEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FirstPartySetEntryOverride::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FirstPartySetsContextConfig::FirstPartySetsContextConfig()
    : customizations(),
      aliases() {}

FirstPartySetsContextConfig::FirstPartySetsContextConfig(
    const base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntryOverride>& customizations_in,
    const base::flat_map<::net::SchemefulSite, ::net::SchemefulSite>& aliases_in)
    : customizations(std::move(customizations_in)),
      aliases(std::move(aliases_in)) {}

FirstPartySetsContextConfig::~FirstPartySetsContextConfig() = default;

void FirstPartySetsContextConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "customizations"), this->customizations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntryOverride>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aliases"), this->aliases,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::net::SchemefulSite, ::net::SchemefulSite>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FirstPartySetsContextConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FirstPartySetsCacheFilter::FirstPartySetsCacheFilter()
    : filter(),
      browser_run_id(0) {}

FirstPartySetsCacheFilter::FirstPartySetsCacheFilter(
    const base::flat_map<::net::SchemefulSite, int64_t>& filter_in,
    int64_t browser_run_id_in)
    : filter(std::move(filter_in)),
      browser_run_id(std::move(browser_run_id_in)) {}

FirstPartySetsCacheFilter::~FirstPartySetsCacheFilter() = default;

void FirstPartySetsCacheFilter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter"), this->filter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::net::SchemefulSite, int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_run_id"), this->browser_run_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FirstPartySetsCacheFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GlobalFirstPartySets::GlobalFirstPartySets()
    : public_sets_version(),
      sets(),
      aliases(),
      manual_config() {}

GlobalFirstPartySets::GlobalFirstPartySets(
    const ::base::Version& public_sets_version_in,
    const base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntry>& sets_in,
    const base::flat_map<::net::SchemefulSite, ::net::SchemefulSite>& aliases_in,
    ::net::FirstPartySetsContextConfig manual_config_in)
    : public_sets_version(std::move(public_sets_version_in)),
      sets(std::move(sets_in)),
      aliases(std::move(aliases_in)),
      manual_config(std::move(manual_config_in)) {}

GlobalFirstPartySets::~GlobalFirstPartySets() = default;

void GlobalFirstPartySets::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_sets_version"), this->public_sets_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Version&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sets"), this->sets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aliases"), this->aliases,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::net::SchemefulSite, ::net::SchemefulSite>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manual_config"), this->manual_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::FirstPartySetsContextConfig>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GlobalFirstPartySets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::FirstPartySetEntry::DataView, ::network::mojom::FirstPartySetEntryPtr>::Read(
    ::network::mojom::FirstPartySetEntry::DataView input,
    ::network::mojom::FirstPartySetEntryPtr* output) {
  bool success = true;
  ::network::mojom::FirstPartySetEntryPtr result(::network::mojom::FirstPartySetEntry::New());
  
      if (success && !input.ReadPrimary(&result->primary))
        success = false;
      if (success && !input.ReadSiteType(&result->site_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FirstPartySetMetadata::DataView, ::network::mojom::FirstPartySetMetadataPtr>::Read(
    ::network::mojom::FirstPartySetMetadata::DataView input,
    ::network::mojom::FirstPartySetMetadataPtr* output) {
  bool success = true;
  ::network::mojom::FirstPartySetMetadataPtr result(::network::mojom::FirstPartySetMetadata::New());
  
      if (success && !input.ReadFrameEntry(&result->frame_entry))
        success = false;
      if (success && !input.ReadTopFrameEntry(&result->top_frame_entry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FirstPartySetEntryOverride::DataView, ::network::mojom::FirstPartySetEntryOverridePtr>::Read(
    ::network::mojom::FirstPartySetEntryOverride::DataView input,
    ::network::mojom::FirstPartySetEntryOverridePtr* output) {
  bool success = true;
  ::network::mojom::FirstPartySetEntryOverridePtr result(::network::mojom::FirstPartySetEntryOverride::New());
  
      if (success && !input.ReadEntry(&result->entry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FirstPartySetsContextConfig::DataView, ::network::mojom::FirstPartySetsContextConfigPtr>::Read(
    ::network::mojom::FirstPartySetsContextConfig::DataView input,
    ::network::mojom::FirstPartySetsContextConfigPtr* output) {
  bool success = true;
  ::network::mojom::FirstPartySetsContextConfigPtr result(::network::mojom::FirstPartySetsContextConfig::New());
  
      if (success && !input.ReadCustomizations(&result->customizations))
        success = false;
      if (success && !input.ReadAliases(&result->aliases))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FirstPartySetsCacheFilter::DataView, ::network::mojom::FirstPartySetsCacheFilterPtr>::Read(
    ::network::mojom::FirstPartySetsCacheFilter::DataView input,
    ::network::mojom::FirstPartySetsCacheFilterPtr* output) {
  bool success = true;
  ::network::mojom::FirstPartySetsCacheFilterPtr result(::network::mojom::FirstPartySetsCacheFilter::New());
  
      if (success && !input.ReadFilter(&result->filter))
        success = false;
      if (success)
        result->browser_run_id = input.browser_run_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::GlobalFirstPartySets::DataView, ::network::mojom::GlobalFirstPartySetsPtr>::Read(
    ::network::mojom::GlobalFirstPartySets::DataView input,
    ::network::mojom::GlobalFirstPartySetsPtr* output) {
  bool success = true;
  ::network::mojom::GlobalFirstPartySetsPtr result(::network::mojom::GlobalFirstPartySets::New());
  
      if (success && !input.ReadPublicSetsVersion(&result->public_sets_version))
        success = false;
      if (success && !input.ReadSets(&result->sets))
        success = false;
      if (success && !input.ReadAliases(&result->aliases))
        success = false;
      if (success && !input.ReadManualConfig(&result->manual_config))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif