// services/network/public/mojom/first_party_sets.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/first_party_sets.mojom-shared-internal.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"

#include "services/network/public/mojom/first_party_sets.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SiteType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FirstPartySetEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::primary(input)) in_primary = Traits::primary(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->primary)::BaseType> primary_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView, send_validation>(
        in_primary,
        primary_fragment);

      fragment->primary.Set(
          primary_fragment.is_null() ? nullptr : primary_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->primary.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary in FirstPartySetEntry struct");

      
      mojo::internal::Serialize<::network::mojom::SiteType>(
        Traits::site_type(input),
        &fragment->site_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FirstPartySetMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_entry(input)) in_frame_entry = Traits::frame_entry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_entry)::BaseType> frame_entry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::FirstPartySetEntryDataView, send_validation>(
        in_frame_entry,
        frame_entry_fragment);

      fragment->frame_entry.Set(
          frame_entry_fragment.is_null() ? nullptr : frame_entry_fragment.data());

      decltype(Traits::top_frame_entry(input)) in_top_frame_entry = Traits::top_frame_entry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_frame_entry)::BaseType> top_frame_entry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::FirstPartySetEntryDataView, send_validation>(
        in_top_frame_entry,
        top_frame_entry_fragment);

      fragment->top_frame_entry.Set(
          top_frame_entry_fragment.is_null() ? nullptr : top_frame_entry_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FirstPartySetEntryOverrideDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetEntryOverrideDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetEntryOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::entry(input)) in_entry = Traits::entry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->entry)::BaseType> entry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::FirstPartySetEntryDataView, send_validation>(
        in_entry,
        entry_fragment);

      fragment->entry.Set(
          entry_fragment.is_null() ? nullptr : entry_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FirstPartySetsContextConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetsContextConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetsContextConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::customizations(input)) in_customizations = Traits::customizations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->customizations)::BaseType>
          customizations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& customizations_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::FirstPartySetEntryOverrideDataView>, send_validation>(
        in_customizations,
        customizations_fragment,
        &customizations_validate_params);

      fragment->customizations.Set(
          customizations_fragment.is_null() ? nullptr : customizations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->customizations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null customizations in FirstPartySetsContextConfig struct");

      decltype(Traits::aliases(input)) in_aliases = Traits::aliases(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aliases)::BaseType>
          aliases_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aliases_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>, send_validation>(
        in_aliases,
        aliases_fragment,
        &aliases_validate_params);

      fragment->aliases.Set(
          aliases_fragment.is_null() ? nullptr : aliases_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aliases.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aliases in FirstPartySetsContextConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FirstPartySetsCacheFilterDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetsCacheFilterDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetsCacheFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::filter(input)) in_filter = Traits::filter(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filter)::BaseType>
          filter_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& filter_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, int64_t>, send_validation>(
        in_filter,
        filter_fragment,
        &filter_validate_params);

      fragment->filter.Set(
          filter_fragment.is_null() ? nullptr : filter_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filter.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filter in FirstPartySetsCacheFilter struct");

      fragment->browser_run_id = Traits::browser_run_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::GlobalFirstPartySetsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::GlobalFirstPartySetsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::GlobalFirstPartySets_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::public_sets_version(input)) in_public_sets_version = Traits::public_sets_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->public_sets_version)::BaseType> public_sets_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::VersionDataView, send_validation>(
        in_public_sets_version,
        public_sets_version_fragment);

      fragment->public_sets_version.Set(
          public_sets_version_fragment.is_null() ? nullptr : public_sets_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->public_sets_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null public_sets_version in GlobalFirstPartySets struct");

      decltype(Traits::sets(input)) in_sets = Traits::sets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sets)::BaseType>
          sets_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sets_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::FirstPartySetEntryDataView>, send_validation>(
        in_sets,
        sets_fragment,
        &sets_validate_params);

      fragment->sets.Set(
          sets_fragment.is_null() ? nullptr : sets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sets in GlobalFirstPartySets struct");

      decltype(Traits::aliases(input)) in_aliases = Traits::aliases(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aliases)::BaseType>
          aliases_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aliases_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>, send_validation>(
        in_aliases,
        aliases_fragment,
        &aliases_validate_params);

      fragment->aliases.Set(
          aliases_fragment.is_null() ? nullptr : aliases_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aliases.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aliases in GlobalFirstPartySets struct");

      decltype(Traits::manual_config(input)) in_manual_config = Traits::manual_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->manual_config)::BaseType> manual_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::FirstPartySetsContextConfigDataView, send_validation>(
        in_manual_config,
        manual_config_fragment);

      fragment->manual_config.Set(
          manual_config_fragment.is_null() ? nullptr : manual_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->manual_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manual_config in GlobalFirstPartySets struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_SEND_VALIDATION_H_