// services/network/public/mojom/fetch_api.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/fetch_api.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/fetch_api.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* RequestModeToStringHelper(RequestMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestMode::kSameOrigin:
      return "kSameOrigin";
    case RequestMode::kNoCors:
      return "kNoCors";
    case RequestMode::kCors:
      return "kCors";
    case RequestMode::kCorsWithForcedPreflight:
      return "kCorsWithForcedPreflight";
    case RequestMode::kNavigate:
      return "kNavigate";
    default:
      return nullptr;
  }
}

std::string RequestModeToString(RequestMode value) {
  const char *str = RequestModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestMode value) {
  return os << RequestModeToString(value);
}

NOINLINE static const char* RequestDestinationToStringHelper(RequestDestination value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestDestination::kEmpty:
      return "kEmpty";
    case RequestDestination::kAudio:
      return "kAudio";
    case RequestDestination::kAudioWorklet:
      return "kAudioWorklet";
    case RequestDestination::kDocument:
      return "kDocument";
    case RequestDestination::kEmbed:
      return "kEmbed";
    case RequestDestination::kFont:
      return "kFont";
    case RequestDestination::kFrame:
      return "kFrame";
    case RequestDestination::kIframe:
      return "kIframe";
    case RequestDestination::kImage:
      return "kImage";
    case RequestDestination::kManifest:
      return "kManifest";
    case RequestDestination::kObject:
      return "kObject";
    case RequestDestination::kPaintWorklet:
      return "kPaintWorklet";
    case RequestDestination::kReport:
      return "kReport";
    case RequestDestination::kScript:
      return "kScript";
    case RequestDestination::kServiceWorker:
      return "kServiceWorker";
    case RequestDestination::kSharedWorker:
      return "kSharedWorker";
    case RequestDestination::kStyle:
      return "kStyle";
    case RequestDestination::kTrack:
      return "kTrack";
    case RequestDestination::kVideo:
      return "kVideo";
    case RequestDestination::kWebBundle:
      return "kWebBundle";
    case RequestDestination::kWorker:
      return "kWorker";
    case RequestDestination::kXslt:
      return "kXslt";
    case RequestDestination::kFencedframe:
      return "kFencedframe";
    case RequestDestination::kWebIdentity:
      return "kWebIdentity";
    case RequestDestination::kDictionary:
      return "kDictionary";
    case RequestDestination::kSpeculationRules:
      return "kSpeculationRules";
    case RequestDestination::kJson:
      return "kJson";
    case RequestDestination::kSharedStorageWorklet:
      return "kSharedStorageWorklet";
    case RequestDestination::kEmailVerification:
      return "kEmailVerification";
    default:
      return nullptr;
  }
}

std::string RequestDestinationToString(RequestDestination value) {
  const char *str = RequestDestinationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestDestination value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestDestination value) {
  return os << RequestDestinationToString(value);
}

NOINLINE static const char* RedirectModeToStringHelper(RedirectMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RedirectMode::kFollow:
      return "kFollow";
    case RedirectMode::kError:
      return "kError";
    case RedirectMode::kManual:
      return "kManual";
    default:
      return nullptr;
  }
}

std::string RedirectModeToString(RedirectMode value) {
  const char *str = RedirectModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RedirectMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RedirectMode value) {
  return os << RedirectModeToString(value);
}

NOINLINE static const char* CredentialsModeToStringHelper(CredentialsMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CredentialsMode::kOmit:
      return "kOmit";
    case CredentialsMode::kSameOrigin:
      return "kSameOrigin";
    case CredentialsMode::kInclude:
      return "kInclude";
    case CredentialsMode::kOmitBug_775438_Workaround:
      return "kOmitBug_775438_Workaround";
    default:
      return nullptr;
  }
}

std::string CredentialsModeToString(CredentialsMode value) {
  const char *str = CredentialsModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CredentialsMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CredentialsMode value) {
  return os << CredentialsModeToString(value);
}

NOINLINE static const char* FetchResponseTypeToStringHelper(FetchResponseType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FetchResponseType::kBasic:
      return "kBasic";
    case FetchResponseType::kCors:
      return "kCors";
    case FetchResponseType::kDefault:
      return "kDefault";
    case FetchResponseType::kError:
      return "kError";
    case FetchResponseType::kOpaque:
      return "kOpaque";
    case FetchResponseType::kOpaqueRedirect:
      return "kOpaqueRedirect";
    default:
      return nullptr;
  }
}

std::string FetchResponseTypeToString(FetchResponseType value) {
  const char *str = FetchResponseTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FetchResponseType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FetchResponseType value) {
  return os << FetchResponseTypeToString(value);
}

NOINLINE static const char* FetchResponseSourceToStringHelper(FetchResponseSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FetchResponseSource::kUnspecified:
      return "kUnspecified";
    case FetchResponseSource::kNetwork:
      return "kNetwork";
    case FetchResponseSource::kHttpCache:
      return "kHttpCache";
    case FetchResponseSource::kCacheStorage:
      return "kCacheStorage";
    default:
      return nullptr;
  }
}

std::string FetchResponseSourceToString(FetchResponseSource value) {
  const char *str = FetchResponseSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FetchResponseSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FetchResponseSource value) {
  return os << FetchResponseSourceToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RequestMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::RequestMode value) {
  return std::move(context).WriteString(::network::mojom::RequestModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RequestDestination>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::RequestDestination value) {
  return std::move(context).WriteString(::network::mojom::RequestDestinationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RedirectMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::RedirectMode value) {
  return std::move(context).WriteString(::network::mojom::RedirectModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CredentialsMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CredentialsMode value) {
  return std::move(context).WriteString(::network::mojom::CredentialsModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::FetchResponseType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::FetchResponseType value) {
  return std::move(context).WriteString(::network::mojom::FetchResponseTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::FetchResponseSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::FetchResponseSource value) {
  return std::move(context).WriteString(::network::mojom::FetchResponseSourceToString(value));
}

} // namespace perfetto