// services/network/public/mojom/encoded_body_length.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ENCODED_BODY_LENGTH_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ENCODED_BODY_LENGTH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/encoded_body_length.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/encoded_body_length.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/encoded_body_length.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace network::mojom {





class  EncodedBodyLength {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EncodedBodyLength, T>::value>;
  using DataView = EncodedBodyLengthDataView;
  using Data_ = internal::EncodedBodyLength_Data;

  template <typename... Args>
  static EncodedBodyLengthPtr New(Args&&... args) {
    return EncodedBodyLengthPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncodedBodyLengthPtr From(const U& u) {
    return mojo::TypeConverter<EncodedBodyLengthPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EncodedBodyLength>::Convert(*this);
  }


  EncodedBodyLength();

  explicit EncodedBodyLength(
      uint64_t value);


  ~EncodedBodyLength();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncodedBodyLengthPtr>
  EncodedBodyLengthPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EncodedBodyLength::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EncodedBodyLength::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EncodedBodyLength::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncodedBodyLength::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncodedBodyLength::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EncodedBodyLength::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EncodedBodyLength_UnserializedMessageContext<
            UserType, EncodedBodyLength::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EncodedBodyLength::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EncodedBodyLength::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EncodedBodyLength_UnserializedMessageContext<
            UserType, EncodedBodyLength::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EncodedBodyLength::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EncodedBodyLength::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EncodedBodyLength::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EncodedBodyLength::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EncodedBodyLength::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
EncodedBodyLengthPtr EncodedBodyLength::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, EncodedBodyLength::EnableIfSame<T>*>
bool EncodedBodyLength::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, EncodedBodyLength::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::EncodedBodyLength::DataView,
                                         ::network::mojom::EncodedBodyLengthPtr> {
  static bool IsNull(const ::network::mojom::EncodedBodyLengthPtr& input) { return !input; }
  static void SetToNull(::network::mojom::EncodedBodyLengthPtr* output) { output->reset(); }

  static decltype(::network::mojom::EncodedBodyLength::value) value(
      const ::network::mojom::EncodedBodyLengthPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::EncodedBodyLength::DataView input, ::network::mojom::EncodedBodyLengthPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ENCODED_BODY_LENGTH_MOJOM_H_