// services/network/public/mojom/document_isolation_policy.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DOCUMENT_ISOLATION_POLICY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DOCUMENT_ISOLATION_POLICY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/document_isolation_policy.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"


namespace network::mojom {
class DocumentIsolationPolicyDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::DocumentIsolationPolicyDataView> {
  using Data = ::network::mojom::internal::DocumentIsolationPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class DocumentIsolationPolicyValue : int32_t {
  
  kNone = 0,
  
  kIsolateAndRequireCorp = 1,
  
  kIsolateAndCredentialless = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DocumentIsolationPolicyValue value);
inline bool IsKnownEnumValue(DocumentIsolationPolicyValue value) {
  return internal::DocumentIsolationPolicyValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DocumentIsolationPolicyReporterInterfaceBase {};

using DocumentIsolationPolicyReporterPtrDataView =
    mojo::InterfacePtrDataView<DocumentIsolationPolicyReporterInterfaceBase>;
using DocumentIsolationPolicyReporterRequestDataView =
    mojo::InterfaceRequestDataView<DocumentIsolationPolicyReporterInterfaceBase>;
using DocumentIsolationPolicyReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DocumentIsolationPolicyReporterInterfaceBase>;
using DocumentIsolationPolicyReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DocumentIsolationPolicyReporterInterfaceBase>;


class DocumentIsolationPolicyDataView {
 public:
  DocumentIsolationPolicyDataView() = default;

  DocumentIsolationPolicyDataView(
      internal::DocumentIsolationPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    auto data_value = data_->value;
    return mojo::internal::Deserialize<::network::mojom::DocumentIsolationPolicyValue>(
        data_value, output);
  }
  DocumentIsolationPolicyValue value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DocumentIsolationPolicyValue>(data_->value));
  }
  inline void GetReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingEndpoint` instead "
    "of `ReadReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReportOnlyValue(UserType* output) const {
    auto data_value = data_->report_only_value;
    return mojo::internal::Deserialize<::network::mojom::DocumentIsolationPolicyValue>(
        data_value, output);
  }
  DocumentIsolationPolicyValue report_only_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DocumentIsolationPolicyValue>(data_->report_only_value));
  }
  inline void GetReportOnlyReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportOnlyReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `report_only_reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportOnlyReportingEndpoint` instead "
    "of `ReadReportOnlyReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->report_only_reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DocumentIsolationPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DOCUMENT_ISOLATION_POLICY_MOJOM_DATA_VIEW_H_