// services/network/public/mojom/digitally_signed.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/digitally_signed.mojom-shared-internal.h"




#include "services/network/public/mojom/digitally_signed.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::HashAlgorithm>
    : public mojo::internal::EnumHashImpl<::network::mojom::HashAlgorithm> {};

template <>
struct hash<::network::mojom::SignatureAlgorithm>
    : public mojo::internal::EnumHashImpl<::network::mojom::SignatureAlgorithm> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HashAlgorithm, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::HashAlgorithm, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::HashAlgorithm>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SignatureAlgorithm, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SignatureAlgorithm, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SignatureAlgorithm>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DigitallySignedDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DigitallySignedDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DigitallySigned_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::HashAlgorithm>(
      Traits::hash_algorithm(input),
      &fragment->hash_algorithm);

    
    mojo::internal::Serialize<::network::mojom::SignatureAlgorithm>(
      Traits::signature_algorithm(input),
      &fragment->signature_algorithm);

    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType>
        signature_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_signature,
      signature_fragment,
      &signature_validate_params);

    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in DigitallySigned struct");
  }

  static bool Deserialize(::network::mojom::internal::DigitallySigned_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DigitallySignedDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void DigitallySignedDataView::GetSignatureDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::HashAlgorithm> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::HashAlgorithm value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SignatureAlgorithm> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SignatureAlgorithm value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_SHARED_H_