// services/network/public/mojom/digitally_signed.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/digitally_signed.mojom-shared-internal.h"

#include "services/network/public/mojom/digitally_signed.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::HashAlgorithm, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SignatureAlgorithm, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DigitallySignedDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DigitallySignedDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DigitallySigned_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::HashAlgorithm>(
        Traits::hash_algorithm(input),
        &fragment->hash_algorithm);

      
      mojo::internal::Serialize<::network::mojom::SignatureAlgorithm>(
        Traits::signature_algorithm(input),
        &fragment->signature_algorithm);

      decltype(Traits::signature(input)) in_signature = Traits::signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature)::BaseType>
          signature_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_signature,
        signature_fragment,
        &signature_validate_params);

      fragment->signature.Set(
          signature_fragment.is_null() ? nullptr : signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in DigitallySigned struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_SEND_VALIDATION_H_