// services/network/public/mojom/devtools_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  AlternateProtocolUsage as network_mojom_AlternateProtocolUsage,
  AlternateProtocolUsageSpec as network_mojom_AlternateProtocolUsageSpec
} from './alternate_protocol_usage.mojom.m.js';

import {
  ClientSecurityState as network_mojom_ClientSecurityState,
  ClientSecurityStateSpec as network_mojom_ClientSecurityStateSpec
} from './client_security_state.mojom.m.js';

import {
  CookieAndLineWithAccessResult as network_mojom_CookieAndLineWithAccessResult,
  CookieAndLineWithAccessResultSpec as network_mojom_CookieAndLineWithAccessResultSpec,
  CookieWithAccessResult as network_mojom_CookieWithAccessResult,
  CookieWithAccessResultSpec as network_mojom_CookieWithAccessResultSpec
} from './cookie_manager.mojom.m.js';

import {
  CookiePartitionKey as network_mojom_CookiePartitionKey,
  CookiePartitionKeySpec as network_mojom_CookiePartitionKeySpec
} from './cookie_partition_key.mojom.m.js';

import {
  CorsErrorStatus as network_mojom_CorsErrorStatus,
  CorsErrorStatusSpec as network_mojom_CorsErrorStatusSpec
} from './cors.mojom.m.js';

import {
  FetchResponseSource as network_mojom_FetchResponseSource,
  FetchResponseSourceSpec as network_mojom_FetchResponseSourceSpec
} from './fetch_api.mojom.m.js';

import {
  HttpRawHeaderPair as network_mojom_HttpRawHeaderPair,
  HttpRawHeaderPairSpec as network_mojom_HttpRawHeaderPairSpec
} from './http_raw_headers.mojom.m.js';

import {
  HttpRequestHeaders as network_mojom_HttpRequestHeaders,
  HttpRequestHeadersSpec as network_mojom_HttpRequestHeadersSpec
} from './http_request_headers.mojom.m.js';

import {
  IPAddressSpace as network_mojom_IPAddressSpace,
  IPAddressSpaceSpec as network_mojom_IPAddressSpaceSpec
} from './ip_address_space.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  LoadTimingInfo as network_mojom_LoadTimingInfo,
  LoadTimingInfoSpec as network_mojom_LoadTimingInfoSpec
} from './load_timing_info.mojom.m.js';

import {
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec,
  SSLInfo as network_mojom_SSLInfo,
  SSLInfoSpec as network_mojom_SSLInfoSpec
} from './network_param.mojom.m.js';

import {
  URLRequestReferrerPolicy as network_mojom_URLRequestReferrerPolicy,
  URLRequestReferrerPolicySpec as network_mojom_URLRequestReferrerPolicySpec
} from './referrer_policy.mojom.m.js';

import {
  RequestPriority as network_mojom_RequestPriority,
  RequestPrioritySpec as network_mojom_RequestPrioritySpec
} from './request_priority.mojom.m.js';

import {
  ServiceWorkerRouterInfo as network_mojom_ServiceWorkerRouterInfo,
  ServiceWorkerRouterInfoSpec as network_mojom_ServiceWorkerRouterInfoSpec
} from './service_worker_router_info.mojom.m.js';

import {
  SharedDictionaryError as network_mojom_SharedDictionaryError,
  SharedDictionaryErrorSpec as network_mojom_SharedDictionaryErrorSpec
} from './shared_dictionary_error.mojom.m.js';

import {
  SRIMessageSignatureIssue as network_mojom_SRIMessageSignatureIssue,
  SRIMessageSignatureIssueSpec as network_mojom_SRIMessageSignatureIssueSpec
} from './sri_message_signature.mojom.m.js';

import {
  TrustTokenOperationResult as network_mojom_TrustTokenOperationResult,
  TrustTokenOperationResultSpec as network_mojom_TrustTokenOperationResultSpec,
  TrustTokenParams as network_mojom_TrustTokenParams,
  TrustTokenParamsSpec as network_mojom_TrustTokenParamsSpec
} from './trust_tokens.mojom.m.js';

import {
  UnencodedDigestIssue as network_mojom_UnencodedDigestIssue,
  UnencodedDigestIssueSpec as network_mojom_UnencodedDigestIssueSpec
} from './unencoded_digest.mojom.m.js';

import {
  URLLoaderCompletionStatus as network_mojom_URLLoaderCompletionStatus,
  URLLoaderCompletionStatusSpec as network_mojom_URLLoaderCompletionStatusSpec
} from './url_loader_completion_status.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevToolsObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DevToolsObserver', scope);
  }
}

/** @interface */
export class DevToolsObserverInterface {
  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network_mojom_CookieWithAccessResult> } cookiesWithAccessResult
   * @param { !Array<!network_mojom_HttpRawHeaderPair> } headers
   * @param { !mojoBase_mojom_TimeTicks } timestamp
   * @param { ?network_mojom_ClientSecurityState } clientSecurityState
   * @param { ?OtherPartitionInfo } otherPartitionInfo
   * @param { ?mojoBase_mojom_UnguessableToken } appliedNetworkConditionsId
   */

  onRawRequest(devtoolRequestId, cookiesWithAccessResult, headers, timestamp, clientSecurityState, otherPartitionInfo, appliedNetworkConditionsId) {}
  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network_mojom_CookieAndLineWithAccessResult> } cookiesWithAccessResult
   * @param { !Array<!network_mojom_HttpRawHeaderPair> } headers
   * @param { ?string } rawResponseHeaders
   * @param { !network_mojom_IPAddressSpace } resourceAddressSpace
   * @param { !number } httpStatusCode
   * @param { ?network_mojom_CookiePartitionKey } cookiePartitionKey
   */

  onRawResponse(devtoolRequestId, cookiesWithAccessResult, headers, rawResponseHeaders, resourceAddressSpace, httpStatusCode, cookiePartitionKey) {}
  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network_mojom_HttpRawHeaderPair> } headers
   */

  onEarlyHintsResponse(devtoolRequestId, headers) {}
  
  /**
   * @param { ?string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !boolean } isWarning
   * @param { !network_mojom_IPAddressSpace } resourceAddressSpace
   * @param { !network_mojom_ClientSecurityState } clientSecurityState
   */

  onPrivateNetworkRequest(devtoolRequestId, url, isWarning, resourceAddressSpace, clientSecurityState) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } devtoolRequestId
   * @param { !network_mojom_HttpRequestHeaders } requestHeaders
   * @param { !URLRequestDevToolsInfo } requestInfo
   * @param { !url_mojom_Url } initiatorUrl
   * @param { !string } initiatorDevtoolRequestId
   */

  onCorsPreflightRequest(devtoolRequestId, requestHeaders, requestInfo, initiatorUrl, initiatorDevtoolRequestId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !URLResponseHeadDevToolsInfo } head
   */

  onCorsPreflightResponse(devtoolRequestId, url, head) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } devtoolRequestId
   * @param { !network_mojom_URLLoaderCompletionStatus } status
   */

  onCorsPreflightRequestCompleted(devtoolRequestId, status) {}
  
  /**
   * @param { !string } devtoolRequestId
   * @param { !network_mojom_TrustTokenOperationResult } result
   */

  onTrustTokenOperationDone(devtoolRequestId, result) {}
  
  /**
   * @param { ?string } devtoolRequestId
   * @param { ?url_mojom_Origin } initiatorOrigin
   * @param { ?network_mojom_ClientSecurityState } clientSecurityState
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_CorsErrorStatus } status
   * @param { !boolean } isWarning
   */

  onCorsError(devtoolRequestId, initiatorOrigin, clientSecurityState, url, status, isWarning) {}
  
  /**
   * @param { ?string } devtoolsRequestId
   * @param { !url_mojom_Url } url
   */

  onOrbError(devtoolsRequestId, url) {}
  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_SharedDictionaryError } error
   */

  onSharedDictionaryError(devtoolRequestId, url, error) {}
  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !Array<!network_mojom_SRIMessageSignatureIssue> } issues
   */

  onSRIMessageSignatureIssue(devtoolRequestId, url, issues) {}
  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_UnencodedDigestIssue } issue
   */

  onUnencodedDigestError(devtoolRequestId, url, issue) {}
  
  /**
   * @param { !DevToolsObserverPendingReceiver } listener
   */

  clone(listener) {}
}

/**
 * @implements { DevToolsObserverInterface }
 */
export class DevToolsObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevToolsObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevToolsObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevToolsObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network_mojom_CookieWithAccessResult> } cookiesWithAccessResult
   * @param { !Array<!network_mojom_HttpRawHeaderPair> } headers
   * @param { !mojoBase_mojom_TimeTicks } timestamp
   * @param { ?network_mojom_ClientSecurityState } clientSecurityState
   * @param { ?OtherPartitionInfo } otherPartitionInfo
   * @param { ?mojoBase_mojom_UnguessableToken } appliedNetworkConditionsId
   */

  onRawRequest(
      devtoolRequestId,
      cookiesWithAccessResult,
      headers,
      timestamp,
      clientSecurityState,
      otherPartitionInfo,
      appliedNetworkConditionsId) {
    this.proxy.sendMessage(
        0,
        DevToolsObserver_OnRawRequest_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          cookiesWithAccessResult,
          headers,
          timestamp,
          clientSecurityState,
          otherPartitionInfo,
          appliedNetworkConditionsId
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network_mojom_CookieAndLineWithAccessResult> } cookiesWithAccessResult
   * @param { !Array<!network_mojom_HttpRawHeaderPair> } headers
   * @param { ?string } rawResponseHeaders
   * @param { !network_mojom_IPAddressSpace } resourceAddressSpace
   * @param { !number } httpStatusCode
   * @param { ?network_mojom_CookiePartitionKey } cookiePartitionKey
   */

  onRawResponse(
      devtoolRequestId,
      cookiesWithAccessResult,
      headers,
      rawResponseHeaders,
      resourceAddressSpace,
      httpStatusCode,
      cookiePartitionKey) {
    this.proxy.sendMessage(
        1,
        DevToolsObserver_OnRawResponse_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          cookiesWithAccessResult,
          headers,
          rawResponseHeaders,
          resourceAddressSpace,
          httpStatusCode,
          cookiePartitionKey
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network_mojom_HttpRawHeaderPair> } headers
   */

  onEarlyHintsResponse(
      devtoolRequestId,
      headers) {
    this.proxy.sendMessage(
        2,
        DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          headers
        ],
        false);
  }

  
  /**
   * @param { ?string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !boolean } isWarning
   * @param { !network_mojom_IPAddressSpace } resourceAddressSpace
   * @param { !network_mojom_ClientSecurityState } clientSecurityState
   */

  onPrivateNetworkRequest(
      devtoolRequestId,
      url,
      isWarning,
      resourceAddressSpace,
      clientSecurityState) {
    this.proxy.sendMessage(
        3,
        DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          isWarning,
          resourceAddressSpace,
          clientSecurityState
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } devtoolRequestId
   * @param { !network_mojom_HttpRequestHeaders } requestHeaders
   * @param { !URLRequestDevToolsInfo } requestInfo
   * @param { !url_mojom_Url } initiatorUrl
   * @param { !string } initiatorDevtoolRequestId
   */

  onCorsPreflightRequest(
      devtoolRequestId,
      requestHeaders,
      requestInfo,
      initiatorUrl,
      initiatorDevtoolRequestId) {
    this.proxy.sendMessage(
        4,
        DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          requestHeaders,
          requestInfo,
          initiatorUrl,
          initiatorDevtoolRequestId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !URLResponseHeadDevToolsInfo } head
   */

  onCorsPreflightResponse(
      devtoolRequestId,
      url,
      head) {
    this.proxy.sendMessage(
        5,
        DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          head
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } devtoolRequestId
   * @param { !network_mojom_URLLoaderCompletionStatus } status
   */

  onCorsPreflightRequestCompleted(
      devtoolRequestId,
      status) {
    this.proxy.sendMessage(
        6,
        DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          status
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !network_mojom_TrustTokenOperationResult } result
   */

  onTrustTokenOperationDone(
      devtoolRequestId,
      result) {
    this.proxy.sendMessage(
        7,
        DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          result
        ],
        false);
  }

  
  /**
   * @param { ?string } devtoolRequestId
   * @param { ?url_mojom_Origin } initiatorOrigin
   * @param { ?network_mojom_ClientSecurityState } clientSecurityState
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_CorsErrorStatus } status
   * @param { !boolean } isWarning
   */

  onCorsError(
      devtoolRequestId,
      initiatorOrigin,
      clientSecurityState,
      url,
      status,
      isWarning) {
    this.proxy.sendMessage(
        8,
        DevToolsObserver_OnCorsError_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          initiatorOrigin,
          clientSecurityState,
          url,
          status,
          isWarning
        ],
        false);
  }

  
  /**
   * @param { ?string } devtoolsRequestId
   * @param { !url_mojom_Url } url
   */

  onOrbError(
      devtoolsRequestId,
      url) {
    this.proxy.sendMessage(
        9,
        DevToolsObserver_OnOrbError_ParamsSpec.$,
        null,
        [
          devtoolsRequestId,
          url
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_SharedDictionaryError } error
   */

  onSharedDictionaryError(
      devtoolRequestId,
      url,
      error) {
    this.proxy.sendMessage(
        10,
        DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          error
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !Array<!network_mojom_SRIMessageSignatureIssue> } issues
   */

  onSRIMessageSignatureIssue(
      devtoolRequestId,
      url,
      issues) {
    this.proxy.sendMessage(
        11,
        DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          issues
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_UnencodedDigestIssue } issue
   */

  onUnencodedDigestError(
      devtoolRequestId,
      url,
      issue) {
    this.proxy.sendMessage(
        12,
        DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          issue
        ],
        false);
  }

  
  /**
   * @param { !DevToolsObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        13,
        DevToolsObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevToolsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevToolsObserverReceiver {
  /**
   * @param {!DevToolsObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevToolsObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevToolsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevToolsObserver_OnRawRequest_ParamsSpec.$,
        null,
        impl.onRawRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DevToolsObserver_OnRawResponse_ParamsSpec.$,
        null,
        impl.onRawResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
        null,
        impl.onEarlyHintsResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
        null,
        impl.onPrivateNetworkRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
        null,
        impl.onCorsPreflightRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
        null,
        impl.onCorsPreflightResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
        null,
        impl.onCorsPreflightRequestCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
        null,
        impl.onTrustTokenOperationDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        DevToolsObserver_OnCorsError_ParamsSpec.$,
        null,
        impl.onCorsError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        DevToolsObserver_OnOrbError_ParamsSpec.$,
        null,
        impl.onOrbError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
        null,
        impl.onSharedDictionaryError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
        null,
        impl.onSRIMessageSignatureIssue.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
        null,
        impl.onUnencodedDigestError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        DevToolsObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevToolsObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DevToolsObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevToolsObserverRemote}
   */
  static getRemote() {
    let remote = new DevToolsObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevToolsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevToolsObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevToolsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRawRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevToolsObserver_OnRawRequest_ParamsSpec.$,
        null,
        this.onRawRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRawResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DevToolsObserver_OnRawResponse_ParamsSpec.$,
        null,
        this.onRawResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEarlyHintsResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
        null,
        this.onEarlyHintsResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPrivateNetworkRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
        null,
        this.onPrivateNetworkRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsPreflightRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
        null,
        this.onCorsPreflightRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsPreflightResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
        null,
        this.onCorsPreflightResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsPreflightRequestCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
        null,
        this.onCorsPreflightRequestCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrustTokenOperationDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
        null,
        this.onTrustTokenOperationDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        DevToolsObserver_OnCorsError_ParamsSpec.$,
        null,
        this.onCorsError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOrbError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        DevToolsObserver_OnOrbError_ParamsSpec.$,
        null,
        this.onOrbError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSharedDictionaryError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
        null,
        this.onSharedDictionaryError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSRIMessageSignatureIssue =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
        null,
        this.onSRIMessageSignatureIssue.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUnencodedDigestError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
        null,
        this.onUnencodedDigestError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        DevToolsObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLRequestDevToolsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLResponseHeadDevToolsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OtherPartitionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnRawRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnRawResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnEarlyHintsResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnCorsPreflightRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnCorsPreflightResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnCorsError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnOrbError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnSharedDictionaryError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_OnUnencodedDigestError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    URLRequestDevToolsInfoSpec.$,
    'URLRequestDevToolsInfo',
    [
      mojo.internal.StructField(
        'method', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 16,
        0,
        network_mojom_RequestPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrerPolicy', 20,
        0,
        network_mojom_URLRequestReferrerPolicySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 24,
        0,
        network_mojom_TrustTokenParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resourceType', 36,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAdRelated', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class URLRequestDevToolsInfo {
  constructor() {
    /** @type { !string } */
    this.method;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_RequestPriority } */
    this.priority;
    /** @type { !network_mojom_URLRequestReferrerPolicy } */
    this.referrerPolicy;
    /** @type { (network_mojom_TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @type { !boolean } */
    this.hasUserGesture;
    /** @type { !number } */
    this.resourceType;
    /** @type { !boolean } */
    this.isAdRelated;
  }
}



mojo.internal.Struct(
    URLResponseHeadDevToolsInfoSpec.$,
    'URLResponseHeadDevToolsInfo',
    [
      mojo.internal.StructField(
        'responseTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mimeType', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'charset', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadTiming', 32,
        0,
        network_mojom_LoadTimingInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certStatus', 40,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodedDataLength', 48,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasInPrefetchCache', 44,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 44,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheStorageCacheName', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alpnNegotiatedProtocol', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alternateProtocolUsage', 72,
        0,
        network_mojom_AlternateProtocolUsageSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaSpdy', 44,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerResponseSource', 76,
        0,
        network_mojom_FetchResponseSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerRouterInfo', 80,
        0,
        network_mojom_ServiceWorkerRouterInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sslInfo', 88,
        0,
        network_mojom_SSLInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 96,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'emittedExtraInfo', 44,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 112],]);



/**
 * @record
 */
export class URLResponseHeadDevToolsInfo {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.responseTime;
    /** @type { !network_mojom_HttpResponseHeaders } */
    this.headers;
    /** @type { !string } */
    this.mimeType;
    /** @type { !string } */
    this.charset;
    /** @type { !network_mojom_LoadTimingInfo } */
    this.loadTiming;
    /** @type { !number } */
    this.certStatus;
    /** @type { !bigint } */
    this.encodedDataLength;
    /** @type { !boolean } */
    this.wasInPrefetchCache;
    /** @type { !boolean } */
    this.wasFetchedViaServiceWorker;
    /** @type { !string } */
    this.cacheStorageCacheName;
    /** @type { !string } */
    this.alpnNegotiatedProtocol;
    /** @type { !network_mojom_AlternateProtocolUsage } */
    this.alternateProtocolUsage;
    /** @type { !boolean } */
    this.wasFetchedViaSpdy;
    /** @type { !network_mojom_FetchResponseSource } */
    this.serviceWorkerResponseSource;
    /** @type { (network_mojom_ServiceWorkerRouterInfo|undefined) } */
    this.serviceWorkerRouterInfo;
    /** @type { (network_mojom_SSLInfo|undefined) } */
    this.sslInfo;
    /** @type { !network_mojom_IPEndPoint } */
    this.remoteEndpoint;
    /** @type { !boolean } */
    this.emittedExtraInfo;
  }
}



mojo.internal.Struct(
    OtherPartitionInfoSpec.$,
    'OtherPartitionInfo',
    [
      mojo.internal.StructField(
        'siteHasCookieInOtherPartition', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OtherPartitionInfo {
  constructor() {
    /** @type { !boolean } */
    this.siteHasCookieInOtherPartition;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnRawRequest_ParamsSpec.$,
    'DevToolsObserver_OnRawRequest_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookiesWithAccessResult', 8,
        0,
        mojo.internal.Array(network_mojom_CookieWithAccessResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        mojo.internal.Array(network_mojom_HttpRawHeaderPairSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 24,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 32,
        0,
        network_mojom_ClientSecurityStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'otherPartitionInfo', 40,
        0,
        OtherPartitionInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'appliedNetworkConditionsId', 48,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class DevToolsObserver_OnRawRequest_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolRequestId;
    /** @type { !Array<!network_mojom_CookieWithAccessResult> } */
    this.cookiesWithAccessResult;
    /** @type { !Array<!network_mojom_HttpRawHeaderPair> } */
    this.headers;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.timestamp;
    /** @type { (network_mojom_ClientSecurityState|undefined) } */
    this.clientSecurityState;
    /** @type { (OtherPartitionInfo|undefined) } */
    this.otherPartitionInfo;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.appliedNetworkConditionsId;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnRawResponse_ParamsSpec.$,
    'DevToolsObserver_OnRawResponse_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookiesWithAccessResult', 8,
        0,
        mojo.internal.Array(network_mojom_CookieAndLineWithAccessResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        mojo.internal.Array(network_mojom_HttpRawHeaderPairSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rawResponseHeaders', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resourceAddressSpace', 32,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpStatusCode', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookiePartitionKey', 40,
        0,
        network_mojom_CookiePartitionKeySpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DevToolsObserver_OnRawResponse_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolRequestId;
    /** @type { !Array<!network_mojom_CookieAndLineWithAccessResult> } */
    this.cookiesWithAccessResult;
    /** @type { !Array<!network_mojom_HttpRawHeaderPair> } */
    this.headers;
    /** @type { (string|undefined) } */
    this.rawResponseHeaders;
    /** @type { !network_mojom_IPAddressSpace } */
    this.resourceAddressSpace;
    /** @type { !number } */
    this.httpStatusCode;
    /** @type { (network_mojom_CookiePartitionKey|undefined) } */
    this.cookiePartitionKey;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
    'DevToolsObserver_OnEarlyHintsResponse_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.Array(network_mojom_HttpRawHeaderPairSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevToolsObserver_OnEarlyHintsResponse_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolRequestId;
    /** @type { !Array<!network_mojom_HttpRawHeaderPair> } */
    this.headers;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
    'DevToolsObserver_OnPrivateNetworkRequest_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isWarning', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resourceAddressSpace', 20,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 24,
        0,
        network_mojom_ClientSecurityStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DevToolsObserver_OnPrivateNetworkRequest_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.devtoolRequestId;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !boolean } */
    this.isWarning;
    /** @type { !network_mojom_IPAddressSpace } */
    this.resourceAddressSpace;
    /** @type { !network_mojom_ClientSecurityState } */
    this.clientSecurityState;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
    'DevToolsObserver_OnCorsPreflightRequest_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestHeaders', 8,
        0,
        network_mojom_HttpRequestHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestInfo', 16,
        0,
        URLRequestDevToolsInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorDevtoolRequestId', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class DevToolsObserver_OnCorsPreflightRequest_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolRequestId;
    /** @type { !network_mojom_HttpRequestHeaders } */
    this.requestHeaders;
    /** @type { !URLRequestDevToolsInfo } */
    this.requestInfo;
    /** @type { !url_mojom_Url } */
    this.initiatorUrl;
    /** @type { !string } */
    this.initiatorDevtoolRequestId;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
    'DevToolsObserver_OnCorsPreflightResponse_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'head', 16,
        0,
        URLResponseHeadDevToolsInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DevToolsObserver_OnCorsPreflightResponse_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolRequestId;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !URLResponseHeadDevToolsInfo } */
    this.head;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
    'DevToolsObserver_OnCorsPreflightRequestCompleted_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        network_mojom_URLLoaderCompletionStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevToolsObserver_OnCorsPreflightRequestCompleted_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolRequestId;
    /** @type { !network_mojom_URLLoaderCompletionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
    'DevToolsObserver_OnTrustTokenOperationDone_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        network_mojom_TrustTokenOperationResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevToolsObserver_OnTrustTokenOperationDone_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolRequestId;
    /** @type { !network_mojom_TrustTokenOperationResult } */
    this.result;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnCorsError_ParamsSpec.$,
    'DevToolsObserver_OnCorsError_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 16,
        0,
        network_mojom_ClientSecurityStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 32,
        0,
        network_mojom_CorsErrorStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isWarning', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DevToolsObserver_OnCorsError_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.devtoolRequestId;
    /** @type { (url_mojom_Origin|undefined) } */
    this.initiatorOrigin;
    /** @type { (network_mojom_ClientSecurityState|undefined) } */
    this.clientSecurityState;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_CorsErrorStatus } */
    this.status;
    /** @type { !boolean } */
    this.isWarning;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnOrbError_ParamsSpec.$,
    'DevToolsObserver_OnOrbError_Params',
    [
      mojo.internal.StructField(
        'devtoolsRequestId', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevToolsObserver_OnOrbError_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.devtoolsRequestId;
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
    'DevToolsObserver_OnSharedDictionaryError_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        network_mojom_SharedDictionaryErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DevToolsObserver_OnSharedDictionaryError_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolRequestId;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_SharedDictionaryError } */
    this.error;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
    'DevToolsObserver_OnSRIMessageSignatureIssue_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issues', 16,
        0,
        mojo.internal.Array(network_mojom_SRIMessageSignatureIssueSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DevToolsObserver_OnSRIMessageSignatureIssue_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolRequestId;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!network_mojom_SRIMessageSignatureIssue> } */
    this.issues;
  }
}



mojo.internal.Struct(
    DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
    'DevToolsObserver_OnUnencodedDigestError_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issue', 16,
        0,
        network_mojom_UnencodedDigestIssueSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DevToolsObserver_OnUnencodedDigestError_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolRequestId;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_UnencodedDigestIssue } */
    this.issue;
  }
}



mojo.internal.Struct(
    DevToolsObserver_Clone_ParamsSpec.$,
    'DevToolsObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(DevToolsObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevToolsObserver_Clone_Params {
  constructor() {
    /** @type { !DevToolsObserverPendingReceiver } */
    this.listener;
  }
}

