// services/network/public/mojom/devtools_observer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/devtools_observer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time1$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var time1$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var alternate_protocol_usage$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/alternate_protocol_usage.mojom', 'alternate_protocol_usage.mojom.js');
  }
  var client_security_state$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/client_security_state.mojom', 'client_security_state.mojom.js');
  }
  var cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_manager.mojom', 'cookie_manager.mojom.js');
  }
  var cookie_partition_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_partition_key.mojom', 'cookie_partition_key.mojom.js');
  }
  var cors$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cors.mojom', 'cors.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', 'fetch_api.mojom.js');
  }
  var http_raw_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_raw_headers.mojom', 'http_raw_headers.mojom.js');
  }
  var http_request_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_request_headers.mojom', 'http_request_headers.mojom.js');
  }
  var ip_address_space$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address_space.mojom', 'ip_address_space.mojom.js');
  }
  var referrer_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/referrer_policy.mojom', 'referrer_policy.mojom.js');
  }
  var request_priority$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/request_priority.mojom', 'request_priority.mojom.js');
  }
  var service_worker_router_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/service_worker_router_info.mojom', 'service_worker_router_info.mojom.js');
  }
  var shared_dictionary_error$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_dictionary_error.mojom', 'shared_dictionary_error.mojom.js');
  }
  var sri_message_signature$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/sri_message_signature.mojom', 'sri_message_signature.mojom.js');
  }
  var unencoded_digest$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/unencoded_digest.mojom', 'unencoded_digest.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', 'trust_tokens.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }
  var url_loader_completion_status$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_completion_status.mojom', 'url_loader_completion_status.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var load_timing_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/load_timing_info.mojom', 'load_timing_info.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function URLRequestDevToolsInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLRequestDevToolsInfo.prototype.initDefaults_ = function() {
    this.method = null;
    this.url = null;
    this.priority = 0;
    this.referrerPolicy = 0;
    this.trustTokenParams = null;
    this.hasUserGesture = false;
    this.isAdRelated = false;
    this.resourceType = 0;
  };
  URLRequestDevToolsInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLRequestDevToolsInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequestDevToolsInfo.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequestDevToolsInfo.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequestDevToolsInfo.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, request_priority$.RequestPriority);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequestDevToolsInfo.referrerPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, referrer_policy$.URLRequestReferrerPolicy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequestDevToolsInfo.trustTokenParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, trust_tokens$.TrustTokenParams, true);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  URLRequestDevToolsInfo.encodedSize = codec.kStructHeaderSize + 40;

  URLRequestDevToolsInfo.decode = function(decoder) {
    var packed;
    var val = new URLRequestDevToolsInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.method =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.priority =
        decoder.decodeStruct(new codec.Enum(request_priority$.RequestPriority));
    val.referrerPolicy =
        decoder.decodeStruct(new codec.Enum(referrer_policy$.URLRequestReferrerPolicy));
    val.trustTokenParams =
        decoder.decodeStructPointer(trust_tokens$.TrustTokenParams);
    packed = decoder.readUint8();
    val.hasUserGesture = (packed >> 0) & 1 ? true : false;
    val.isAdRelated = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.resourceType =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  URLRequestDevToolsInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLRequestDevToolsInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.method);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.encodeStruct(codec.Int32, val.referrerPolicy);
    encoder.encodeStructPointer(trust_tokens$.TrustTokenParams, val.trustTokenParams);
    packed = 0;
    packed |= (val.hasUserGesture & 1) << 0
    packed |= (val.isAdRelated & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.resourceType);
  };
  function URLResponseHeadDevToolsInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLResponseHeadDevToolsInfo.prototype.initDefaults_ = function() {
    this.responseTime = null;
    this.headers = null;
    this.mimeType = null;
    this.charset = null;
    this.loadTiming = null;
    this.certStatus = 0;
    this.wasInPrefetchCache = false;
    this.wasFetchedViaServiceWorker = false;
    this.wasFetchedViaSpdy = false;
    this.emittedExtraInfo = false;
    this.encodedDataLength = 0;
    this.cacheStorageCacheName = null;
    this.alpnNegotiatedProtocol = null;
    this.alternateProtocolUsage = 0;
    this.serviceWorkerResponseSource = 0;
    this.serviceWorkerRouterInfo = null;
    this.sslInfo = null;
    this.remoteEndpoint = null;
  };
  URLResponseHeadDevToolsInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLResponseHeadDevToolsInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 112}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.responseTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time1$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HttpResponseHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.mimeType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.charset
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.loadTiming
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, load_timing_info$.LoadTimingInfo, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate URLResponseHeadDevToolsInfo.cacheStorageCacheName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 56, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.alpnNegotiatedProtocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.alternateProtocolUsage
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 72, alternate_protocol_usage$.AlternateProtocolUsage);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLResponseHeadDevToolsInfo.serviceWorkerResponseSource
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 76, fetch_api$.FetchResponseSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.serviceWorkerRouterInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, service_worker_router_info$.ServiceWorkerRouterInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.sslInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, network_param$.SSLInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHeadDevToolsInfo.remoteEndpoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLResponseHeadDevToolsInfo.encodedSize = codec.kStructHeaderSize + 104;

  URLResponseHeadDevToolsInfo.decode = function(decoder) {
    var packed;
    var val = new URLResponseHeadDevToolsInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.responseTime =
        decoder.decodeStructPointer(time1$.Time);
    val.headers =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    val.mimeType =
        decoder.decodeStruct(codec.String);
    val.charset =
        decoder.decodeStruct(codec.String);
    val.loadTiming =
        decoder.decodeStructPointer(load_timing_info$.LoadTimingInfo);
    val.certStatus =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.wasInPrefetchCache = (packed >> 0) & 1 ? true : false;
    val.wasFetchedViaServiceWorker = (packed >> 1) & 1 ? true : false;
    val.wasFetchedViaSpdy = (packed >> 2) & 1 ? true : false;
    val.emittedExtraInfo = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.encodedDataLength =
        decoder.decodeStruct(codec.Int64);
    val.cacheStorageCacheName =
        decoder.decodeStruct(codec.String);
    val.alpnNegotiatedProtocol =
        decoder.decodeStruct(codec.String);
    val.alternateProtocolUsage =
        decoder.decodeStruct(new codec.Enum(alternate_protocol_usage$.AlternateProtocolUsage));
    val.serviceWorkerResponseSource =
        decoder.decodeStruct(new codec.Enum(fetch_api$.FetchResponseSource));
    val.serviceWorkerRouterInfo =
        decoder.decodeStructPointer(service_worker_router_info$.ServiceWorkerRouterInfo);
    val.sslInfo =
        decoder.decodeStructPointer(network_param$.SSLInfo);
    val.remoteEndpoint =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  URLResponseHeadDevToolsInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLResponseHeadDevToolsInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time1$.Time, val.responseTime);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.headers);
    encoder.encodeStruct(codec.String, val.mimeType);
    encoder.encodeStruct(codec.String, val.charset);
    encoder.encodeStructPointer(load_timing_info$.LoadTimingInfo, val.loadTiming);
    encoder.encodeStruct(codec.Uint32, val.certStatus);
    packed = 0;
    packed |= (val.wasInPrefetchCache & 1) << 0
    packed |= (val.wasFetchedViaServiceWorker & 1) << 1
    packed |= (val.wasFetchedViaSpdy & 1) << 2
    packed |= (val.emittedExtraInfo & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.encodedDataLength);
    encoder.encodeStruct(codec.String, val.cacheStorageCacheName);
    encoder.encodeStruct(codec.String, val.alpnNegotiatedProtocol);
    encoder.encodeStruct(codec.Int32, val.alternateProtocolUsage);
    encoder.encodeStruct(codec.Int32, val.serviceWorkerResponseSource);
    encoder.encodeStructPointer(service_worker_router_info$.ServiceWorkerRouterInfo, val.serviceWorkerRouterInfo);
    encoder.encodeStructPointer(network_param$.SSLInfo, val.sslInfo);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.remoteEndpoint);
  };
  function OtherPartitionInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OtherPartitionInfo.prototype.initDefaults_ = function() {
    this.siteHasCookieInOtherPartition = false;
  };
  OtherPartitionInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OtherPartitionInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  OtherPartitionInfo.encodedSize = codec.kStructHeaderSize + 8;

  OtherPartitionInfo.decode = function(decoder) {
    var packed;
    var val = new OtherPartitionInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.siteHasCookieInOtherPartition = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OtherPartitionInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OtherPartitionInfo.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.siteHasCookieInOtherPartition & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DevToolsObserver_OnRawRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnRawRequest_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.cookiesWithAccessResult = null;
    this.headers = null;
    this.timestamp = null;
    this.clientSecurityState = null;
    this.otherPartitionInfo = null;
    this.appliedNetworkConditionsId = null;
  };
  DevToolsObserver_OnRawRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnRawRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawRequest_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawRequest_Params.cookiesWithAccessResult
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(cookie_manager$.CookieWithAccessResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawRequest_Params.headers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawRequest_Params.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time1$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawRequest_Params.clientSecurityState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, client_security_state$.ClientSecurityState, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawRequest_Params.otherPartitionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, OtherPartitionInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawRequest_Params.appliedNetworkConditionsId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnRawRequest_Params.encodedSize = codec.kStructHeaderSize + 56;

  DevToolsObserver_OnRawRequest_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnRawRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.cookiesWithAccessResult =
        decoder.decodeArrayPointer(new codec.PointerTo(cookie_manager$.CookieWithAccessResult));
    val.headers =
        decoder.decodeArrayPointer(new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair));
    val.timestamp =
        decoder.decodeStructPointer(time1$.TimeTicks);
    val.clientSecurityState =
        decoder.decodeStructPointer(client_security_state$.ClientSecurityState);
    val.otherPartitionInfo =
        decoder.decodeStructPointer(OtherPartitionInfo);
    val.appliedNetworkConditionsId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  DevToolsObserver_OnRawRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnRawRequest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeArrayPointer(new codec.PointerTo(cookie_manager$.CookieWithAccessResult), val.cookiesWithAccessResult);
    encoder.encodeArrayPointer(new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair), val.headers);
    encoder.encodeStructPointer(time1$.TimeTicks, val.timestamp);
    encoder.encodeStructPointer(client_security_state$.ClientSecurityState, val.clientSecurityState);
    encoder.encodeStructPointer(OtherPartitionInfo, val.otherPartitionInfo);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.appliedNetworkConditionsId);
  };
  function DevToolsObserver_OnRawResponse_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnRawResponse_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.cookiesWithAccessResult = null;
    this.headers = null;
    this.rawResponseHeaders = null;
    this.resourceAddressSpace = 0;
    this.httpStatusCode = 0;
    this.cookiePartitionKey = null;
  };
  DevToolsObserver_OnRawResponse_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnRawResponse_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawResponse_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawResponse_Params.cookiesWithAccessResult
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(cookie_manager$.CookieAndLineWithAccessResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawResponse_Params.headers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawResponse_Params.rawResponseHeaders
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnRawResponse_Params.resourceAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DevToolsObserver_OnRawResponse_Params.cookiePartitionKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, cookie_partition_key$.CookiePartitionKey, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnRawResponse_Params.encodedSize = codec.kStructHeaderSize + 48;

  DevToolsObserver_OnRawResponse_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnRawResponse_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.cookiesWithAccessResult =
        decoder.decodeArrayPointer(new codec.PointerTo(cookie_manager$.CookieAndLineWithAccessResult));
    val.headers =
        decoder.decodeArrayPointer(new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair));
    val.rawResponseHeaders =
        decoder.decodeStruct(codec.String);
    val.resourceAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.httpStatusCode =
        decoder.decodeStruct(codec.Int32);
    val.cookiePartitionKey =
        decoder.decodeStructPointer(cookie_partition_key$.CookiePartitionKey);
    return val;
  };

  DevToolsObserver_OnRawResponse_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnRawResponse_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeArrayPointer(new codec.PointerTo(cookie_manager$.CookieAndLineWithAccessResult), val.cookiesWithAccessResult);
    encoder.encodeArrayPointer(new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair), val.headers);
    encoder.encodeStruct(codec.String, val.rawResponseHeaders);
    encoder.encodeStruct(codec.Int32, val.resourceAddressSpace);
    encoder.encodeStruct(codec.Int32, val.httpStatusCode);
    encoder.encodeStructPointer(cookie_partition_key$.CookiePartitionKey, val.cookiePartitionKey);
  };
  function DevToolsObserver_OnEarlyHintsResponse_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnEarlyHintsResponse_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.headers = null;
  };
  DevToolsObserver_OnEarlyHintsResponse_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnEarlyHintsResponse_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnEarlyHintsResponse_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnEarlyHintsResponse_Params.headers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnEarlyHintsResponse_Params.encodedSize = codec.kStructHeaderSize + 16;

  DevToolsObserver_OnEarlyHintsResponse_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnEarlyHintsResponse_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.headers =
        decoder.decodeArrayPointer(new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair));
    return val;
  };

  DevToolsObserver_OnEarlyHintsResponse_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnEarlyHintsResponse_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeArrayPointer(new codec.PointerTo(http_raw_headers$.HttpRawHeaderPair), val.headers);
  };
  function DevToolsObserver_OnPrivateNetworkRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnPrivateNetworkRequest_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.url = null;
    this.isWarning = false;
    this.resourceAddressSpace = 0;
    this.clientSecurityState = null;
  };
  DevToolsObserver_OnPrivateNetworkRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnPrivateNetworkRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnPrivateNetworkRequest_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnPrivateNetworkRequest_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DevToolsObserver_OnPrivateNetworkRequest_Params.resourceAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnPrivateNetworkRequest_Params.clientSecurityState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, client_security_state$.ClientSecurityState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnPrivateNetworkRequest_Params.encodedSize = codec.kStructHeaderSize + 32;

  DevToolsObserver_OnPrivateNetworkRequest_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnPrivateNetworkRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.isWarning = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.resourceAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.clientSecurityState =
        decoder.decodeStructPointer(client_security_state$.ClientSecurityState);
    return val;
  };

  DevToolsObserver_OnPrivateNetworkRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnPrivateNetworkRequest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeStructPointer(url$.Url, val.url);
    packed = 0;
    packed |= (val.isWarning & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.resourceAddressSpace);
    encoder.encodeStructPointer(client_security_state$.ClientSecurityState, val.clientSecurityState);
  };
  function DevToolsObserver_OnCorsPreflightRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnCorsPreflightRequest_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.requestHeaders = null;
    this.requestInfo = null;
    this.initiatorUrl = null;
    this.initiatorDevtoolRequestId = null;
  };
  DevToolsObserver_OnCorsPreflightRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnCorsPreflightRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightRequest_Params.devtoolRequestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightRequest_Params.requestHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, http_request_headers$.HttpRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightRequest_Params.requestInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, URLRequestDevToolsInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightRequest_Params.initiatorUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightRequest_Params.initiatorDevtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnCorsPreflightRequest_Params.encodedSize = codec.kStructHeaderSize + 40;

  DevToolsObserver_OnCorsPreflightRequest_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnCorsPreflightRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.requestHeaders =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    val.requestInfo =
        decoder.decodeStructPointer(URLRequestDevToolsInfo);
    val.initiatorUrl =
        decoder.decodeStructPointer(url$.Url);
    val.initiatorDevtoolRequestId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  DevToolsObserver_OnCorsPreflightRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnCorsPreflightRequest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolRequestId);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.requestHeaders);
    encoder.encodeStructPointer(URLRequestDevToolsInfo, val.requestInfo);
    encoder.encodeStructPointer(url$.Url, val.initiatorUrl);
    encoder.encodeStruct(codec.String, val.initiatorDevtoolRequestId);
  };
  function DevToolsObserver_OnCorsPreflightResponse_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnCorsPreflightResponse_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.url = null;
    this.head = null;
  };
  DevToolsObserver_OnCorsPreflightResponse_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnCorsPreflightResponse_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightResponse_Params.devtoolRequestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightResponse_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightResponse_Params.head
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, URLResponseHeadDevToolsInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnCorsPreflightResponse_Params.encodedSize = codec.kStructHeaderSize + 24;

  DevToolsObserver_OnCorsPreflightResponse_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnCorsPreflightResponse_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.head =
        decoder.decodeStructPointer(URLResponseHeadDevToolsInfo);
    return val;
  };

  DevToolsObserver_OnCorsPreflightResponse_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnCorsPreflightResponse_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolRequestId);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(URLResponseHeadDevToolsInfo, val.head);
  };
  function DevToolsObserver_OnCorsPreflightRequestCompleted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnCorsPreflightRequestCompleted_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.status = null;
  };
  DevToolsObserver_OnCorsPreflightRequestCompleted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnCorsPreflightRequestCompleted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightRequestCompleted_Params.devtoolRequestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsPreflightRequestCompleted_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url_loader_completion_status$.URLLoaderCompletionStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnCorsPreflightRequestCompleted_Params.encodedSize = codec.kStructHeaderSize + 16;

  DevToolsObserver_OnCorsPreflightRequestCompleted_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnCorsPreflightRequestCompleted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.status =
        decoder.decodeStructPointer(url_loader_completion_status$.URLLoaderCompletionStatus);
    return val;
  };

  DevToolsObserver_OnCorsPreflightRequestCompleted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnCorsPreflightRequestCompleted_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolRequestId);
    encoder.encodeStructPointer(url_loader_completion_status$.URLLoaderCompletionStatus, val.status);
  };
  function DevToolsObserver_OnTrustTokenOperationDone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnTrustTokenOperationDone_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.result = null;
  };
  DevToolsObserver_OnTrustTokenOperationDone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnTrustTokenOperationDone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnTrustTokenOperationDone_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnTrustTokenOperationDone_Params.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, trust_tokens$.TrustTokenOperationResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnTrustTokenOperationDone_Params.encodedSize = codec.kStructHeaderSize + 16;

  DevToolsObserver_OnTrustTokenOperationDone_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnTrustTokenOperationDone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.result =
        decoder.decodeStructPointer(trust_tokens$.TrustTokenOperationResult);
    return val;
  };

  DevToolsObserver_OnTrustTokenOperationDone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnTrustTokenOperationDone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeStructPointer(trust_tokens$.TrustTokenOperationResult, val.result);
  };
  function DevToolsObserver_OnCorsError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnCorsError_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.initiatorOrigin = null;
    this.clientSecurityState = null;
    this.url = null;
    this.status = null;
    this.isWarning = false;
  };
  DevToolsObserver_OnCorsError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnCorsError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsError_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsError_Params.initiatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsError_Params.clientSecurityState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, client_security_state$.ClientSecurityState, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsError_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnCorsError_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, cors$.CorsErrorStatus, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DevToolsObserver_OnCorsError_Params.encodedSize = codec.kStructHeaderSize + 48;

  DevToolsObserver_OnCorsError_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnCorsError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.initiatorOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.clientSecurityState =
        decoder.decodeStructPointer(client_security_state$.ClientSecurityState);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.status =
        decoder.decodeStructPointer(cors$.CorsErrorStatus);
    packed = decoder.readUint8();
    val.isWarning = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DevToolsObserver_OnCorsError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnCorsError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeStructPointer(origin$.Origin, val.initiatorOrigin);
    encoder.encodeStructPointer(client_security_state$.ClientSecurityState, val.clientSecurityState);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(cors$.CorsErrorStatus, val.status);
    packed = 0;
    packed |= (val.isWarning & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DevToolsObserver_OnOrbError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnOrbError_Params.prototype.initDefaults_ = function() {
    this.devtoolsRequestId = null;
    this.url = null;
  };
  DevToolsObserver_OnOrbError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnOrbError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnOrbError_Params.devtoolsRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnOrbError_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnOrbError_Params.encodedSize = codec.kStructHeaderSize + 16;

  DevToolsObserver_OnOrbError_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnOrbError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolsRequestId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  DevToolsObserver_OnOrbError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnOrbError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolsRequestId);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function DevToolsObserver_OnSharedDictionaryError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnSharedDictionaryError_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.url = null;
    this.error = 0;
  };
  DevToolsObserver_OnSharedDictionaryError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnSharedDictionaryError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnSharedDictionaryError_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnSharedDictionaryError_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnSharedDictionaryError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, shared_dictionary_error$.SharedDictionaryError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnSharedDictionaryError_Params.encodedSize = codec.kStructHeaderSize + 24;

  DevToolsObserver_OnSharedDictionaryError_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnSharedDictionaryError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.error =
        decoder.decodeStruct(new codec.Enum(shared_dictionary_error$.SharedDictionaryError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DevToolsObserver_OnSharedDictionaryError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnSharedDictionaryError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DevToolsObserver_OnSRIMessageSignatureIssue_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnSRIMessageSignatureIssue_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.url = null;
    this.issues = null;
  };
  DevToolsObserver_OnSRIMessageSignatureIssue_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnSRIMessageSignatureIssue_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnSRIMessageSignatureIssue_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnSRIMessageSignatureIssue_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnSRIMessageSignatureIssue_Params.issues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(sri_message_signature$.SRIMessageSignatureIssue), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnSRIMessageSignatureIssue_Params.encodedSize = codec.kStructHeaderSize + 24;

  DevToolsObserver_OnSRIMessageSignatureIssue_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnSRIMessageSignatureIssue_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.issues =
        decoder.decodeArrayPointer(new codec.PointerTo(sri_message_signature$.SRIMessageSignatureIssue));
    return val;
  };

  DevToolsObserver_OnSRIMessageSignatureIssue_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnSRIMessageSignatureIssue_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeArrayPointer(new codec.PointerTo(sri_message_signature$.SRIMessageSignatureIssue), val.issues);
  };
  function DevToolsObserver_OnUnencodedDigestError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_OnUnencodedDigestError_Params.prototype.initDefaults_ = function() {
    this.devtoolRequestId = null;
    this.url = null;
    this.issue = 0;
  };
  DevToolsObserver_OnUnencodedDigestError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_OnUnencodedDigestError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnUnencodedDigestError_Params.devtoolRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnUnencodedDigestError_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_OnUnencodedDigestError_Params.issue
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, unencoded_digest$.UnencodedDigestIssue);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_OnUnencodedDigestError_Params.encodedSize = codec.kStructHeaderSize + 24;

  DevToolsObserver_OnUnencodedDigestError_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_OnUnencodedDigestError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolRequestId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.issue =
        decoder.decodeStruct(new codec.Enum(unencoded_digest$.UnencodedDigestIssue));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DevToolsObserver_OnUnencodedDigestError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_OnUnencodedDigestError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolRequestId);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.issue);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DevToolsObserver_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevToolsObserver_Clone_Params.prototype.initDefaults_ = function() {
    this.listener = new bindings.InterfaceRequest();
  };
  DevToolsObserver_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevToolsObserver_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevToolsObserver_Clone_Params.listener
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DevToolsObserver_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  DevToolsObserver_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new DevToolsObserver_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listener =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DevToolsObserver_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevToolsObserver_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.listener);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kDevToolsObserver_OnRawRequest_Name = 0;
  var kDevToolsObserver_OnRawResponse_Name = 1;
  var kDevToolsObserver_OnEarlyHintsResponse_Name = 2;
  var kDevToolsObserver_OnPrivateNetworkRequest_Name = 3;
  var kDevToolsObserver_OnCorsPreflightRequest_Name = 4;
  var kDevToolsObserver_OnCorsPreflightResponse_Name = 5;
  var kDevToolsObserver_OnCorsPreflightRequestCompleted_Name = 6;
  var kDevToolsObserver_OnTrustTokenOperationDone_Name = 7;
  var kDevToolsObserver_OnCorsError_Name = 8;
  var kDevToolsObserver_OnOrbError_Name = 9;
  var kDevToolsObserver_OnSharedDictionaryError_Name = 10;
  var kDevToolsObserver_OnSRIMessageSignatureIssue_Name = 11;
  var kDevToolsObserver_OnUnencodedDigestError_Name = 12;
  var kDevToolsObserver_Clone_Name = 13;

  function DevToolsObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DevToolsObserver,
                                                   handleOrPtrInfo);
  }

  function DevToolsObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DevToolsObserver, associatedInterfacePtrInfo);
  }

  DevToolsObserverAssociatedPtr.prototype =
      Object.create(DevToolsObserverPtr.prototype);
  DevToolsObserverAssociatedPtr.prototype.constructor =
      DevToolsObserverAssociatedPtr;

  function DevToolsObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  DevToolsObserverPtr.prototype.onRawRequest = function() {
    return DevToolsObserverProxy.prototype.onRawRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onRawRequest = function(devtoolRequestId, cookiesWithAccessResult, headers, timestamp, clientSecurityState, otherPartitionInfo, appliedNetworkConditionsId) {
    var params_ = new DevToolsObserver_OnRawRequest_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.cookiesWithAccessResult = cookiesWithAccessResult;
    params_.headers = headers;
    params_.timestamp = timestamp;
    params_.clientSecurityState = clientSecurityState;
    params_.otherPartitionInfo = otherPartitionInfo;
    params_.appliedNetworkConditionsId = appliedNetworkConditionsId;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnRawRequest_Name,
        codec.align(DevToolsObserver_OnRawRequest_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnRawRequest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onRawResponse = function() {
    return DevToolsObserverProxy.prototype.onRawResponse
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onRawResponse = function(devtoolRequestId, cookiesWithAccessResult, headers, rawResponseHeaders, resourceAddressSpace, httpStatusCode, cookiePartitionKey) {
    var params_ = new DevToolsObserver_OnRawResponse_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.cookiesWithAccessResult = cookiesWithAccessResult;
    params_.headers = headers;
    params_.rawResponseHeaders = rawResponseHeaders;
    params_.resourceAddressSpace = resourceAddressSpace;
    params_.httpStatusCode = httpStatusCode;
    params_.cookiePartitionKey = cookiePartitionKey;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnRawResponse_Name,
        codec.align(DevToolsObserver_OnRawResponse_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnRawResponse_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onEarlyHintsResponse = function() {
    return DevToolsObserverProxy.prototype.onEarlyHintsResponse
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onEarlyHintsResponse = function(devtoolRequestId, headers) {
    var params_ = new DevToolsObserver_OnEarlyHintsResponse_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.headers = headers;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnEarlyHintsResponse_Name,
        codec.align(DevToolsObserver_OnEarlyHintsResponse_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnEarlyHintsResponse_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onPrivateNetworkRequest = function() {
    return DevToolsObserverProxy.prototype.onPrivateNetworkRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onPrivateNetworkRequest = function(devtoolRequestId, url, isWarning, resourceAddressSpace, clientSecurityState) {
    var params_ = new DevToolsObserver_OnPrivateNetworkRequest_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.url = url;
    params_.isWarning = isWarning;
    params_.resourceAddressSpace = resourceAddressSpace;
    params_.clientSecurityState = clientSecurityState;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnPrivateNetworkRequest_Name,
        codec.align(DevToolsObserver_OnPrivateNetworkRequest_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnPrivateNetworkRequest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onCorsPreflightRequest = function() {
    return DevToolsObserverProxy.prototype.onCorsPreflightRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onCorsPreflightRequest = function(devtoolRequestId, requestHeaders, requestInfo, initiatorUrl, initiatorDevtoolRequestId) {
    var params_ = new DevToolsObserver_OnCorsPreflightRequest_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.requestHeaders = requestHeaders;
    params_.requestInfo = requestInfo;
    params_.initiatorUrl = initiatorUrl;
    params_.initiatorDevtoolRequestId = initiatorDevtoolRequestId;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnCorsPreflightRequest_Name,
        codec.align(DevToolsObserver_OnCorsPreflightRequest_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnCorsPreflightRequest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onCorsPreflightResponse = function() {
    return DevToolsObserverProxy.prototype.onCorsPreflightResponse
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onCorsPreflightResponse = function(devtoolRequestId, url, head) {
    var params_ = new DevToolsObserver_OnCorsPreflightResponse_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.url = url;
    params_.head = head;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnCorsPreflightResponse_Name,
        codec.align(DevToolsObserver_OnCorsPreflightResponse_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnCorsPreflightResponse_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onCorsPreflightRequestCompleted = function() {
    return DevToolsObserverProxy.prototype.onCorsPreflightRequestCompleted
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onCorsPreflightRequestCompleted = function(devtoolRequestId, status) {
    var params_ = new DevToolsObserver_OnCorsPreflightRequestCompleted_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnCorsPreflightRequestCompleted_Name,
        codec.align(DevToolsObserver_OnCorsPreflightRequestCompleted_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnCorsPreflightRequestCompleted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onTrustTokenOperationDone = function() {
    return DevToolsObserverProxy.prototype.onTrustTokenOperationDone
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onTrustTokenOperationDone = function(devtoolRequestId, result) {
    var params_ = new DevToolsObserver_OnTrustTokenOperationDone_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.result = result;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnTrustTokenOperationDone_Name,
        codec.align(DevToolsObserver_OnTrustTokenOperationDone_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnTrustTokenOperationDone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onCorsError = function() {
    return DevToolsObserverProxy.prototype.onCorsError
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onCorsError = function(devtoolRequestId, initiatorOrigin, clientSecurityState, url, status, isWarning) {
    var params_ = new DevToolsObserver_OnCorsError_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.initiatorOrigin = initiatorOrigin;
    params_.clientSecurityState = clientSecurityState;
    params_.url = url;
    params_.status = status;
    params_.isWarning = isWarning;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnCorsError_Name,
        codec.align(DevToolsObserver_OnCorsError_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnCorsError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onOrbError = function() {
    return DevToolsObserverProxy.prototype.onOrbError
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onOrbError = function(devtoolsRequestId, url) {
    var params_ = new DevToolsObserver_OnOrbError_Params();
    params_.devtoolsRequestId = devtoolsRequestId;
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnOrbError_Name,
        codec.align(DevToolsObserver_OnOrbError_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnOrbError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onSharedDictionaryError = function() {
    return DevToolsObserverProxy.prototype.onSharedDictionaryError
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onSharedDictionaryError = function(devtoolRequestId, url, error) {
    var params_ = new DevToolsObserver_OnSharedDictionaryError_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.url = url;
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnSharedDictionaryError_Name,
        codec.align(DevToolsObserver_OnSharedDictionaryError_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnSharedDictionaryError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onSRIMessageSignatureIssue = function() {
    return DevToolsObserverProxy.prototype.onSRIMessageSignatureIssue
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onSRIMessageSignatureIssue = function(devtoolRequestId, url, issues) {
    var params_ = new DevToolsObserver_OnSRIMessageSignatureIssue_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.url = url;
    params_.issues = issues;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnSRIMessageSignatureIssue_Name,
        codec.align(DevToolsObserver_OnSRIMessageSignatureIssue_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnSRIMessageSignatureIssue_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.onUnencodedDigestError = function() {
    return DevToolsObserverProxy.prototype.onUnencodedDigestError
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.onUnencodedDigestError = function(devtoolRequestId, url, issue) {
    var params_ = new DevToolsObserver_OnUnencodedDigestError_Params();
    params_.devtoolRequestId = devtoolRequestId;
    params_.url = url;
    params_.issue = issue;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_OnUnencodedDigestError_Name,
        codec.align(DevToolsObserver_OnUnencodedDigestError_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_OnUnencodedDigestError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DevToolsObserverPtr.prototype.clone = function() {
    return DevToolsObserverProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  DevToolsObserverProxy.prototype.clone = function(listener) {
    var params_ = new DevToolsObserver_Clone_Params();
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kDevToolsObserver_Clone_Name,
        codec.align(DevToolsObserver_Clone_Params.encodedSize));
    builder.encodeStruct(DevToolsObserver_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function DevToolsObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  DevToolsObserverStub.prototype.onRawRequest = function(devtoolRequestId, cookiesWithAccessResult, headers, timestamp, clientSecurityState, otherPartitionInfo, appliedNetworkConditionsId) {
    return this.delegate_ && this.delegate_.onRawRequest && this.delegate_.onRawRequest(devtoolRequestId, cookiesWithAccessResult, headers, timestamp, clientSecurityState, otherPartitionInfo, appliedNetworkConditionsId);
  }
  DevToolsObserverStub.prototype.onRawResponse = function(devtoolRequestId, cookiesWithAccessResult, headers, rawResponseHeaders, resourceAddressSpace, httpStatusCode, cookiePartitionKey) {
    return this.delegate_ && this.delegate_.onRawResponse && this.delegate_.onRawResponse(devtoolRequestId, cookiesWithAccessResult, headers, rawResponseHeaders, resourceAddressSpace, httpStatusCode, cookiePartitionKey);
  }
  DevToolsObserverStub.prototype.onEarlyHintsResponse = function(devtoolRequestId, headers) {
    return this.delegate_ && this.delegate_.onEarlyHintsResponse && this.delegate_.onEarlyHintsResponse(devtoolRequestId, headers);
  }
  DevToolsObserverStub.prototype.onPrivateNetworkRequest = function(devtoolRequestId, url, isWarning, resourceAddressSpace, clientSecurityState) {
    return this.delegate_ && this.delegate_.onPrivateNetworkRequest && this.delegate_.onPrivateNetworkRequest(devtoolRequestId, url, isWarning, resourceAddressSpace, clientSecurityState);
  }
  DevToolsObserverStub.prototype.onCorsPreflightRequest = function(devtoolRequestId, requestHeaders, requestInfo, initiatorUrl, initiatorDevtoolRequestId) {
    return this.delegate_ && this.delegate_.onCorsPreflightRequest && this.delegate_.onCorsPreflightRequest(devtoolRequestId, requestHeaders, requestInfo, initiatorUrl, initiatorDevtoolRequestId);
  }
  DevToolsObserverStub.prototype.onCorsPreflightResponse = function(devtoolRequestId, url, head) {
    return this.delegate_ && this.delegate_.onCorsPreflightResponse && this.delegate_.onCorsPreflightResponse(devtoolRequestId, url, head);
  }
  DevToolsObserverStub.prototype.onCorsPreflightRequestCompleted = function(devtoolRequestId, status) {
    return this.delegate_ && this.delegate_.onCorsPreflightRequestCompleted && this.delegate_.onCorsPreflightRequestCompleted(devtoolRequestId, status);
  }
  DevToolsObserverStub.prototype.onTrustTokenOperationDone = function(devtoolRequestId, result) {
    return this.delegate_ && this.delegate_.onTrustTokenOperationDone && this.delegate_.onTrustTokenOperationDone(devtoolRequestId, result);
  }
  DevToolsObserverStub.prototype.onCorsError = function(devtoolRequestId, initiatorOrigin, clientSecurityState, url, status, isWarning) {
    return this.delegate_ && this.delegate_.onCorsError && this.delegate_.onCorsError(devtoolRequestId, initiatorOrigin, clientSecurityState, url, status, isWarning);
  }
  DevToolsObserverStub.prototype.onOrbError = function(devtoolsRequestId, url) {
    return this.delegate_ && this.delegate_.onOrbError && this.delegate_.onOrbError(devtoolsRequestId, url);
  }
  DevToolsObserverStub.prototype.onSharedDictionaryError = function(devtoolRequestId, url, error) {
    return this.delegate_ && this.delegate_.onSharedDictionaryError && this.delegate_.onSharedDictionaryError(devtoolRequestId, url, error);
  }
  DevToolsObserverStub.prototype.onSRIMessageSignatureIssue = function(devtoolRequestId, url, issues) {
    return this.delegate_ && this.delegate_.onSRIMessageSignatureIssue && this.delegate_.onSRIMessageSignatureIssue(devtoolRequestId, url, issues);
  }
  DevToolsObserverStub.prototype.onUnencodedDigestError = function(devtoolRequestId, url, issue) {
    return this.delegate_ && this.delegate_.onUnencodedDigestError && this.delegate_.onUnencodedDigestError(devtoolRequestId, url, issue);
  }
  DevToolsObserverStub.prototype.clone = function(listener) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(listener);
  }

  DevToolsObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDevToolsObserver_OnRawRequest_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnRawRequest_Params);
      this.onRawRequest(params.devtoolRequestId, params.cookiesWithAccessResult, params.headers, params.timestamp, params.clientSecurityState, params.otherPartitionInfo, params.appliedNetworkConditionsId);
      return true;
    case kDevToolsObserver_OnRawResponse_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnRawResponse_Params);
      this.onRawResponse(params.devtoolRequestId, params.cookiesWithAccessResult, params.headers, params.rawResponseHeaders, params.resourceAddressSpace, params.httpStatusCode, params.cookiePartitionKey);
      return true;
    case kDevToolsObserver_OnEarlyHintsResponse_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnEarlyHintsResponse_Params);
      this.onEarlyHintsResponse(params.devtoolRequestId, params.headers);
      return true;
    case kDevToolsObserver_OnPrivateNetworkRequest_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnPrivateNetworkRequest_Params);
      this.onPrivateNetworkRequest(params.devtoolRequestId, params.url, params.isWarning, params.resourceAddressSpace, params.clientSecurityState);
      return true;
    case kDevToolsObserver_OnCorsPreflightRequest_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnCorsPreflightRequest_Params);
      this.onCorsPreflightRequest(params.devtoolRequestId, params.requestHeaders, params.requestInfo, params.initiatorUrl, params.initiatorDevtoolRequestId);
      return true;
    case kDevToolsObserver_OnCorsPreflightResponse_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnCorsPreflightResponse_Params);
      this.onCorsPreflightResponse(params.devtoolRequestId, params.url, params.head);
      return true;
    case kDevToolsObserver_OnCorsPreflightRequestCompleted_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnCorsPreflightRequestCompleted_Params);
      this.onCorsPreflightRequestCompleted(params.devtoolRequestId, params.status);
      return true;
    case kDevToolsObserver_OnTrustTokenOperationDone_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnTrustTokenOperationDone_Params);
      this.onTrustTokenOperationDone(params.devtoolRequestId, params.result);
      return true;
    case kDevToolsObserver_OnCorsError_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnCorsError_Params);
      this.onCorsError(params.devtoolRequestId, params.initiatorOrigin, params.clientSecurityState, params.url, params.status, params.isWarning);
      return true;
    case kDevToolsObserver_OnOrbError_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnOrbError_Params);
      this.onOrbError(params.devtoolsRequestId, params.url);
      return true;
    case kDevToolsObserver_OnSharedDictionaryError_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnSharedDictionaryError_Params);
      this.onSharedDictionaryError(params.devtoolRequestId, params.url, params.error);
      return true;
    case kDevToolsObserver_OnSRIMessageSignatureIssue_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnSRIMessageSignatureIssue_Params);
      this.onSRIMessageSignatureIssue(params.devtoolRequestId, params.url, params.issues);
      return true;
    case kDevToolsObserver_OnUnencodedDigestError_Name:
      var params = reader.decodeStruct(DevToolsObserver_OnUnencodedDigestError_Params);
      this.onUnencodedDigestError(params.devtoolRequestId, params.url, params.issue);
      return true;
    case kDevToolsObserver_Clone_Name:
      var params = reader.decodeStruct(DevToolsObserver_Clone_Params);
      this.clone(params.listener);
      return true;
    default:
      return false;
    }
  };

  DevToolsObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateDevToolsObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDevToolsObserver_OnRawRequest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnRawRequest_Params;
      break;
      case kDevToolsObserver_OnRawResponse_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnRawResponse_Params;
      break;
      case kDevToolsObserver_OnEarlyHintsResponse_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnEarlyHintsResponse_Params;
      break;
      case kDevToolsObserver_OnPrivateNetworkRequest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnPrivateNetworkRequest_Params;
      break;
      case kDevToolsObserver_OnCorsPreflightRequest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnCorsPreflightRequest_Params;
      break;
      case kDevToolsObserver_OnCorsPreflightResponse_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnCorsPreflightResponse_Params;
      break;
      case kDevToolsObserver_OnCorsPreflightRequestCompleted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnCorsPreflightRequestCompleted_Params;
      break;
      case kDevToolsObserver_OnTrustTokenOperationDone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnTrustTokenOperationDone_Params;
      break;
      case kDevToolsObserver_OnCorsError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnCorsError_Params;
      break;
      case kDevToolsObserver_OnOrbError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnOrbError_Params;
      break;
      case kDevToolsObserver_OnSharedDictionaryError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnSharedDictionaryError_Params;
      break;
      case kDevToolsObserver_OnSRIMessageSignatureIssue_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnSRIMessageSignatureIssue_Params;
      break;
      case kDevToolsObserver_OnUnencodedDigestError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_OnUnencodedDigestError_Params;
      break;
      case kDevToolsObserver_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DevToolsObserver_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDevToolsObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var DevToolsObserver = {
    name: 'network.mojom.DevToolsObserver',
    kVersion: 0,
    ptrClass: DevToolsObserverPtr,
    proxyClass: DevToolsObserverProxy,
    stubClass: DevToolsObserverStub,
    validateRequest: validateDevToolsObserverRequest,
    validateResponse: null,
  };
  DevToolsObserverStub.prototype.validator = validateDevToolsObserverRequest;
  DevToolsObserverProxy.prototype.validator = null;
  exports.URLRequestDevToolsInfo = URLRequestDevToolsInfo;
  exports.URLResponseHeadDevToolsInfo = URLResponseHeadDevToolsInfo;
  exports.OtherPartitionInfo = OtherPartitionInfo;
  exports.DevToolsObserver = DevToolsObserver;
  exports.DevToolsObserverPtr = DevToolsObserverPtr;
  exports.DevToolsObserverAssociatedPtr = DevToolsObserverAssociatedPtr;
})();