// services/network/public/mojom/devtools_observer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/devtools_observer.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/devtools_observer.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/devtools_observer.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom.h"
#include "services/network/public/mojom/client_security_state.mojom-forward.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/cookie_partition_key.mojom.h"
#include "services/network/public/mojom/cors.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/http_raw_headers.mojom-forward.h"
#include "services/network/public/mojom/http_request_headers.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/referrer_policy.mojom.h"
#include "services/network/public/mojom/request_priority.mojom.h"
#include "services/network/public/mojom/service_worker_router_info.mojom.h"
#include "services/network/public/mojom/shared_dictionary_error.mojom-forward.h"
#include "services/network/public/mojom/sri_message_signature.mojom-forward.h"
#include "services/network/public/mojom/unencoded_digest.mojom-forward.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/load_timing_info.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace network::mojom {

class DevToolsObserverProxy;

template <typename ImplRefTraits>
class DevToolsObserverStub;

class DevToolsObserverRequestValidator;


class DevToolsObserver
    : public DevToolsObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.DevToolsObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevToolsObserverInterfaceBase;
  using Proxy_ = DevToolsObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsObserverStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRawRequestMinVersion = 0,
    kOnRawResponseMinVersion = 0,
    kOnEarlyHintsResponseMinVersion = 0,
    kOnPrivateNetworkRequestMinVersion = 0,
    kOnCorsPreflightRequestMinVersion = 0,
    kOnCorsPreflightResponseMinVersion = 0,
    kOnCorsPreflightRequestCompletedMinVersion = 0,
    kOnTrustTokenOperationDoneMinVersion = 0,
    kOnCorsErrorMinVersion = 0,
    kOnOrbErrorMinVersion = 0,
    kOnSharedDictionaryErrorMinVersion = 0,
    kOnSRIMessageSignatureIssueMinVersion = 0,
    kOnUnencodedDigestErrorMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnRawRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRawResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEarlyHintsResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPrivateNetworkRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCorsPreflightRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCorsPreflightResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCorsPreflightRequestCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTrustTokenOperationDone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCorsError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnOrbError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSharedDictionaryError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSRIMessageSignatureIssue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnUnencodedDigestError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevToolsObserver() = default;

  virtual void OnRawRequest(const std::string& devtool_request_id, const std::vector<::net::CookieWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, ::base::TimeTicks timestamp, ::network::mojom::ClientSecurityStatePtr client_security_state, OtherPartitionInfoPtr other_partition_info, const std::optional<::base::UnguessableToken>& applied_network_conditions_id) = 0;

  virtual void OnRawResponse(const std::string& devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, const std::optional<std::string>& raw_response_headers, ::network::mojom::IPAddressSpace resource_address_space, int32_t http_status_code, const std::optional<::net::CookiePartitionKey>& cookie_partition_key) = 0;

  virtual void OnEarlyHintsResponse(const std::string& devtool_request_id, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers) = 0;

  virtual void OnPrivateNetworkRequest(const std::optional<std::string>& devtool_request_id, const ::GURL& url, bool is_warning, ::network::mojom::IPAddressSpace resource_address_space, ::network::mojom::ClientSecurityStatePtr client_security_state) = 0;

  virtual void OnCorsPreflightRequest(const ::base::UnguessableToken& devtool_request_id, const ::net::HttpRequestHeaders& request_headers, URLRequestDevToolsInfoPtr request_info, const ::GURL& initiator_url, const std::string& initiator_devtool_request_id) = 0;

  virtual void OnCorsPreflightResponse(const ::base::UnguessableToken& devtool_request_id, const ::GURL& url, URLResponseHeadDevToolsInfoPtr head) = 0;

  virtual void OnCorsPreflightRequestCompleted(const ::base::UnguessableToken& devtool_request_id, const ::network::URLLoaderCompletionStatus& status) = 0;

  virtual void OnTrustTokenOperationDone(const std::string& devtool_request_id, ::network::mojom::TrustTokenOperationResultPtr result) = 0;

  virtual void OnCorsError(const std::optional<std::string>& devtool_request_id, const std::optional<::url::Origin>& initiator_origin, ::network::mojom::ClientSecurityStatePtr client_security_state, const ::GURL& url, const ::network::CorsErrorStatus& status, bool is_warning) = 0;

  virtual void OnOrbError(const std::optional<std::string>& devtools_request_id, const ::GURL& url) = 0;

  virtual void OnSharedDictionaryError(const std::string& devtool_request_id, const ::GURL& url, ::network::mojom::SharedDictionaryError error) = 0;

  virtual void OnSRIMessageSignatureIssue(const std::string& devtool_request_id, const ::GURL& url, std::vector<::network::mojom::SRIMessageSignatureIssuePtr> issues) = 0;

  virtual void OnUnencodedDigestError(const std::string& devtool_request_id, const ::GURL& url, ::network::mojom::UnencodedDigestIssue issue) = 0;

  virtual void Clone(::mojo::PendingReceiver<DevToolsObserver> listener) = 0;
};



class  DevToolsObserverProxy
    : public DevToolsObserver {
 public:
  using InterfaceType = DevToolsObserver;

  explicit DevToolsObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRawRequest(const std::string& devtool_request_id, const std::vector<::net::CookieWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, ::base::TimeTicks timestamp, ::network::mojom::ClientSecurityStatePtr client_security_state, OtherPartitionInfoPtr other_partition_info, const std::optional<::base::UnguessableToken>& applied_network_conditions_id) final;
  
  void OnRawResponse(const std::string& devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, const std::optional<std::string>& raw_response_headers, ::network::mojom::IPAddressSpace resource_address_space, int32_t http_status_code, const std::optional<::net::CookiePartitionKey>& cookie_partition_key) final;
  
  void OnEarlyHintsResponse(const std::string& devtool_request_id, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers) final;
  
  void OnPrivateNetworkRequest(const std::optional<std::string>& devtool_request_id, const ::GURL& url, bool is_warning, ::network::mojom::IPAddressSpace resource_address_space, ::network::mojom::ClientSecurityStatePtr client_security_state) final;
  
  void OnCorsPreflightRequest(const ::base::UnguessableToken& devtool_request_id, const ::net::HttpRequestHeaders& request_headers, URLRequestDevToolsInfoPtr request_info, const ::GURL& initiator_url, const std::string& initiator_devtool_request_id) final;
  
  void OnCorsPreflightResponse(const ::base::UnguessableToken& devtool_request_id, const ::GURL& url, URLResponseHeadDevToolsInfoPtr head) final;
  
  void OnCorsPreflightRequestCompleted(const ::base::UnguessableToken& devtool_request_id, const ::network::URLLoaderCompletionStatus& status) final;
  
  void OnTrustTokenOperationDone(const std::string& devtool_request_id, ::network::mojom::TrustTokenOperationResultPtr result) final;
  
  void OnCorsError(const std::optional<std::string>& devtool_request_id, const std::optional<::url::Origin>& initiator_origin, ::network::mojom::ClientSecurityStatePtr client_security_state, const ::GURL& url, const ::network::CorsErrorStatus& status, bool is_warning) final;
  
  void OnOrbError(const std::optional<std::string>& devtools_request_id, const ::GURL& url) final;
  
  void OnSharedDictionaryError(const std::string& devtool_request_id, const ::GURL& url, ::network::mojom::SharedDictionaryError error) final;
  
  void OnSRIMessageSignatureIssue(const std::string& devtool_request_id, const ::GURL& url, std::vector<::network::mojom::SRIMessageSignatureIssuePtr> issues) final;
  
  void OnUnencodedDigestError(const std::string& devtool_request_id, const ::GURL& url, ::network::mojom::UnencodedDigestIssue issue) final;
  
  void Clone(::mojo::PendingReceiver<DevToolsObserver> listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DevToolsObserverStubDispatch {
 public:
  static bool Accept(DevToolsObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsObserver>>
class DevToolsObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsObserverStub() = default;
  ~DevToolsObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DevToolsObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  OtherPartitionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OtherPartitionInfo, T>::value>;
  using DataView = OtherPartitionInfoDataView;
  using Data_ = internal::OtherPartitionInfo_Data;

  template <typename... Args>
  static OtherPartitionInfoPtr New(Args&&... args) {
    return OtherPartitionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OtherPartitionInfoPtr From(const U& u) {
    return mojo::TypeConverter<OtherPartitionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OtherPartitionInfo>::Convert(*this);
  }


  OtherPartitionInfo();

  explicit OtherPartitionInfo(
      bool site_has_cookie_in_other_partition);


  ~OtherPartitionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OtherPartitionInfoPtr>
  OtherPartitionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OtherPartitionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OtherPartitionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OtherPartitionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OtherPartitionInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OtherPartitionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OtherPartitionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OtherPartitionInfo_UnserializedMessageContext<
            UserType, OtherPartitionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OtherPartitionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OtherPartitionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OtherPartitionInfo_UnserializedMessageContext<
            UserType, OtherPartitionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OtherPartitionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool site_has_cookie_in_other_partition;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OtherPartitionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OtherPartitionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OtherPartitionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OtherPartitionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  URLRequestDevToolsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLRequestDevToolsInfo, T>::value>;
  using DataView = URLRequestDevToolsInfoDataView;
  using Data_ = internal::URLRequestDevToolsInfo_Data;

  template <typename... Args>
  static URLRequestDevToolsInfoPtr New(Args&&... args) {
    return URLRequestDevToolsInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLRequestDevToolsInfoPtr From(const U& u) {
    return mojo::TypeConverter<URLRequestDevToolsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLRequestDevToolsInfo>::Convert(*this);
  }


  URLRequestDevToolsInfo();

  URLRequestDevToolsInfo(
      const std::string& method,
      const ::GURL& url,
      ::net::RequestPriority priority,
      ::net::ReferrerPolicy referrer_policy,
      ::network::mojom::TrustTokenParamsPtr trust_token_params,
      bool has_user_gesture,
      uint32_t resource_type,
      bool is_ad_related);

URLRequestDevToolsInfo(const URLRequestDevToolsInfo&) = delete;
URLRequestDevToolsInfo& operator=(const URLRequestDevToolsInfo&) = delete;

  ~URLRequestDevToolsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLRequestDevToolsInfoPtr>
  URLRequestDevToolsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLRequestDevToolsInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLRequestDevToolsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLRequestDevToolsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLRequestDevToolsInfo_UnserializedMessageContext<
            UserType, URLRequestDevToolsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLRequestDevToolsInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLRequestDevToolsInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLRequestDevToolsInfo_UnserializedMessageContext<
            UserType, URLRequestDevToolsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLRequestDevToolsInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string method;
  
  ::GURL url;
  
  ::net::RequestPriority priority;
  
  ::net::ReferrerPolicy referrer_policy;
  
  ::network::mojom::TrustTokenParamsPtr trust_token_params;
  
  bool has_user_gesture;
  
  uint32_t resource_type;
  
  bool is_ad_related;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLResponseHeadDevToolsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLResponseHeadDevToolsInfo, T>::value>;
  using DataView = URLResponseHeadDevToolsInfoDataView;
  using Data_ = internal::URLResponseHeadDevToolsInfo_Data;

  template <typename... Args>
  static URLResponseHeadDevToolsInfoPtr New(Args&&... args) {
    return URLResponseHeadDevToolsInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLResponseHeadDevToolsInfoPtr From(const U& u) {
    return mojo::TypeConverter<URLResponseHeadDevToolsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLResponseHeadDevToolsInfo>::Convert(*this);
  }


  URLResponseHeadDevToolsInfo();

  URLResponseHeadDevToolsInfo(
      ::base::Time response_time,
      const ::scoped_refptr<::net::HttpResponseHeaders>& headers,
      const std::string& mime_type,
      const std::string& charset,
      const ::net::LoadTimingInfo& load_timing,
      uint32_t cert_status,
      int64_t encoded_data_length,
      bool was_in_prefetch_cache,
      bool was_fetched_via_service_worker,
      const std::string& cache_storage_cache_name,
      const std::string& alpn_negotiated_protocol,
      ::net::AlternateProtocolUsage alternate_protocol_usage,
      bool was_fetched_via_spdy,
      ::network::mojom::FetchResponseSource service_worker_response_source,
      ::network::mojom::ServiceWorkerRouterInfoPtr service_worker_router_info,
      const std::optional<::net::SSLInfo>& ssl_info,
      const ::net::IPEndPoint& remote_endpoint,
      bool emitted_extra_info);

URLResponseHeadDevToolsInfo(const URLResponseHeadDevToolsInfo&) = delete;
URLResponseHeadDevToolsInfo& operator=(const URLResponseHeadDevToolsInfo&) = delete;

  ~URLResponseHeadDevToolsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLResponseHeadDevToolsInfoPtr>
  URLResponseHeadDevToolsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLResponseHeadDevToolsInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLResponseHeadDevToolsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLResponseHeadDevToolsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLResponseHeadDevToolsInfo_UnserializedMessageContext<
            UserType, URLResponseHeadDevToolsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLResponseHeadDevToolsInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLResponseHeadDevToolsInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLResponseHeadDevToolsInfo_UnserializedMessageContext<
            UserType, URLResponseHeadDevToolsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLResponseHeadDevToolsInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time response_time;
  
  ::scoped_refptr<::net::HttpResponseHeaders> headers;
  
  std::string mime_type;
  
  std::string charset;
  
  ::net::LoadTimingInfo load_timing;
  
  uint32_t cert_status;
  
  int64_t encoded_data_length;
  
  bool was_in_prefetch_cache;
  
  bool was_fetched_via_service_worker;
  
  std::string cache_storage_cache_name;
  
  std::string alpn_negotiated_protocol;
  
  ::net::AlternateProtocolUsage alternate_protocol_usage;
  
  bool was_fetched_via_spdy;
  
  ::network::mojom::FetchResponseSource service_worker_response_source;
  
  ::network::mojom::ServiceWorkerRouterInfoPtr service_worker_router_info;
  
  std::optional<::net::SSLInfo> ssl_info;
  
  ::net::IPEndPoint remote_endpoint;
  
  bool emitted_extra_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
URLRequestDevToolsInfoPtr URLRequestDevToolsInfo::Clone() const {
  return New(
      mojo::Clone(method),
      mojo::Clone(url),
      mojo::Clone(priority),
      mojo::Clone(referrer_policy),
      mojo::Clone(trust_token_params),
      mojo::Clone(has_user_gesture),
      mojo::Clone(resource_type),
      mojo::Clone(is_ad_related)
  );
}

template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>*>
bool URLRequestDevToolsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->trust_token_params, other_struct.trust_token_params))
    return false;
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  if (!mojo::Equals(this->resource_type, other_struct.resource_type))
    return false;
  if (!mojo::Equals(this->is_ad_related, other_struct.is_ad_related))
    return false;
  return true;
}

template <typename T, URLRequestDevToolsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.trust_token_params < rhs.trust_token_params)
    return true;
  if (rhs.trust_token_params < lhs.trust_token_params)
    return false;
  if (lhs.has_user_gesture < rhs.has_user_gesture)
    return true;
  if (rhs.has_user_gesture < lhs.has_user_gesture)
    return false;
  if (lhs.resource_type < rhs.resource_type)
    return true;
  if (rhs.resource_type < lhs.resource_type)
    return false;
  if (lhs.is_ad_related < rhs.is_ad_related)
    return true;
  if (rhs.is_ad_related < lhs.is_ad_related)
    return false;
  return false;
}
template <typename StructPtrType>
URLResponseHeadDevToolsInfoPtr URLResponseHeadDevToolsInfo::Clone() const {
  return New(
      mojo::Clone(response_time),
      mojo::Clone(headers),
      mojo::Clone(mime_type),
      mojo::Clone(charset),
      mojo::Clone(load_timing),
      mojo::Clone(cert_status),
      mojo::Clone(encoded_data_length),
      mojo::Clone(was_in_prefetch_cache),
      mojo::Clone(was_fetched_via_service_worker),
      mojo::Clone(cache_storage_cache_name),
      mojo::Clone(alpn_negotiated_protocol),
      mojo::Clone(alternate_protocol_usage),
      mojo::Clone(was_fetched_via_spdy),
      mojo::Clone(service_worker_response_source),
      mojo::Clone(service_worker_router_info),
      mojo::Clone(ssl_info),
      mojo::Clone(remote_endpoint),
      mojo::Clone(emitted_extra_info)
  );
}

template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>*>
bool URLResponseHeadDevToolsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response_time, other_struct.response_time))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->charset, other_struct.charset))
    return false;
  if (!mojo::Equals(this->load_timing, other_struct.load_timing))
    return false;
  if (!mojo::Equals(this->cert_status, other_struct.cert_status))
    return false;
  if (!mojo::Equals(this->encoded_data_length, other_struct.encoded_data_length))
    return false;
  if (!mojo::Equals(this->was_in_prefetch_cache, other_struct.was_in_prefetch_cache))
    return false;
  if (!mojo::Equals(this->was_fetched_via_service_worker, other_struct.was_fetched_via_service_worker))
    return false;
  if (!mojo::Equals(this->cache_storage_cache_name, other_struct.cache_storage_cache_name))
    return false;
  if (!mojo::Equals(this->alpn_negotiated_protocol, other_struct.alpn_negotiated_protocol))
    return false;
  if (!mojo::Equals(this->alternate_protocol_usage, other_struct.alternate_protocol_usage))
    return false;
  if (!mojo::Equals(this->was_fetched_via_spdy, other_struct.was_fetched_via_spdy))
    return false;
  if (!mojo::Equals(this->service_worker_response_source, other_struct.service_worker_response_source))
    return false;
  if (!mojo::Equals(this->service_worker_router_info, other_struct.service_worker_router_info))
    return false;
  if (!mojo::Equals(this->ssl_info, other_struct.ssl_info))
    return false;
  if (!mojo::Equals(this->remote_endpoint, other_struct.remote_endpoint))
    return false;
  if (!mojo::Equals(this->emitted_extra_info, other_struct.emitted_extra_info))
    return false;
  return true;
}

template <typename T, URLResponseHeadDevToolsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.response_time < rhs.response_time)
    return true;
  if (rhs.response_time < lhs.response_time)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.charset < rhs.charset)
    return true;
  if (rhs.charset < lhs.charset)
    return false;
  if (lhs.load_timing < rhs.load_timing)
    return true;
  if (rhs.load_timing < lhs.load_timing)
    return false;
  if (lhs.cert_status < rhs.cert_status)
    return true;
  if (rhs.cert_status < lhs.cert_status)
    return false;
  if (lhs.encoded_data_length < rhs.encoded_data_length)
    return true;
  if (rhs.encoded_data_length < lhs.encoded_data_length)
    return false;
  if (lhs.was_in_prefetch_cache < rhs.was_in_prefetch_cache)
    return true;
  if (rhs.was_in_prefetch_cache < lhs.was_in_prefetch_cache)
    return false;
  if (lhs.was_fetched_via_service_worker < rhs.was_fetched_via_service_worker)
    return true;
  if (rhs.was_fetched_via_service_worker < lhs.was_fetched_via_service_worker)
    return false;
  if (lhs.cache_storage_cache_name < rhs.cache_storage_cache_name)
    return true;
  if (rhs.cache_storage_cache_name < lhs.cache_storage_cache_name)
    return false;
  if (lhs.alpn_negotiated_protocol < rhs.alpn_negotiated_protocol)
    return true;
  if (rhs.alpn_negotiated_protocol < lhs.alpn_negotiated_protocol)
    return false;
  if (lhs.alternate_protocol_usage < rhs.alternate_protocol_usage)
    return true;
  if (rhs.alternate_protocol_usage < lhs.alternate_protocol_usage)
    return false;
  if (lhs.was_fetched_via_spdy < rhs.was_fetched_via_spdy)
    return true;
  if (rhs.was_fetched_via_spdy < lhs.was_fetched_via_spdy)
    return false;
  if (lhs.service_worker_response_source < rhs.service_worker_response_source)
    return true;
  if (rhs.service_worker_response_source < lhs.service_worker_response_source)
    return false;
  if (lhs.service_worker_router_info < rhs.service_worker_router_info)
    return true;
  if (rhs.service_worker_router_info < lhs.service_worker_router_info)
    return false;
  if (lhs.ssl_info < rhs.ssl_info)
    return true;
  if (rhs.ssl_info < lhs.ssl_info)
    return false;
  if (lhs.remote_endpoint < rhs.remote_endpoint)
    return true;
  if (rhs.remote_endpoint < lhs.remote_endpoint)
    return false;
  if (lhs.emitted_extra_info < rhs.emitted_extra_info)
    return true;
  if (rhs.emitted_extra_info < lhs.emitted_extra_info)
    return false;
  return false;
}
template <typename StructPtrType>
OtherPartitionInfoPtr OtherPartitionInfo::Clone() const {
  return New(
      mojo::Clone(site_has_cookie_in_other_partition)
  );
}

template <typename T, OtherPartitionInfo::EnableIfSame<T>*>
bool OtherPartitionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site_has_cookie_in_other_partition, other_struct.site_has_cookie_in_other_partition))
    return false;
  return true;
}

template <typename T, OtherPartitionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site_has_cookie_in_other_partition < rhs.site_has_cookie_in_other_partition)
    return true;
  if (rhs.site_has_cookie_in_other_partition < lhs.site_has_cookie_in_other_partition)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::URLRequestDevToolsInfo::DataView,
                                         ::network::mojom::URLRequestDevToolsInfoPtr> {
  static bool IsNull(const ::network::mojom::URLRequestDevToolsInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLRequestDevToolsInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::URLRequestDevToolsInfo::method)& method(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->method;
  }

  static const decltype(::network::mojom::URLRequestDevToolsInfo::url)& url(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->url;
  }

  static decltype(::network::mojom::URLRequestDevToolsInfo::priority) priority(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->priority;
  }

  static decltype(::network::mojom::URLRequestDevToolsInfo::referrer_policy) referrer_policy(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::network::mojom::URLRequestDevToolsInfo::trust_token_params)& trust_token_params(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->trust_token_params;
  }

  static decltype(::network::mojom::URLRequestDevToolsInfo::has_user_gesture) has_user_gesture(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->has_user_gesture;
  }

  static decltype(::network::mojom::URLRequestDevToolsInfo::resource_type) resource_type(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->resource_type;
  }

  static decltype(::network::mojom::URLRequestDevToolsInfo::is_ad_related) is_ad_related(
      const ::network::mojom::URLRequestDevToolsInfoPtr& input) {
    return input->is_ad_related;
  }

  static bool Read(::network::mojom::URLRequestDevToolsInfo::DataView input, ::network::mojom::URLRequestDevToolsInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::URLResponseHeadDevToolsInfo::DataView,
                                         ::network::mojom::URLResponseHeadDevToolsInfoPtr> {
  static bool IsNull(const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLResponseHeadDevToolsInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::response_time)& response_time(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->response_time;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::headers)& headers(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::mime_type)& mime_type(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->mime_type;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::charset)& charset(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->charset;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::load_timing)& load_timing(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->load_timing;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::cert_status) cert_status(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->cert_status;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::encoded_data_length) encoded_data_length(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->encoded_data_length;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::was_in_prefetch_cache) was_in_prefetch_cache(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->was_in_prefetch_cache;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::was_fetched_via_service_worker) was_fetched_via_service_worker(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->was_fetched_via_service_worker;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::cache_storage_cache_name)& cache_storage_cache_name(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->cache_storage_cache_name;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::alpn_negotiated_protocol)& alpn_negotiated_protocol(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->alpn_negotiated_protocol;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::alternate_protocol_usage) alternate_protocol_usage(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->alternate_protocol_usage;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::was_fetched_via_spdy) was_fetched_via_spdy(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->was_fetched_via_spdy;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::service_worker_response_source) service_worker_response_source(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->service_worker_response_source;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::service_worker_router_info)& service_worker_router_info(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->service_worker_router_info;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::ssl_info)& ssl_info(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->ssl_info;
  }

  static const decltype(::network::mojom::URLResponseHeadDevToolsInfo::remote_endpoint)& remote_endpoint(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->remote_endpoint;
  }

  static decltype(::network::mojom::URLResponseHeadDevToolsInfo::emitted_extra_info) emitted_extra_info(
      const ::network::mojom::URLResponseHeadDevToolsInfoPtr& input) {
    return input->emitted_extra_info;
  }

  static bool Read(::network::mojom::URLResponseHeadDevToolsInfo::DataView input, ::network::mojom::URLResponseHeadDevToolsInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::OtherPartitionInfo::DataView,
                                         ::network::mojom::OtherPartitionInfoPtr> {
  static bool IsNull(const ::network::mojom::OtherPartitionInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::OtherPartitionInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::OtherPartitionInfo::site_has_cookie_in_other_partition) site_has_cookie_in_other_partition(
      const ::network::mojom::OtherPartitionInfoPtr& input) {
    return input->site_has_cookie_in_other_partition;
  }

  static bool Read(::network::mojom::OtherPartitionInfo::DataView input, ::network::mojom::OtherPartitionInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_H_