// services/network/public/mojom/devtools_observer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/devtools_observer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_error.mojom-shared.h"
#include "services/network/public/mojom/sri_message_signature.mojom-shared.h"
#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/network/public/mojom/devtools_observer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::URLRequestDevToolsInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLRequestDevToolsInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLRequestDevToolsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::method(input)) in_method = Traits::method(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method)::BaseType> method_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_method,
        method_fragment);

      fragment->method.Set(
          method_fragment.is_null() ? nullptr : method_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in URLRequestDevToolsInfo struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in URLRequestDevToolsInfo struct");

      
      mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::priority(input),
        &fragment->priority);

      
      mojo::internal::Serialize<::network::mojom::URLRequestReferrerPolicy>(
        Traits::referrer_policy(input),
        &fragment->referrer_policy);

      decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView, send_validation>(
        in_trust_token_params,
        trust_token_params_fragment);

      fragment->trust_token_params.Set(
          trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());

      fragment->has_user_gesture = Traits::has_user_gesture(input);

      fragment->resource_type = Traits::resource_type(input);

      fragment->is_ad_related = Traits::is_ad_related(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::URLResponseHeadDevToolsInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLResponseHeadDevToolsInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLResponseHeadDevToolsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_time)::BaseType> response_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_response_time,
        response_time_fragment);

      fragment->response_time.Set(
          response_time_fragment.is_null() ? nullptr : response_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_time in URLResponseHeadDevToolsInfo struct");

      decltype(Traits::headers(input)) in_headers = Traits::headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers)::BaseType> headers_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView, send_validation>(
        in_headers,
        headers_fragment);

      fragment->headers.Set(
          headers_fragment.is_null() ? nullptr : headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in URLResponseHeadDevToolsInfo struct");

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in URLResponseHeadDevToolsInfo struct");

      decltype(Traits::charset(input)) in_charset = Traits::charset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->charset)::BaseType> charset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_charset,
        charset_fragment);

      fragment->charset.Set(
          charset_fragment.is_null() ? nullptr : charset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->charset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null charset in URLResponseHeadDevToolsInfo struct");

      decltype(Traits::load_timing(input)) in_load_timing = Traits::load_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->load_timing)::BaseType> load_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView, send_validation>(
        in_load_timing,
        load_timing_fragment);

      fragment->load_timing.Set(
          load_timing_fragment.is_null() ? nullptr : load_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->load_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null load_timing in URLResponseHeadDevToolsInfo struct");

      fragment->cert_status = Traits::cert_status(input);

      fragment->encoded_data_length = Traits::encoded_data_length(input);

      fragment->was_in_prefetch_cache = Traits::was_in_prefetch_cache(input);

      fragment->was_fetched_via_service_worker = Traits::was_fetched_via_service_worker(input);

      decltype(Traits::cache_storage_cache_name(input)) in_cache_storage_cache_name = Traits::cache_storage_cache_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cache_storage_cache_name)::BaseType> cache_storage_cache_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_cache_storage_cache_name,
        cache_storage_cache_name_fragment);

      fragment->cache_storage_cache_name.Set(
          cache_storage_cache_name_fragment.is_null() ? nullptr : cache_storage_cache_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cache_storage_cache_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cache_storage_cache_name in URLResponseHeadDevToolsInfo struct");

      decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_alpn_negotiated_protocol,
        alpn_negotiated_protocol_fragment);

      fragment->alpn_negotiated_protocol.Set(
          alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alpn_negotiated_protocol.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alpn_negotiated_protocol in URLResponseHeadDevToolsInfo struct");

      
      mojo::internal::Serialize<::network::mojom::AlternateProtocolUsage>(
        Traits::alternate_protocol_usage(input),
        &fragment->alternate_protocol_usage);

      fragment->was_fetched_via_spdy = Traits::was_fetched_via_spdy(input);

      
      mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
        Traits::service_worker_response_source(input),
        &fragment->service_worker_response_source);

      decltype(Traits::service_worker_router_info(input)) in_service_worker_router_info = Traits::service_worker_router_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_worker_router_info)::BaseType> service_worker_router_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterInfoDataView, send_validation>(
        in_service_worker_router_info,
        service_worker_router_info_fragment);

      fragment->service_worker_router_info.Set(
          service_worker_router_info_fragment.is_null() ? nullptr : service_worker_router_info_fragment.data());

      decltype(Traits::ssl_info(input)) in_ssl_info = Traits::ssl_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ssl_info)::BaseType> ssl_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SSLInfoDataView, send_validation>(
        in_ssl_info,
        ssl_info_fragment);

      fragment->ssl_info.Set(
          ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

      decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPEndPointDataView, send_validation>(
        in_remote_endpoint,
        remote_endpoint_fragment);

      fragment->remote_endpoint.Set(
          remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->remote_endpoint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null remote_endpoint in URLResponseHeadDevToolsInfo struct");

      fragment->emitted_extra_info = Traits::emitted_extra_info(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::OtherPartitionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::OtherPartitionInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::OtherPartitionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->site_has_cookie_in_other_partition = Traits::site_has_cookie_in_other_partition(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_SEND_VALIDATION_H_