// services/network/public/mojom/devtools_observer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DevToolsObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DevToolsObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.DevToolsObserverInterface }
 */
network.mojom.DevToolsObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DevToolsObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DevToolsObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DevToolsObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network.mojom.CookieWithAccessResult> } cookiesWithAccessResult
   * @param { !Array<!network.mojom.HttpRawHeaderPair> } headers
   * @param { !mojoBase.mojom.TimeTicks } timestamp
   * @param { ?network.mojom.ClientSecurityState } clientSecurityState
   * @param { ?network.mojom.OtherPartitionInfo } otherPartitionInfo
   * @param { ?mojoBase.mojom.UnguessableToken } appliedNetworkConditionsId
   */

  onRawRequest(
      devtoolRequestId,
      cookiesWithAccessResult,
      headers,
      timestamp,
      clientSecurityState,
      otherPartitionInfo,
      appliedNetworkConditionsId) {
    this.proxy.sendMessage(
        0,
        network.mojom.DevToolsObserver_OnRawRequest_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          cookiesWithAccessResult,
          headers,
          timestamp,
          clientSecurityState,
          otherPartitionInfo,
          appliedNetworkConditionsId
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network.mojom.CookieAndLineWithAccessResult> } cookiesWithAccessResult
   * @param { !Array<!network.mojom.HttpRawHeaderPair> } headers
   * @param { ?string } rawResponseHeaders
   * @param { !network.mojom.IPAddressSpace } resourceAddressSpace
   * @param { !number } httpStatusCode
   * @param { ?network.mojom.CookiePartitionKey } cookiePartitionKey
   */

  onRawResponse(
      devtoolRequestId,
      cookiesWithAccessResult,
      headers,
      rawResponseHeaders,
      resourceAddressSpace,
      httpStatusCode,
      cookiePartitionKey) {
    this.proxy.sendMessage(
        1,
        network.mojom.DevToolsObserver_OnRawResponse_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          cookiesWithAccessResult,
          headers,
          rawResponseHeaders,
          resourceAddressSpace,
          httpStatusCode,
          cookiePartitionKey
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !Array<!network.mojom.HttpRawHeaderPair> } headers
   */

  onEarlyHintsResponse(
      devtoolRequestId,
      headers) {
    this.proxy.sendMessage(
        2,
        network.mojom.DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          headers
        ],
        false);
  }

  
  /**
   * @param { ?string } devtoolRequestId
   * @param { !url.mojom.Url } url
   * @param { !boolean } isWarning
   * @param { !network.mojom.IPAddressSpace } resourceAddressSpace
   * @param { !network.mojom.ClientSecurityState } clientSecurityState
   */

  onPrivateNetworkRequest(
      devtoolRequestId,
      url,
      isWarning,
      resourceAddressSpace,
      clientSecurityState) {
    this.proxy.sendMessage(
        3,
        network.mojom.DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          isWarning,
          resourceAddressSpace,
          clientSecurityState
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } devtoolRequestId
   * @param { !network.mojom.HttpRequestHeaders } requestHeaders
   * @param { !network.mojom.URLRequestDevToolsInfo } requestInfo
   * @param { !url.mojom.Url } initiatorUrl
   * @param { !string } initiatorDevtoolRequestId
   */

  onCorsPreflightRequest(
      devtoolRequestId,
      requestHeaders,
      requestInfo,
      initiatorUrl,
      initiatorDevtoolRequestId) {
    this.proxy.sendMessage(
        4,
        network.mojom.DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          requestHeaders,
          requestInfo,
          initiatorUrl,
          initiatorDevtoolRequestId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } devtoolRequestId
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.URLResponseHeadDevToolsInfo } head
   */

  onCorsPreflightResponse(
      devtoolRequestId,
      url,
      head) {
    this.proxy.sendMessage(
        5,
        network.mojom.DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          head
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } devtoolRequestId
   * @param { !network.mojom.URLLoaderCompletionStatus } status
   */

  onCorsPreflightRequestCompleted(
      devtoolRequestId,
      status) {
    this.proxy.sendMessage(
        6,
        network.mojom.DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          status
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !network.mojom.TrustTokenOperationResult } result
   */

  onTrustTokenOperationDone(
      devtoolRequestId,
      result) {
    this.proxy.sendMessage(
        7,
        network.mojom.DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          result
        ],
        false);
  }

  
  /**
   * @param { ?string } devtoolRequestId
   * @param { ?url.mojom.Origin } initiatorOrigin
   * @param { ?network.mojom.ClientSecurityState } clientSecurityState
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.CorsErrorStatus } status
   * @param { !boolean } isWarning
   */

  onCorsError(
      devtoolRequestId,
      initiatorOrigin,
      clientSecurityState,
      url,
      status,
      isWarning) {
    this.proxy.sendMessage(
        8,
        network.mojom.DevToolsObserver_OnCorsError_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          initiatorOrigin,
          clientSecurityState,
          url,
          status,
          isWarning
        ],
        false);
  }

  
  /**
   * @param { ?string } devtoolsRequestId
   * @param { !url.mojom.Url } url
   */

  onOrbError(
      devtoolsRequestId,
      url) {
    this.proxy.sendMessage(
        9,
        network.mojom.DevToolsObserver_OnOrbError_ParamsSpec.$,
        null,
        [
          devtoolsRequestId,
          url
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.SharedDictionaryError } error
   */

  onSharedDictionaryError(
      devtoolRequestId,
      url,
      error) {
    this.proxy.sendMessage(
        10,
        network.mojom.DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          error
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url.mojom.Url } url
   * @param { !Array<!network.mojom.SRIMessageSignatureIssue> } issues
   */

  onSRIMessageSignatureIssue(
      devtoolRequestId,
      url,
      issues) {
    this.proxy.sendMessage(
        11,
        network.mojom.DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          issues
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolRequestId
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.UnencodedDigestIssue } issue
   */

  onUnencodedDigestError(
      devtoolRequestId,
      url,
      issue) {
    this.proxy.sendMessage(
        12,
        network.mojom.DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
        null,
        [
          devtoolRequestId,
          url,
          issue
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DevToolsObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        13,
        network.mojom.DevToolsObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevToolsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DevToolsObserverReceiver = class {
  /**
   * @param {!network.mojom.DevToolsObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DevToolsObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DevToolsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DevToolsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DevToolsObserver_OnRawRequest_ParamsSpec.$,
        null,
        impl.onRawRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.DevToolsObserver_OnRawResponse_ParamsSpec.$,
        null,
        impl.onRawResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
        null,
        impl.onEarlyHintsResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
        null,
        impl.onPrivateNetworkRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
        null,
        impl.onCorsPreflightRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
        null,
        impl.onCorsPreflightResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
        null,
        impl.onCorsPreflightRequestCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
        null,
        impl.onTrustTokenOperationDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.DevToolsObserver_OnCorsError_ParamsSpec.$,
        null,
        impl.onCorsError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.DevToolsObserver_OnOrbError_ParamsSpec.$,
        null,
        impl.onOrbError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        network.mojom.DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
        null,
        impl.onSharedDictionaryError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        network.mojom.DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
        null,
        impl.onSRIMessageSignatureIssue.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        network.mojom.DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
        null,
        impl.onUnencodedDigestError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        network.mojom.DevToolsObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DevToolsObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DevToolsObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DevToolsObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DevToolsObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevToolsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DevToolsObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DevToolsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DevToolsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRawRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DevToolsObserver_OnRawRequest_ParamsSpec.$,
        null,
        this.onRawRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRawResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.DevToolsObserver_OnRawResponse_ParamsSpec.$,
        null,
        this.onRawResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEarlyHintsResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
        null,
        this.onEarlyHintsResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPrivateNetworkRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
        null,
        this.onPrivateNetworkRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsPreflightRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
        null,
        this.onCorsPreflightRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsPreflightResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
        null,
        this.onCorsPreflightResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsPreflightRequestCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
        null,
        this.onCorsPreflightRequestCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrustTokenOperationDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
        null,
        this.onTrustTokenOperationDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCorsError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.DevToolsObserver_OnCorsError_ParamsSpec.$,
        null,
        this.onCorsError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOrbError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.DevToolsObserver_OnOrbError_ParamsSpec.$,
        null,
        this.onOrbError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSharedDictionaryError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        network.mojom.DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
        null,
        this.onSharedDictionaryError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSRIMessageSignatureIssue =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        network.mojom.DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
        null,
        this.onSRIMessageSignatureIssue.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUnencodedDigestError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        network.mojom.DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
        null,
        this.onUnencodedDigestError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        network.mojom.DevToolsObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLRequestDevToolsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLResponseHeadDevToolsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.OtherPartitionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnRawRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnRawResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnEarlyHintsResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnCorsPreflightRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnCorsPreflightResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnCorsError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnOrbError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnSharedDictionaryError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_OnUnencodedDigestError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DevToolsObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.URLRequestDevToolsInfoSpec.$,
    'URLRequestDevToolsInfo',
    [
      mojo.internal.StructField(
        'method', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 16,
        0,
        network.mojom.RequestPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrerPolicy', 20,
        0,
        network.mojom.URLRequestReferrerPolicySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 24,
        0,
        network.mojom.TrustTokenParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resourceType', 36,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAdRelated', 32,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
network.mojom.URLRequestDevToolsInfo = class {
  constructor() {
    /** @export { !string } */
    this.method;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.RequestPriority } */
    this.priority;
    /** @export { !network.mojom.URLRequestReferrerPolicy } */
    this.referrerPolicy;
    /** @export { (network.mojom.TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @export { !boolean } */
    this.hasUserGesture;
    /** @export { !number } */
    this.resourceType;
    /** @export { !boolean } */
    this.isAdRelated;
  }
};



mojo.internal.Struct(
    network.mojom.URLResponseHeadDevToolsInfoSpec.$,
    'URLResponseHeadDevToolsInfo',
    [
      mojo.internal.StructField(
        'responseTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'charset', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadTiming', 32,
        0,
        network.mojom.LoadTimingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certStatus', 40,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encodedDataLength', 48,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasInPrefetchCache', 44,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 44,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheStorageCacheName', 56,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alpnNegotiatedProtocol', 64,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alternateProtocolUsage', 72,
        0,
        network.mojom.AlternateProtocolUsageSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaSpdy', 44,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerResponseSource', 76,
        0,
        network.mojom.FetchResponseSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerRouterInfo', 80,
        0,
        network.mojom.ServiceWorkerRouterInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sslInfo', 88,
        0,
        network.mojom.SSLInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 96,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'emittedExtraInfo', 44,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 112],]);





/** @record */
network.mojom.URLResponseHeadDevToolsInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.responseTime;
    /** @export { !network.mojom.HttpResponseHeaders } */
    this.headers;
    /** @export { !string } */
    this.mimeType;
    /** @export { !string } */
    this.charset;
    /** @export { !network.mojom.LoadTimingInfo } */
    this.loadTiming;
    /** @export { !number } */
    this.certStatus;
    /** @export { !bigint } */
    this.encodedDataLength;
    /** @export { !boolean } */
    this.wasInPrefetchCache;
    /** @export { !boolean } */
    this.wasFetchedViaServiceWorker;
    /** @export { !string } */
    this.cacheStorageCacheName;
    /** @export { !string } */
    this.alpnNegotiatedProtocol;
    /** @export { !network.mojom.AlternateProtocolUsage } */
    this.alternateProtocolUsage;
    /** @export { !boolean } */
    this.wasFetchedViaSpdy;
    /** @export { !network.mojom.FetchResponseSource } */
    this.serviceWorkerResponseSource;
    /** @export { (network.mojom.ServiceWorkerRouterInfo|undefined) } */
    this.serviceWorkerRouterInfo;
    /** @export { (network.mojom.SSLInfo|undefined) } */
    this.sslInfo;
    /** @export { !network.mojom.IPEndPoint } */
    this.remoteEndpoint;
    /** @export { !boolean } */
    this.emittedExtraInfo;
  }
};



mojo.internal.Struct(
    network.mojom.OtherPartitionInfoSpec.$,
    'OtherPartitionInfo',
    [
      mojo.internal.StructField(
        'siteHasCookieInOtherPartition', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.OtherPartitionInfo = class {
  constructor() {
    /** @export { !boolean } */
    this.siteHasCookieInOtherPartition;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnRawRequest_ParamsSpec.$,
    'DevToolsObserver_OnRawRequest_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookiesWithAccessResult', 8,
        0,
        mojo.internal.Array(network.mojom.CookieWithAccessResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        mojo.internal.Array(network.mojom.HttpRawHeaderPairSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timestamp', 24,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 32,
        0,
        network.mojom.ClientSecurityStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'otherPartitionInfo', 40,
        0,
        network.mojom.OtherPartitionInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'appliedNetworkConditionsId', 48,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
network.mojom.DevToolsObserver_OnRawRequest_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolRequestId;
    /** @export { !Array<!network.mojom.CookieWithAccessResult> } */
    this.cookiesWithAccessResult;
    /** @export { !Array<!network.mojom.HttpRawHeaderPair> } */
    this.headers;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.timestamp;
    /** @export { (network.mojom.ClientSecurityState|undefined) } */
    this.clientSecurityState;
    /** @export { (network.mojom.OtherPartitionInfo|undefined) } */
    this.otherPartitionInfo;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.appliedNetworkConditionsId;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnRawResponse_ParamsSpec.$,
    'DevToolsObserver_OnRawResponse_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookiesWithAccessResult', 8,
        0,
        mojo.internal.Array(network.mojom.CookieAndLineWithAccessResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        mojo.internal.Array(network.mojom.HttpRawHeaderPairSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rawResponseHeaders', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resourceAddressSpace', 32,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpStatusCode', 36,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookiePartitionKey', 40,
        0,
        network.mojom.CookiePartitionKeySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.DevToolsObserver_OnRawResponse_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolRequestId;
    /** @export { !Array<!network.mojom.CookieAndLineWithAccessResult> } */
    this.cookiesWithAccessResult;
    /** @export { !Array<!network.mojom.HttpRawHeaderPair> } */
    this.headers;
    /** @export { (string|undefined) } */
    this.rawResponseHeaders;
    /** @export { !network.mojom.IPAddressSpace } */
    this.resourceAddressSpace;
    /** @export { !number } */
    this.httpStatusCode;
    /** @export { (network.mojom.CookiePartitionKey|undefined) } */
    this.cookiePartitionKey;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnEarlyHintsResponse_ParamsSpec.$,
    'DevToolsObserver_OnEarlyHintsResponse_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.Array(network.mojom.HttpRawHeaderPairSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DevToolsObserver_OnEarlyHintsResponse_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolRequestId;
    /** @export { !Array<!network.mojom.HttpRawHeaderPair> } */
    this.headers;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnPrivateNetworkRequest_ParamsSpec.$,
    'DevToolsObserver_OnPrivateNetworkRequest_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isWarning', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resourceAddressSpace', 20,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 24,
        0,
        network.mojom.ClientSecurityStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.DevToolsObserver_OnPrivateNetworkRequest_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.devtoolRequestId;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !boolean } */
    this.isWarning;
    /** @export { !network.mojom.IPAddressSpace } */
    this.resourceAddressSpace;
    /** @export { !network.mojom.ClientSecurityState } */
    this.clientSecurityState;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnCorsPreflightRequest_ParamsSpec.$,
    'DevToolsObserver_OnCorsPreflightRequest_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestHeaders', 8,
        0,
        network.mojom.HttpRequestHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestInfo', 16,
        0,
        network.mojom.URLRequestDevToolsInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorDevtoolRequestId', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
network.mojom.DevToolsObserver_OnCorsPreflightRequest_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolRequestId;
    /** @export { !network.mojom.HttpRequestHeaders } */
    this.requestHeaders;
    /** @export { !network.mojom.URLRequestDevToolsInfo } */
    this.requestInfo;
    /** @export { !url.mojom.Url } */
    this.initiatorUrl;
    /** @export { !string } */
    this.initiatorDevtoolRequestId;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnCorsPreflightResponse_ParamsSpec.$,
    'DevToolsObserver_OnCorsPreflightResponse_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'head', 16,
        0,
        network.mojom.URLResponseHeadDevToolsInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.DevToolsObserver_OnCorsPreflightResponse_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolRequestId;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.URLResponseHeadDevToolsInfo } */
    this.head;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsSpec.$,
    'DevToolsObserver_OnCorsPreflightRequestCompleted_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        network.mojom.URLLoaderCompletionStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DevToolsObserver_OnCorsPreflightRequestCompleted_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolRequestId;
    /** @export { !network.mojom.URLLoaderCompletionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnTrustTokenOperationDone_ParamsSpec.$,
    'DevToolsObserver_OnTrustTokenOperationDone_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        network.mojom.TrustTokenOperationResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DevToolsObserver_OnTrustTokenOperationDone_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolRequestId;
    /** @export { !network.mojom.TrustTokenOperationResult } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnCorsError_ParamsSpec.$,
    'DevToolsObserver_OnCorsError_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 16,
        0,
        network.mojom.ClientSecurityStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 32,
        0,
        network.mojom.CorsErrorStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isWarning', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.DevToolsObserver_OnCorsError_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.devtoolRequestId;
    /** @export { (url.mojom.Origin|undefined) } */
    this.initiatorOrigin;
    /** @export { (network.mojom.ClientSecurityState|undefined) } */
    this.clientSecurityState;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.CorsErrorStatus } */
    this.status;
    /** @export { !boolean } */
    this.isWarning;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnOrbError_ParamsSpec.$,
    'DevToolsObserver_OnOrbError_Params',
    [
      mojo.internal.StructField(
        'devtoolsRequestId', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DevToolsObserver_OnOrbError_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.devtoolsRequestId;
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnSharedDictionaryError_ParamsSpec.$,
    'DevToolsObserver_OnSharedDictionaryError_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        network.mojom.SharedDictionaryErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.DevToolsObserver_OnSharedDictionaryError_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolRequestId;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SharedDictionaryError } */
    this.error;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnSRIMessageSignatureIssue_ParamsSpec.$,
    'DevToolsObserver_OnSRIMessageSignatureIssue_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issues', 16,
        0,
        mojo.internal.Array(network.mojom.SRIMessageSignatureIssueSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.DevToolsObserver_OnSRIMessageSignatureIssue_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolRequestId;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Array<!network.mojom.SRIMessageSignatureIssue> } */
    this.issues;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_OnUnencodedDigestError_ParamsSpec.$,
    'DevToolsObserver_OnUnencodedDigestError_Params',
    [
      mojo.internal.StructField(
        'devtoolRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issue', 16,
        0,
        network.mojom.UnencodedDigestIssueSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.DevToolsObserver_OnUnencodedDigestError_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolRequestId;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.UnencodedDigestIssue } */
    this.issue;
  }
};



mojo.internal.Struct(
    network.mojom.DevToolsObserver_Clone_ParamsSpec.$,
    'DevToolsObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DevToolsObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DevToolsObserver_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.DevToolsObserverPendingReceiver } */
    this.listener;
  }
};

