// services/network/public/mojom/device_bound_sessions.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/device_bound_sessions.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "services/network/public/mojom/clear_data_filter.mojom-forward.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/device_bound_sessions_mojom_traits.h"




namespace network::mojom {

class DeviceBoundSessionManagerProxy;

template <typename ImplRefTraits>
class DeviceBoundSessionManagerStub;

class DeviceBoundSessionManagerRequestValidator;
class DeviceBoundSessionManagerResponseValidator;


class DeviceBoundSessionManager
    : public DeviceBoundSessionManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.DeviceBoundSessionManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceBoundSessionManagerInterfaceBase;
  using Proxy_ = DeviceBoundSessionManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceBoundSessionManagerStub<ImplRefTraits>;

  using RequestValidator_ = DeviceBoundSessionManagerRequestValidator;
  using ResponseValidator_ = DeviceBoundSessionManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllSessionsMinVersion = 0,
    kDeleteSessionMinVersion = 0,
    kDeleteAllSessionsMinVersion = 0,
    kAddObserverMinVersion = 0,
    kCreateBoundSessionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllSessions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAllSessions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateBoundSessions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceBoundSessionManager() = default;

  using GetAllSessionsCallback = base::OnceCallback<void(const std::vector<::net::device_bound_sessions::SessionKey>&)>;
  using GetAllSessionsMojoCallback = base::OnceCallback<void(const std::vector<::net::device_bound_sessions::SessionKey>&)>;

  virtual void GetAllSessions(GetAllSessionsCallback callback) = 0;

  virtual void DeleteSession(::net::device_bound_sessions::DeletionReason reason, const ::net::device_bound_sessions::SessionKey& session) = 0;

  using DeleteAllSessionsCallback = base::OnceCallback<void()>;
  using DeleteAllSessionsMojoCallback = base::OnceCallback<void()>;

  virtual void DeleteAllSessions(::net::device_bound_sessions::DeletionReason reason, std::optional<::base::Time> created_after_time, std::optional<::base::Time> created_before_time, ::network::mojom::ClearDataFilterPtr filter, DeleteAllSessionsCallback callback) = 0;

  virtual void AddObserver(const ::GURL& url, ::mojo::PendingRemote<DeviceBoundSessionAccessObserver> observer) = 0;

  using CreateBoundSessionsCallback = base::OnceCallback<void(const std::vector<::net::device_bound_sessions::SessionError::ErrorType>&, std::vector<::net::CookieInclusionStatus>)>;
  using CreateBoundSessionsMojoCallback = base::OnceCallback<void(const std::vector<::net::device_bound_sessions::SessionError::ErrorType>&, std::vector<::net::CookieInclusionStatus>)>;

  virtual void CreateBoundSessions(std::vector<::net::device_bound_sessions::SessionParams> params, const std::vector<uint8_t>& wrapped_key, const std::vector<::net::CanonicalCookie>& cookies_to_set, const ::net::CookieOptions& cookie_options, CreateBoundSessionsCallback callback) = 0;
};

class DeviceBoundSessionAccessObserverProxy;

template <typename ImplRefTraits>
class DeviceBoundSessionAccessObserverStub;

class DeviceBoundSessionAccessObserverRequestValidator;


class DeviceBoundSessionAccessObserver
    : public DeviceBoundSessionAccessObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.DeviceBoundSessionAccessObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceBoundSessionAccessObserverInterfaceBase;
  using Proxy_ = DeviceBoundSessionAccessObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceBoundSessionAccessObserverStub<ImplRefTraits>;

  using RequestValidator_ = DeviceBoundSessionAccessObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceBoundSessionAccessedMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDeviceBoundSessionAccessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceBoundSessionAccessObserver() = default;

  virtual void OnDeviceBoundSessionAccessed(const ::net::device_bound_sessions::SessionAccess& access) = 0;

  virtual void Clone(::mojo::PendingReceiver<DeviceBoundSessionAccessObserver> observer) = 0;
};



class  DeviceBoundSessionManagerProxy
    : public DeviceBoundSessionManager {
 public:
  using InterfaceType = DeviceBoundSessionManager;

  explicit DeviceBoundSessionManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllSessions(GetAllSessionsCallback callback) final;
  
  void DeleteSession(::net::device_bound_sessions::DeletionReason reason, const ::net::device_bound_sessions::SessionKey& session) final;
  
  void DeleteAllSessions(::net::device_bound_sessions::DeletionReason reason, std::optional<::base::Time> created_after_time, std::optional<::base::Time> created_before_time, ::network::mojom::ClearDataFilterPtr filter, DeleteAllSessionsCallback callback) final;
  
  void AddObserver(const ::GURL& url, ::mojo::PendingRemote<DeviceBoundSessionAccessObserver> observer) final;
  
  void CreateBoundSessions(std::vector<::net::device_bound_sessions::SessionParams> params, const std::vector<uint8_t>& wrapped_key, const std::vector<::net::CanonicalCookie>& cookies_to_set, const ::net::CookieOptions& cookie_options, CreateBoundSessionsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DeviceBoundSessionAccessObserverProxy
    : public DeviceBoundSessionAccessObserver {
 public:
  using InterfaceType = DeviceBoundSessionAccessObserver;

  explicit DeviceBoundSessionAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceBoundSessionAccessed(const ::net::device_bound_sessions::SessionAccess& access) final;
  
  void Clone(::mojo::PendingReceiver<DeviceBoundSessionAccessObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DeviceBoundSessionManagerStubDispatch {
 public:
  static bool Accept(DeviceBoundSessionManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceBoundSessionManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceBoundSessionManager>>
class DeviceBoundSessionManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceBoundSessionManagerStub() = default;
  ~DeviceBoundSessionManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceBoundSessionAccessObserverStubDispatch {
 public:
  static bool Accept(DeviceBoundSessionAccessObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceBoundSessionAccessObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceBoundSessionAccessObserver>>
class DeviceBoundSessionAccessObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceBoundSessionAccessObserverStub() = default;
  ~DeviceBoundSessionAccessObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionAccessObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionAccessObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceBoundSessionManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeviceBoundSessionAccessObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeviceBoundSessionManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  DeviceBoundSessionScopeSpecification {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionScopeSpecification, T>::value>;
  using DataView = DeviceBoundSessionScopeSpecificationDataView;
  using Data_ = internal::DeviceBoundSessionScopeSpecification_Data;

  template <typename... Args>
  static DeviceBoundSessionScopeSpecificationPtr New(Args&&... args) {
    return DeviceBoundSessionScopeSpecificationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionScopeSpecificationPtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionScopeSpecificationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionScopeSpecification>::Convert(*this);
  }


  DeviceBoundSessionScopeSpecification();

  DeviceBoundSessionScopeSpecification(
      DeviceBoundSessionScopeSpecificationType type,
      const std::string& domain,
      const std::string& path);


  ~DeviceBoundSessionScopeSpecification();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionScopeSpecificationPtr>
  DeviceBoundSessionScopeSpecificationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionScopeSpecification::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionScopeSpecification::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionScopeSpecification::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionScopeSpecification_UnserializedMessageContext<
            UserType, DeviceBoundSessionScopeSpecification::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionScopeSpecification::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionScopeSpecification::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionScopeSpecification_UnserializedMessageContext<
            UserType, DeviceBoundSessionScopeSpecification::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionScopeSpecification::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DeviceBoundSessionScopeSpecificationType type;
  
  std::string domain;
  
  std::string path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DeviceBoundSessionCredential {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionCredential, T>::value>;
  using DataView = DeviceBoundSessionCredentialDataView;
  using Data_ = internal::DeviceBoundSessionCredential_Data;

  template <typename... Args>
  static DeviceBoundSessionCredentialPtr New(Args&&... args) {
    return DeviceBoundSessionCredentialPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionCredentialPtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionCredentialPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionCredential>::Convert(*this);
  }


  DeviceBoundSessionCredential();

  DeviceBoundSessionCredential(
      const std::string& name,
      const std::string& attributes);


  ~DeviceBoundSessionCredential();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionCredentialPtr>
  DeviceBoundSessionCredentialPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionCredential::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionCredential::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionCredential::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionCredential_UnserializedMessageContext<
            UserType, DeviceBoundSessionCredential::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionCredential::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionCredential::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionCredential_UnserializedMessageContext<
            UserType, DeviceBoundSessionCredential::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionCredential::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string attributes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  DeviceBoundSessionKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionKey, T>::value>;
  using DataView = DeviceBoundSessionKeyDataView;
  using Data_ = internal::DeviceBoundSessionKey_Data;

  template <typename... Args>
  static DeviceBoundSessionKeyPtr New(Args&&... args) {
    return DeviceBoundSessionKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionKeyPtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionKey>::Convert(*this);
  }


  DeviceBoundSessionKey();

  DeviceBoundSessionKey(
      const ::net::SchemefulSite& site,
      const std::string& id);


  ~DeviceBoundSessionKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionKeyPtr>
  DeviceBoundSessionKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionKey_UnserializedMessageContext<
            UserType, DeviceBoundSessionKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionKey_UnserializedMessageContext<
            UserType, DeviceBoundSessionKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::SchemefulSite site;
  
  std::string id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DeviceBoundSessionAccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionAccess, T>::value>;
  using DataView = DeviceBoundSessionAccessDataView;
  using Data_ = internal::DeviceBoundSessionAccess_Data;

  template <typename... Args>
  static DeviceBoundSessionAccessPtr New(Args&&... args) {
    return DeviceBoundSessionAccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionAccessPtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionAccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionAccess>::Convert(*this);
  }


  DeviceBoundSessionAccess();

  DeviceBoundSessionAccess(
      DeviceBoundSessionAccessType access_type,
      const ::net::device_bound_sessions::SessionKey& session_key,
      std::vector<std::string> cookies);


  ~DeviceBoundSessionAccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionAccessPtr>
  DeviceBoundSessionAccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionAccess::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionAccess::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionAccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionAccess_UnserializedMessageContext<
            UserType, DeviceBoundSessionAccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionAccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionAccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionAccess_UnserializedMessageContext<
            UserType, DeviceBoundSessionAccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionAccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DeviceBoundSessionAccessType access_type;
  
  ::net::device_bound_sessions::SessionKey session_key;
  
  std::vector<std::string> cookies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DeviceBoundSessionScope {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionScope, T>::value>;
  using DataView = DeviceBoundSessionScopeDataView;
  using Data_ = internal::DeviceBoundSessionScope_Data;

  template <typename... Args>
  static DeviceBoundSessionScopePtr New(Args&&... args) {
    return DeviceBoundSessionScopePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionScopePtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionScopePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionScope>::Convert(*this);
  }


  DeviceBoundSessionScope();

  DeviceBoundSessionScope(
      bool include_site,
      std::vector<DeviceBoundSessionScopeSpecificationPtr> specifications,
      const std::string& origin);

DeviceBoundSessionScope(const DeviceBoundSessionScope&) = delete;
DeviceBoundSessionScope& operator=(const DeviceBoundSessionScope&) = delete;

  ~DeviceBoundSessionScope();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionScopePtr>
  DeviceBoundSessionScopePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionScope::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionScope::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionScope::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionScope::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionScope::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionScope::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionScope_UnserializedMessageContext<
            UserType, DeviceBoundSessionScope::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionScope::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionScope::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionScope_UnserializedMessageContext<
            UserType, DeviceBoundSessionScope::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionScope::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool include_site;
  
  std::vector<DeviceBoundSessionScopeSpecificationPtr> specifications;
  
  std::string origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionScope::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionScope::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionScope::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionScope::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DeviceBoundSessionParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionParams, T>::value>;
  using DataView = DeviceBoundSessionParamsDataView;
  using Data_ = internal::DeviceBoundSessionParams_Data;

  template <typename... Args>
  static DeviceBoundSessionParamsPtr New(Args&&... args) {
    return DeviceBoundSessionParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionParamsPtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionParams>::Convert(*this);
  }


  DeviceBoundSessionParams();

  DeviceBoundSessionParams(
      const std::string& session_id,
      const ::GURL& fetcher_url,
      const std::string& refresh_url,
      DeviceBoundSessionScopePtr scope,
      std::vector<DeviceBoundSessionCredentialPtr> credentials,
      std::vector<std::string> allowed_refresh_initiators);

DeviceBoundSessionParams(const DeviceBoundSessionParams&) = delete;
DeviceBoundSessionParams& operator=(const DeviceBoundSessionParams&) = delete;

  ~DeviceBoundSessionParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionParamsPtr>
  DeviceBoundSessionParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionParams_UnserializedMessageContext<
            UserType, DeviceBoundSessionParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionParams_UnserializedMessageContext<
            UserType, DeviceBoundSessionParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string session_id;
  
  ::GURL fetcher_url;
  
  std::string refresh_url;
  
  DeviceBoundSessionScopePtr scope;
  
  std::vector<DeviceBoundSessionCredentialPtr> credentials;
  
  std::vector<std::string> allowed_refresh_initiators;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DeviceBoundSessionKeyPtr DeviceBoundSessionKey::Clone() const {
  return New(
      mojo::Clone(site),
      mojo::Clone(id)
  );
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>*>
bool DeviceBoundSessionKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site, other_struct.site))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site < rhs.site)
    return true;
  if (rhs.site < lhs.site)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceBoundSessionAccessPtr DeviceBoundSessionAccess::Clone() const {
  return New(
      mojo::Clone(access_type),
      mojo::Clone(session_key),
      mojo::Clone(cookies)
  );
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>*>
bool DeviceBoundSessionAccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->access_type, other_struct.access_type))
    return false;
  if (!mojo::Equals(this->session_key, other_struct.session_key))
    return false;
  if (!mojo::Equals(this->cookies, other_struct.cookies))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.access_type < rhs.access_type)
    return true;
  if (rhs.access_type < lhs.access_type)
    return false;
  if (lhs.session_key < rhs.session_key)
    return true;
  if (rhs.session_key < lhs.session_key)
    return false;
  if (lhs.cookies < rhs.cookies)
    return true;
  if (rhs.cookies < lhs.cookies)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceBoundSessionScopeSpecificationPtr DeviceBoundSessionScopeSpecification::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(domain),
      mojo::Clone(path)
  );
}

template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>*>
bool DeviceBoundSessionScopeSpecification::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionScopeSpecification::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceBoundSessionScopePtr DeviceBoundSessionScope::Clone() const {
  return New(
      mojo::Clone(include_site),
      mojo::Clone(specifications),
      mojo::Clone(origin)
  );
}

template <typename T, DeviceBoundSessionScope::EnableIfSame<T>*>
bool DeviceBoundSessionScope::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_site, other_struct.include_site))
    return false;
  if (!mojo::Equals(this->specifications, other_struct.specifications))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionScope::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.include_site < rhs.include_site)
    return true;
  if (rhs.include_site < lhs.include_site)
    return false;
  if (lhs.specifications < rhs.specifications)
    return true;
  if (rhs.specifications < lhs.specifications)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceBoundSessionCredentialPtr DeviceBoundSessionCredential::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(attributes)
  );
}

template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>*>
bool DeviceBoundSessionCredential::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->attributes, other_struct.attributes))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionCredential::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.attributes < rhs.attributes)
    return true;
  if (rhs.attributes < lhs.attributes)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceBoundSessionParamsPtr DeviceBoundSessionParams::Clone() const {
  return New(
      mojo::Clone(session_id),
      mojo::Clone(fetcher_url),
      mojo::Clone(refresh_url),
      mojo::Clone(scope),
      mojo::Clone(credentials),
      mojo::Clone(allowed_refresh_initiators)
  );
}

template <typename T, DeviceBoundSessionParams::EnableIfSame<T>*>
bool DeviceBoundSessionParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_id, other_struct.session_id))
    return false;
  if (!mojo::Equals(this->fetcher_url, other_struct.fetcher_url))
    return false;
  if (!mojo::Equals(this->refresh_url, other_struct.refresh_url))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->credentials, other_struct.credentials))
    return false;
  if (!mojo::Equals(this->allowed_refresh_initiators, other_struct.allowed_refresh_initiators))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_id < rhs.session_id)
    return true;
  if (rhs.session_id < lhs.session_id)
    return false;
  if (lhs.fetcher_url < rhs.fetcher_url)
    return true;
  if (rhs.fetcher_url < lhs.fetcher_url)
    return false;
  if (lhs.refresh_url < rhs.refresh_url)
    return true;
  if (rhs.refresh_url < lhs.refresh_url)
    return false;
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.credentials < rhs.credentials)
    return true;
  if (rhs.credentials < lhs.credentials)
    return false;
  if (lhs.allowed_refresh_initiators < rhs.allowed_refresh_initiators)
    return true;
  if (rhs.allowed_refresh_initiators < lhs.allowed_refresh_initiators)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::DeviceBoundSessionKey::DataView,
                                         ::network::mojom::DeviceBoundSessionKeyPtr> {
  static bool IsNull(const ::network::mojom::DeviceBoundSessionKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DeviceBoundSessionKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DeviceBoundSessionKey::site)& site(
      const ::network::mojom::DeviceBoundSessionKeyPtr& input) {
    return input->site;
  }

  static const decltype(::network::mojom::DeviceBoundSessionKey::id)& id(
      const ::network::mojom::DeviceBoundSessionKeyPtr& input) {
    return input->id;
  }

  static bool Read(::network::mojom::DeviceBoundSessionKey::DataView input, ::network::mojom::DeviceBoundSessionKeyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::DeviceBoundSessionAccess::DataView,
                                         ::network::mojom::DeviceBoundSessionAccessPtr> {
  static bool IsNull(const ::network::mojom::DeviceBoundSessionAccessPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DeviceBoundSessionAccessPtr* output) { output->reset(); }

  static decltype(::network::mojom::DeviceBoundSessionAccess::access_type) access_type(
      const ::network::mojom::DeviceBoundSessionAccessPtr& input) {
    return input->access_type;
  }

  static const decltype(::network::mojom::DeviceBoundSessionAccess::session_key)& session_key(
      const ::network::mojom::DeviceBoundSessionAccessPtr& input) {
    return input->session_key;
  }

  static const decltype(::network::mojom::DeviceBoundSessionAccess::cookies)& cookies(
      const ::network::mojom::DeviceBoundSessionAccessPtr& input) {
    return input->cookies;
  }

  static bool Read(::network::mojom::DeviceBoundSessionAccess::DataView input, ::network::mojom::DeviceBoundSessionAccessPtr* output);
};


template <>
struct  StructTraits<::network::mojom::DeviceBoundSessionScopeSpecification::DataView,
                                         ::network::mojom::DeviceBoundSessionScopeSpecificationPtr> {
  static bool IsNull(const ::network::mojom::DeviceBoundSessionScopeSpecificationPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DeviceBoundSessionScopeSpecificationPtr* output) { output->reset(); }

  static decltype(::network::mojom::DeviceBoundSessionScopeSpecification::type) type(
      const ::network::mojom::DeviceBoundSessionScopeSpecificationPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::DeviceBoundSessionScopeSpecification::domain)& domain(
      const ::network::mojom::DeviceBoundSessionScopeSpecificationPtr& input) {
    return input->domain;
  }

  static const decltype(::network::mojom::DeviceBoundSessionScopeSpecification::path)& path(
      const ::network::mojom::DeviceBoundSessionScopeSpecificationPtr& input) {
    return input->path;
  }

  static bool Read(::network::mojom::DeviceBoundSessionScopeSpecification::DataView input, ::network::mojom::DeviceBoundSessionScopeSpecificationPtr* output);
};


template <>
struct  StructTraits<::network::mojom::DeviceBoundSessionScope::DataView,
                                         ::network::mojom::DeviceBoundSessionScopePtr> {
  static bool IsNull(const ::network::mojom::DeviceBoundSessionScopePtr& input) { return !input; }
  static void SetToNull(::network::mojom::DeviceBoundSessionScopePtr* output) { output->reset(); }

  static decltype(::network::mojom::DeviceBoundSessionScope::include_site) include_site(
      const ::network::mojom::DeviceBoundSessionScopePtr& input) {
    return input->include_site;
  }

  static const decltype(::network::mojom::DeviceBoundSessionScope::specifications)& specifications(
      const ::network::mojom::DeviceBoundSessionScopePtr& input) {
    return input->specifications;
  }

  static const decltype(::network::mojom::DeviceBoundSessionScope::origin)& origin(
      const ::network::mojom::DeviceBoundSessionScopePtr& input) {
    return input->origin;
  }

  static bool Read(::network::mojom::DeviceBoundSessionScope::DataView input, ::network::mojom::DeviceBoundSessionScopePtr* output);
};


template <>
struct  StructTraits<::network::mojom::DeviceBoundSessionCredential::DataView,
                                         ::network::mojom::DeviceBoundSessionCredentialPtr> {
  static bool IsNull(const ::network::mojom::DeviceBoundSessionCredentialPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DeviceBoundSessionCredentialPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DeviceBoundSessionCredential::name)& name(
      const ::network::mojom::DeviceBoundSessionCredentialPtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::DeviceBoundSessionCredential::attributes)& attributes(
      const ::network::mojom::DeviceBoundSessionCredentialPtr& input) {
    return input->attributes;
  }

  static bool Read(::network::mojom::DeviceBoundSessionCredential::DataView input, ::network::mojom::DeviceBoundSessionCredentialPtr* output);
};


template <>
struct  StructTraits<::network::mojom::DeviceBoundSessionParams::DataView,
                                         ::network::mojom::DeviceBoundSessionParamsPtr> {
  static bool IsNull(const ::network::mojom::DeviceBoundSessionParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DeviceBoundSessionParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DeviceBoundSessionParams::session_id)& session_id(
      const ::network::mojom::DeviceBoundSessionParamsPtr& input) {
    return input->session_id;
  }

  static const decltype(::network::mojom::DeviceBoundSessionParams::fetcher_url)& fetcher_url(
      const ::network::mojom::DeviceBoundSessionParamsPtr& input) {
    return input->fetcher_url;
  }

  static const decltype(::network::mojom::DeviceBoundSessionParams::refresh_url)& refresh_url(
      const ::network::mojom::DeviceBoundSessionParamsPtr& input) {
    return input->refresh_url;
  }

  static const decltype(::network::mojom::DeviceBoundSessionParams::scope)& scope(
      const ::network::mojom::DeviceBoundSessionParamsPtr& input) {
    return input->scope;
  }

  static const decltype(::network::mojom::DeviceBoundSessionParams::credentials)& credentials(
      const ::network::mojom::DeviceBoundSessionParamsPtr& input) {
    return input->credentials;
  }

  static const decltype(::network::mojom::DeviceBoundSessionParams::allowed_refresh_initiators)& allowed_refresh_initiators(
      const ::network::mojom::DeviceBoundSessionParamsPtr& input) {
    return input->allowed_refresh_initiators;
  }

  static bool Read(::network::mojom::DeviceBoundSessionParams::DataView input, ::network::mojom::DeviceBoundSessionParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_H_