// services/network/public/mojom/device_bound_sessions.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/device_bound_sessions.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::DeviceBoundSessionAccessType>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionAccessType> {};

template <>
struct hash<::network::mojom::DeviceBoundSessionUsage>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionUsage> {};

template <>
struct hash<::network::mojom::DeviceBoundSessionDeletionReason>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionDeletionReason> {};

template <>
struct hash<::network::mojom::DeviceBoundSessionScopeSpecificationType>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionScopeSpecificationType> {};

template <>
struct hash<::network::mojom::DeviceBoundSessionError>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionAccessType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionAccessType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionAccessType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionDeletionReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionDeletionReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionDeletionReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionScopeSpecificationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionScopeSpecificationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionScopeSpecificationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::site(input)) in_site = Traits::site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site)::BaseType> site_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_site,
      site_fragment);

    fragment->site.Set(
        site_fragment.is_null() ? nullptr : site_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->site.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site in DeviceBoundSessionKey struct");

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in DeviceBoundSessionKey struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionAccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionAccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionAccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionAccessType>(
      Traits::access_type(input),
      &fragment->access_type);

    decltype(Traits::session_key(input)) in_session_key = Traits::session_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_key)::BaseType> session_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionKeyDataView>(
      in_session_key,
      session_key_fragment);

    fragment->session_key.Set(
        session_key_fragment.is_null() ? nullptr : session_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_key in DeviceBoundSessionAccess struct");

    decltype(Traits::cookies(input)) in_cookies = Traits::cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookies)::BaseType>
        cookies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cookies,
      cookies_fragment,
      &cookies_validate_params);

    fragment->cookies.Set(
        cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in DeviceBoundSessionAccess struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionAccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionAccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionScopeSpecificationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionScopeSpecificationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionScopeSpecification_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionScopeSpecificationType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain)::BaseType> domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain,
      domain_fragment);

    fragment->domain.Set(
        domain_fragment.is_null() ? nullptr : domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in DeviceBoundSessionScopeSpecification struct");

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in DeviceBoundSessionScopeSpecification struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionScopeSpecification_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionScopeSpecificationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionScopeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionScopeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionScope_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->include_site = Traits::include_site(input);

    decltype(Traits::specifications(input)) in_specifications = Traits::specifications(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->specifications)::BaseType>
        specifications_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& specifications_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DeviceBoundSessionScopeSpecificationDataView>>(
      in_specifications,
      specifications_fragment,
      &specifications_validate_params);

    fragment->specifications.Set(
        specifications_fragment.is_null() ? nullptr : specifications_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->specifications.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null specifications in DeviceBoundSessionScope struct");

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in DeviceBoundSessionScope struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionScope_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionScopeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionCredentialDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionCredentialDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionCredential_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in DeviceBoundSessionCredential struct");

    decltype(Traits::attributes(input)) in_attributes = Traits::attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attributes)::BaseType> attributes_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_attributes,
      attributes_fragment);

    fragment->attributes.Set(
        attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attributes in DeviceBoundSessionCredential struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionCredential_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionCredentialDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::session_id(input)) in_session_id = Traits::session_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_id)::BaseType> session_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id,
      session_id_fragment);

    fragment->session_id.Set(
        session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in DeviceBoundSessionParams struct");

    decltype(Traits::fetcher_url(input)) in_fetcher_url = Traits::fetcher_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetcher_url)::BaseType> fetcher_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_fetcher_url,
      fetcher_url_fragment);

    fragment->fetcher_url.Set(
        fetcher_url_fragment.is_null() ? nullptr : fetcher_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fetcher_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fetcher_url in DeviceBoundSessionParams struct");

    decltype(Traits::refresh_url(input)) in_refresh_url = Traits::refresh_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->refresh_url)::BaseType> refresh_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_refresh_url,
      refresh_url_fragment);

    fragment->refresh_url.Set(
        refresh_url_fragment.is_null() ? nullptr : refresh_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->refresh_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null refresh_url in DeviceBoundSessionParams struct");

    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope)::BaseType> scope_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionScopeDataView>(
      in_scope,
      scope_fragment);

    fragment->scope.Set(
        scope_fragment.is_null() ? nullptr : scope_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope in DeviceBoundSessionParams struct");

    decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credentials)::BaseType>
        credentials_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DeviceBoundSessionCredentialDataView>>(
      in_credentials,
      credentials_fragment,
      &credentials_validate_params);

    fragment->credentials.Set(
        credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credentials.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credentials in DeviceBoundSessionParams struct");

    decltype(Traits::allowed_refresh_initiators(input)) in_allowed_refresh_initiators = Traits::allowed_refresh_initiators(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_refresh_initiators)::BaseType>
        allowed_refresh_initiators_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowed_refresh_initiators_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_allowed_refresh_initiators,
      allowed_refresh_initiators_fragment,
      &allowed_refresh_initiators_validate_params);

    fragment->allowed_refresh_initiators.Set(
        allowed_refresh_initiators_fragment.is_null() ? nullptr : allowed_refresh_initiators_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allowed_refresh_initiators.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allowed_refresh_initiators in DeviceBoundSessionParams struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void DeviceBoundSessionKeyDataView::GetSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void DeviceBoundSessionKeyDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DeviceBoundSessionAccessDataView::GetSessionKeyDataView(
    DeviceBoundSessionKeyDataView* output) {
  auto pointer = data_->session_key.Get();
  *output = DeviceBoundSessionKeyDataView(pointer, message_);
}
inline void DeviceBoundSessionAccessDataView::GetCookiesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cookies.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void DeviceBoundSessionScopeSpecificationDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DeviceBoundSessionScopeSpecificationDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DeviceBoundSessionScopeDataView::GetSpecificationsDataView(
    mojo::ArrayDataView<DeviceBoundSessionScopeSpecificationDataView>* output) {
  auto pointer = data_->specifications.Get();
  *output = mojo::ArrayDataView<DeviceBoundSessionScopeSpecificationDataView>(pointer, message_);
}
inline void DeviceBoundSessionScopeDataView::GetOriginDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->origin.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DeviceBoundSessionCredentialDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DeviceBoundSessionCredentialDataView::GetAttributesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->attributes.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DeviceBoundSessionParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DeviceBoundSessionParamsDataView::GetFetcherUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->fetcher_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DeviceBoundSessionParamsDataView::GetRefreshUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->refresh_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DeviceBoundSessionParamsDataView::GetScopeDataView(
    DeviceBoundSessionScopeDataView* output) {
  auto pointer = data_->scope.Get();
  *output = DeviceBoundSessionScopeDataView(pointer, message_);
}
inline void DeviceBoundSessionParamsDataView::GetCredentialsDataView(
    mojo::ArrayDataView<DeviceBoundSessionCredentialDataView>* output) {
  auto pointer = data_->credentials.Get();
  *output = mojo::ArrayDataView<DeviceBoundSessionCredentialDataView>(pointer, message_);
}
inline void DeviceBoundSessionParamsDataView::GetAllowedRefreshInitiatorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->allowed_refresh_initiators.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionAccessType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionAccessType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionDeletionReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionDeletionReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionScopeSpecificationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionScopeSpecificationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionError value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_