// services/network/public/mojom/device_bound_sessions.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* DeviceBoundSessionAccessTypeToStringHelper(DeviceBoundSessionAccessType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionAccessType::kCreation:
      return "kCreation";
    case DeviceBoundSessionAccessType::kUpdate:
      return "kUpdate";
    case DeviceBoundSessionAccessType::kTermination:
      return "kTermination";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionAccessTypeToString(DeviceBoundSessionAccessType value) {
  const char *str = DeviceBoundSessionAccessTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionAccessType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionAccessType value) {
  return os << DeviceBoundSessionAccessTypeToString(value);
}

NOINLINE static const char* DeviceBoundSessionUsageToStringHelper(DeviceBoundSessionUsage value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionUsage::kUnknown:
      return "kUnknown";
    case DeviceBoundSessionUsage::kNoUsage:
      return "kNoUsage";
    case DeviceBoundSessionUsage::kInScopeNotDeferred:
      return "kInScopeNotDeferred";
    case DeviceBoundSessionUsage::kDeferred:
      return "kDeferred";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionUsageToString(DeviceBoundSessionUsage value) {
  const char *str = DeviceBoundSessionUsageToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionUsage value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionUsage value) {
  return os << DeviceBoundSessionUsageToString(value);
}

NOINLINE static const char* DeviceBoundSessionDeletionReasonToStringHelper(DeviceBoundSessionDeletionReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionDeletionReason::kExpired:
      return "kExpired";
    case DeviceBoundSessionDeletionReason::kFailedToRestoreKey:
      return "kFailedToRestoreKey";
    case DeviceBoundSessionDeletionReason::kFailedToUnwrapKey:
      return "kFailedToUnwrapKey";
    case DeviceBoundSessionDeletionReason::kStoragePartitionCleared:
      return "kStoragePartitionCleared";
    case DeviceBoundSessionDeletionReason::kClearBrowsingData:
      return "kClearBrowsingData";
    case DeviceBoundSessionDeletionReason::kServerRequested:
      return "kServerRequested";
    case DeviceBoundSessionDeletionReason::kInvalidSessionParams:
      return "kInvalidSessionParams";
    case DeviceBoundSessionDeletionReason::kRefreshFatalError:
      return "kRefreshFatalError";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionDeletionReasonToString(DeviceBoundSessionDeletionReason value) {
  const char *str = DeviceBoundSessionDeletionReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionDeletionReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionDeletionReason value) {
  return os << DeviceBoundSessionDeletionReasonToString(value);
}

NOINLINE static const char* DeviceBoundSessionScopeSpecificationTypeToStringHelper(DeviceBoundSessionScopeSpecificationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionScopeSpecificationType::kExclude:
      return "kExclude";
    case DeviceBoundSessionScopeSpecificationType::kInclude:
      return "kInclude";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionScopeSpecificationTypeToString(DeviceBoundSessionScopeSpecificationType value) {
  const char *str = DeviceBoundSessionScopeSpecificationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionScopeSpecificationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionScopeSpecificationType value) {
  return os << DeviceBoundSessionScopeSpecificationTypeToString(value);
}

NOINLINE static const char* DeviceBoundSessionErrorToStringHelper(DeviceBoundSessionError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionError::kSuccess:
      return "kSuccess";
    case DeviceBoundSessionError::kKeyError:
      return "kKeyError";
    case DeviceBoundSessionError::kSigningError:
      return "kSigningError";
    case DeviceBoundSessionError::kServerRequestedTermination:
      return "kServerRequestedTermination";
    case DeviceBoundSessionError::kInvalidSessionId:
      return "kInvalidSessionId";
    case DeviceBoundSessionError::kInvalidChallenge:
      return "kInvalidChallenge";
    case DeviceBoundSessionError::kTooManyChallenges:
      return "kTooManyChallenges";
    case DeviceBoundSessionError::kInvalidFetcherUrl:
      return "kInvalidFetcherUrl";
    case DeviceBoundSessionError::kInvalidRefreshUrl:
      return "kInvalidRefreshUrl";
    case DeviceBoundSessionError::kTransientHttpError:
      return "kTransientHttpError";
    case DeviceBoundSessionError::kScopeOriginSameSiteMismatch:
      return "kScopeOriginSameSiteMismatch";
    case DeviceBoundSessionError::kRefreshUrlSameSiteMismatch:
      return "kRefreshUrlSameSiteMismatch";
    case DeviceBoundSessionError::kMismatchedSessionId:
      return "kMismatchedSessionId";
    case DeviceBoundSessionError::kMissingScope:
      return "kMissingScope";
    case DeviceBoundSessionError::kNoCredentials:
      return "kNoCredentials";
    case DeviceBoundSessionError::kSubdomainRegistrationWellKnownUnavailable:
      return "kSubdomainRegistrationWellKnownUnavailable";
    case DeviceBoundSessionError::kSubdomainRegistrationUnauthorized:
      return "kSubdomainRegistrationUnauthorized";
    case DeviceBoundSessionError::kSubdomainRegistrationWellKnownMalformed:
      return "kSubdomainRegistrationWellKnownMalformed";
    case DeviceBoundSessionError::kSessionProviderWellKnownUnavailable:
      return "kSessionProviderWellKnownUnavailable";
    case DeviceBoundSessionError::kRelyingPartyWellKnownUnavailable:
      return "kRelyingPartyWellKnownUnavailable";
    case DeviceBoundSessionError::kFederatedKeyThumbprintMismatch:
      return "kFederatedKeyThumbprintMismatch";
    case DeviceBoundSessionError::kInvalidFederatedSessionUrl:
      return "kInvalidFederatedSessionUrl";
    case DeviceBoundSessionError::kInvalidFederatedKey:
      return "kInvalidFederatedKey";
    case DeviceBoundSessionError::kTooManyRelyingOriginLabels:
      return "kTooManyRelyingOriginLabels";
    case DeviceBoundSessionError::kBoundCookieSetForbidden:
      return "kBoundCookieSetForbidden";
    case DeviceBoundSessionError::kNetError:
      return "kNetError";
    case DeviceBoundSessionError::kProxyError:
      return "kProxyError";
    case DeviceBoundSessionError::kEmptySessionConfig:
      return "kEmptySessionConfig";
    case DeviceBoundSessionError::kInvalidCredentialsConfig:
      return "kInvalidCredentialsConfig";
    case DeviceBoundSessionError::kInvalidCredentialsType:
      return "kInvalidCredentialsType";
    case DeviceBoundSessionError::kInvalidCredentialsEmptyName:
      return "kInvalidCredentialsEmptyName";
    case DeviceBoundSessionError::kInvalidCredentialsCookie:
      return "kInvalidCredentialsCookie";
    case DeviceBoundSessionError::kPersistentHttpError:
      return "kPersistentHttpError";
    case DeviceBoundSessionError::kRegistrationAttemptedChallenge:
      return "kRegistrationAttemptedChallenge";
    case DeviceBoundSessionError::kInvalidScopeOrigin:
      return "kInvalidScopeOrigin";
    case DeviceBoundSessionError::kScopeOriginContainsPath:
      return "kScopeOriginContainsPath";
    case DeviceBoundSessionError::kRefreshInitiatorNotString:
      return "kRefreshInitiatorNotString";
    case DeviceBoundSessionError::kRefreshInitiatorInvalidHostPattern:
      return "kRefreshInitiatorInvalidHostPattern";
    case DeviceBoundSessionError::kInvalidScopeSpecification:
      return "kInvalidScopeSpecification";
    case DeviceBoundSessionError::kMissingScopeSpecificationType:
      return "kMissingScopeSpecificationType";
    case DeviceBoundSessionError::kEmptyScopeSpecificationDomain:
      return "kEmptyScopeSpecificationDomain";
    case DeviceBoundSessionError::kEmptyScopeSpecificationPath:
      return "kEmptyScopeSpecificationPath";
    case DeviceBoundSessionError::kInvalidScopeSpecificationType:
      return "kInvalidScopeSpecificationType";
    case DeviceBoundSessionError::kInvalidScopeIncludeSite:
      return "kInvalidScopeIncludeSite";
    case DeviceBoundSessionError::kMissingScopeIncludeSite:
      return "kMissingScopeIncludeSite";
    case DeviceBoundSessionError::kFederatedNotAuthorizedByProvider:
      return "kFederatedNotAuthorizedByProvider";
    case DeviceBoundSessionError::kFederatedNotAuthorizedByRelyingParty:
      return "kFederatedNotAuthorizedByRelyingParty";
    case DeviceBoundSessionError::kSessionProviderWellKnownMalformed:
      return "kSessionProviderWellKnownMalformed";
    case DeviceBoundSessionError::kSessionProviderWellKnownHasProviderOrigin:
      return "kSessionProviderWellKnownHasProviderOrigin";
    case DeviceBoundSessionError::kRelyingPartyWellKnownMalformed:
      return "kRelyingPartyWellKnownMalformed";
    case DeviceBoundSessionError::kRelyingPartyWellKnownHasRelyingOrigins:
      return "kRelyingPartyWellKnownHasRelyingOrigins";
    case DeviceBoundSessionError::kInvalidFederatedSessionProviderSessionMissing:
      return "kInvalidFederatedSessionProviderSessionMissing";
    case DeviceBoundSessionError::kInvalidFederatedSessionWrongProviderOrigin:
      return "kInvalidFederatedSessionWrongProviderOrigin";
    case DeviceBoundSessionError::kInvalidCredentialsCookieCreationTime:
      return "kInvalidCredentialsCookieCreationTime";
    case DeviceBoundSessionError::kInvalidCredentialsCookieName:
      return "kInvalidCredentialsCookieName";
    case DeviceBoundSessionError::kInvalidCredentialsCookieParsing:
      return "kInvalidCredentialsCookieParsing";
    case DeviceBoundSessionError::kInvalidCredentialsCookieUnpermittedAttribute:
      return "kInvalidCredentialsCookieUnpermittedAttribute";
    case DeviceBoundSessionError::kInvalidCredentialsCookieInvalidDomain:
      return "kInvalidCredentialsCookieInvalidDomain";
    case DeviceBoundSessionError::kInvalidCredentialsCookiePrefix:
      return "kInvalidCredentialsCookiePrefix";
    case DeviceBoundSessionError::kInvalidScopeRulePath:
      return "kInvalidScopeRulePath";
    case DeviceBoundSessionError::kInvalidScopeRuleHostPattern:
      return "kInvalidScopeRuleHostPattern";
    case DeviceBoundSessionError::kScopeRuleOriginScopedHostPatternMismatch:
      return "kScopeRuleOriginScopedHostPatternMismatch";
    case DeviceBoundSessionError::kScopeRuleSiteScopedHostPatternMismatch:
      return "kScopeRuleSiteScopedHostPatternMismatch";
    case DeviceBoundSessionError::kSigningQuotaExceeded:
      return "kSigningQuotaExceeded";
    case DeviceBoundSessionError::kInvalidConfigJson:
      return "kInvalidConfigJson";
    case DeviceBoundSessionError::kInvalidFederatedSessionProviderFailedToRestoreKey:
      return "kInvalidFederatedSessionProviderFailedToRestoreKey";
    case DeviceBoundSessionError::kFailedToUnwrapKey:
      return "kFailedToUnwrapKey";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionErrorToString(DeviceBoundSessionError value) {
  const char *str = DeviceBoundSessionErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionError value) {
  return os << DeviceBoundSessionErrorToString(value);
}

namespace internal {


// static
bool DeviceBoundSessionKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionKey_Data* object =
      static_cast<const DeviceBoundSessionKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionKey_Data::DeviceBoundSessionKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionAccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionAccess_Data* object =
      static_cast<const DeviceBoundSessionAccess_Data*>(data);


  if (!::network::mojom::internal::DeviceBoundSessionAccessType_Data
        ::Validate(object->access_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionAccess_Data::DeviceBoundSessionAccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionScopeSpecification_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionScopeSpecification_Data* object =
      static_cast<const DeviceBoundSessionScopeSpecification_Data*>(data);


  if (!::network::mojom::internal::DeviceBoundSessionScopeSpecificationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domain_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionScopeSpecification_Data::DeviceBoundSessionScopeSpecification_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionScope_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionScope_Data* object =
      static_cast<const DeviceBoundSessionScope_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->specifications, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& specifications_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->specifications, validation_context,
                                         &specifications_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origin_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->origin, validation_context,
                                         &origin_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionScope_Data::DeviceBoundSessionScope_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionCredential_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionCredential_Data* object =
      static_cast<const DeviceBoundSessionCredential_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributes, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attributes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attributes, validation_context,
                                         &attributes_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionCredential_Data::DeviceBoundSessionCredential_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionParams_Data* object =
      static_cast<const DeviceBoundSessionParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fetcher_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fetcher_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->refresh_url, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& refresh_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->refresh_url, validation_context,
                                         &refresh_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scope, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credentials, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credentials, validation_context,
                                         &credentials_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allowed_refresh_initiators, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& allowed_refresh_initiators_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->allowed_refresh_initiators, validation_context,
                                         &allowed_refresh_initiators_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionParams_Data::DeviceBoundSessionParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_GetAllSessions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_GetAllSessions_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_GetAllSessions_Params_Data*>(data);

  return true;
}

DeviceBoundSessionManager_GetAllSessions_Params_Data::DeviceBoundSessionManager_GetAllSessions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data* object =
      static_cast<const DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sessions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sessions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sessions, validation_context,
                                         &sessions_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data::DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_DeleteSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_DeleteSession_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_DeleteSession_Params_Data*>(data);


  if (!::network::mojom::internal::DeviceBoundSessionDeletionReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session, validation_context))
    return false;

  return true;
}

DeviceBoundSessionManager_DeleteSession_Params_Data::DeviceBoundSessionManager_DeleteSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_DeleteAllSessions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_DeleteAllSessions_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_DeleteAllSessions_Params_Data*>(data);


  if (!::network::mojom::internal::DeviceBoundSessionDeletionReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->created_after_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->created_before_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

DeviceBoundSessionManager_DeleteAllSessions_Params_Data::DeviceBoundSessionManager_DeleteAllSessions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data* object =
      static_cast<const DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data*>(data);

  return true;
}

DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data::DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_AddObserver_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceBoundSessionManager_AddObserver_Params_Data::DeviceBoundSessionManager_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_CreateBoundSessions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_CreateBoundSessions_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_CreateBoundSessions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->params, validation_context,
                                         &params_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->wrapped_key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& wrapped_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->wrapped_key, validation_context,
                                         &wrapped_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies_to_set, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_to_set_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies_to_set, validation_context,
                                         &cookies_to_set_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_options, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie_options, validation_context))
    return false;

  return true;
}

DeviceBoundSessionManager_CreateBoundSessions_Params_Data::DeviceBoundSessionManager_CreateBoundSessions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_CreateBoundSessions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_CreateBoundSessions_ResponseParams_Data* object =
      static_cast<const DeviceBoundSessionManager_CreateBoundSessions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_results, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_results_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::DeviceBoundSessionError_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->session_results, validation_context,
                                         &session_results_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_results, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookie_results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookie_results, validation_context,
                                         &cookie_results_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionManager_CreateBoundSessions_ResponseParams_Data::DeviceBoundSessionManager_CreateBoundSessions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data* object =
      static_cast<const DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->access, validation_context))
    return false;

  return true;
}

DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data::DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionAccessObserver_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionAccessObserver_Clone_Params_Data* object =
      static_cast<const DeviceBoundSessionAccessObserver_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceBoundSessionAccessObserver_Clone_Params_Data::DeviceBoundSessionAccessObserver_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionAccessType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionAccessType value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionAccessTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionUsage>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionUsage value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionUsageToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionDeletionReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionDeletionReason value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionDeletionReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionScopeSpecificationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionScopeSpecificationType value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionScopeSpecificationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionError>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionError value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionErrorToString(value));
}

} // namespace perfetto