// services/network/public/mojom/device_bound_sessions.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/device_bound_sessions.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::DeviceBoundSessionAccessType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::DeviceBoundSessionUsage, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::DeviceBoundSessionDeletionReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::DeviceBoundSessionScopeSpecificationType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::DeviceBoundSessionError, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DeviceBoundSessionKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::site(input)) in_site = Traits::site(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->site)::BaseType> site_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView, send_validation>(
        in_site,
        site_fragment);

      fragment->site.Set(
          site_fragment.is_null() ? nullptr : site_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->site.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site in DeviceBoundSessionKey struct");

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in DeviceBoundSessionKey struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DeviceBoundSessionAccessDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionAccessDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionAccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::DeviceBoundSessionAccessType>(
        Traits::access_type(input),
        &fragment->access_type);

      decltype(Traits::session_key(input)) in_session_key = Traits::session_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_key)::BaseType> session_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::DeviceBoundSessionKeyDataView, send_validation>(
        in_session_key,
        session_key_fragment);

      fragment->session_key.Set(
          session_key_fragment.is_null() ? nullptr : session_key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_key in DeviceBoundSessionAccess struct");

      decltype(Traits::cookies(input)) in_cookies = Traits::cookies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookies)::BaseType>
          cookies_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_cookies,
        cookies_fragment,
        &cookies_validate_params);

      fragment->cookies.Set(
          cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookies in DeviceBoundSessionAccess struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DeviceBoundSessionScopeSpecificationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionScopeSpecificationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionScopeSpecification_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::DeviceBoundSessionScopeSpecificationType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::domain(input)) in_domain = Traits::domain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain)::BaseType> domain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_domain,
        domain_fragment);

      fragment->domain.Set(
          domain_fragment.is_null() ? nullptr : domain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain in DeviceBoundSessionScopeSpecification struct");

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in DeviceBoundSessionScopeSpecification struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DeviceBoundSessionScopeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionScopeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionScope_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->include_site = Traits::include_site(input);

      decltype(Traits::specifications(input)) in_specifications = Traits::specifications(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->specifications)::BaseType>
          specifications_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& specifications_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DeviceBoundSessionScopeSpecificationDataView>, send_validation>(
        in_specifications,
        specifications_fragment,
        &specifications_validate_params);

      fragment->specifications.Set(
          specifications_fragment.is_null() ? nullptr : specifications_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->specifications.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null specifications in DeviceBoundSessionScope struct");

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in DeviceBoundSessionScope struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DeviceBoundSessionCredentialDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionCredentialDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionCredential_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in DeviceBoundSessionCredential struct");

      decltype(Traits::attributes(input)) in_attributes = Traits::attributes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attributes)::BaseType> attributes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_attributes,
        attributes_fragment);

      fragment->attributes.Set(
          attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attributes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attributes in DeviceBoundSessionCredential struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::DeviceBoundSessionParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::session_id(input)) in_session_id = Traits::session_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_id)::BaseType> session_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_session_id,
        session_id_fragment);

      fragment->session_id.Set(
          session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_id in DeviceBoundSessionParams struct");

      decltype(Traits::fetcher_url(input)) in_fetcher_url = Traits::fetcher_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fetcher_url)::BaseType> fetcher_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_fetcher_url,
        fetcher_url_fragment);

      fragment->fetcher_url.Set(
          fetcher_url_fragment.is_null() ? nullptr : fetcher_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fetcher_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fetcher_url in DeviceBoundSessionParams struct");

      decltype(Traits::refresh_url(input)) in_refresh_url = Traits::refresh_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->refresh_url)::BaseType> refresh_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_refresh_url,
        refresh_url_fragment);

      fragment->refresh_url.Set(
          refresh_url_fragment.is_null() ? nullptr : refresh_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->refresh_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null refresh_url in DeviceBoundSessionParams struct");

      decltype(Traits::scope(input)) in_scope = Traits::scope(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scope)::BaseType> scope_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::DeviceBoundSessionScopeDataView, send_validation>(
        in_scope,
        scope_fragment);

      fragment->scope.Set(
          scope_fragment.is_null() ? nullptr : scope_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scope.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in DeviceBoundSessionParams struct");

      decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->credentials)::BaseType>
          credentials_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DeviceBoundSessionCredentialDataView>, send_validation>(
        in_credentials,
        credentials_fragment,
        &credentials_validate_params);

      fragment->credentials.Set(
          credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->credentials.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null credentials in DeviceBoundSessionParams struct");

      decltype(Traits::allowed_refresh_initiators(input)) in_allowed_refresh_initiators = Traits::allowed_refresh_initiators(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->allowed_refresh_initiators)::BaseType>
          allowed_refresh_initiators_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& allowed_refresh_initiators_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_allowed_refresh_initiators,
        allowed_refresh_initiators_fragment,
        &allowed_refresh_initiators_validate_params);

      fragment->allowed_refresh_initiators.Set(
          allowed_refresh_initiators_fragment.is_null() ? nullptr : allowed_refresh_initiators_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->allowed_refresh_initiators.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null allowed_refresh_initiators in DeviceBoundSessionParams struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SEND_VALIDATION_H_