// services/network/public/mojom/device_bound_sessions.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionAccessTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionAccessType = {
  
  kCreation: 0,
  kUpdate: 1,
  kTermination: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionUsageSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionUsage = {
  
  kUnknown: 0,
  kNoUsage: 1,
  kInScopeNotDeferred: 2,
  kDeferred: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionDeletionReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionDeletionReason = {
  
  kExpired: 0,
  kFailedToRestoreKey: 1,
  kFailedToUnwrapKey: 2,
  kStoragePartitionCleared: 3,
  kClearBrowsingData: 4,
  kServerRequested: 5,
  kInvalidSessionParams: 6,
  kRefreshFatalError: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionScopeSpecificationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionScopeSpecificationType = {
  
  kExclude: 0,
  kInclude: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionError = {
  
  kSuccess: 0,
  kKeyError: 1,
  kSigningError: 2,
  kServerRequestedTermination: 5,
  kInvalidSessionId: 7,
  kInvalidChallenge: 9,
  kTooManyChallenges: 10,
  kInvalidFetcherUrl: 11,
  kInvalidRefreshUrl: 12,
  kTransientHttpError: 13,
  kScopeOriginSameSiteMismatch: 15,
  kRefreshUrlSameSiteMismatch: 16,
  kMismatchedSessionId: 18,
  kMissingScope: 21,
  kNoCredentials: 22,
  kSubdomainRegistrationWellKnownUnavailable: 24,
  kSubdomainRegistrationUnauthorized: 25,
  kSubdomainRegistrationWellKnownMalformed: 26,
  kSessionProviderWellKnownUnavailable: 28,
  kRelyingPartyWellKnownUnavailable: 30,
  kFederatedKeyThumbprintMismatch: 32,
  kInvalidFederatedSessionUrl: 33,
  kInvalidFederatedKey: 35,
  kTooManyRelyingOriginLabels: 36,
  kBoundCookieSetForbidden: 37,
  kNetError: 38,
  kProxyError: 39,
  kEmptySessionConfig: 41,
  kInvalidCredentialsConfig: 42,
  kInvalidCredentialsType: 43,
  kInvalidCredentialsEmptyName: 44,
  kInvalidCredentialsCookie: 45,
  kPersistentHttpError: 46,
  kRegistrationAttemptedChallenge: 47,
  kInvalidScopeOrigin: 48,
  kScopeOriginContainsPath: 49,
  kRefreshInitiatorNotString: 50,
  kRefreshInitiatorInvalidHostPattern: 51,
  kInvalidScopeSpecification: 52,
  kMissingScopeSpecificationType: 53,
  kEmptyScopeSpecificationDomain: 54,
  kEmptyScopeSpecificationPath: 55,
  kInvalidScopeSpecificationType: 56,
  kInvalidScopeIncludeSite: 57,
  kMissingScopeIncludeSite: 58,
  kFederatedNotAuthorizedByProvider: 59,
  kFederatedNotAuthorizedByRelyingParty: 60,
  kSessionProviderWellKnownMalformed: 61,
  kSessionProviderWellKnownHasProviderOrigin: 62,
  kRelyingPartyWellKnownMalformed: 63,
  kRelyingPartyWellKnownHasRelyingOrigins: 64,
  kInvalidFederatedSessionProviderSessionMissing: 65,
  kInvalidFederatedSessionWrongProviderOrigin: 66,
  kInvalidCredentialsCookieCreationTime: 67,
  kInvalidCredentialsCookieName: 68,
  kInvalidCredentialsCookieParsing: 69,
  kInvalidCredentialsCookieUnpermittedAttribute: 70,
  kInvalidCredentialsCookieInvalidDomain: 71,
  kInvalidCredentialsCookiePrefix: 72,
  kInvalidScopeRulePath: 73,
  kInvalidScopeRuleHostPattern: 74,
  kScopeRuleOriginScopedHostPatternMismatch: 75,
  kScopeRuleSiteScopedHostPatternMismatch: 76,
  kSigningQuotaExceeded: 77,
  kInvalidConfigJson: 78,
  kInvalidFederatedSessionProviderFailedToRestoreKey: 79,
  kFailedToUnwrapKey: 80,
  MIN_VALUE: 0,
  MAX_VALUE: 80,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DeviceBoundSessionManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DeviceBoundSessionManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.DeviceBoundSessionManagerInterface }
 */
network.mojom.DeviceBoundSessionManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DeviceBoundSessionManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DeviceBoundSessionManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DeviceBoundSessionManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        sessions: !Array<!network.mojom.DeviceBoundSessionKey>,
   *  }>}
   */

  getAllSessions() {
    return this.proxy.sendMessage(
        0,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionDeletionReason } reason
   * @param { !network.mojom.DeviceBoundSessionKey } session
   */

  deleteSession(
      reason,
      session) {
    this.proxy.sendMessage(
        1,
        network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        [
          reason,
          session
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionDeletionReason } reason
   * @param { ?mojoBase.mojom.Time } createdAfterTime
   * @param { ?mojoBase.mojom.Time } createdBeforeTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  deleteAllSessions(
      reason,
      createdAfterTime,
      createdBeforeTime,
      filter) {
    return this.proxy.sendMessage(
        2,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        [
          reason,
          createdAfterTime,
          createdBeforeTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.DeviceBoundSessionAccessObserverRemote } observer
   */

  addObserver(
      url,
      observer) {
    this.proxy.sendMessage(
        3,
        network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        [
          url,
          observer
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.DeviceBoundSessionParams> } params
   * @param { !Array<!number> } wrappedKey
   * @param { !Array<!network.mojom.CanonicalCookie> } cookiesToSet
   * @param { !network.mojom.CookieOptions } cookieOptions
   * @return {!Promise<{
        sessionResults: !Array<!network.mojom.DeviceBoundSessionError>,
        cookieResults: !Array<!network.mojom.CookieInclusionStatus>,
   *  }>}
   */

  createBoundSessions(
      params,
      wrappedKey,
      cookiesToSet,
      cookieOptions) {
    return this.proxy.sendMessage(
        4,
        network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ResponseParamsSpec.$,
        [
          params,
          wrappedKey,
          cookiesToSet,
          cookieOptions
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DeviceBoundSessionManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DeviceBoundSessionManagerReceiver = class {
  /**
   * @param {!network.mojom.DeviceBoundSessionManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DeviceBoundSessionManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DeviceBoundSessionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        impl.getAllSessions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        impl.deleteSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        impl.deleteAllSessions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ResponseParamsSpec.$,
        impl.createBoundSessions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DeviceBoundSessionManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DeviceBoundSessionManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DeviceBoundSessionManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DeviceBoundSessionManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DeviceBoundSessionManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DeviceBoundSessionManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DeviceBoundSessionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        this.getAllSessions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        this.deleteSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        this.deleteAllSessions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createBoundSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ResponseParamsSpec.$,
        this.createBoundSessions.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DeviceBoundSessionAccessObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.DeviceBoundSessionAccessObserverInterface }
 */
network.mojom.DeviceBoundSessionAccessObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DeviceBoundSessionAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DeviceBoundSessionAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DeviceBoundSessionAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionAccess } access
   */

  onDeviceBoundSessionAccessed(
      access) {
    this.proxy.sendMessage(
        0,
        network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        [
          access
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionAccessObserverPendingReceiver } observer
   */

  clone(
      observer) {
    this.proxy.sendMessage(
        1,
        network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DeviceBoundSessionAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserverReceiver = class {
  /**
   * @param {!network.mojom.DeviceBoundSessionAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DeviceBoundSessionAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DeviceBoundSessionAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        impl.onDeviceBoundSessionAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DeviceBoundSessionAccessObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DeviceBoundSessionAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DeviceBoundSessionAccessObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DeviceBoundSessionAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DeviceBoundSessionAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DeviceBoundSessionAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceBoundSessionAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        this.onDeviceBoundSessionAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionAccessSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionScopeSpecificationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionScopeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionCredentialSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.DeviceBoundSessionKeySpec.$,
    'DeviceBoundSessionKey',
    [
      mojo.internal.StructField(
        'site', 0,
        0,
        network.mojom.SchemefulSiteSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DeviceBoundSessionKey = class {
  constructor() {
    /** @export { !network.mojom.SchemefulSite } */
    this.site;
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionAccessSpec.$,
    'DeviceBoundSessionAccess',
    [
      mojo.internal.StructField(
        'accessType', 0,
        0,
        network.mojom.DeviceBoundSessionAccessTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionKey', 8,
        0,
        network.mojom.DeviceBoundSessionKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookies', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.DeviceBoundSessionAccess = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionAccessType } */
    this.accessType;
    /** @export { !network.mojom.DeviceBoundSessionKey } */
    this.sessionKey;
    /** @export { !Array<!string> } */
    this.cookies;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionScopeSpecificationSpec.$,
    'DeviceBoundSessionScopeSpecification',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.DeviceBoundSessionScopeSpecificationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domain', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.DeviceBoundSessionScopeSpecification = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionScopeSpecificationType } */
    this.type;
    /** @export { !string } */
    this.domain;
    /** @export { !string } */
    this.path;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionScopeSpec.$,
    'DeviceBoundSessionScope',
    [
      mojo.internal.StructField(
        'includeSite', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'specifications', 8,
        0,
        mojo.internal.Array(network.mojom.DeviceBoundSessionScopeSpecificationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.DeviceBoundSessionScope = class {
  constructor() {
    /** @export { !boolean } */
    this.includeSite;
    /** @export { !Array<!network.mojom.DeviceBoundSessionScopeSpecification> } */
    this.specifications;
    /** @export { !string } */
    this.origin;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionCredentialSpec.$,
    'DeviceBoundSessionCredential',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attributes', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DeviceBoundSessionCredential = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.attributes;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionParamsSpec.$,
    'DeviceBoundSessionParams',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetcherUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'refreshUrl', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scope', 24,
        0,
        network.mojom.DeviceBoundSessionScopeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credentials', 32,
        0,
        mojo.internal.Array(network.mojom.DeviceBoundSessionCredentialSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowedRefreshInitiators', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.DeviceBoundSessionParams = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
    /** @export { !url.mojom.Url } */
    this.fetcherUrl;
    /** @export { !string } */
    this.refreshUrl;
    /** @export { !network.mojom.DeviceBoundSessionScope } */
    this.scope;
    /** @export { !Array<!network.mojom.DeviceBoundSessionCredential> } */
    this.credentials;
    /** @export { !Array<!string> } */
    this.allowedRefreshInitiators;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
    'DeviceBoundSessionManager_GetAllSessions_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.DeviceBoundSessionManager_GetAllSessions_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
    'DeviceBoundSessionManager_GetAllSessions_ResponseParams',
    [
      mojo.internal.StructField(
        'sessions', 0,
        0,
        mojo.internal.Array(network.mojom.DeviceBoundSessionKeySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.DeviceBoundSessionKey> } */
    this.sessions;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
    'DeviceBoundSessionManager_DeleteSession_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        network.mojom.DeviceBoundSessionDeletionReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'session', 8,
        0,
        network.mojom.DeviceBoundSessionKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DeviceBoundSessionManager_DeleteSession_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionDeletionReason } */
    this.reason;
    /** @export { !network.mojom.DeviceBoundSessionKey } */
    this.session;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
    'DeviceBoundSessionManager_DeleteAllSessions_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        network.mojom.DeviceBoundSessionDeletionReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'createdAfterTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'createdBeforeTime', 16,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionDeletionReason } */
    this.reason;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.createdAfterTime;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.createdBeforeTime;
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
    'DeviceBoundSessionManager_DeleteAllSessions_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
    'DeviceBoundSessionManager_AddObserver_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(network.mojom.DeviceBoundSessionAccessObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DeviceBoundSessionManager_AddObserver_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.DeviceBoundSessionAccessObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ParamsSpec.$,
    'DeviceBoundSessionManager_CreateBoundSessions_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        mojo.internal.Array(network.mojom.DeviceBoundSessionParamsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wrappedKey', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookiesToSet', 16,
        0,
        mojo.internal.Array(network.mojom.CanonicalCookieSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieOptions', 24,
        0,
        network.mojom.CookieOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.DeviceBoundSessionManager_CreateBoundSessions_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.DeviceBoundSessionParams> } */
    this.params;
    /** @export { !Array<!number> } */
    this.wrappedKey;
    /** @export { !Array<!network.mojom.CanonicalCookie> } */
    this.cookiesToSet;
    /** @export { !network.mojom.CookieOptions } */
    this.cookieOptions;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ResponseParamsSpec.$,
    'DeviceBoundSessionManager_CreateBoundSessions_ResponseParams',
    [
      mojo.internal.StructField(
        'sessionResults', 0,
        0,
        mojo.internal.Array(network.mojom.DeviceBoundSessionErrorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieResults', 8,
        0,
        mojo.internal.Array(network.mojom.CookieInclusionStatusSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DeviceBoundSessionManager_CreateBoundSessions_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.DeviceBoundSessionError> } */
    this.sessionResults;
    /** @export { !Array<!network.mojom.CookieInclusionStatus> } */
    this.cookieResults;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
    'DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params',
    [
      mojo.internal.StructField(
        'access', 0,
        0,
        network.mojom.DeviceBoundSessionAccessSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionAccess } */
    this.access;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
    'DeviceBoundSessionAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DeviceBoundSessionAccessObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DeviceBoundSessionAccessObserver_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionAccessObserverPendingReceiver } */
    this.observer;
  }
};

