// services/network/public/mojom/device_bound_sessions.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class DeviceBoundSessionKeyDataView;

class DeviceBoundSessionAccessDataView;

class DeviceBoundSessionScopeSpecificationDataView;

class DeviceBoundSessionScopeDataView;

class DeviceBoundSessionCredentialDataView;

class DeviceBoundSessionParamsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionKeyDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionAccessDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionAccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionScopeSpecificationDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionScopeSpecification_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionScopeDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionScope_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionCredentialDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionCredential_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionParamsDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class DeviceBoundSessionAccessType : int32_t {
  
  kCreation = 0,
  
  kUpdate = 1,
  
  kTermination = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionAccessType value);
inline bool IsKnownEnumValue(DeviceBoundSessionAccessType value) {
  return internal::DeviceBoundSessionAccessType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceBoundSessionUsage : int32_t {
  
  kUnknown = 0,
  
  kNoUsage = 1,
  
  kInScopeNotDeferred = 2,
  
  kDeferred = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionUsage value);
inline bool IsKnownEnumValue(DeviceBoundSessionUsage value) {
  return internal::DeviceBoundSessionUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceBoundSessionDeletionReason : int32_t {
  
  kExpired = 0,
  
  kFailedToRestoreKey = 1,
  
  kFailedToUnwrapKey = 2,
  
  kStoragePartitionCleared = 3,
  
  kClearBrowsingData = 4,
  
  kServerRequested = 5,
  
  kInvalidSessionParams = 6,
  
  kRefreshFatalError = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionDeletionReason value);
inline bool IsKnownEnumValue(DeviceBoundSessionDeletionReason value) {
  return internal::DeviceBoundSessionDeletionReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceBoundSessionScopeSpecificationType : int32_t {
  
  kExclude = 0,
  
  kInclude = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionScopeSpecificationType value);
inline bool IsKnownEnumValue(DeviceBoundSessionScopeSpecificationType value) {
  return internal::DeviceBoundSessionScopeSpecificationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceBoundSessionError : int32_t {
  
  kSuccess = 0,
  
  kKeyError = 1,
  
  kSigningError = 2,
  
  kServerRequestedTermination = 5,
  
  kInvalidSessionId = 7,
  
  kInvalidChallenge = 9,
  
  kTooManyChallenges = 10,
  
  kInvalidFetcherUrl = 11,
  
  kInvalidRefreshUrl = 12,
  
  kTransientHttpError = 13,
  
  kScopeOriginSameSiteMismatch = 15,
  
  kRefreshUrlSameSiteMismatch = 16,
  
  kMismatchedSessionId = 18,
  
  kMissingScope = 21,
  
  kNoCredentials = 22,
  
  kSubdomainRegistrationWellKnownUnavailable = 24,
  
  kSubdomainRegistrationUnauthorized = 25,
  
  kSubdomainRegistrationWellKnownMalformed = 26,
  
  kSessionProviderWellKnownUnavailable = 28,
  
  kRelyingPartyWellKnownUnavailable = 30,
  
  kFederatedKeyThumbprintMismatch = 32,
  
  kInvalidFederatedSessionUrl = 33,
  
  kInvalidFederatedKey = 35,
  
  kTooManyRelyingOriginLabels = 36,
  
  kBoundCookieSetForbidden = 37,
  
  kNetError = 38,
  
  kProxyError = 39,
  
  kEmptySessionConfig = 41,
  
  kInvalidCredentialsConfig = 42,
  
  kInvalidCredentialsType = 43,
  
  kInvalidCredentialsEmptyName = 44,
  
  kInvalidCredentialsCookie = 45,
  
  kPersistentHttpError = 46,
  
  kRegistrationAttemptedChallenge = 47,
  
  kInvalidScopeOrigin = 48,
  
  kScopeOriginContainsPath = 49,
  
  kRefreshInitiatorNotString = 50,
  
  kRefreshInitiatorInvalidHostPattern = 51,
  
  kInvalidScopeSpecification = 52,
  
  kMissingScopeSpecificationType = 53,
  
  kEmptyScopeSpecificationDomain = 54,
  
  kEmptyScopeSpecificationPath = 55,
  
  kInvalidScopeSpecificationType = 56,
  
  kInvalidScopeIncludeSite = 57,
  
  kMissingScopeIncludeSite = 58,
  
  kFederatedNotAuthorizedByProvider = 59,
  
  kFederatedNotAuthorizedByRelyingParty = 60,
  
  kSessionProviderWellKnownMalformed = 61,
  
  kSessionProviderWellKnownHasProviderOrigin = 62,
  
  kRelyingPartyWellKnownMalformed = 63,
  
  kRelyingPartyWellKnownHasRelyingOrigins = 64,
  
  kInvalidFederatedSessionProviderSessionMissing = 65,
  
  kInvalidFederatedSessionWrongProviderOrigin = 66,
  
  kInvalidCredentialsCookieCreationTime = 67,
  
  kInvalidCredentialsCookieName = 68,
  
  kInvalidCredentialsCookieParsing = 69,
  
  kInvalidCredentialsCookieUnpermittedAttribute = 70,
  
  kInvalidCredentialsCookieInvalidDomain = 71,
  
  kInvalidCredentialsCookiePrefix = 72,
  
  kInvalidScopeRulePath = 73,
  
  kInvalidScopeRuleHostPattern = 74,
  
  kScopeRuleOriginScopedHostPatternMismatch = 75,
  
  kScopeRuleSiteScopedHostPatternMismatch = 76,
  
  kSigningQuotaExceeded = 77,
  
  kInvalidConfigJson = 78,
  
  kInvalidFederatedSessionProviderFailedToRestoreKey = 79,
  
  kFailedToUnwrapKey = 80,
  kMinValue = 0,
  kMaxValue = 80,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionError value);
inline bool IsKnownEnumValue(DeviceBoundSessionError value) {
  return internal::DeviceBoundSessionError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DeviceBoundSessionManagerInterfaceBase {};

using DeviceBoundSessionManagerPtrDataView =
    mojo::InterfacePtrDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerRequestDataView =
    mojo::InterfaceRequestDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceBoundSessionManagerInterfaceBase>;
class DeviceBoundSessionAccessObserverInterfaceBase {};

using DeviceBoundSessionAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceBoundSessionAccessObserverInterfaceBase>;


class DeviceBoundSessionKeyDataView {
 public:
  DeviceBoundSessionKeyDataView() = default;

  DeviceBoundSessionKeyDataView(
      internal::DeviceBoundSessionKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceBoundSessionAccessDataView {
 public:
  DeviceBoundSessionAccessDataView() = default;

  DeviceBoundSessionAccessDataView(
      internal::DeviceBoundSessionAccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAccessType(UserType* output) const {
    auto data_value = data_->access_type;
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionAccessType>(
        data_value, output);
  }
  DeviceBoundSessionAccessType access_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DeviceBoundSessionAccessType>(data_->access_type));
  }
  inline void GetSessionKeyDataView(
      DeviceBoundSessionKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionKey(UserType* output) {
    
    auto* pointer = data_->session_key.Get();
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionKeyDataView>(
        pointer, output, message_);
  }
  inline void GetCookiesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionAccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceBoundSessionScopeSpecificationDataView {
 public:
  DeviceBoundSessionScopeSpecificationDataView() = default;

  DeviceBoundSessionScopeSpecificationDataView(
      internal::DeviceBoundSessionScopeSpecification_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionScopeSpecificationType>(
        data_value, output);
  }
  DeviceBoundSessionScopeSpecificationType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DeviceBoundSessionScopeSpecificationType>(data_->type));
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionScopeSpecification_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceBoundSessionScopeDataView {
 public:
  DeviceBoundSessionScopeDataView() = default;

  DeviceBoundSessionScopeDataView(
      internal::DeviceBoundSessionScope_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool include_site() const {
    return data_->include_site;
  }
  inline void GetSpecificationsDataView(
      mojo::ArrayDataView<DeviceBoundSessionScopeSpecificationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpecifications(UserType* output) {
    
    auto* pointer = data_->specifications.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::DeviceBoundSessionScopeSpecificationDataView>>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionScope_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceBoundSessionCredentialDataView {
 public:
  DeviceBoundSessionCredentialDataView() = default;

  DeviceBoundSessionCredentialDataView(
      internal::DeviceBoundSessionCredential_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAttributesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributes(UserType* output) {
    
    auto* pointer = data_->attributes.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionCredential_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceBoundSessionParamsDataView {
 public:
  DeviceBoundSessionParamsDataView() = default;

  DeviceBoundSessionParamsDataView(
      internal::DeviceBoundSessionParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFetcherUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetcherUrl(UserType* output) {
    
    auto* pointer = data_->fetcher_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRefreshUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRefreshUrl(UserType* output) {
    
    auto* pointer = data_->refresh_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetScopeDataView(
      DeviceBoundSessionScopeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionScopeDataView>(
        pointer, output, message_);
  }
  inline void GetCredentialsDataView(
      mojo::ArrayDataView<DeviceBoundSessionCredentialDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentials(UserType* output) {
    
    auto* pointer = data_->credentials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::DeviceBoundSessionCredentialDataView>>(
        pointer, output, message_);
  }
  inline void GetAllowedRefreshInitiatorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedRefreshInitiators(UserType* output) {
    
    auto* pointer = data_->allowed_refresh_initiators.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_DATA_VIEW_H_