// services/network/public/mojom/data_pipe_getter.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DataPipeGetterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DataPipeGetter', scope);
  }
}

/** @interface */
export class DataPipeGetterInterface {
  
  /**
   * @param { !MojoHandle } pipe
   * @return {!Promise<{
        status: !number,
        size: !bigint,
   *  }>}
   */

  read(pipe) {}
  
  /**
   * @param { !DataPipeGetterPendingReceiver } receiver
   */

  clone(receiver) {}
}

/**
 * @implements { DataPipeGetterInterface }
 */
export class DataPipeGetterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DataPipeGetterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DataPipeGetterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DataPipeGetterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MojoHandle } pipe
   * @return {!Promise<{
        status: !number,
        size: !bigint,
   *  }>}
   */

  read(
      pipe) {
    return this.proxy.sendMessage(
        0,
        DataPipeGetter_Read_ParamsSpec.$,
        DataPipeGetter_Read_ResponseParamsSpec.$,
        [
          pipe
        ],
        false);
  }

  
  /**
   * @param { !DataPipeGetterPendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        1,
        DataPipeGetter_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DataPipeGetter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DataPipeGetterReceiver {
  /**
   * @param {!DataPipeGetterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DataPipeGetterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DataPipeGetterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DataPipeGetterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DataPipeGetter_Read_ParamsSpec.$,
        DataPipeGetter_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DataPipeGetter_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DataPipeGetter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DataPipeGetter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DataPipeGetterRemote}
   */
  static getRemote() {
    let remote = new DataPipeGetterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DataPipeGetter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DataPipeGetterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DataPipeGetterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DataPipeGetterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DataPipeGetter_Read_ParamsSpec.$,
        DataPipeGetter_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DataPipeGetter_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataPipeGetter_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataPipeGetter_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataPipeGetter_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DataPipeGetter_Read_ParamsSpec.$,
    'DataPipeGetter_Read_Params',
    [
      mojo.internal.StructField(
        'pipe', 0,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DataPipeGetter_Read_Params {
  constructor() {
    /** @type { !MojoHandle } */
    this.pipe;
  }
}



mojo.internal.Struct(
    DataPipeGetter_Read_ResponseParamsSpec.$,
    'DataPipeGetter_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DataPipeGetter_Read_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.status;
    /** @type { !bigint } */
    this.size;
  }
}



mojo.internal.Struct(
    DataPipeGetter_Clone_ParamsSpec.$,
    'DataPipeGetter_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(DataPipeGetterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DataPipeGetter_Clone_Params {
  constructor() {
    /** @type { !DataPipeGetterPendingReceiver } */
    this.receiver;
  }
}

