// services/network/public/mojom/ct_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/ct_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');



  function CTPolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CTPolicy.prototype.initDefaults_ = function() {
    this.excludedHosts = null;
    this.excludedSpkis = null;
  };
  CTPolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CTPolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTPolicy.excludedHosts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTPolicy.excludedSpkis
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CTPolicy.encodedSize = codec.kStructHeaderSize + 16;

  CTPolicy.decode = function(decoder) {
    var packed;
    var val = new CTPolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.excludedHosts =
        decoder.decodeArrayPointer(codec.String);
    val.excludedSpkis =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  CTPolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CTPolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.excludedHosts);
    encoder.encodeArrayPointer(codec.String, val.excludedSpkis);
  };
  exports.CTPolicy = CTPolicy;
})();