// services/network/public/mojom/ct_policy.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CT_POLICY_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CT_POLICY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ct_policy.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/ct_policy.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/ct_policy.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace network::mojom {








class  CTPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CTPolicy, T>::value>;
  using DataView = CTPolicyDataView;
  using Data_ = internal::CTPolicy_Data;

  template <typename... Args>
  static CTPolicyPtr New(Args&&... args) {
    return CTPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CTPolicyPtr From(const U& u) {
    return mojo::TypeConverter<CTPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CTPolicy>::Convert(*this);
  }


  CTPolicy();

  CTPolicy(
      std::vector<std::string> excluded_hosts,
      std::vector<std::string> excluded_spkis);


  ~CTPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CTPolicyPtr>
  CTPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CTPolicy::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CTPolicy::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CTPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CTPolicy_UnserializedMessageContext<
            UserType, CTPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CTPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CTPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CTPolicy_UnserializedMessageContext<
            UserType, CTPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CTPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> excluded_hosts;
  
  std::vector<std::string> excluded_spkis;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CTPolicyPtr CTPolicy::Clone() const {
  return New(
      mojo::Clone(excluded_hosts),
      mojo::Clone(excluded_spkis)
  );
}

template <typename T, CTPolicy::EnableIfSame<T>*>
bool CTPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->excluded_hosts, other_struct.excluded_hosts))
    return false;
  if (!mojo::Equals(this->excluded_spkis, other_struct.excluded_spkis))
    return false;
  return true;
}

template <typename T, CTPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.excluded_hosts < rhs.excluded_hosts)
    return true;
  if (rhs.excluded_hosts < lhs.excluded_hosts)
    return false;
  if (lhs.excluded_spkis < rhs.excluded_spkis)
    return true;
  if (rhs.excluded_spkis < lhs.excluded_spkis)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CTPolicy::DataView,
                                         ::network::mojom::CTPolicyPtr> {
  static bool IsNull(const ::network::mojom::CTPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CTPolicyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CTPolicy::excluded_hosts)& excluded_hosts(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->excluded_hosts;
  }

  static const decltype(::network::mojom::CTPolicy::excluded_spkis)& excluded_spkis(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->excluded_spkis;
  }

  static bool Read(::network::mojom::CTPolicy::DataView input, ::network::mojom::CTPolicyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CT_POLICY_MOJOM_H_