// services/network/public/mojom/ct_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CT_POLICY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CT_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ct_policy.mojom-shared-internal.h"




#include "services/network/public/mojom/ct_policy.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CTPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CTPolicyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CTPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::excluded_hosts(input)) in_excluded_hosts = Traits::excluded_hosts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->excluded_hosts)::BaseType>
        excluded_hosts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& excluded_hosts_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_excluded_hosts,
      excluded_hosts_fragment,
      &excluded_hosts_validate_params);

    fragment->excluded_hosts.Set(
        excluded_hosts_fragment.is_null() ? nullptr : excluded_hosts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->excluded_hosts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null excluded_hosts in CTPolicy struct");

    decltype(Traits::excluded_spkis(input)) in_excluded_spkis = Traits::excluded_spkis(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->excluded_spkis)::BaseType>
        excluded_spkis_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& excluded_spkis_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_excluded_spkis,
      excluded_spkis_fragment,
      &excluded_spkis_validate_params);

    fragment->excluded_spkis.Set(
        excluded_spkis_fragment.is_null() ? nullptr : excluded_spkis_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->excluded_spkis.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null excluded_spkis in CTPolicy struct");
  }

  static bool Deserialize(::network::mojom::internal::CTPolicy_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CTPolicyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void CTPolicyDataView::GetExcludedHostsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excluded_hosts.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CTPolicyDataView::GetExcludedSpkisDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excluded_spkis.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CT_POLICY_MOJOM_SHARED_H_