// services/network/public/mojom/ct_log_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/ct_log_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace network::mojom {
class PreviousOperatorEntryDataView;

class CTLogInfoDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::PreviousOperatorEntryDataView> {
  using Data = ::network::mojom::internal::PreviousOperatorEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CTLogInfoDataView> {
  using Data = ::network::mojom::internal::CTLogInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CTLogInfo_LogType : int32_t {
  
  kUnspecified = 0,
  
  kRFC6962 = 1,
  
  kStaticCTAPI = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CTLogInfo_LogType value);
inline bool IsKnownEnumValue(CTLogInfo_LogType value) {
  return internal::CTLogInfo_LogType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PreviousOperatorEntryDataView {
 public:
  PreviousOperatorEntryDataView() = default;

  PreviousOperatorEntryDataView(
      internal::PreviousOperatorEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEndTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndTime(UserType* output) {
    
    auto* pointer = data_->end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::PreviousOperatorEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CTLogInfoDataView {
 public:
  CTLogInfoDataView() = default;

  CTLogInfoDataView(
      internal::CTLogInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetPublicKeyDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKey(UserType* output) {
    
    auto* pointer = data_->public_key.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisqualifiedAtDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisqualifiedAt(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `disqualified_at` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisqualifiedAt` instead "
    "of `ReadDisqualifiedAt if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->disqualified_at.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetMmdDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMmd(UserType* output) {
    
    auto* pointer = data_->mmd.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentOperatorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentOperator(UserType* output) {
    
    auto* pointer = data_->current_operator.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPreviousOperatorsDataView(
      mojo::ArrayDataView<PreviousOperatorEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousOperators(UserType* output) {
    
    auto* pointer = data_->previous_operators.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PreviousOperatorEntryDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLogType(UserType* output) const {
    auto data_value = data_->log_type;
    return mojo::internal::Deserialize<::network::mojom::CTLogInfo_LogType>(
        data_value, output);
  }
  CTLogInfo_LogType log_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CTLogInfo_LogType>(data_->log_type));
  }
 private:
  internal::CTLogInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_DATA_VIEW_H_