// services/network/public/mojom/cross_origin_opener_policy.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CoopAccessReportType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CrossOriginOpenerPolicyValue, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CrossOriginOpenerPolicyReporterParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CrossOriginOpenerPolicyReporterParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CrossOriginOpenerPolicyReporterParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::CoopAccessReportType>(
        Traits::report_type(input),
        &fragment->report_type);

      decltype(Traits::reporter(input)) in_reporter = Traits::reporter(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginOpenerPolicyReporterInterfaceBase>>(
        in_reporter,
        &fragment->reporter,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->reporter)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid reporter in CrossOriginOpenerPolicyReporterParams struct");

      fragment->endpoint_defined = Traits::endpoint_defined(input);

      decltype(Traits::reported_window_url(input)) in_reported_window_url = Traits::reported_window_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reported_window_url)::BaseType> reported_window_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_reported_window_url,
        reported_window_url_fragment);

      fragment->reported_window_url.Set(
          reported_window_url_fragment.is_null() ? nullptr : reported_window_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reported_window_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reported_window_url in CrossOriginOpenerPolicyReporterParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CrossOriginOpenerPolicyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CrossOriginOpenerPolicyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CrossOriginOpenerPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        Traits::value(input),
        &fragment->value);

      decltype(Traits::reporting_endpoint(input)) in_reporting_endpoint = Traits::reporting_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reporting_endpoint)::BaseType> reporting_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_reporting_endpoint,
        reporting_endpoint_fragment);

      fragment->reporting_endpoint.Set(
          reporting_endpoint_fragment.is_null() ? nullptr : reporting_endpoint_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        Traits::report_only_value(input),
        &fragment->report_only_value);

      decltype(Traits::report_only_reporting_endpoint(input)) in_report_only_reporting_endpoint = Traits::report_only_reporting_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_only_reporting_endpoint)::BaseType> report_only_reporting_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_report_only_reporting_endpoint,
        report_only_reporting_endpoint_fragment);

      fragment->report_only_reporting_endpoint.Set(
          report_only_reporting_endpoint_fragment.is_null() ? nullptr : report_only_reporting_endpoint_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        Traits::soap_by_default_value(input),
        &fragment->soap_by_default_value);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SEND_VALIDATION_H_