// services/network/public/mojom/cross_origin_opener_policy.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"


namespace network::mojom {
class CrossOriginOpenerPolicyReporterParamsDataView;

class CrossOriginOpenerPolicyDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CrossOriginOpenerPolicyReporterParamsDataView> {
  using Data = ::network::mojom::internal::CrossOriginOpenerPolicyReporterParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CrossOriginOpenerPolicyDataView> {
  using Data = ::network::mojom::internal::CrossOriginOpenerPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CoopAccessReportType : int32_t {
  
  kAccessFromCoopPageToOpener = 0,
  
  kAccessFromCoopPageToOpenee = 1,
  
  kAccessFromCoopPageToOther = 2,
  
  kAccessToCoopPageFromOpener = 3,
  
  kAccessToCoopPageFromOpenee = 4,
  
  kAccessToCoopPageFromOther = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, CoopAccessReportType value);
inline bool IsKnownEnumValue(CoopAccessReportType value) {
  return internal::CoopAccessReportType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CrossOriginOpenerPolicyValue : int32_t {
  
  kUnsafeNone = 0,
  
  kSameOriginAllowPopups = 1,
  
  kSameOrigin = 2,
  
  kSameOriginPlusCoep = 3,
  
  kNoopenerAllowPopups = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, CrossOriginOpenerPolicyValue value);
inline bool IsKnownEnumValue(CrossOriginOpenerPolicyValue value) {
  return internal::CrossOriginOpenerPolicyValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CrossOriginOpenerPolicyReporterInterfaceBase {};

using CrossOriginOpenerPolicyReporterPtrDataView =
    mojo::InterfacePtrDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;
using CrossOriginOpenerPolicyReporterRequestDataView =
    mojo::InterfaceRequestDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;
using CrossOriginOpenerPolicyReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;
using CrossOriginOpenerPolicyReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;


class CrossOriginOpenerPolicyReporterParamsDataView {
 public:
  CrossOriginOpenerPolicyReporterParamsDataView() = default;

  CrossOriginOpenerPolicyReporterParamsDataView(
      internal::CrossOriginOpenerPolicyReporterParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReportType(UserType* output) const {
    auto data_value = data_->report_type;
    return mojo::internal::Deserialize<::network::mojom::CoopAccessReportType>(
        data_value, output);
  }
  CoopAccessReportType report_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CoopAccessReportType>(data_->report_type));
  }
  template <typename UserType>
  UserType TakeReporter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginOpenerPolicyReporterInterfaceBase>>(
            &data_->reporter, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool endpoint_defined() const {
    return data_->endpoint_defined;
  }
  inline void GetReportedWindowUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportedWindowUrl(UserType* output) {
    
    auto* pointer = data_->reported_window_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CrossOriginOpenerPolicyReporterParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CrossOriginOpenerPolicyDataView {
 public:
  CrossOriginOpenerPolicyDataView() = default;

  CrossOriginOpenerPolicyDataView(
      internal::CrossOriginOpenerPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    auto data_value = data_->value;
    return mojo::internal::Deserialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        data_value, output);
  }
  CrossOriginOpenerPolicyValue value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(data_->value));
  }
  inline void GetReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingEndpoint` instead "
    "of `ReadReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReportOnlyValue(UserType* output) const {
    auto data_value = data_->report_only_value;
    return mojo::internal::Deserialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        data_value, output);
  }
  CrossOriginOpenerPolicyValue report_only_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(data_->report_only_value));
  }
  inline void GetReportOnlyReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportOnlyReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `report_only_reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportOnlyReportingEndpoint` instead "
    "of `ReadReportOnlyReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->report_only_reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSoapByDefaultValue(UserType* output) const {
    auto data_value = data_->soap_by_default_value;
    return mojo::internal::Deserialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        data_value, output);
  }
  CrossOriginOpenerPolicyValue soap_by_default_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(data_->soap_by_default_value));
  }
 private:
  internal::CrossOriginOpenerPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_DATA_VIEW_H_