// services/network/public/mojom/cors_origin_pattern.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"


namespace network::mojom {
class CorsOriginPatternDataView;

class CorsOriginAccessPatternsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CorsOriginPatternDataView> {
  using Data = ::network::mojom::internal::CorsOriginPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CorsOriginAccessPatternsDataView> {
  using Data = ::network::mojom::internal::CorsOriginAccessPatterns_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CorsPortMatchMode : int32_t {
  
  kAllowAnyPort = 0,
  
  kAllowOnlySpecifiedPort = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CorsPortMatchMode value);
inline bool IsKnownEnumValue(CorsPortMatchMode value) {
  return internal::CorsPortMatchMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CorsDomainMatchMode : int32_t {
  
  kAllowSubdomains = 0,
  
  kAllowRegistrableDomains = 1,
  
  kDisallowSubdomains = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CorsDomainMatchMode value);
inline bool IsKnownEnumValue(CorsDomainMatchMode value) {
  return internal::CorsDomainMatchMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CorsOriginAccessMatchPriority : int32_t {
  
  kNoMatchingOrigin = 0,
  
  kDefaultPriority = 1,
  
  kLowPriority = 2,
  
  kMediumPriority = 3,
  
  kHighPriority = 4,
  
  kMaxPriority = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, CorsOriginAccessMatchPriority value);
inline bool IsKnownEnumValue(CorsOriginAccessMatchPriority value) {
  return internal::CorsOriginAccessMatchPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CorsOriginPatternDataView {
 public:
  CorsOriginPatternDataView() = default;

  CorsOriginPatternDataView(
      internal::CorsOriginPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint16_t port() const {
    return data_->port;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDomainMatchMode(UserType* output) const {
    auto data_value = data_->domain_match_mode;
    return mojo::internal::Deserialize<::network::mojom::CorsDomainMatchMode>(
        data_value, output);
  }
  CorsDomainMatchMode domain_match_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CorsDomainMatchMode>(data_->domain_match_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPortMatchMode(UserType* output) const {
    auto data_value = data_->port_match_mode;
    return mojo::internal::Deserialize<::network::mojom::CorsPortMatchMode>(
        data_value, output);
  }
  CorsPortMatchMode port_match_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CorsPortMatchMode>(data_->port_match_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::CorsOriginAccessMatchPriority>(
        data_value, output);
  }
  CorsOriginAccessMatchPriority priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CorsOriginAccessMatchPriority>(data_->priority));
  }
 private:
  internal::CorsOriginPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CorsOriginAccessPatternsDataView {
 public:
  CorsOriginAccessPatternsDataView() = default;

  CorsOriginAccessPatternsDataView(
      internal::CorsOriginAccessPatterns_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourceOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceOrigin(UserType* output) {
    
    auto* pointer = data_->source_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetAllowPatternsDataView(
      mojo::ArrayDataView<CorsOriginPatternDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowPatterns(UserType* output) {
    
    auto* pointer = data_->allow_patterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
        pointer, output, message_);
  }
  inline void GetBlockPatternsDataView(
      mojo::ArrayDataView<CorsOriginPatternDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockPatterns(UserType* output) {
    
    auto* pointer = data_->block_patterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CorsOriginAccessPatterns_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_DATA_VIEW_H_