// services/network/public/mojom/cors_origin_pattern.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cors_origin_pattern.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {









class BLINK_PLATFORM_EXPORT CorsOriginPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CorsOriginPattern, T>::value>;
  using DataView = CorsOriginPatternDataView;
  using Data_ = internal::CorsOriginPattern_Data;

  template <typename... Args>
  static CorsOriginPatternPtr New(Args&&... args) {
    return CorsOriginPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CorsOriginPatternPtr From(const U& u) {
    return mojo::TypeConverter<CorsOriginPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CorsOriginPattern>::Convert(*this);
  }


  CorsOriginPattern();

  CorsOriginPattern(
      const ::blink::String& protocol,
      const ::blink::String& domain,
      uint16_t port,
      CorsDomainMatchMode domain_match_mode,
      CorsPortMatchMode port_match_mode,
      CorsOriginAccessMatchPriority priority);


  ~CorsOriginPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CorsOriginPatternPtr>
  CorsOriginPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CorsOriginPattern::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CorsOriginPattern::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CorsOriginPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CorsOriginPattern_UnserializedMessageContext<
            UserType, CorsOriginPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CorsOriginPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CorsOriginPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CorsOriginPattern_UnserializedMessageContext<
            UserType, CorsOriginPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CorsOriginPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String protocol;
  
  ::blink::String domain;
  
  uint16_t port;
  
  CorsDomainMatchMode domain_match_mode;
  
  CorsPortMatchMode port_match_mode;
  
  CorsOriginAccessMatchPriority priority;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CorsOriginAccessPatterns {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CorsOriginAccessPatterns, T>::value>;
  using DataView = CorsOriginAccessPatternsDataView;
  using Data_ = internal::CorsOriginAccessPatterns_Data;

  template <typename... Args>
  static CorsOriginAccessPatternsPtr New(Args&&... args) {
    return CorsOriginAccessPatternsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CorsOriginAccessPatternsPtr From(const U& u) {
    return mojo::TypeConverter<CorsOriginAccessPatternsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CorsOriginAccessPatterns>::Convert(*this);
  }


  CorsOriginAccessPatterns();

  CorsOriginAccessPatterns(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin,
      ::blink::Vector<CorsOriginPatternPtr> allow_patterns,
      ::blink::Vector<CorsOriginPatternPtr> block_patterns);

CorsOriginAccessPatterns(const CorsOriginAccessPatterns&) = delete;
CorsOriginAccessPatterns& operator=(const CorsOriginAccessPatterns&) = delete;

  ~CorsOriginAccessPatterns();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CorsOriginAccessPatternsPtr>
  CorsOriginAccessPatternsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CorsOriginAccessPatterns::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CorsOriginAccessPatterns::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CorsOriginAccessPatterns::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CorsOriginAccessPatterns_UnserializedMessageContext<
            UserType, CorsOriginAccessPatterns::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CorsOriginAccessPatterns::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CorsOriginAccessPatterns::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CorsOriginAccessPatterns_UnserializedMessageContext<
            UserType, CorsOriginAccessPatterns::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CorsOriginAccessPatterns::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> source_origin;
  
  ::blink::Vector<CorsOriginPatternPtr> allow_patterns;
  
  ::blink::Vector<CorsOriginPatternPtr> block_patterns;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CorsOriginPatternPtr CorsOriginPattern::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(domain),
      mojo::Clone(port),
      mojo::Clone(domain_match_mode),
      mojo::Clone(port_match_mode),
      mojo::Clone(priority)
  );
}

template <typename T, CorsOriginPattern::EnableIfSame<T>*>
bool CorsOriginPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->domain_match_mode, other_struct.domain_match_mode))
    return false;
  if (!mojo::Equals(this->port_match_mode, other_struct.port_match_mode))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  return true;
}

template <typename T, CorsOriginPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  if (lhs.domain_match_mode < rhs.domain_match_mode)
    return true;
  if (rhs.domain_match_mode < lhs.domain_match_mode)
    return false;
  if (lhs.port_match_mode < rhs.port_match_mode)
    return true;
  if (rhs.port_match_mode < lhs.port_match_mode)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  return false;
}
template <typename StructPtrType>
CorsOriginAccessPatternsPtr CorsOriginAccessPatterns::Clone() const {
  return New(
      mojo::Clone(source_origin),
      mojo::Clone(allow_patterns),
      mojo::Clone(block_patterns)
  );
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>*>
bool CorsOriginAccessPatterns::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_origin, other_struct.source_origin))
    return false;
  if (!mojo::Equals(this->allow_patterns, other_struct.allow_patterns))
    return false;
  if (!mojo::Equals(this->block_patterns, other_struct.block_patterns))
    return false;
  return true;
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_origin < rhs.source_origin)
    return true;
  if (rhs.source_origin < lhs.source_origin)
    return false;
  if (lhs.allow_patterns < rhs.allow_patterns)
    return true;
  if (rhs.allow_patterns < lhs.allow_patterns)
    return false;
  if (lhs.block_patterns < rhs.block_patterns)
    return true;
  if (rhs.block_patterns < lhs.block_patterns)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CorsOriginPattern::DataView,
                                         ::network::mojom::blink::CorsOriginPatternPtr> {
  static bool IsNull(const ::network::mojom::blink::CorsOriginPatternPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CorsOriginPatternPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CorsOriginPattern::protocol)& protocol(
      const ::network::mojom::blink::CorsOriginPatternPtr& input) {
    return input->protocol;
  }

  static const decltype(::network::mojom::blink::CorsOriginPattern::domain)& domain(
      const ::network::mojom::blink::CorsOriginPatternPtr& input) {
    return input->domain;
  }

  static decltype(::network::mojom::blink::CorsOriginPattern::port) port(
      const ::network::mojom::blink::CorsOriginPatternPtr& input) {
    return input->port;
  }

  static decltype(::network::mojom::blink::CorsOriginPattern::domain_match_mode) domain_match_mode(
      const ::network::mojom::blink::CorsOriginPatternPtr& input) {
    return input->domain_match_mode;
  }

  static decltype(::network::mojom::blink::CorsOriginPattern::port_match_mode) port_match_mode(
      const ::network::mojom::blink::CorsOriginPatternPtr& input) {
    return input->port_match_mode;
  }

  static decltype(::network::mojom::blink::CorsOriginPattern::priority) priority(
      const ::network::mojom::blink::CorsOriginPatternPtr& input) {
    return input->priority;
  }

  static bool Read(::network::mojom::blink::CorsOriginPattern::DataView input, ::network::mojom::blink::CorsOriginPatternPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CorsOriginAccessPatterns::DataView,
                                         ::network::mojom::blink::CorsOriginAccessPatternsPtr> {
  static bool IsNull(const ::network::mojom::blink::CorsOriginAccessPatternsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CorsOriginAccessPatternsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CorsOriginAccessPatterns::source_origin)& source_origin(
      const ::network::mojom::blink::CorsOriginAccessPatternsPtr& input) {
    return input->source_origin;
  }

  static const decltype(::network::mojom::blink::CorsOriginAccessPatterns::allow_patterns)& allow_patterns(
      const ::network::mojom::blink::CorsOriginAccessPatternsPtr& input) {
    return input->allow_patterns;
  }

  static const decltype(::network::mojom::blink::CorsOriginAccessPatterns::block_patterns)& block_patterns(
      const ::network::mojom::blink::CorsOriginAccessPatternsPtr& input) {
    return input->block_patterns;
  }

  static bool Read(::network::mojom::blink::CorsOriginAccessPatterns::DataView input, ::network::mojom::blink::CorsOriginAccessPatternsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_BLINK_H_