// services/network/public/mojom/cookie_partition_key.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/cookie_partition_key.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }


  var AncestorChainBit = {};
  AncestorChainBit.kSameSite = 0;
  AncestorChainBit.kCrossSite = 1;
  AncestorChainBit.MIN_VALUE = 0;
  AncestorChainBit.MAX_VALUE = 1;

  AncestorChainBit.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AncestorChainBit.toKnownEnumValue = function(value) {
    return value;
  };

  AncestorChainBit.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CookiePartitionKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookiePartitionKey.prototype.initDefaults_ = function() {
    this.site = null;
    this.fromScript = false;
    this.ancestorChainBit = AncestorChainBit.kCrossSite;
    this.nonce = null;
  };
  CookiePartitionKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookiePartitionKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookiePartitionKey.site
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CookiePartitionKey.nonce
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookiePartitionKey.ancestorChainBit
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AncestorChainBit);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookiePartitionKey.encodedSize = codec.kStructHeaderSize + 24;

  CookiePartitionKey.decode = function(decoder) {
    var packed;
    var val = new CookiePartitionKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.site =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    packed = decoder.readUint8();
    val.fromScript = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.ancestorChainBit =
        decoder.decodeStruct(new codec.Enum(AncestorChainBit));
    val.nonce =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  CookiePartitionKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookiePartitionKey.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.site);
    packed = 0;
    packed |= (val.fromScript & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.ancestorChainBit);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.nonce);
  };
  function CookiePartitionKeyCollection(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookiePartitionKeyCollection.prototype.initDefaults_ = function() {
    this.containsAllPartitions = false;
    this.keys = null;
  };
  CookiePartitionKeyCollection.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookiePartitionKeyCollection.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CookiePartitionKeyCollection.keys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(CookiePartitionKey), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookiePartitionKeyCollection.encodedSize = codec.kStructHeaderSize + 16;

  CookiePartitionKeyCollection.decode = function(decoder) {
    var packed;
    var val = new CookiePartitionKeyCollection();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.containsAllPartitions = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.keys =
        decoder.decodeArrayPointer(new codec.PointerTo(CookiePartitionKey));
    return val;
  };

  CookiePartitionKeyCollection.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookiePartitionKeyCollection.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.containsAllPartitions & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(CookiePartitionKey), val.keys);
  };
  exports.AncestorChainBit = AncestorChainBit;
  exports.CookiePartitionKey = CookiePartitionKey;
  exports.CookiePartitionKeyCollection = CookiePartitionKeyCollection;
})();