// services/network/public/mojom/cookie_partition_key.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cookie_partition_key.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cookie_partition_key.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/cookie_manager_mojom_traits.h"




namespace network::mojom {









class  CookiePartitionKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookiePartitionKey, T>::value>;
  using DataView = CookiePartitionKeyDataView;
  using Data_ = internal::CookiePartitionKey_Data;

  template <typename... Args>
  static CookiePartitionKeyPtr New(Args&&... args) {
    return CookiePartitionKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookiePartitionKeyPtr From(const U& u) {
    return mojo::TypeConverter<CookiePartitionKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookiePartitionKey>::Convert(*this);
  }


  CookiePartitionKey();

  CookiePartitionKey(
      const ::net::SchemefulSite& site,
      bool from_script,
      const std::optional<::base::UnguessableToken>& nonce,
      AncestorChainBit ancestor_chain_bit);


  ~CookiePartitionKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookiePartitionKeyPtr>
  CookiePartitionKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookiePartitionKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookiePartitionKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookiePartitionKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookiePartitionKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookiePartitionKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookiePartitionKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookiePartitionKey_UnserializedMessageContext<
            UserType, CookiePartitionKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookiePartitionKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookiePartitionKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookiePartitionKey_UnserializedMessageContext<
            UserType, CookiePartitionKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookiePartitionKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::SchemefulSite site;
  
  bool from_script;
  
  std::optional<::base::UnguessableToken> nonce;
  
  AncestorChainBit ancestor_chain_bit;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookiePartitionKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookiePartitionKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookiePartitionKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookiePartitionKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CookiePartitionKeyCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookiePartitionKeyCollection, T>::value>;
  using DataView = CookiePartitionKeyCollectionDataView;
  using Data_ = internal::CookiePartitionKeyCollection_Data;

  template <typename... Args>
  static CookiePartitionKeyCollectionPtr New(Args&&... args) {
    return CookiePartitionKeyCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookiePartitionKeyCollectionPtr From(const U& u) {
    return mojo::TypeConverter<CookiePartitionKeyCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookiePartitionKeyCollection>::Convert(*this);
  }


  CookiePartitionKeyCollection();

  CookiePartitionKeyCollection(
      bool contains_all_partitions,
      std::vector<::net::CookiePartitionKey> keys);


  ~CookiePartitionKeyCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookiePartitionKeyCollectionPtr>
  CookiePartitionKeyCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookiePartitionKeyCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookiePartitionKeyCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookiePartitionKeyCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookiePartitionKeyCollection_UnserializedMessageContext<
            UserType, CookiePartitionKeyCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookiePartitionKeyCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookiePartitionKeyCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookiePartitionKeyCollection_UnserializedMessageContext<
            UserType, CookiePartitionKeyCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookiePartitionKeyCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool contains_all_partitions;
  
  std::vector<::net::CookiePartitionKey> keys;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CookiePartitionKeyPtr CookiePartitionKey::Clone() const {
  return New(
      mojo::Clone(site),
      mojo::Clone(from_script),
      mojo::Clone(nonce),
      mojo::Clone(ancestor_chain_bit)
  );
}

template <typename T, CookiePartitionKey::EnableIfSame<T>*>
bool CookiePartitionKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site, other_struct.site))
    return false;
  if (!mojo::Equals(this->from_script, other_struct.from_script))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  if (!mojo::Equals(this->ancestor_chain_bit, other_struct.ancestor_chain_bit))
    return false;
  return true;
}

template <typename T, CookiePartitionKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site < rhs.site)
    return true;
  if (rhs.site < lhs.site)
    return false;
  if (lhs.from_script < rhs.from_script)
    return true;
  if (rhs.from_script < lhs.from_script)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  if (lhs.ancestor_chain_bit < rhs.ancestor_chain_bit)
    return true;
  if (rhs.ancestor_chain_bit < lhs.ancestor_chain_bit)
    return false;
  return false;
}
template <typename StructPtrType>
CookiePartitionKeyCollectionPtr CookiePartitionKeyCollection::Clone() const {
  return New(
      mojo::Clone(contains_all_partitions),
      mojo::Clone(keys)
  );
}

template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>*>
bool CookiePartitionKeyCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->contains_all_partitions, other_struct.contains_all_partitions))
    return false;
  if (!mojo::Equals(this->keys, other_struct.keys))
    return false;
  return true;
}

template <typename T, CookiePartitionKeyCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.contains_all_partitions < rhs.contains_all_partitions)
    return true;
  if (rhs.contains_all_partitions < lhs.contains_all_partitions)
    return false;
  if (lhs.keys < rhs.keys)
    return true;
  if (rhs.keys < lhs.keys)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CookiePartitionKey::DataView,
                                         ::network::mojom::CookiePartitionKeyPtr> {
  static bool IsNull(const ::network::mojom::CookiePartitionKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookiePartitionKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CookiePartitionKey::site)& site(
      const ::network::mojom::CookiePartitionKeyPtr& input) {
    return input->site;
  }

  static decltype(::network::mojom::CookiePartitionKey::from_script) from_script(
      const ::network::mojom::CookiePartitionKeyPtr& input) {
    return input->from_script;
  }

  static const decltype(::network::mojom::CookiePartitionKey::nonce)& nonce(
      const ::network::mojom::CookiePartitionKeyPtr& input) {
    return input->nonce;
  }

  static decltype(::network::mojom::CookiePartitionKey::ancestor_chain_bit) ancestor_chain_bit(
      const ::network::mojom::CookiePartitionKeyPtr& input) {
    return input->ancestor_chain_bit;
  }

  static bool Read(::network::mojom::CookiePartitionKey::DataView input, ::network::mojom::CookiePartitionKeyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookiePartitionKeyCollection::DataView,
                                         ::network::mojom::CookiePartitionKeyCollectionPtr> {
  static bool IsNull(const ::network::mojom::CookiePartitionKeyCollectionPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookiePartitionKeyCollectionPtr* output) { output->reset(); }

  static decltype(::network::mojom::CookiePartitionKeyCollection::contains_all_partitions) contains_all_partitions(
      const ::network::mojom::CookiePartitionKeyCollectionPtr& input) {
    return input->contains_all_partitions;
  }

  static const decltype(::network::mojom::CookiePartitionKeyCollection::keys)& keys(
      const ::network::mojom::CookiePartitionKeyCollectionPtr& input) {
    return input->keys;
  }

  static bool Read(::network::mojom::CookiePartitionKeyCollection::DataView input, ::network::mojom::CookiePartitionKeyCollectionPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_H_