// services/network/public/mojom/cookie_partition_key.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cookie_partition_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"

#include "services/network/public/mojom/cookie_partition_key.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::AncestorChainBit, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookiePartitionKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookiePartitionKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookiePartitionKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::site(input)) in_site = Traits::site(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->site)::BaseType> site_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView, send_validation>(
        in_site,
        site_fragment);

      fragment->site.Set(
          site_fragment.is_null() ? nullptr : site_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->site.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site in CookiePartitionKey struct");

      fragment->from_script = Traits::from_script(input);

      decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce)::BaseType> nonce_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_nonce,
        nonce_fragment);

      fragment->nonce.Set(
          nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::AncestorChainBit>(
        Traits::ancestor_chain_bit(input),
        &fragment->ancestor_chain_bit);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookiePartitionKeyCollectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookiePartitionKeyCollectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookiePartitionKeyCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->contains_all_partitions = Traits::contains_all_partitions(input);

      decltype(Traits::keys(input)) in_keys = Traits::keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keys)::BaseType>
          keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookiePartitionKeyDataView>, send_validation>(
        in_keys,
        keys_fragment,
        &keys_validate_params);

      fragment->keys.Set(
          keys_fragment.is_null() ? nullptr : keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keys in CookiePartitionKeyCollection struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_SEND_VALIDATION_H_