// services/network/public/mojom/cookie_manager.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/cookie_manager.mojom.h"


namespace network::mojom {


class  CookieChangeListenerInterceptorForTesting : public CookieChangeListener {
  virtual CookieChangeListener* GetForwardingInterface() = 0;
  void OnCookieChange(const ::net::CookieChangeInfo& change) override;
};
class  CookieChangeListenerAsyncWaiter {
 public:
  explicit CookieChangeListenerAsyncWaiter(CookieChangeListener* proxy);

  CookieChangeListenerAsyncWaiter(const CookieChangeListenerAsyncWaiter&) = delete;
  CookieChangeListenerAsyncWaiter& operator=(const CookieChangeListenerAsyncWaiter&) = delete;

  ~CookieChangeListenerAsyncWaiter();

 private:
  CookieChangeListener* const proxy_;
};


class  CookieManagerInterceptorForTesting : public CookieManager {
  virtual CookieManager* GetForwardingInterface() = 0;
  void GetAllCookies(GetAllCookiesCallback callback) override;
  void GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) override;
  void GetCookieList(const ::GURL& url, const ::net::CookieOptions& cookie_options, const ::net::CookiePartitionKeyCollection& cookie_partition_key_collection, GetCookieListCallback callback) override;
  void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& source_url, const ::net::CookieOptions& cookie_options, SetCanonicalCookieCallback callback) override;
  void DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) override;
  void DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) override;
  void DeleteSessionOnlyCookies(DeleteSessionOnlyCookiesCallback callback) override;
  void DeleteStaleSessionOnlyCookies(DeleteStaleSessionOnlyCookiesCallback callback) override;
  void AddCookieChangeListener(const ::GURL& url, const std::optional<std::string>& name, ::mojo::PendingRemote<CookieChangeListener> listener) override;
  void AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) override;
  void CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) override;
  void FlushCookieStore(FlushCookieStoreCallback callback) override;
  void AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) override;
  void SetContentSettings(::content_settings::mojom::ContentSettingsType content_settings_type, const std::vector<::ContentSettingPatternSource>& settings, SetContentSettingsCallback callback) override;
  void SetForceKeepSessionState() override;
  void BlockThirdPartyCookies(bool block) override;
  void SetMitigationsEnabledFor3pcd(bool enable) override;
  void SetTrackingProtectionEnabledFor3pcd(bool enable) override;
  void SetPreCommitCallbackDelayForTesting(::base::TimeDelta delay) override;
};
class  CookieManagerAsyncWaiter {
 public:
  explicit CookieManagerAsyncWaiter(CookieManager* proxy);

  CookieManagerAsyncWaiter(const CookieManagerAsyncWaiter&) = delete;
  CookieManagerAsyncWaiter& operator=(const CookieManagerAsyncWaiter&) = delete;

  ~CookieManagerAsyncWaiter();
  void GetAllCookies(
      std::vector<::net::CanonicalCookie>* out_cookies);
  std::vector<::net::CanonicalCookie> GetAllCookies();
  void GetAllCookiesWithAccessSemantics(
      std::vector<::net::CanonicalCookie>* out_cookies, std::vector<::net::CookieAccessSemantics>* out_access_semantics_list);
  
  void GetCookieList(
      const ::GURL& url, const ::net::CookieOptions& cookie_options, const ::net::CookiePartitionKeyCollection& cookie_partition_key_collection, std::vector<::net::CookieWithAccessResult>* out_cookies, std::vector<::net::CookieWithAccessResult>* out_excluded_cookies);
  
  void SetCanonicalCookie(
      const ::net::CanonicalCookie& cookie, const ::GURL& source_url, const ::net::CookieOptions& cookie_options, ::net::CookieAccessResult* out_access_result);
  ::net::CookieAccessResult SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& source_url, const ::net::CookieOptions& cookie_options);
  void DeleteCanonicalCookie(
      const ::net::CanonicalCookie& cookie, bool* out_success);
  bool DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie);
  void DeleteCookies(
      CookieDeletionFilterPtr filter, uint32_t* out_num_deleted);
  uint32_t DeleteCookies(CookieDeletionFilterPtr filter);
  void DeleteSessionOnlyCookies(
      uint32_t* out_num_deleted);
  uint32_t DeleteSessionOnlyCookies();
  void DeleteStaleSessionOnlyCookies(
      uint32_t* out_num_deleted);
  uint32_t DeleteStaleSessionOnlyCookies();
  void FlushCookieStore(
      );
  
  void AllowFileSchemeCookies(
      bool allow, bool* out_success);
  bool AllowFileSchemeCookies(bool allow);
  void SetContentSettings(
      ::content_settings::mojom::ContentSettingsType content_settings_type, const std::vector<::ContentSettingPatternSource>& settings);
  

 private:
  CookieManager* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_TEST_UTILS_H_