// services/network/public/mojom/cookie_manager.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cookie_manager.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "components/content_settings/core/common/content_settings_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/network/public/mojom/cookie_manager.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieAccessDelegateType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookiePriority, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieSourceScheme, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieSameSite, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieEffectiveSameSite, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieExemptionReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::ContextType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieSameSiteContextMetadataDowngradeType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieSourceType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::ContextRedirectTypeBug1221316, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::HttpMethod, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieAccessSemantics, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieScopeSemantics, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieChangeCause, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieDeletionSessionControl, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieManagerParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieManagerParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieManagerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->block_third_party_cookies = Traits::block_third_party_cookies(input);

      fragment->tracking_protection_enabled_for_3pcd = Traits::tracking_protection_enabled_for_3pcd(input);

      fragment->mitigations_enabled_for_3pcd = Traits::mitigations_enabled_for_3pcd(input);

      decltype(Traits::content_settings(input)) in_content_settings = Traits::content_settings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_settings)::BaseType>
          content_settings_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& content_settings_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::content_settings::mojom::internal::ContentSettingsType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::content_settings::mojom::ContentSettingsType, mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>, send_validation>(
        in_content_settings,
        content_settings_fragment,
        &content_settings_validate_params);

      fragment->content_settings.Set(
          content_settings_fragment.is_null() ? nullptr : content_settings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_settings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_settings in CookieManagerParams struct");

      decltype(Traits::secure_origin_cookies_allowed_schemes(input)) in_secure_origin_cookies_allowed_schemes = Traits::secure_origin_cookies_allowed_schemes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->secure_origin_cookies_allowed_schemes)::BaseType>
          secure_origin_cookies_allowed_schemes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& secure_origin_cookies_allowed_schemes_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_secure_origin_cookies_allowed_schemes,
        secure_origin_cookies_allowed_schemes_fragment,
        &secure_origin_cookies_allowed_schemes_validate_params);

      fragment->secure_origin_cookies_allowed_schemes.Set(
          secure_origin_cookies_allowed_schemes_fragment.is_null() ? nullptr : secure_origin_cookies_allowed_schemes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->secure_origin_cookies_allowed_schemes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null secure_origin_cookies_allowed_schemes in CookieManagerParams struct");

      decltype(Traits::matching_scheme_cookies_allowed_schemes(input)) in_matching_scheme_cookies_allowed_schemes = Traits::matching_scheme_cookies_allowed_schemes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->matching_scheme_cookies_allowed_schemes)::BaseType>
          matching_scheme_cookies_allowed_schemes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& matching_scheme_cookies_allowed_schemes_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_matching_scheme_cookies_allowed_schemes,
        matching_scheme_cookies_allowed_schemes_fragment,
        &matching_scheme_cookies_allowed_schemes_validate_params);

      fragment->matching_scheme_cookies_allowed_schemes.Set(
          matching_scheme_cookies_allowed_schemes_fragment.is_null() ? nullptr : matching_scheme_cookies_allowed_schemes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->matching_scheme_cookies_allowed_schemes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null matching_scheme_cookies_allowed_schemes in CookieManagerParams struct");

      decltype(Traits::third_party_cookies_allowed_schemes(input)) in_third_party_cookies_allowed_schemes = Traits::third_party_cookies_allowed_schemes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->third_party_cookies_allowed_schemes)::BaseType>
          third_party_cookies_allowed_schemes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& third_party_cookies_allowed_schemes_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_third_party_cookies_allowed_schemes,
        third_party_cookies_allowed_schemes_fragment,
        &third_party_cookies_allowed_schemes_validate_params);

      fragment->third_party_cookies_allowed_schemes.Set(
          third_party_cookies_allowed_schemes_fragment.is_null() ? nullptr : third_party_cookies_allowed_schemes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->third_party_cookies_allowed_schemes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null third_party_cookies_allowed_schemes in CookieManagerParams struct");

      fragment->allow_file_scheme_cookies = Traits::allow_file_scheme_cookies(input);

      
      mojo::internal::Serialize<::network::mojom::CookieAccessDelegateType>(
        Traits::cookie_access_delegate_type(input),
        &fragment->cookie_access_delegate_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieSameSiteContextMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieSameSiteContextMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieSameSiteContextMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::CookieSameSiteContextMetadataDowngradeType>(
        Traits::cross_site_redirect_downgrade(input),
        &fragment->cross_site_redirect_downgrade);

      
      mojo::internal::Serialize<::network::mojom::ContextRedirectTypeBug1221316>(
        Traits::redirect_type_bug_1221316(input),
        &fragment->redirect_type_bug_1221316);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieSameSiteContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieSameSiteContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieSameSiteContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::ContextType>(
        Traits::context(input),
        &fragment->context);

      
      mojo::internal::Serialize<::network::mojom::ContextType>(
        Traits::schemeful_context(input),
        &fragment->schemeful_context);

      decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metadata)::BaseType> metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieSameSiteContextMetadataDataView, send_validation>(
        in_metadata,
        metadata_fragment);

      fragment->metadata.Set(
          metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->metadata.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in CookieSameSiteContext struct");

      decltype(Traits::schemeful_metadata(input)) in_schemeful_metadata = Traits::schemeful_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->schemeful_metadata)::BaseType> schemeful_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieSameSiteContextMetadataDataView, send_validation>(
        in_schemeful_metadata,
        schemeful_metadata_fragment);

      fragment->schemeful_metadata.Set(
          schemeful_metadata_fragment.is_null() ? nullptr : schemeful_metadata_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->schemeful_metadata.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null schemeful_metadata in CookieSameSiteContext struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->exclude_httponly = Traits::exclude_httponly(input);

      decltype(Traits::same_site_cookie_context(input)) in_same_site_cookie_context = Traits::same_site_cookie_context(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->same_site_cookie_context)::BaseType> same_site_cookie_context_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieSameSiteContextDataView, send_validation>(
        in_same_site_cookie_context,
        same_site_cookie_context_fragment);

      fragment->same_site_cookie_context.Set(
          same_site_cookie_context_fragment.is_null() ? nullptr : same_site_cookie_context_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->same_site_cookie_context.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null same_site_cookie_context in CookieOptions struct");

      fragment->update_access_time = Traits::update_access_time(input);

      fragment->return_excluded_cookies = Traits::return_excluded_cookies(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CanonicalCookieDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CanonicalCookieDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CanonicalCookie_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in CanonicalCookie struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in CanonicalCookie struct");

      decltype(Traits::domain(input)) in_domain = Traits::domain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain)::BaseType> domain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_domain,
        domain_fragment);

      fragment->domain.Set(
          domain_fragment.is_null() ? nullptr : domain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain in CanonicalCookie struct");

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in CanonicalCookie struct");

      decltype(Traits::creation(input)) in_creation = Traits::creation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->creation)::BaseType> creation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_creation,
        creation_fragment);

      fragment->creation.Set(
          creation_fragment.is_null() ? nullptr : creation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->creation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null creation in CanonicalCookie struct");

      decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiry)::BaseType> expiry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_expiry,
        expiry_fragment);

      fragment->expiry.Set(
          expiry_fragment.is_null() ? nullptr : expiry_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expiry.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiry in CanonicalCookie struct");

      decltype(Traits::last_access(input)) in_last_access = Traits::last_access(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_access)::BaseType> last_access_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_access,
        last_access_fragment);

      fragment->last_access.Set(
          last_access_fragment.is_null() ? nullptr : last_access_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_access.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_access in CanonicalCookie struct");

      decltype(Traits::last_update(input)) in_last_update = Traits::last_update(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_update)::BaseType> last_update_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_update,
        last_update_fragment);

      fragment->last_update.Set(
          last_update_fragment.is_null() ? nullptr : last_update_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_update.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_update in CanonicalCookie struct");

      fragment->secure = Traits::secure(input);

      fragment->httponly = Traits::httponly(input);

      
      mojo::internal::Serialize<::network::mojom::CookieSameSite>(
        Traits::site_restrictions(input),
        &fragment->site_restrictions);

      
      mojo::internal::Serialize<::network::mojom::CookiePriority>(
        Traits::priority(input),
        &fragment->priority);

      
      mojo::internal::Serialize<::network::mojom::CookieSourceScheme>(
        Traits::source_scheme(input),
        &fragment->source_scheme);

      decltype(Traits::partition_key(input)) in_partition_key = Traits::partition_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->partition_key)::BaseType> partition_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookiePartitionKeyDataView, send_validation>(
        in_partition_key,
        partition_key_fragment);

      fragment->partition_key.Set(
          partition_key_fragment.is_null() ? nullptr : partition_key_fragment.data());

      fragment->source_port = Traits::source_port(input);

      
      mojo::internal::Serialize<::network::mojom::CookieSourceType>(
        Traits::source_type(input),
        &fragment->source_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ExclusionReasonsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ExclusionReasonsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ExclusionReasons_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->exclusions_bitmask = Traits::exclusions_bitmask(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::WarningReasonsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WarningReasonsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WarningReasons_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->warnings_bitmask = Traits::warnings_bitmask(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieInclusionStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieInclusionStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieInclusionStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::exclusion_reasons(input)) in_exclusion_reasons = Traits::exclusion_reasons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->exclusion_reasons)::BaseType> exclusion_reasons_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ExclusionReasonsDataView, send_validation>(
        in_exclusion_reasons,
        exclusion_reasons_fragment);

      fragment->exclusion_reasons.Set(
          exclusion_reasons_fragment.is_null() ? nullptr : exclusion_reasons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->exclusion_reasons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exclusion_reasons in CookieInclusionStatus struct");

      decltype(Traits::warning_reasons(input)) in_warning_reasons = Traits::warning_reasons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->warning_reasons)::BaseType> warning_reasons_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::WarningReasonsDataView, send_validation>(
        in_warning_reasons,
        warning_reasons_fragment);

      fragment->warning_reasons.Set(
          warning_reasons_fragment.is_null() ? nullptr : warning_reasons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->warning_reasons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null warning_reasons in CookieInclusionStatus struct");

      
      mojo::internal::Serialize<::network::mojom::CookieExemptionReason>(
        Traits::exemption_reason(input),
        &fragment->exemption_reason);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieAndLineWithAccessResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAndLineWithAccessResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieAndLineWithAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie)::BaseType> cookie_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView, send_validation>(
        in_cookie,
        cookie_fragment);

      fragment->cookie.Set(
          cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

      decltype(Traits::cookie_string(input)) in_cookie_string = Traits::cookie_string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_string)::BaseType> cookie_string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_cookie_string,
        cookie_string_fragment);

      fragment->cookie_string.Set(
          cookie_string_fragment.is_null() ? nullptr : cookie_string_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie_string.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_string in CookieAndLineWithAccessResult struct");

      decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->access_result)::BaseType> access_result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView, send_validation>(
        in_access_result,
        access_result_fragment);

      fragment->access_result.Set(
          access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->access_result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_result in CookieAndLineWithAccessResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieOrLineWithAccessResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieOrLineWithAccessResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieOrLineWithAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cookie_or_line(input)) in_cookie_or_line = Traits::cookie_or_line(input);
      mojo::internal::MessageFragment<decltype(fragment->cookie_or_line)>
          cookie_or_line_fragment(fragment.message());
      cookie_or_line_fragment.Claim(&fragment->cookie_or_line);
      
      mojo::internal::Serialize<::network::mojom::CookieOrLineDataView, send_validation>(
        in_cookie_or_line,
        cookie_or_line_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie_or_line.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_or_line in CookieOrLineWithAccessResult struct");

      decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->access_result)::BaseType> access_result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView, send_validation>(
        in_access_result,
        access_result_fragment);

      fragment->access_result.Set(
          access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->access_result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_result in CookieOrLineWithAccessResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieAccessResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAccessResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::CookieEffectiveSameSite>(
        Traits::effective_same_site(input),
        &fragment->effective_same_site);

      
      mojo::internal::Serialize<::network::mojom::CookieAccessSemantics>(
        Traits::access_semantics(input),
        &fragment->access_semantics);

      
      mojo::internal::Serialize<::network::mojom::CookieScopeSemantics>(
        Traits::scope_semantics(input),
        &fragment->scope_semantics);

      decltype(Traits::status(input)) in_status = Traits::status(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->status)::BaseType> status_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieInclusionStatusDataView, send_validation>(
        in_status,
        status_fragment);

      fragment->status.Set(
          status_fragment.is_null() ? nullptr : status_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->status.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status in CookieAccessResult struct");

      fragment->is_allowed_to_access_secure_cookies = Traits::is_allowed_to_access_secure_cookies(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieWithAccessResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieWithAccessResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieWithAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie)::BaseType> cookie_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView, send_validation>(
        in_cookie,
        cookie_fragment);

      fragment->cookie.Set(
          cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie in CookieWithAccessResult struct");

      decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->access_result)::BaseType> access_result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView, send_validation>(
        in_access_result,
        access_result_fragment);

      fragment->access_result.Set(
          access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->access_result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_result in CookieWithAccessResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieChangeInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieChangeInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieChangeInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie)::BaseType> cookie_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView, send_validation>(
        in_cookie,
        cookie_fragment);

      fragment->cookie.Set(
          cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie in CookieChangeInfo struct");

      decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->access_result)::BaseType> access_result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView, send_validation>(
        in_access_result,
        access_result_fragment);

      fragment->access_result.Set(
          access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->access_result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_result in CookieChangeInfo struct");

      
      mojo::internal::Serialize<::network::mojom::CookieChangeCause>(
        Traits::cause(input),
        &fragment->cause);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieDeletionFilterDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieDeletionFilterDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieDeletionFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::created_after_time(input)) in_created_after_time = Traits::created_after_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->created_after_time)::BaseType> created_after_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_created_after_time,
        created_after_time_fragment);

      fragment->created_after_time.Set(
          created_after_time_fragment.is_null() ? nullptr : created_after_time_fragment.data());

      decltype(Traits::created_before_time(input)) in_created_before_time = Traits::created_before_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->created_before_time)::BaseType> created_before_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_created_before_time,
        created_before_time_fragment);

      fragment->created_before_time.Set(
          created_before_time_fragment.is_null() ? nullptr : created_before_time_fragment.data());

      decltype(Traits::excluding_domains(input)) in_excluding_domains = Traits::excluding_domains(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->excluding_domains)::BaseType>
          excluding_domains_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& excluding_domains_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_excluding_domains,
        excluding_domains_fragment,
        &excluding_domains_validate_params);

      fragment->excluding_domains.Set(
          excluding_domains_fragment.is_null() ? nullptr : excluding_domains_fragment.data());

      decltype(Traits::including_domains(input)) in_including_domains = Traits::including_domains(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->including_domains)::BaseType>
          including_domains_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& including_domains_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_including_domains,
        including_domains_fragment,
        &including_domains_validate_params);

      fragment->including_domains.Set(
          including_domains_fragment.is_null() ? nullptr : including_domains_fragment.data());

      decltype(Traits::cookie_name(input)) in_cookie_name = Traits::cookie_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_name)::BaseType> cookie_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_cookie_name,
        cookie_name_fragment);

      fragment->cookie_name.Set(
          cookie_name_fragment.is_null() ? nullptr : cookie_name_fragment.data());

      decltype(Traits::host_name(input)) in_host_name = Traits::host_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_name)::BaseType> host_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_host_name,
        host_name_fragment);

      fragment->host_name.Set(
          host_name_fragment.is_null() ? nullptr : host_name_fragment.data());

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::CookieDeletionSessionControl>(
        Traits::session_control(input),
        &fragment->session_control);

      decltype(Traits::cookie_partition_key_collection(input)) in_cookie_partition_key_collection = Traits::cookie_partition_key_collection(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_partition_key_collection)::BaseType> cookie_partition_key_collection_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookiePartitionKeyCollectionDataView, send_validation>(
        in_cookie_partition_key_collection,
        cookie_partition_key_collection_fragment);

      fragment->cookie_partition_key_collection.Set(
          cookie_partition_key_collection_fragment.is_null() ? nullptr : cookie_partition_key_collection_fragment.data());

      fragment->partitioned_state_only = Traits::partitioned_state_only(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieOrLineDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::CookieOrLineDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::CookieOrLine_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::CookieOrLineDataView::Tag::kCookie: {
    decltype(Traits::cookie(input))
    in_cookie = Traits::cookie(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cookie)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView, send_validation>(
  in_cookie,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cookie in CookieOrLine union");
    fragment->data.f_cookie.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::CookieOrLineDataView::Tag::kCookieString: {
    decltype(Traits::cookie_string(input))
    in_cookie_string = Traits::cookie_string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cookie_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_cookie_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cookie_string in CookieOrLine union");
    fragment->data.f_cookie_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SEND_VALIDATION_H_