// services/network/public/mojom/cookie_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('contentSettings.mojom.ContentSettingsType');
goog.require('contentSettings.mojom.ContentSettingPatternSource');
goog.require('network.mojom.CookiePartitionKey');
goog.require('network.mojom.CookiePartitionKeyCollection');
goog.require('mojoBase.mojom.Time');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('url.mojom.Url');




goog.provide('network.mojom.CookieAccessDelegateType');
goog.provide('network.mojom.CookieAccessDelegateTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieAccessDelegateTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieAccessDelegateType = {
  
  USE_CONTENT_SETTINGS: 0,
  ALWAYS_LEGACY: 1,
  ALWAYS_NONLEGACY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('network.mojom.CookiePriority');
goog.provide('network.mojom.CookiePrioritySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookiePrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookiePriority = {
  
  LOW: 0,
  MEDIUM: 1,
  HIGH: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('network.mojom.CookieSourceScheme');
goog.provide('network.mojom.CookieSourceSchemeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieSourceSchemeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieSourceScheme = {
  
  kUnset: 0,
  kNonSecure: 1,
  kSecure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('network.mojom.CookieSameSite');
goog.provide('network.mojom.CookieSameSiteSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieSameSiteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieSameSite = {
  
  UNSPECIFIED: -1,
  NO_RESTRICTION: 0,
  LAX_MODE: 1,
  STRICT_MODE: 2,
  MIN_VALUE: -1,
  MAX_VALUE: 2,
};

goog.provide('network.mojom.CookieEffectiveSameSite');
goog.provide('network.mojom.CookieEffectiveSameSiteSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieEffectiveSameSiteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieEffectiveSameSite = {
  
  kNoRestriction: 0,
  kLaxMode: 1,
  kStrictMode: 2,
  kLaxModeAllowUnsafe: 3,
  kUndefined: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('network.mojom.CookieExemptionReason');
goog.provide('network.mojom.CookieExemptionReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieExemptionReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieExemptionReason = {
  
  kNone: 0,
  kUserSetting: 1,
  k3PCDMetadata: 2,
  k3PCDDeprecationTrial: 3,
  kTopLevel3PCDDeprecationTrial: 4,
  k3PCDHeuristics: 5,
  kEnterprisePolicy: 6,
  kStorageAccess: 7,
  kTopLevelStorageAccess: 8,
  kScheme: 9,
  kSameSiteNoneCookiesInSandbox: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

goog.provide('network.mojom.ContextType');
goog.provide('network.mojom.ContextTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ContextTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ContextType = {
  
  CROSS_SITE: 0,
  SAME_SITE_LAX_METHOD_UNSAFE: 1,
  SAME_SITE_LAX: 2,
  SAME_SITE_STRICT: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('network.mojom.CookieSameSiteContextMetadataDowngradeType');
goog.provide('network.mojom.CookieSameSiteContextMetadataDowngradeTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieSameSiteContextMetadataDowngradeTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieSameSiteContextMetadataDowngradeType = {
  
  kNoDowngrade: 0,
  kStrictToLax: 1,
  kStrictToCross: 2,
  kLaxToCross: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('network.mojom.CookieSourceType');
goog.provide('network.mojom.CookieSourceTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieSourceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieSourceType = {
  
  kUnknown: 0,
  kHTTP: 1,
  kScript: 2,
  kOther: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('network.mojom.ContextRedirectTypeBug1221316');
goog.provide('network.mojom.ContextRedirectTypeBug1221316Spec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ContextRedirectTypeBug1221316Spec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ContextRedirectTypeBug1221316 = {
  
  kUnset: 0,
  kNoRedirect: 1,
  kCrossSiteRedirect: 2,
  kPartialSameSiteRedirect: 3,
  kAllSameSiteRedirect: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('network.mojom.HttpMethod');
goog.provide('network.mojom.HttpMethodSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.HttpMethodSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.HttpMethod = {
  
  kUnset: 0,
  kUnknown: 1,
  kGet: 2,
  kHead: 3,
  kPost: 4,
  KPut: 5,
  kDelete: 6,
  kConnect: 7,
  kOptions: 8,
  kTrace: 9,
  kPatch: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

goog.provide('network.mojom.CookieAccessSemantics');
goog.provide('network.mojom.CookieAccessSemanticsSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieAccessSemanticsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieAccessSemantics = {
  
  UNKNOWN: -1,
  NONLEGACY: 0,
  LEGACY: 1,
  MIN_VALUE: -1,
  MAX_VALUE: 1,
};

goog.provide('network.mojom.CookieScopeSemantics');
goog.provide('network.mojom.CookieScopeSemanticsSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieScopeSemanticsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieScopeSemantics = {
  
  UNKNOWN: -1,
  NONLEGACY: 0,
  LEGACY: 1,
  MIN_VALUE: -1,
  MAX_VALUE: 1,
};

goog.provide('network.mojom.CookieChangeCause');
goog.provide('network.mojom.CookieChangeCauseSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieChangeCauseSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieChangeCause = {
  
  INSERTED: 0,
  EXPLICIT: 1,
  UNKNOWN_DELETION: 2,
  OVERWRITE: 3,
  EXPIRED: 4,
  EVICTED: 5,
  EXPIRED_OVERWRITE: 6,
  INSERTED_NO_CHANGE_OVERWRITE: 7,
  INSERTED_NO_VALUE_CHANGE_OVERWRITE: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

goog.provide('network.mojom.CookieDeletionSessionControl');
goog.provide('network.mojom.CookieDeletionSessionControlSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieDeletionSessionControlSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieDeletionSessionControl = {
  
  IGNORE_CONTROL: 0,
  SESSION_COOKIES: 1,
  PERSISTENT_COOKIES: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('network.mojom.CookieChangeListener');
goog.provide('network.mojom.CookieChangeListenerReceiver');
goog.provide('network.mojom.CookieChangeListenerCallbackRouter');
goog.provide('network.mojom.CookieChangeListenerInterface');
goog.provide('network.mojom.CookieChangeListenerRemote');
goog.provide('network.mojom.CookieChangeListenerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CookieChangeListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CookieChangeListener.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.CookieChangeListenerInterface = class {
  
  /**
   * @param { !network.mojom.CookieChangeInfo } change
   */

  onCookieChange(change) {}
};

/**
 * @export
 * @implements { network.mojom.CookieChangeListenerInterface }
 */
network.mojom.CookieChangeListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CookieChangeListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CookieChangeListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CookieChangeListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.CookieChangeInfo } change
   */

  onCookieChange(
      change) {
    this.proxy.sendMessage(
        0,
        network.mojom.CookieChangeListener_OnCookieChange_ParamsSpec.$,
        null,
        [
          change
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CookieChangeListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CookieChangeListenerReceiver = class {
  /**
   * @param {!network.mojom.CookieChangeListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CookieChangeListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CookieChangeListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CookieChangeListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CookieChangeListener_OnCookieChange_ParamsSpec.$,
        null,
        impl.onCookieChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CookieChangeListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CookieChangeListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CookieChangeListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CookieChangeListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CookieChangeListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CookieChangeListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CookieChangeListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CookieChangeListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCookieChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CookieChangeListener_OnCookieChange_ParamsSpec.$,
        null,
        this.onCookieChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.CookieManager');
goog.provide('network.mojom.CookieManagerReceiver');
goog.provide('network.mojom.CookieManagerCallbackRouter');
goog.provide('network.mojom.CookieManagerInterface');
goog.provide('network.mojom.CookieManagerRemote');
goog.provide('network.mojom.CookieManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CookieManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CookieManager.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.CookieManagerInterface = class {
  
  /**
   * @return {!Promise<{
        cookies: !Array<!network.mojom.CanonicalCookie>,
   *  }>}
   */

  getAllCookies() {}
  
  /**
   * @return {!Promise<{
        cookies: !Array<!network.mojom.CanonicalCookie>,
        accessSemanticsList: !Array<!network.mojom.CookieAccessSemantics>,
   *  }>}
   */

  getAllCookiesWithAccessSemantics() {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.CookieOptions } cookieOptions
   * @param { !network.mojom.CookiePartitionKeyCollection } cookiePartitionKeyCollection
   * @return {!Promise<{
        cookies: !Array<!network.mojom.CookieWithAccessResult>,
        excludedCookies: !Array<!network.mojom.CookieWithAccessResult>,
   *  }>}
   */

  getCookieList(url, cookieOptions, cookiePartitionKeyCollection) {}
  
  /**
   * @param { !network.mojom.CanonicalCookie } cookie
   * @param { !url.mojom.Url } sourceUrl
   * @param { !network.mojom.CookieOptions } cookieOptions
   * @return {!Promise<{
        accessResult: !network.mojom.CookieAccessResult,
   *  }>}
   */

  setCanonicalCookie(cookie, sourceUrl, cookieOptions) {}
  
  /**
   * @param { !network.mojom.CanonicalCookie } cookie
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteCanonicalCookie(cookie) {}
  
  /**
   * @param { !network.mojom.CookieDeletionFilter } filter
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteCookies(filter) {}
  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteSessionOnlyCookies() {}
  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteStaleSessionOnlyCookies() {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { ?string } name
   * @param { !network.mojom.CookieChangeListenerRemote } listener
   */

  addCookieChangeListener(url, name, listener) {}
  
  /**
   * @param { !network.mojom.CookieChangeListenerRemote } notificationPointer
   */

  addGlobalChangeListener(notificationPointer) {}
  
  /**
   * @param { !network.mojom.CookieManagerPendingReceiver } newInterface
   */

  cloneInterface(newInterface) {}
  
  /**
   * @return {!Promise}
   */

  flushCookieStore() {}
  
  /**
   * @param { !boolean } allow
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  allowFileSchemeCookies(allow) {}
  
  /**
   * @param { !contentSettings.mojom.ContentSettingsType } contentSettingsType
   * @param { !Array<!contentSettings.mojom.ContentSettingPatternSource> } settings
   * @return {!Promise}
   */

  setContentSettings(contentSettingsType, settings) {}
  
  /**
   */

  setForceKeepSessionState() {}
  
  /**
   * @param { !boolean } block
   */

  blockThirdPartyCookies(block) {}
  
  /**
   * @param { !boolean } enable
   */

  setMitigationsEnabledFor3pcd(enable) {}
  
  /**
   * @param { !boolean } enable
   */

  setTrackingProtectionEnabledFor3pcd(enable) {}
  
  /**
   * @param { !mojoBase.mojom.TimeDelta } delay
   */

  setPreCommitCallbackDelayForTesting(delay) {}
};

/**
 * @export
 * @implements { network.mojom.CookieManagerInterface }
 */
network.mojom.CookieManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CookieManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CookieManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CookieManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        cookies: !Array<!network.mojom.CanonicalCookie>,
   *  }>}
   */

  getAllCookies() {
    return this.proxy.sendMessage(
        0,
        network.mojom.CookieManager_GetAllCookies_ParamsSpec.$,
        network.mojom.CookieManager_GetAllCookies_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        cookies: !Array<!network.mojom.CanonicalCookie>,
        accessSemanticsList: !Array<!network.mojom.CookieAccessSemantics>,
   *  }>}
   */

  getAllCookiesWithAccessSemantics() {
    return this.proxy.sendMessage(
        1,
        network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
        network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.CookieOptions } cookieOptions
   * @param { !network.mojom.CookiePartitionKeyCollection } cookiePartitionKeyCollection
   * @return {!Promise<{
        cookies: !Array<!network.mojom.CookieWithAccessResult>,
        excludedCookies: !Array<!network.mojom.CookieWithAccessResult>,
   *  }>}
   */

  getCookieList(
      url,
      cookieOptions,
      cookiePartitionKeyCollection) {
    return this.proxy.sendMessage(
        2,
        network.mojom.CookieManager_GetCookieList_ParamsSpec.$,
        network.mojom.CookieManager_GetCookieList_ResponseParamsSpec.$,
        [
          url,
          cookieOptions,
          cookiePartitionKeyCollection
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CanonicalCookie } cookie
   * @param { !url.mojom.Url } sourceUrl
   * @param { !network.mojom.CookieOptions } cookieOptions
   * @return {!Promise<{
        accessResult: !network.mojom.CookieAccessResult,
   *  }>}
   */

  setCanonicalCookie(
      cookie,
      sourceUrl,
      cookieOptions) {
    return this.proxy.sendMessage(
        3,
        network.mojom.CookieManager_SetCanonicalCookie_ParamsSpec.$,
        network.mojom.CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        [
          cookie,
          sourceUrl,
          cookieOptions
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CanonicalCookie } cookie
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteCanonicalCookie(
      cookie) {
    return this.proxy.sendMessage(
        4,
        network.mojom.CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
        network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
        [
          cookie
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CookieDeletionFilter } filter
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteCookies(
      filter) {
    return this.proxy.sendMessage(
        5,
        network.mojom.CookieManager_DeleteCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteCookies_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteSessionOnlyCookies() {
    return this.proxy.sendMessage(
        6,
        network.mojom.CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteStaleSessionOnlyCookies() {
    return this.proxy.sendMessage(
        7,
        network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { ?string } name
   * @param { !network.mojom.CookieChangeListenerRemote } listener
   */

  addCookieChangeListener(
      url,
      name,
      listener) {
    this.proxy.sendMessage(
        8,
        network.mojom.CookieManager_AddCookieChangeListener_ParamsSpec.$,
        null,
        [
          url,
          name,
          listener
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CookieChangeListenerRemote } notificationPointer
   */

  addGlobalChangeListener(
      notificationPointer) {
    this.proxy.sendMessage(
        9,
        network.mojom.CookieManager_AddGlobalChangeListener_ParamsSpec.$,
        null,
        [
          notificationPointer
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CookieManagerPendingReceiver } newInterface
   */

  cloneInterface(
      newInterface) {
    this.proxy.sendMessage(
        10,
        network.mojom.CookieManager_CloneInterface_ParamsSpec.$,
        null,
        [
          newInterface
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flushCookieStore() {
    return this.proxy.sendMessage(
        11,
        network.mojom.CookieManager_FlushCookieStore_ParamsSpec.$,
        network.mojom.CookieManager_FlushCookieStore_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } allow
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  allowFileSchemeCookies(
      allow) {
    return this.proxy.sendMessage(
        12,
        network.mojom.CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
        network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
        [
          allow
        ],
        false);
  }

  
  /**
   * @param { !contentSettings.mojom.ContentSettingsType } contentSettingsType
   * @param { !Array<!contentSettings.mojom.ContentSettingPatternSource> } settings
   * @return {!Promise}
   */

  setContentSettings(
      contentSettingsType,
      settings) {
    return this.proxy.sendMessage(
        13,
        network.mojom.CookieManager_SetContentSettings_ParamsSpec.$,
        network.mojom.CookieManager_SetContentSettings_ResponseParamsSpec.$,
        [
          contentSettingsType,
          settings
        ],
        false);
  }

  
  /**
   */

  setForceKeepSessionState() {
    this.proxy.sendMessage(
        14,
        network.mojom.CookieManager_SetForceKeepSessionState_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } block
   */

  blockThirdPartyCookies(
      block) {
    this.proxy.sendMessage(
        15,
        network.mojom.CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        [
          block
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  setMitigationsEnabledFor3pcd(
      enable) {
    this.proxy.sendMessage(
        16,
        network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  setTrackingProtectionEnabledFor3pcd(
      enable) {
    this.proxy.sendMessage(
        17,
        network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } delay
   */

  setPreCommitCallbackDelayForTesting(
      delay) {
    this.proxy.sendMessage(
        18,
        network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
        null,
        [
          delay
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CookieManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CookieManagerReceiver = class {
  /**
   * @param {!network.mojom.CookieManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CookieManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CookieManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CookieManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CookieManager_GetAllCookies_ParamsSpec.$,
        network.mojom.CookieManager_GetAllCookies_ResponseParamsSpec.$,
        impl.getAllCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
        network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
        impl.getAllCookiesWithAccessSemantics.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.CookieManager_GetCookieList_ParamsSpec.$,
        network.mojom.CookieManager_GetCookieList_ResponseParamsSpec.$,
        impl.getCookieList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.CookieManager_SetCanonicalCookie_ParamsSpec.$,
        network.mojom.CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        impl.setCanonicalCookie.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
        network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
        impl.deleteCanonicalCookie.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.CookieManager_DeleteCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteCookies_ResponseParamsSpec.$,
        impl.deleteCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
        impl.deleteSessionOnlyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
        impl.deleteStaleSessionOnlyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.CookieManager_AddCookieChangeListener_ParamsSpec.$,
        null,
        impl.addCookieChangeListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.CookieManager_AddGlobalChangeListener_ParamsSpec.$,
        null,
        impl.addGlobalChangeListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        network.mojom.CookieManager_CloneInterface_ParamsSpec.$,
        null,
        impl.cloneInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        network.mojom.CookieManager_FlushCookieStore_ParamsSpec.$,
        network.mojom.CookieManager_FlushCookieStore_ResponseParamsSpec.$,
        impl.flushCookieStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        network.mojom.CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
        network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
        impl.allowFileSchemeCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        network.mojom.CookieManager_SetContentSettings_ParamsSpec.$,
        network.mojom.CookieManager_SetContentSettings_ResponseParamsSpec.$,
        impl.setContentSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        network.mojom.CookieManager_SetForceKeepSessionState_ParamsSpec.$,
        null,
        impl.setForceKeepSessionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        network.mojom.CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        impl.blockThirdPartyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
        null,
        impl.setMitigationsEnabledFor3pcd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
        null,
        impl.setTrackingProtectionEnabledFor3pcd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
        null,
        impl.setPreCommitCallbackDelayForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CookieManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CookieManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CookieManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CookieManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CookieManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CookieManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CookieManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CookieManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CookieManager_GetAllCookies_ParamsSpec.$,
        network.mojom.CookieManager_GetAllCookies_ResponseParamsSpec.$,
        this.getAllCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllCookiesWithAccessSemantics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
        network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
        this.getAllCookiesWithAccessSemantics.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCookieList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.CookieManager_GetCookieList_ParamsSpec.$,
        network.mojom.CookieManager_GetCookieList_ResponseParamsSpec.$,
        this.getCookieList.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCanonicalCookie =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.CookieManager_SetCanonicalCookie_ParamsSpec.$,
        network.mojom.CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        this.setCanonicalCookie.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteCanonicalCookie =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
        network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
        this.deleteCanonicalCookie.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.CookieManager_DeleteCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteCookies_ResponseParamsSpec.$,
        this.deleteCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSessionOnlyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
        this.deleteSessionOnlyCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteStaleSessionOnlyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
        network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
        this.deleteStaleSessionOnlyCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addCookieChangeListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.CookieManager_AddCookieChangeListener_ParamsSpec.$,
        null,
        this.addCookieChangeListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addGlobalChangeListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.CookieManager_AddGlobalChangeListener_ParamsSpec.$,
        null,
        this.addGlobalChangeListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cloneInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        network.mojom.CookieManager_CloneInterface_ParamsSpec.$,
        null,
        this.cloneInterface.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushCookieStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        network.mojom.CookieManager_FlushCookieStore_ParamsSpec.$,
        network.mojom.CookieManager_FlushCookieStore_ResponseParamsSpec.$,
        this.flushCookieStore.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowFileSchemeCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        network.mojom.CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
        network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
        this.allowFileSchemeCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setContentSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        network.mojom.CookieManager_SetContentSettings_ParamsSpec.$,
        network.mojom.CookieManager_SetContentSettings_ResponseParamsSpec.$,
        this.setContentSettings.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setForceKeepSessionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        network.mojom.CookieManager_SetForceKeepSessionState_ParamsSpec.$,
        null,
        this.setForceKeepSessionState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blockThirdPartyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        network.mojom.CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        this.blockThirdPartyCookies.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMitigationsEnabledFor3pcd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
        null,
        this.setMitigationsEnabledFor3pcd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrackingProtectionEnabledFor3pcd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
        null,
        this.setTrackingProtectionEnabledFor3pcd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPreCommitCallbackDelayForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
        null,
        this.setPreCommitCallbackDelayForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.CookieManagerParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManagerParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieSameSiteContextMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieSameSiteContextMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieSameSiteContextSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieSameSiteContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CanonicalCookieSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CanonicalCookieSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.ExclusionReasonsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ExclusionReasonsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.WarningReasonsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WarningReasonsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieInclusionStatusSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieInclusionStatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieAndLineWithAccessResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieAndLineWithAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieOrLineWithAccessResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieOrLineWithAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieAccessResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieWithAccessResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieWithAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieChangeInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieChangeInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieDeletionFilterSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieDeletionFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieChangeListener_OnCookieChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieChangeListener_OnCookieChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_GetAllCookies_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_GetAllCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_GetAllCookies_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_GetAllCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_GetCookieList_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_GetCookieList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_GetCookieList_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_GetCookieList_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetCanonicalCookie_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetCanonicalCookie_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetCanonicalCookie_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetCanonicalCookie_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteCanonicalCookie_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteCanonicalCookie_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteCookies_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteCookies_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteSessionOnlyCookies_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteSessionOnlyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_AddCookieChangeListener_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_AddCookieChangeListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_AddGlobalChangeListener_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_AddGlobalChangeListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_CloneInterface_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_CloneInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_FlushCookieStore_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_FlushCookieStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_FlushCookieStore_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_FlushCookieStore_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_AllowFileSchemeCookies_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_AllowFileSchemeCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetContentSettings_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetContentSettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetContentSettings_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetContentSettings_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetForceKeepSessionState_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetForceKeepSessionState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_BlockThirdPartyCookies_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_BlockThirdPartyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CookieOrLineSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieOrLineSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.CookieManagerParamsSpec.$,
    'CookieManagerParams',
    [
      mojo.internal.StructField(
        'blockThirdPartyCookies', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trackingProtectionEnabledFor3pcd', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mitigationsEnabledFor3pcd', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentSettings', 8,
        0,
        mojo.internal.Map(contentSettings.mojom.ContentSettingsTypeSpec.$, mojo.internal.Array(contentSettings.mojom.ContentSettingPatternSourceSpec.$, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'secureOriginCookiesAllowedSchemes', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchingSchemeCookiesAllowedSchemes', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'thirdPartyCookiesAllowedSchemes', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowFileSchemeCookies', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieAccessDelegateType', 4,
        0,
        network.mojom.CookieAccessDelegateTypeSpec.$,
        network.mojom.CookieAccessDelegateType.USE_CONTENT_SETTINGS,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.CookieManagerParams');

/** @record */
network.mojom.CookieManagerParams = class {
  constructor() {
    /** @export { !boolean } */
    this.blockThirdPartyCookies;
    /** @export { !boolean } */
    this.trackingProtectionEnabledFor3pcd;
    /** @export { !boolean } */
    this.mitigationsEnabledFor3pcd;
    /** @export { !Object<!contentSettings.mojom.ContentSettingsType, !Array<!contentSettings.mojom.ContentSettingPatternSource>> } */
    this.contentSettings;
    /** @export { !Array<!string> } */
    this.secureOriginCookiesAllowedSchemes;
    /** @export { !Array<!string> } */
    this.matchingSchemeCookiesAllowedSchemes;
    /** @export { !Array<!string> } */
    this.thirdPartyCookiesAllowedSchemes;
    /** @export { !boolean } */
    this.allowFileSchemeCookies;
    /** @export { !network.mojom.CookieAccessDelegateType } */
    this.cookieAccessDelegateType;
  }
};



mojo.internal.Struct(
    network.mojom.CookieSameSiteContextMetadataSpec.$,
    'CookieSameSiteContextMetadata',
    [
      mojo.internal.StructField(
        'crossSiteRedirectDowngrade', 0,
        0,
        network.mojom.CookieSameSiteContextMetadataDowngradeTypeSpec.$,
        network.mojom.CookieSameSiteContextMetadataDowngradeType.kNoDowngrade,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirectTypeBug1221316', 4,
        0,
        network.mojom.ContextRedirectTypeBug1221316Spec.$,
        network.mojom.ContextRedirectTypeBug1221316.kUnset,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieSameSiteContextMetadata');

/** @record */
network.mojom.CookieSameSiteContextMetadata = class {
  constructor() {
    /** @export { !network.mojom.CookieSameSiteContextMetadataDowngradeType } */
    this.crossSiteRedirectDowngrade;
    /** @export { !network.mojom.ContextRedirectTypeBug1221316 } */
    this.redirectTypeBug1221316;
  }
};



mojo.internal.Struct(
    network.mojom.CookieSameSiteContextSpec.$,
    'CookieSameSiteContext',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        network.mojom.ContextTypeSpec.$,
        network.mojom.ContextType.CROSS_SITE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'schemefulContext', 4,
        0,
        network.mojom.ContextTypeSpec.$,
        network.mojom.ContextType.CROSS_SITE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        network.mojom.CookieSameSiteContextMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'schemefulMetadata', 16,
        0,
        network.mojom.CookieSameSiteContextMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieSameSiteContext');

/** @record */
network.mojom.CookieSameSiteContext = class {
  constructor() {
    /** @export { !network.mojom.ContextType } */
    this.context;
    /** @export { !network.mojom.ContextType } */
    this.schemefulContext;
    /** @export { !network.mojom.CookieSameSiteContextMetadata } */
    this.metadata;
    /** @export { !network.mojom.CookieSameSiteContextMetadata } */
    this.schemefulMetadata;
  }
};



mojo.internal.Struct(
    network.mojom.CookieOptionsSpec.$,
    'CookieOptions',
    [
      mojo.internal.StructField(
        'excludeHttponly', 0,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sameSiteCookieContext', 8,
        0,
        network.mojom.CookieSameSiteContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateAccessTime', 0,
        1,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'returnExcludedCookies', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CookieOptions');

/** @record */
network.mojom.CookieOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.excludeHttponly;
    /** @export { !network.mojom.CookieSameSiteContext } */
    this.sameSiteCookieContext;
    /** @export { !boolean } */
    this.updateAccessTime;
    /** @export { !boolean } */
    this.returnExcludedCookies;
  }
};



mojo.internal.Struct(
    network.mojom.CanonicalCookieSpec.$,
    'CanonicalCookie',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domain', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'creation', 32,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expiry', 40,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastAccess', 48,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastUpdate', 56,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'secure', 64,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httponly', 64,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteRestrictions', 68,
        0,
        network.mojom.CookieSameSiteSpec.$,
        network.mojom.CookieSameSite.NO_RESTRICTION,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 72,
        0,
        network.mojom.CookiePrioritySpec.$,
        network.mojom.CookiePriority.MEDIUM,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceScheme', 76,
        0,
        network.mojom.CookieSourceSchemeSpec.$,
        network.mojom.CookieSourceScheme.kUnset,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'partitionKey', 80,
        0,
        network.mojom.CookiePartitionKeySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourcePort', 88,
        0,
        mojo.internal.Int32,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceType', 92,
        0,
        network.mojom.CookieSourceTypeSpec.$,
        network.mojom.CookieSourceType.kUnknown,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 104],]);



goog.provide('network.mojom.CanonicalCookie');

/** @record */
network.mojom.CanonicalCookie = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.value;
    /** @export { !string } */
    this.domain;
    /** @export { !string } */
    this.path;
    /** @export { !mojoBase.mojom.Time } */
    this.creation;
    /** @export { !mojoBase.mojom.Time } */
    this.expiry;
    /** @export { !mojoBase.mojom.Time } */
    this.lastAccess;
    /** @export { !mojoBase.mojom.Time } */
    this.lastUpdate;
    /** @export { !boolean } */
    this.secure;
    /** @export { !boolean } */
    this.httponly;
    /** @export { !network.mojom.CookieSameSite } */
    this.siteRestrictions;
    /** @export { !network.mojom.CookiePriority } */
    this.priority;
    /** @export { !network.mojom.CookieSourceScheme } */
    this.sourceScheme;
    /** @export { (network.mojom.CookiePartitionKey|undefined) } */
    this.partitionKey;
    /** @export { !number } */
    this.sourcePort;
    /** @export { !network.mojom.CookieSourceType } */
    this.sourceType;
  }
};



mojo.internal.Struct(
    network.mojom.ExclusionReasonsSpec.$,
    'ExclusionReasons',
    [
      mojo.internal.StructField(
        'exclusionsBitmask', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.ExclusionReasons');

/** @record */
network.mojom.ExclusionReasons = class {
  constructor() {
    /** @export { !bigint } */
    this.exclusionsBitmask;
  }
};



mojo.internal.Struct(
    network.mojom.WarningReasonsSpec.$,
    'WarningReasons',
    [
      mojo.internal.StructField(
        'warningsBitmask', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.WarningReasons');

/** @record */
network.mojom.WarningReasons = class {
  constructor() {
    /** @export { !bigint } */
    this.warningsBitmask;
  }
};



mojo.internal.Struct(
    network.mojom.CookieInclusionStatusSpec.$,
    'CookieInclusionStatus',
    [
      mojo.internal.StructField(
        'exclusionReasons', 0,
        0,
        network.mojom.ExclusionReasonsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'warningReasons', 8,
        0,
        network.mojom.WarningReasonsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exemptionReason', 16,
        0,
        network.mojom.CookieExemptionReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieInclusionStatus');

/** @record */
network.mojom.CookieInclusionStatus = class {
  constructor() {
    /** @export { !network.mojom.ExclusionReasons } */
    this.exclusionReasons;
    /** @export { !network.mojom.WarningReasons } */
    this.warningReasons;
    /** @export { !network.mojom.CookieExemptionReason } */
    this.exemptionReason;
  }
};



mojo.internal.Struct(
    network.mojom.CookieAndLineWithAccessResultSpec.$,
    'CookieAndLineWithAccessResult',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        network.mojom.CanonicalCookieSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieString', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessResult', 16,
        0,
        network.mojom.CookieAccessResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieAndLineWithAccessResult');

/** @record */
network.mojom.CookieAndLineWithAccessResult = class {
  constructor() {
    /** @export { (network.mojom.CanonicalCookie|undefined) } */
    this.cookie;
    /** @export { !string } */
    this.cookieString;
    /** @export { !network.mojom.CookieAccessResult } */
    this.accessResult;
  }
};



mojo.internal.Struct(
    network.mojom.CookieOrLineWithAccessResultSpec.$,
    'CookieOrLineWithAccessResult',
    [
      mojo.internal.StructField(
        'cookieOrLine', 0,
        0,
        network.mojom.CookieOrLineSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessResult', 16,
        0,
        network.mojom.CookieAccessResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieOrLineWithAccessResult');

/** @record */
network.mojom.CookieOrLineWithAccessResult = class {
  constructor() {
    /** @export { !network.mojom.CookieOrLine } */
    this.cookieOrLine;
    /** @export { !network.mojom.CookieAccessResult } */
    this.accessResult;
  }
};



mojo.internal.Struct(
    network.mojom.CookieAccessResultSpec.$,
    'CookieAccessResult',
    [
      mojo.internal.StructField(
        'effectiveSameSite', 0,
        0,
        network.mojom.CookieEffectiveSameSiteSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessSemantics', 4,
        0,
        network.mojom.CookieAccessSemanticsSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scopeSemantics', 8,
        0,
        network.mojom.CookieScopeSemanticsSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 16,
        0,
        network.mojom.CookieInclusionStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAllowedToAccessSecureCookies', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieAccessResult');

/** @record */
network.mojom.CookieAccessResult = class {
  constructor() {
    /** @export { !network.mojom.CookieEffectiveSameSite } */
    this.effectiveSameSite;
    /** @export { !network.mojom.CookieAccessSemantics } */
    this.accessSemantics;
    /** @export { !network.mojom.CookieScopeSemantics } */
    this.scopeSemantics;
    /** @export { !network.mojom.CookieInclusionStatus } */
    this.status;
    /** @export { !boolean } */
    this.isAllowedToAccessSecureCookies;
  }
};



mojo.internal.Struct(
    network.mojom.CookieWithAccessResultSpec.$,
    'CookieWithAccessResult',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        network.mojom.CanonicalCookieSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessResult', 8,
        0,
        network.mojom.CookieAccessResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CookieWithAccessResult');

/** @record */
network.mojom.CookieWithAccessResult = class {
  constructor() {
    /** @export { !network.mojom.CanonicalCookie } */
    this.cookie;
    /** @export { !network.mojom.CookieAccessResult } */
    this.accessResult;
  }
};



mojo.internal.Struct(
    network.mojom.CookieChangeInfoSpec.$,
    'CookieChangeInfo',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        network.mojom.CanonicalCookieSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessResult', 8,
        0,
        network.mojom.CookieAccessResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cause', 16,
        0,
        network.mojom.CookieChangeCauseSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieChangeInfo');

/** @record */
network.mojom.CookieChangeInfo = class {
  constructor() {
    /** @export { !network.mojom.CanonicalCookie } */
    this.cookie;
    /** @export { !network.mojom.CookieAccessResult } */
    this.accessResult;
    /** @export { !network.mojom.CookieChangeCause } */
    this.cause;
  }
};



mojo.internal.Struct(
    network.mojom.CookieDeletionFilterSpec.$,
    'CookieDeletionFilter',
    [
      mojo.internal.StructField(
        'createdAfterTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'createdBeforeTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'excludingDomains', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includingDomains', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieName', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostName', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 48,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionControl', 56,
        0,
        network.mojom.CookieDeletionSessionControlSpec.$,
        network.mojom.CookieDeletionSessionControl.IGNORE_CONTROL,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookiePartitionKeyCollection', 64,
        0,
        network.mojom.CookiePartitionKeyCollectionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'partitionedStateOnly', 60,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('network.mojom.CookieDeletionFilter');

/** @record */
network.mojom.CookieDeletionFilter = class {
  constructor() {
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.createdAfterTime;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.createdBeforeTime;
    /** @export { (Array<!string>|undefined) } */
    this.excludingDomains;
    /** @export { (Array<!string>|undefined) } */
    this.includingDomains;
    /** @export { (string|undefined) } */
    this.cookieName;
    /** @export { (string|undefined) } */
    this.hostName;
    /** @export { (url.mojom.Url|undefined) } */
    this.url;
    /** @export { !network.mojom.CookieDeletionSessionControl } */
    this.sessionControl;
    /** @export { (network.mojom.CookiePartitionKeyCollection|undefined) } */
    this.cookiePartitionKeyCollection;
    /** @export { !boolean } */
    this.partitionedStateOnly;
  }
};



mojo.internal.Struct(
    network.mojom.CookieChangeListener_OnCookieChange_ParamsSpec.$,
    'CookieChangeListener_OnCookieChange_Params',
    [
      mojo.internal.StructField(
        'change', 0,
        0,
        network.mojom.CookieChangeInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieChangeListener_OnCookieChange_Params');

/** @record */
network.mojom.CookieChangeListener_OnCookieChange_Params = class {
  constructor() {
    /** @export { !network.mojom.CookieChangeInfo } */
    this.change;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_GetAllCookies_ParamsSpec.$,
    'CookieManager_GetAllCookies_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_GetAllCookies_Params');

/** @record */
network.mojom.CookieManager_GetAllCookies_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_GetAllCookies_ResponseParamsSpec.$,
    'CookieManager_GetAllCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'cookies', 0,
        0,
        mojo.internal.Array(network.mojom.CanonicalCookieSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_GetAllCookies_ResponseParams');

/** @record */
network.mojom.CookieManager_GetAllCookies_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.CanonicalCookie> } */
    this.cookies;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
    'CookieManager_GetAllCookiesWithAccessSemantics_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_Params');

/** @record */
network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
    'CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams',
    [
      mojo.internal.StructField(
        'cookies', 0,
        0,
        mojo.internal.Array(network.mojom.CanonicalCookieSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessSemanticsList', 8,
        0,
        mojo.internal.Array(network.mojom.CookieAccessSemanticsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams');

/** @record */
network.mojom.CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.CanonicalCookie> } */
    this.cookies;
    /** @export { !Array<!network.mojom.CookieAccessSemantics> } */
    this.accessSemanticsList;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_GetCookieList_ParamsSpec.$,
    'CookieManager_GetCookieList_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieOptions', 8,
        0,
        network.mojom.CookieOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookiePartitionKeyCollection', 16,
        0,
        network.mojom.CookiePartitionKeyCollectionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieManager_GetCookieList_Params');

/** @record */
network.mojom.CookieManager_GetCookieList_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.CookieOptions } */
    this.cookieOptions;
    /** @export { !network.mojom.CookiePartitionKeyCollection } */
    this.cookiePartitionKeyCollection;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_GetCookieList_ResponseParamsSpec.$,
    'CookieManager_GetCookieList_ResponseParams',
    [
      mojo.internal.StructField(
        'cookies', 0,
        0,
        mojo.internal.Array(network.mojom.CookieWithAccessResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'excludedCookies', 8,
        0,
        mojo.internal.Array(network.mojom.CookieWithAccessResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CookieManager_GetCookieList_ResponseParams');

/** @record */
network.mojom.CookieManager_GetCookieList_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.CookieWithAccessResult> } */
    this.cookies;
    /** @export { !Array<!network.mojom.CookieWithAccessResult> } */
    this.excludedCookies;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetCanonicalCookie_ParamsSpec.$,
    'CookieManager_SetCanonicalCookie_Params',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        network.mojom.CanonicalCookieSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieOptions', 16,
        0,
        network.mojom.CookieOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieManager_SetCanonicalCookie_Params');

/** @record */
network.mojom.CookieManager_SetCanonicalCookie_Params = class {
  constructor() {
    /** @export { !network.mojom.CanonicalCookie } */
    this.cookie;
    /** @export { !url.mojom.Url } */
    this.sourceUrl;
    /** @export { !network.mojom.CookieOptions } */
    this.cookieOptions;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
    'CookieManager_SetCanonicalCookie_ResponseParams',
    [
      mojo.internal.StructField(
        'accessResult', 0,
        0,
        network.mojom.CookieAccessResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_SetCanonicalCookie_ResponseParams');

/** @record */
network.mojom.CookieManager_SetCanonicalCookie_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.CookieAccessResult } */
    this.accessResult;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
    'CookieManager_DeleteCanonicalCookie_Params',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        network.mojom.CanonicalCookieSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_DeleteCanonicalCookie_Params');

/** @record */
network.mojom.CookieManager_DeleteCanonicalCookie_Params = class {
  constructor() {
    /** @export { !network.mojom.CanonicalCookie } */
    this.cookie;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
    'CookieManager_DeleteCanonicalCookie_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParams');

/** @record */
network.mojom.CookieManager_DeleteCanonicalCookie_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteCookies_ParamsSpec.$,
    'CookieManager_DeleteCookies_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.CookieDeletionFilterSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_DeleteCookies_Params');

/** @record */
network.mojom.CookieManager_DeleteCookies_Params = class {
  constructor() {
    /** @export { !network.mojom.CookieDeletionFilter } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteCookies_ResponseParamsSpec.$,
    'CookieManager_DeleteCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'numDeleted', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_DeleteCookies_ResponseParams');

/** @record */
network.mojom.CookieManager_DeleteCookies_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.numDeleted;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
    'CookieManager_DeleteSessionOnlyCookies_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_DeleteSessionOnlyCookies_Params');

/** @record */
network.mojom.CookieManager_DeleteSessionOnlyCookies_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
    'CookieManager_DeleteSessionOnlyCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'numDeleted', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParams');

/** @record */
network.mojom.CookieManager_DeleteSessionOnlyCookies_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.numDeleted;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
    'CookieManager_DeleteStaleSessionOnlyCookies_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_Params');

/** @record */
network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
    'CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'numDeleted', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams');

/** @record */
network.mojom.CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.numDeleted;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_AddCookieChangeListener_ParamsSpec.$,
    'CookieManager_AddCookieChangeListener_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'listener', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CookieChangeListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CookieManager_AddCookieChangeListener_Params');

/** @record */
network.mojom.CookieManager_AddCookieChangeListener_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { (string|undefined) } */
    this.name;
    /** @export { !network.mojom.CookieChangeListenerRemote } */
    this.listener;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_AddGlobalChangeListener_ParamsSpec.$,
    'CookieManager_AddGlobalChangeListener_Params',
    [
      mojo.internal.StructField(
        'notificationPointer', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CookieChangeListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_AddGlobalChangeListener_Params');

/** @record */
network.mojom.CookieManager_AddGlobalChangeListener_Params = class {
  constructor() {
    /** @export { !network.mojom.CookieChangeListenerRemote } */
    this.notificationPointer;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_CloneInterface_ParamsSpec.$,
    'CookieManager_CloneInterface_Params',
    [
      mojo.internal.StructField(
        'newInterface', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.CookieManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_CloneInterface_Params');

/** @record */
network.mojom.CookieManager_CloneInterface_Params = class {
  constructor() {
    /** @export { !network.mojom.CookieManagerPendingReceiver } */
    this.newInterface;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_FlushCookieStore_ParamsSpec.$,
    'CookieManager_FlushCookieStore_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_FlushCookieStore_Params');

/** @record */
network.mojom.CookieManager_FlushCookieStore_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_FlushCookieStore_ResponseParamsSpec.$,
    'CookieManager_FlushCookieStore_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_FlushCookieStore_ResponseParams');

/** @record */
network.mojom.CookieManager_FlushCookieStore_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
    'CookieManager_AllowFileSchemeCookies_Params',
    [
      mojo.internal.StructField(
        'allow', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_AllowFileSchemeCookies_Params');

/** @record */
network.mojom.CookieManager_AllowFileSchemeCookies_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.allow;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
    'CookieManager_AllowFileSchemeCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParams');

/** @record */
network.mojom.CookieManager_AllowFileSchemeCookies_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetContentSettings_ParamsSpec.$,
    'CookieManager_SetContentSettings_Params',
    [
      mojo.internal.StructField(
        'contentSettingsType', 0,
        0,
        contentSettings.mojom.ContentSettingsTypeSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        mojo.internal.Array(contentSettings.mojom.ContentSettingPatternSourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CookieManager_SetContentSettings_Params');

/** @record */
network.mojom.CookieManager_SetContentSettings_Params = class {
  constructor() {
    /** @export { !contentSettings.mojom.ContentSettingsType } */
    this.contentSettingsType;
    /** @export { !Array<!contentSettings.mojom.ContentSettingPatternSource> } */
    this.settings;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetContentSettings_ResponseParamsSpec.$,
    'CookieManager_SetContentSettings_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_SetContentSettings_ResponseParams');

/** @record */
network.mojom.CookieManager_SetContentSettings_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetForceKeepSessionState_ParamsSpec.$,
    'CookieManager_SetForceKeepSessionState_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CookieManager_SetForceKeepSessionState_Params');

/** @record */
network.mojom.CookieManager_SetForceKeepSessionState_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
    'CookieManager_BlockThirdPartyCookies_Params',
    [
      mojo.internal.StructField(
        'block', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_BlockThirdPartyCookies_Params');

/** @record */
network.mojom.CookieManager_BlockThirdPartyCookies_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.block;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
    'CookieManager_SetMitigationsEnabledFor3pcd_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_Params');

/** @record */
network.mojom.CookieManager_SetMitigationsEnabledFor3pcd_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
    'CookieManager_SetTrackingProtectionEnabledFor3pcd_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_Params');

/** @record */
network.mojom.CookieManager_SetTrackingProtectionEnabledFor3pcd_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
  }
};



mojo.internal.Struct(
    network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
    'CookieManager_SetPreCommitCallbackDelayForTesting_Params',
    [
      mojo.internal.StructField(
        'delay', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_Params');

/** @record */
network.mojom.CookieManager_SetPreCommitCallbackDelayForTesting_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.delay;
  }
};

goog.provide('network.mojom.CookieOrLine');


mojo.internal.Union(
    network.mojom.CookieOrLineSpec.$, 'CookieOrLine',
    {
      'cookie': {
        'ordinal': 0,
        'type': network.mojom.CanonicalCookieSpec.$,
      },
      'cookieString': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   cookie: (!network.mojom.CanonicalCookie|undefined),
 *   cookieString: (!string|undefined),
 * } }
 */
network.mojom.CookieOrLine;
